
SET(TPL_QT_QMAKE_EXECUTABLE "" CACHE STRING "A Trilinos specific variable that defines where the Qt Qmake Execuatable is")

IF(TPL_QT_QMAKE_EXECUTABLE AND QT_QMAKE_EXECUTABLE)
	IF(NOT(${TPL_QT_QMAKE_EXECUTABLE} EQUAL ${QT_QMAKE_EXECUTABLE}))
		MESSAGE(FATAL_ERROR "Uh oh. Looks like you set both the TPL_QT_QMAKE_EXECUTABLE and QT_QMAKE_EXECUTABLE variables and set them differently. You only need to set one.")
	ENDIF()
ENDIF()

IF(TPL_QT_QMAKE_EXECUTABLE)
	SET(QT_QMAKE_EXECUTABLE ${TPL_QT_QMAKE_EXECUTABLE})
ENDIF()

IF(QT_LIBRARY_DIRS)
	SET(QT_LIBRARY_DIR ${QT_LIBRARY_DIRS})
ENDIF()

IF(TPL_QT_LIBRARY_DIRS)
	SET(QT_LIBRARY_DIR ${TPL_QT_LIBRARY_DIRS})
ENDIF()

IF(QT_INCLUDE_DIRS)
	SET(QT_INCLUDE_DIR ${QT_INCLUDE_DIRS})
ENDIF()

IF(TPL_QT_INCLUDE_DIRS)
	SET(QT_INCLUDE_DIR ${TPL_QT_INCLUDE_DIRS})
ENDIF()

IF(TPL_QT_LIBRARIES)
	SET(QT_LIBRARIES ${TPL_QT_LIBRARIES})
ENDIF()

IF(NOT QT_REQUIRED_VERSION)
  SET(QT_REQUIRED_VERSION 4.5.0)
ENDIF()
IF(NOT QT_REQUIRED_COMPONENTS)
  SET(QT_REQUIRED_COMPONENTS QtCore QtGui QtTest QtXml)
ENDIF()

FIND_PACKAGE(Qt4 ${QT_REQUIRED_VERSION} COMPONENTS ${QT_REQUIRED_COMPONENTS} REQUIRED)
if(NOT QT4_FOUND)
  MESSAGE(FATAL_ERROR "Couldn't find Qt ${QT_REQUIRED_VERSION} or greater. Abort..")
endif()

IF(NOT(QT_INCLUDE_DIRS))
	SET(QT_INCLUDE_DIRS ${QT_INCLUDES})
ENDIF()

IF(NOT(QT_LIBRARY_DIRS))
	SET(QT_LIBRARY_DIRS ${QT_LIBRARY_DIR})
ENDIF()

IF(NOT(TPL_QT_INCLUDE_DIRS))
	SET(TPL_QT_INCLUDE_DIRS ${QT_INCLUDE_DIRS})
ENDIF()

IF(NOT(TPL_QT_LIBRARY_DIRS))
	SET(TPL_QT_LIBRARY_DIRS ${QT_LIBRARY_DIRS})
ENDIF()

IF(NOT(TPL_QT_LIBRARIES))
	SET(TPL_QT_LIBRARIES ${QT_QTCORE_LIBRARY} ${QT_QTGUI_LIBRARY} ${QT_QTTEST_LIBRARY} ${QT_QTXML_LIBRARY})
ENDIF()

TRIBITS_TPL_FIND_INCLUDE_DIRS_AND_LIBRARIES( QT
  REQUIRED_HEADERS QMainWindow QDialog QAbstratItemModel QTreeView QItemDelegate QPushButton QGridLayout QSpinBox QComboBox QLineEdit QLabel QScrollArea QDir QXmlStreamWriter QXmlStreamReader QStringList QDomElement
  REQUIRED_LIBS_NAMES QtCore QtGui QtXml
  )

