#include "twine/scene/graph.h"
#include <cxxtest/TestSuite.h>

class GridTestSuite : public CxxTest::TestSuite {
public:
	GridTestSuite() {
	}

	void test_draw_graph() {
		Graphics::Screen screen(640, 480);
		const uint8 brick_326[] = {
			0x30, 0x26, 0x00, 0x00, 0x03, 0x15, 0x43, 0xd0, 0xd0, 0xd2, 0xd2, 0x15, 0x03, 0x13, 0x47, 0xd0,
			0xd0, 0xf1, 0xf1, 0xf3, 0xf3, 0xd2, 0xd2, 0x13, 0x03, 0x11, 0x4b, 0xd0, 0xd0, 0xf1, 0xf1, 0xd0,
			0xf0, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0x11, 0x03, 0x0f, 0x4f, 0xd0, 0xd0, 0xf1, 0xf1, 0xd0,
			0xf0, 0xf0, 0x11, 0x13, 0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0x0f, 0x03, 0x0d, 0x53, 0xd0,
			0xd0, 0xf1, 0xf1, 0xd0, 0xf0, 0xf0, 0x11, 0xd0, 0xd0, 0xd2, 0xd2, 0x13, 0xd1, 0xd1, 0xd2, 0xf3,
			0xf3, 0xd2, 0xd2, 0x0d, 0x03, 0x0b, 0x57, 0xd0, 0xd0, 0xf1, 0xf1, 0xd0, 0xf0, 0xf0, 0x11, 0xd0,
			0xd0, 0xf0, 0xf0, 0xd1, 0xd1, 0xd2, 0xd2, 0x13, 0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0x0b,
			0x03, 0x09, 0x5b, 0xd0, 0xd0, 0xf1, 0xf1, 0xd0, 0xf0, 0xf0, 0x11, 0xd0, 0xd0, 0xf0, 0xf0, 0x11,
			0x11, 0x13, 0x13, 0xf2, 0xd1, 0xd2, 0xd2, 0x13, 0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0x09,
			0x08, 0x07, 0x49, 0xd0, 0xd0, 0xf1, 0xf1, 0xd0, 0xf0, 0xf0, 0x11, 0xd0, 0xd0, 0x82, 0xf0, 0x00,
			0x43, 0x11, 0xd0, 0xd2, 0x13, 0x00, 0x4c, 0xf2, 0xd1, 0xd1, 0xd2, 0xd2, 0x13, 0xd1, 0xd1, 0xd2,
			0xf3, 0xf3, 0xd2, 0xd2, 0x07, 0x07, 0x05, 0x4d, 0xd0, 0xd0, 0xf1, 0xf1, 0xd0, 0xf0, 0xf0, 0x11,
			0xd0, 0xd0, 0xf0, 0xf0, 0x11, 0x11, 0x01, 0x43, 0x11, 0xd1, 0xd3, 0x13, 0x01, 0x4d, 0x13, 0x13,
			0xf2, 0xd1, 0xd2, 0xd2, 0x13, 0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0x05, 0x0c, 0x03, 0x49,
			0xd0, 0xd0, 0xf1, 0xf1, 0xd0, 0xf0, 0xf0, 0x11, 0xd0, 0xd0, 0x82, 0xf0, 0x00, 0x41, 0x11, 0xd0,
			0x01, 0x43, 0x11, 0xd1, 0xd3, 0x13, 0x01, 0x41, 0xd2, 0x13, 0x00, 0x4c, 0xf2, 0xd1, 0xd1, 0xd2,
			0xd2, 0x13, 0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0x03, 0x0b, 0x01, 0x4d, 0xd0, 0xd0, 0xf1,
			0xf1, 0xd0, 0xf0, 0xf0, 0x11, 0xd0, 0xd0, 0xf0, 0xf0, 0x11, 0x11, 0x01, 0x41, 0x11, 0xd1, 0x01,
			0x43, 0x11, 0xd0, 0xd2, 0x13, 0x01, 0x41, 0xd3, 0x13, 0x01, 0x4d, 0x13, 0x13, 0xf2, 0xd1, 0xd2,
			0xd2, 0x13, 0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0x01, 0x0e, 0x49, 0xd2, 0xd2, 0xf1, 0xf1,
			0xd0, 0xf0, 0xf0, 0x11, 0xd0, 0xd0, 0x82, 0xf0, 0x00, 0x41, 0x11, 0xd0, 0x01, 0x41, 0x11, 0xd1,
			0x01, 0x43, 0x11, 0x11, 0x13, 0x13, 0x01, 0x41, 0xd3, 0x13, 0x01, 0x41, 0xd2, 0x13, 0x00, 0x4c,
			0xf2, 0xd1, 0xd1, 0xd2, 0xd2, 0x13, 0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xd0, 0xd0, 0x0d, 0x4b, 0xf3,
			0xf3, 0xd2, 0xd2, 0xf0, 0x11, 0xd0, 0xd0, 0xf0, 0xf0, 0x11, 0x11, 0x01, 0x41, 0x11, 0xd1, 0x01,
			0x41, 0x11, 0xd0, 0x00, 0x45, 0xf0, 0x11, 0x11, 0x13, 0x13, 0xf2, 0x00, 0x41, 0xd2, 0x13, 0x01,
			0x41, 0xd3, 0x13, 0x01, 0x4b, 0x13, 0x13, 0xf2, 0xd1, 0xd2, 0xd2, 0x13, 0xd1, 0xd0, 0xd0, 0xf1,
			0xf1, 0x11, 0x45, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0x82, 0xf0, 0x00, 0x41, 0x11, 0xd0, 0x01,
			0x41, 0x11, 0xd1, 0x01, 0x42, 0x11, 0x11, 0xf0, 0x82, 0x11, 0x82, 0x13, 0x42, 0xf2, 0x13, 0x13,
			0x01, 0x41, 0xd3, 0x13, 0x01, 0x41, 0xd2, 0x13, 0x00, 0x48, 0xf2, 0xd1, 0xd1, 0xd0, 0xd0, 0xf1,
			0xf1, 0xd0, 0xf0, 0x11, 0x47, 0x13, 0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0x01, 0x41, 0x11,
			0xd1, 0x01, 0x41, 0x11, 0xd0, 0x00, 0x40, 0xf0, 0x83, 0x11, 0x43, 0xd0, 0xd0, 0xd2, 0xd2, 0x83,
			0x13, 0x40, 0xf2, 0x00, 0x41, 0xd2, 0x13, 0x01, 0x41, 0xd3, 0x13, 0x01, 0x47, 0xd0, 0xd0, 0xf1,
			0xf1, 0xd0, 0xf0, 0xf0, 0x11, 0x09, 0x4b, 0xd2, 0xd2, 0x13, 0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2,
			0xd2, 0x11, 0xd1, 0x01, 0x42, 0x11, 0x11, 0xf0, 0x82, 0x11, 0x47, 0xd0, 0xd0, 0xf0, 0xf0, 0xd1,
			0xd1, 0xd2, 0xd2, 0x82, 0x13, 0x42, 0xf2, 0x13, 0x13, 0x01, 0x4b, 0xd3, 0x13, 0xd0, 0xd0, 0xf1,
			0xf1, 0xd0, 0xf0, 0xf0, 0x11, 0xd0, 0xd0, 0x0b, 0x4b, 0xd1, 0xd1, 0xd2, 0xd2, 0x13, 0xd1, 0xd1,
			0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0x00, 0x40, 0xf0, 0x83, 0x11, 0x43, 0xd0, 0xd0, 0xf0, 0xf0, 0x03,
			0x43, 0xd1, 0xd1, 0xd2, 0xd2, 0x83, 0x13, 0x40, 0xf2, 0x00, 0x4b, 0xd0, 0xd0, 0xf1, 0xf1, 0xd0,
			0xf0, 0xf0, 0x11, 0xd0, 0xd0, 0xf0, 0xf0, 0x03, 0x53, 0x13, 0x13, 0xf2, 0xd1, 0xd2, 0xd2, 0x13,
			0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0x11, 0x11, 0xd0, 0xd0, 0xf0, 0xf0, 0x07, 0x53, 0xd1,
			0xd1, 0xd2, 0xd2, 0x13, 0x13, 0xd0, 0xd0, 0xf1, 0xf1, 0xd0, 0xf0, 0xf0, 0x11, 0xd0, 0xd0, 0xf0,
			0xf0, 0x11, 0x11, 0x05, 0x51, 0xd2, 0x13, 0x11, 0xf2, 0xd1, 0xd1, 0xd2, 0xd2, 0x13, 0xd1, 0xd1,
			0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0xf0, 0xf0, 0x0b, 0x4b, 0xd1, 0xd1, 0xd0, 0xd0, 0xf1, 0xf1, 0xd0,
			0xf0, 0xf0, 0x11, 0xd0, 0xd0, 0x82, 0xf0, 0x42, 0x13, 0x11, 0xd0, 0x03, 0x51, 0xd3, 0x13, 0x11,
			0xd1, 0x13, 0x13, 0xf2, 0xd1, 0xd2, 0xd2, 0x13, 0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0x0b,
			0x51, 0xd0, 0xd0, 0xf1, 0xf1, 0xd0, 0xf0, 0xf0, 0x11, 0xd0, 0xd0, 0xf0, 0xf0, 0x11, 0x11, 0xd3,
			0x13, 0x11, 0xd1, 0x05, 0x53, 0xd3, 0x13, 0x11, 0xd0, 0xd2, 0x13, 0x11, 0xf2, 0xd1, 0xd1, 0xd2,
			0xd2, 0x13, 0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0x07, 0x49, 0xd0, 0xd0, 0xf1, 0xf1, 0xd0,
			0xf0, 0xf0, 0x11, 0xd0, 0xd0, 0x82, 0xf0, 0x46, 0x13, 0x11, 0xd0, 0xd2, 0x13, 0x11, 0xd1, 0x03,
			0x55, 0xd2, 0x13, 0x11, 0x11, 0xd3, 0x13, 0x11, 0x11, 0x13, 0x13, 0xf2, 0xd1, 0xd2, 0xd2, 0x13,
			0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0x03, 0x55, 0xd0, 0xd0, 0xf1, 0xf1, 0xd0, 0xf0, 0xf0,
			0x11, 0xd0, 0xd0, 0xf0, 0xf0, 0x11, 0x11, 0x13, 0x13, 0x11, 0xd1, 0x13, 0x13, 0x11, 0xd0, 0x06,
			0x49, 0x13, 0x13, 0x11, 0x11, 0xd3, 0x13, 0xd0, 0xd0, 0xd2, 0x13, 0x00, 0x56, 0xf2, 0xd1, 0xd1,
			0xd2, 0xd2, 0x13, 0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xd2, 0xd2, 0xd0, 0xd0, 0xf1, 0xf1, 0xd0, 0xf0,
			0xf0, 0x11, 0xd0, 0xd0, 0x82, 0xf0, 0x00, 0x49, 0x11, 0xd0, 0xd2, 0xd2, 0x11, 0xd1, 0x13, 0x13,
			0x11, 0x11, 0x07, 0x49, 0x13, 0x13, 0xf2, 0x11, 0xd2, 0x13, 0xf0, 0xf0, 0xd3, 0x13, 0x01, 0x57,
			0x13, 0x13, 0xf2, 0xd1, 0xd2, 0xd2, 0x13, 0xd1, 0xd1, 0xd2, 0xf3, 0xf3, 0xf1, 0xf1, 0xd0, 0xf0,
			0xf0, 0x11, 0xd0, 0xd0, 0xf0, 0xf0, 0x11, 0x11, 0x01, 0x40, 0x11, 0x82, 0xd1, 0x45, 0x11, 0xd0,
			0x13, 0xf0, 0x11, 0x11, 0x10, 0x82, 0x13, 0x42, 0xf2, 0x13, 0x13, 0x01, 0x41, 0xd3, 0x13, 0x01,
			0x41, 0xd2, 0x13, 0x00, 0x4e, 0xf2, 0xd1, 0xd1, 0xd2, 0xd2, 0x13, 0xd1, 0xd1, 0xd2, 0xd0, 0xf0,
			0xf0, 0x11, 0xd0, 0xd0, 0x82, 0xf0, 0x00, 0x41, 0x11, 0xd0, 0x01, 0x41, 0x11, 0xd1, 0x01, 0x42,
			0x11, 0x11, 0xf0, 0x82, 0x11, 0x11, 0x41, 0xd2, 0xd2, 0x83, 0x13, 0x40, 0xf2, 0x00, 0x41, 0xd2,
			0x13, 0x01, 0x41, 0xd3, 0x13, 0x01, 0x4f, 0x13, 0x13, 0xf2, 0xd1, 0xd2, 0xd2, 0x13, 0xd1, 0xf0,
			0x11, 0xd0, 0xd0, 0xf0, 0xf0, 0x11, 0x11, 0x01, 0x41, 0x11, 0xd1, 0x01, 0x41, 0x11, 0xd0, 0x00,
			0x40, 0xf0, 0x83, 0x11, 0x41, 0xd0, 0xd0, 0x12, 0x43, 0xd1, 0xd1, 0xd2, 0xd2, 0x82, 0x13, 0x42,
			0xf2, 0x13, 0x13, 0x01, 0x41, 0xd3, 0x13, 0x01, 0x41, 0xd2, 0x13, 0x00, 0x46, 0xf2, 0xd1, 0xd1,
			0xd2, 0xd2, 0xd0, 0xd0, 0x82, 0xf0, 0x00, 0x41, 0x11, 0xd0, 0x01, 0x41, 0x11, 0xd1, 0x01, 0x42,
			0x11, 0x11, 0xf0, 0x82, 0x11, 0x43, 0xd0, 0xd0, 0xf0, 0xf0, 0x13, 0x01, 0x43, 0xd1, 0xd1, 0xd2,
			0xd2, 0x83, 0x13, 0x40, 0xf2, 0x00, 0x41, 0xd2, 0x13, 0x01, 0x41, 0xd3, 0x13, 0x01, 0x47, 0x13,
			0x13, 0xf2, 0xd1, 0xf0, 0xf0, 0x11, 0x11, 0x01, 0x41, 0x11, 0xd1, 0x01, 0x41, 0x11, 0xd0, 0x00,
			0x40, 0xf0, 0x83, 0x11, 0x43, 0xd0, 0xd0, 0xf0, 0xf0, 0x01, 0x13, 0x03, 0x43, 0xd1, 0xd1, 0xd2,
			0xd2, 0x82, 0x13, 0x42, 0xf2, 0x13, 0x13, 0x01, 0x41, 0xd3, 0x13, 0x01, 0x41, 0xd2, 0x13, 0x00,
			0x41, 0xf2, 0xf0, 0x00, 0x41, 0x11, 0xd0, 0x01, 0x41, 0x11, 0xd1, 0x01, 0x42, 0x11, 0x11, 0xf0,
			0x82, 0x11, 0x43, 0xd0, 0xd0, 0xf0, 0xf0, 0x03, 0x11, 0x05, 0x43, 0xd1, 0xd1, 0xd2, 0xd2, 0x83,
			0x13, 0x40, 0xf2, 0x00, 0x41, 0xd2, 0x13, 0x01, 0x41, 0xd3, 0x13, 0x03, 0x41, 0x11, 0xd1, 0x01,
			0x41, 0x11, 0xd0, 0x00, 0x40, 0xf0, 0x83, 0x11, 0x43, 0xd0, 0xd0, 0xf0, 0xf0, 0x05, 0x0d, 0x07,
			0x43, 0xd1, 0xd1, 0xd2, 0xd2, 0x82, 0x13, 0x42, 0xf2, 0x13, 0x13, 0x01, 0x41, 0xd3, 0x13, 0x03,
			0x41, 0x11, 0xd1, 0x01, 0x42, 0x11, 0x11, 0xf0, 0x82, 0x11, 0x43, 0xd0, 0xd0, 0xf0, 0xf0, 0x07,
			0x0d, 0x09, 0x43, 0xd1, 0xd1, 0xd2, 0xd2, 0x83, 0x13, 0x40, 0xf2, 0x00, 0x41, 0xd2, 0x13, 0x03,
			0x41, 0x11, 0xd0, 0x00, 0x40, 0xf0, 0x83, 0x11, 0x43, 0xd0, 0xd0, 0xf0, 0xf0, 0x09, 0x09, 0x0b,
			0x43, 0xd1, 0xd1, 0xd2, 0xd2, 0x82, 0x13, 0x42, 0xf2, 0x13, 0x13, 0x03, 0x42, 0x11, 0x11, 0xf0,
			0x82, 0x11, 0x43, 0xd0, 0xd0, 0xf0, 0xf0, 0x0b, 0x09, 0x0d, 0x43, 0xd1, 0xd1, 0xd2, 0xd2, 0x83,
			0x13, 0x40, 0xf2, 0x01, 0x40, 0xf0, 0x83, 0x11, 0x43, 0xd0, 0xd0, 0xf0, 0xf0, 0x0d, 0x07, 0x0f,
			0x43, 0xd1, 0xd1, 0xd2, 0xd2, 0x82, 0x13, 0x41, 0xf2, 0xf0, 0x82, 0x11, 0x43, 0xd0, 0xd0, 0xf0,
			0xf0, 0x0f, 0x03, 0x11, 0x4b, 0xd1, 0xd1, 0xd2, 0xd2, 0x13, 0x13, 0x11, 0x11, 0xd0, 0xd0, 0xf0,
			0xf0, 0x11, 0x03, 0x13, 0x47, 0xd1, 0xd1, 0xd2, 0xd2, 0xd0, 0xd0, 0xf0, 0xf0, 0x13, 0x03, 0x15,
			0x43, 0xd1, 0xd1, 0xf0, 0xf0, 0x15};

		screen.clear(0);
		const Common::Rect &clip = screen.getBounds();
		const int32 posX = 100;
		const int32 posY = 100;
		const bool isSprite = false;

		bool result = TwinE::drawGraph(posX, posY, brick_326, isSprite, screen, clip);
		TS_ASSERT_EQUALS(0, screen.getPixel(posX + 21, posY));
		TS_ASSERT_EQUALS(0xd0, screen.getPixel(posX + 22, posY));
		TS_ASSERT_EQUALS(0xf0, screen.getPixel(posX + 25, posY + 37));
		TS_ASSERT_EQUALS(0, screen.getPixel(posX + 26, posY + 37));
		// Common::DumpFile file;
		// file.open("test_gridtest.png");
		// Image::writePNG(file, screen, pal);
		TS_ASSERT(result);
	}
};
