# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class MatchedBlockName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the condition block name that matched blob properties."""

    IF = "If"
    ELSE = "Else"
    NONE = "None"


class OnFailure(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Action to be taken when the operation fails for a object."""

    BREAK = "break"


class OnSuccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Action to be taken when the operation is successful for a object."""

    CONTINUE = "continue"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the provisioning state of the storage task."""

    VALIDATE_SUBSCRIPTION_QUOTA_BEGIN = "ValidateSubscriptionQuotaBegin"
    VALIDATE_SUBSCRIPTION_QUOTA_END = "ValidateSubscriptionQuotaEnd"
    ACCEPTED = "Accepted"
    CREATING = "Creating"
    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    CANCELED = "Canceled"
    FAILED = "Failed"


class RunResult(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the overall result of the execution for the run instance."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"


class RunStatusEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the status of the execution."""

    IN_PROGRESS = "InProgress"
    FINISHED = "Finished"


class StorageTaskOperationName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operation to be performed on the object."""

    SET_BLOB_TIER = "SetBlobTier"
    SET_BLOB_TAGS = "SetBlobTags"
    SET_BLOB_IMMUTABILITY_POLICY = "SetBlobImmutabilityPolicy"
    SET_BLOB_LEGAL_HOLD = "SetBlobLegalHold"
    SET_BLOB_EXPIRY = "SetBlobExpiry"
    DELETE_BLOB = "DeleteBlob"
    UNDELETE_BLOB = "UndeleteBlob"
