# pyOCD debugger
# Copyright (c) 2025 Arm Limited
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import os
import sysconfig

def get_site_packages() -> str:
    """Get the path to the site-packages directory."""
    path = sysconfig.get_path('purelib')
    if not path:
        raise RuntimeError("Could not determine site-packages directory")
    return path

def main() -> None:
    site_packages = get_site_packages()
    # Check if running in GitHub Actions
    github_env = os.getenv('GITHUB_ENV')

    if github_env:
        # If running in GitHub Actions, write to GITHUB_ENV
        with open(github_env, "a") as env_file:
            env_file.write(f"SITE_PACKAGES={site_packages}\n")
    else:
        # If not running in GitHub Actions, print the path
        print(f"SITE_PACKAGES={site_packages}")

if __name__ == "__main__":
    main()
