// This C++ file is the interface between GNU/Octave and Psychtoolbox
// module GetSecs. It defines the entry-point function FGetSecs and the online
// help for GetSecs. The function itself (see bottom of file) is just a
// wrapper around octFunction(), the real command dispatcher defined in
// the PsychScriptingGlue.cc file.
// This file is autogenerated, please do not edit!
//

#ifdef PTBOCTAVE
#define PTBMODULE_GetSecs
#include <octave/oct.h>

extern "C" {
  // mex.cc names both mexFunction (c) and MEXFUNCTION (Fortran)
  // but the mex file only defines one of them, so define the other
  // here just to keep the linker happy, but don't ever call it.
  void F77_FUNC(mexfunction,MEXFUNCTION)() {}
  const char *mexFunctionName = "GetSecs";
} ;

DEFUN_DLD(GetSecs, args, nargout,
"\
 s=GetSecs\n\
 \n\
 GetSecs returns the time in seconds (with high precision) since the\n\
 computer started. GetSecs is an improved replacement for Matlab's\n\
 CPUTIME, which is unreliable.\n\
\n\
 Call GetSecsTick to find out the precision of the clock used by GetSecs.\n\
 \n\
 TIMING ADVICE: the first time you access any MEX function or M file,\n\
 Matlab takes several hundred milliseconds to load it from disk.\n\
 Allocating a variable takes time too. Usually you'll want to omit\n\
 those delays from your timing measurements by making sure all the\n\
 functions you use are loaded and that all the variables you use are\n\
 allocated, before you start timing. MEX files stay loaded until you\n\
 flush the MEX files (e.g. by changing directory or calling CLEAR\n\
 MEX). M files and variables stay in memory until you clear them.\n\
 \n\
 CPUTIME is a Matlab built-in function that is nominally similar to\n\
 GetSecs. Both return absolute time in seconds. A minor difference is\n\
 that GetSecs returns time since System startup, whereas CPUTIME\n\
 returns time since Matlab started. The important difference is that\n\
 CPUTIME was utterly unreliable in Matlab 4, and its help note in\n\
 Matlab 5 says \"The return value may overflow the internal\n\
 representation and wrap around.\" We suggest that you avoid CPUTIME, \n\
 and use GetSecs instead.\n\
\n\
 Win : ___________________________________________________________________\n\
\n\
 On Windows machines the high precision GetPerformanceCounter() call \n\
 is used to get the number of seconds since system start up, if a \n\
 performance counter is available. Otherwise, the less accurate \n\
 GetCurrentTick() is used. \n\
 \n\
 See also: GetSecsTick, WaitSecs, GetTicks, WaitTicks, GetSecsTest, \n\
")
{
  octave_value_list octFunction(const octave_value_list &, const int);
  return octFunction(args, nargout);
}
#endif

