/*=========================================================================
 
 Program:   OpenIGTLLink Library -- Dummy position data
 Module:    $RCSfile: $
 Language:  C
 Date:      $Date: $
 Version:   $Revision: $
 
 Copyright (c) Insight Software Consortium. All rights reserved.
 
 This software is distributed WITHOUT ANY WARRANTY; without even
 the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the above copyright notices for more information.
 
 =========================================================================*/

#ifndef __IGTL_TEST_DATA_COMMAND_FORMAT2_H
#define __IGTL_TEST_DATA_COMMAND_FORMAT2_H

unsigned char test_command_messageFormat2[] = {
  
  /*-------- OpenIGTLink message header -------*/
  0x00, 0x02,                                     /* Version number */
  0x43, 0x4F, 0x4D, 0x4D, 0x41, 0x4E, 0x44, 0x00,
  0x00, 0x00, 0x00, 0x00,                         /* COMMAND */
  0x4F, 0x70, 0x74, 0x69, 0x63, 0x61, 0x6C, 0x54,
  0x72, 0x61, 0x63, 0x6B, 0x65, 0x72, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,                         /* Device name */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* Time stamp */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE9, /* Body size */
  0x85, 0xD2, 0x5E, 0xE9, 0x41, 0x90, 0x17, 0x70, /* CRC */
 
  /* Extended header
   0                 2                      4               8           12
   +-----------------+----------------------+---------------+-------------+
   | EXT_HEADER_SIZE | METADATA_HEADER_SIZE | METADATA_SIZE | MESSAGE_ID  |
   +-----------------+----------------------+---------------+-------------+*/
  0x00, 0x0c, 0x00, 0x12, 0x00, 0x00, 0x00, 0x27,
  0x00, 0x00, 0x00, 0x01,
  
  ////// Start of command message header
  0x00, 0x00, 0x00, 0x05,                          /*Command ID*/
  0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20,
  0x61, 0x20, 0x74, 0x65, 0x73, 0x74, 0x20, 0x63,
  0x6F, 0x6D, 0x6D, 0x61, 0x6E, 0x64, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* Command name*/
  0x00, 0x03,                                      /* Encoding */
  0x00, 0x00, 0x00, 0x1A,                          /* Command length*/
  ////// End of command message header
  
  
  0x53, 0x74, 0x61, 0x72, 0x74, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x74, 0x72, 0x61, 0x63, 0x6B, 0x69,
  0x6E, 0x67, 0x20, 0x6D, 0x61, 0x63, 0x68, 0x69,
  0x6E, 0x65,                                       /* Command */
  
  /*---------- Command Message Meta data body ------------*/
  0x00, 0x02,                                     /* Index Count */
  0x00, 0x11, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, /* first element Key size(2 Bytes), value coding(2 Bytes), value size(4 Bytes)*/
  0x00, 0x12, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, /* second element Key size, value coding, value size*/
  
  0x46, 0x69, 0x72, 0x73, 0x74, 0x20, 0x70, 0x61, /* First Patient Age 22*/
  0x74, 0x69, 0x65, 0x6e, 0x74, 0x20, 0x61, 0x67,
  0x65, 0x32,
  0x32, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x20, /* Second Patient Age 25*/
  0x70, 0x61, 0x74, 0x69, 0x65, 0x6e, 0x74, 0x20,
  0x61, 0x67, 0x65, 0x32, 0x35
  
  
};

#endif /* __IGTL_TEST_DATA_COMMAND_FORMAT2_H */



