static n24 huc620lut[0x200] = {
  0x000000, 0x00001b, 0x01023d, 0x000058, 0x01047b, 0x000095, 0x0205b8, 0x0002d3,
  0x1c0004, 0x200427, 0x1d0141, 0x210664, 0x1d027f, 0x2207a2, 0x1e04bc, 0x2209df,
  0x400610, 0x3c032b, 0x41084e, 0x3d0568, 0x420a8b, 0x3e06a6, 0x420bc8, 0x3e08e3,
  0x5c0514, 0x58022f, 0x5d0752, 0x59046c, 0x5e098f, 0x5a05aa, 0x5e0acd, 0x5a07e7,
  0x780419, 0x7d093b, 0x790656, 0x7d0b79, 0x7a0893, 0x7e0db6, 0x7a09d1, 0x7f0ef3,
  0x9c0b25, 0x99083f, 0x9d0d62, 0x990a7d, 0x9e0fa0, 0x9a0cba, 0x9e11dd, 0x9b0df7,
  0xb80a29, 0xb50744, 0xb90c66, 0xb50981, 0xba0ea4, 0xb60abe, 0xba0fe1, 0xb70cfc,
  0xd4092d, 0xd90e50, 0xd50b6a, 0xda108d, 0xd60da8, 0xda12cb, 0xd60ee5, 0xdb13ff,
  0x092502, 0x05221d, 0x092740, 0x06245a, 0x0a297d, 0x062598, 0x0b2aba, 0x0727d5,
  0x252406, 0x212121, 0x252644, 0x22235e, 0x262881, 0x22249c, 0x2729be, 0x2326d9,
  0x41230a, 0x45282d, 0x412548, 0x462a6b, 0x422785, 0x462ca8, 0x4328c2, 0x472de5,
  0x652a17, 0x612731, 0x662c54, 0x62296f, 0x662e91, 0x622bac, 0x6730cf, 0x632ce9,
  0x81291b, 0x7d2635, 0x822b58, 0x7e2873, 0x822d96, 0x7e2ab0, 0x832fd3, 0x7f2bed,
  0x9d281f, 0xa12d42, 0x9e2a5c, 0xa22f7f, 0x9e2c9a, 0xa331bc, 0x9f2dd7, 0xa332fa,
  0xc12f2b, 0xbd2c46, 0xc23169, 0xbe2e83, 0xc233a6, 0xbf30c0, 0xc335e3, 0xbf31fe,
  0xdd2e2f, 0xd92b4a, 0xde306d, 0xda2d87, 0xde32aa, 0xdb2fc5, 0xdf34e7, 0xdb30ff,
  0x094200, 0x0e471f, 0x0a443a, 0x0e495c, 0x0a4677, 0x0f4b9a, 0x0b47b4, 0x104cd7,
  0x2d4909, 0x2a4623, 0x2e4b46, 0x2a4861, 0x2f4d83, 0x2b4a9e, 0x2746b8, 0x2c4bdb,
  0x49480d, 0x464527, 0x4a4a4a, 0x464765, 0x4b4c87, 0x4749a2, 0x4b4ec5, 0x484adf,
  0x654711, 0x6a4c34, 0x66494e, 0x6a4e71, 0x674b8b, 0x6b50ae, 0x674dc9, 0x6c52ec,
  0x8a4e1d, 0x864b38, 0x8a505a, 0x864d75, 0x8b5298, 0x874fb2, 0x834bcd, 0x8850f0,
  0xa64d21, 0xa24a3c, 0xa64f5f, 0xa24c79, 0xa7519c, 0xa34eb6, 0xa853d9, 0xa44ff4,
  0xc24c25, 0xc65148, 0xc24e63, 0xc75385, 0xc350a0, 0xc755c3, 0xc452dd, 0xc857ff,
  0xe65432, 0xe2504c, 0xe6556f, 0xe35289, 0xdf4fa4, 0xe354c7, 0xe051e1, 0xe456ff,
  0x126700, 0x0e6419, 0x12693c, 0x0f6656, 0x136b79, 0x0f6894, 0x146db7, 0x1069d1,
  0x2e6603, 0x326b25, 0x2e6840, 0x336d63, 0x2f6a7d, 0x346fa0, 0x306cbb, 0x3471dd,
  0x4a6507, 0x4e6a2a, 0x4a6744, 0x4f6c67, 0x4b6981, 0x506ea4, 0x4c6bbf, 0x5070e2,
  0x6e6c13, 0x6a692e, 0x6f6e50, 0x6b6b6b, 0x6f708e, 0x6c6da8, 0x7072cb, 0x6c6ee6,
  0x8a6b17, 0x8e703a, 0x8b6d54, 0x8f7277, 0x8b6f92, 0x9074b5, 0x8c71cf, 0x9076f2,
  0xa66a1b, 0xaa6f3e, 0xa76c59, 0xab717b, 0xa76e96, 0xac73b9, 0xa870d3, 0xac75f6,
  0xca7228, 0xc66e42, 0xcb7365, 0xc7707f, 0xcc75a2, 0xc872bd, 0xcc77e0, 0xc874fa,
  0xe6702c, 0xeb754e, 0xe77269, 0xeb778c, 0xe874a6, 0xec79c9, 0xe876e4, 0xed7bff,
  0x128400, 0x17891b, 0x138636, 0x178b59, 0x148873, 0x188d96, 0x148ab1, 0x198fd3,
  0x378b05, 0x33881f, 0x378d42, 0x338a5d, 0x388f80, 0x348c9a, 0x3991bd, 0x358dd7,
  0x538a09, 0x578f2c, 0x538c46, 0x589169, 0x548e84, 0x5893a6, 0x5590c1, 0x5995e4,
  0x6f890d, 0x738e30, 0x6f8b4a, 0x74906d, 0x708d88, 0x7492ab, 0x718fc5, 0x7594e8,
  0x939119, 0x8f8d34, 0x939257, 0x908f71, 0x949494, 0x9091af, 0x9596d1, 0x9193ec,
  0xaf8f1d, 0xb39440, 0xaf915b, 0xb4967e, 0xb09398, 0xb598bb, 0xb195d5, 0xb59af8,
  0xcb8e22, 0xcf9344, 0xcb905f, 0xd09582, 0xcc929c, 0xd197bf, 0xcd94da, 0xd199fc,
  0xef962e, 0xeb9248, 0xf0976b, 0xec9486, 0xf099a9, 0xed96c3, 0xf19be6, 0xed98ff,
  0x1ba900, 0x1fae1e, 0x1cab38, 0x20b05b, 0x1cad76, 0x21b298, 0x1dafb3, 0x19abcd,
  0x37a800, 0x3bad22, 0x38aa3c, 0x3caf5f, 0x38ac7a, 0x3db19c, 0x39aeb7, 0x3db3da,
  0x5bb00b, 0x57ac26, 0x5cb149, 0x58ae63, 0x5db386, 0x59b0a0, 0x5db5c3, 0x59b2de,
  0x77af0f, 0x7cb432, 0x78b04d, 0x7cb56f, 0x79b28a, 0x75afa5, 0x79b4c7, 0x75b1e2,
  0x93ad13, 0x98b236, 0x94af51, 0x98b474, 0x95b18e, 0x99b6b1, 0x95b3cb, 0x9ab8ee,
  0xb7b520, 0xb4b13a, 0xb8b65d, 0xb4b378, 0xb9b89a, 0xb5b5b5, 0xb9bad8, 0xb6b7f2,
  0xd3b424, 0xd8b947, 0xd4b561, 0xd9ba84, 0xd5b79e, 0xd1b4b9, 0xd5b9dc, 0xd2b6f6,
  0xefb328, 0xf4b84b, 0xf0b465, 0xf5b988, 0xf1b6a3, 0xf5bbc5, 0xf1b8e0, 0xf6bdff,
  0x24cf00, 0x20cb18, 0x24d03a, 0x21cd55, 0x25d278, 0x21cf92, 0x26d4b5, 0x22d1d0,
  0x40ce01, 0x3cca1c, 0x40cf3f, 0x3dcc59, 0x41d17c, 0x3dce96, 0x42d3b9, 0x3ed0d4,
  0x5ccd05, 0x60d228, 0x5cce43, 0x61d365, 0x5dd080, 0x61d5a3, 0x5ed2bd, 0x62d7e0,
  0x80d412, 0x7cd02c, 0x81d54f, 0x7dd269, 0x81d78c, 0x7dd4a7, 0x82d9ca, 0x7ed6e4,
  0x9cd316, 0x98cf30, 0x9dd453, 0x99d16e, 0x9dd690, 0x99d3ab, 0x9ed8ce, 0x9ad5e8,
  0xb8d21a, 0xbcd73d, 0xb9d357, 0xbdd87a, 0xb9d594, 0xbedab7, 0xbad7d2, 0xbedcf5,
  0xdcd926, 0xd8d641, 0xdddb63, 0xd9d77e, 0xdddca1, 0xdad9bb, 0xdedede, 0xdadbf9,
  0xf8d82a, 0xf4d545, 0xf9da67, 0xf5d682, 0xf9dba5, 0xf6d8bf, 0xfadde2, 0xf6dafd,
  0x24ec00, 0x29f11a, 0x25ed34, 0x29f257, 0x25ef72, 0x2af495, 0x26f1af, 0x2bf6d2,
  0x48f303, 0x45f01e, 0x49f541, 0x45f15b, 0x4af67e, 0x46f399, 0x4af8bb, 0x47f5d6,
  0x64f208, 0x61ee22, 0x65f345, 0x61f05f, 0x66f582, 0x62f29d, 0x66f7c0, 0x63f4da,
  0x80f10c, 0x85f62e, 0x81f249, 0x85f76c, 0x82f486, 0x86f9a9, 0x82f6c4, 0x87fbe6,
  0xa5f818, 0xa1f532, 0xa5fa55, 0xa1f670, 0xa6fb93, 0xa2f8ad, 0xa7fdd0, 0xa3faeb,
  0xc1f71c, 0xbdf437, 0xc1f959, 0xbdf574, 0xc2fa97, 0xbef7b1, 0xc3fcd4, 0xbff9ef,
  0xddf620, 0xe1fb43, 0xddf85d, 0xe2fd80, 0xdef99b, 0xe2febe, 0xdffbd8, 0xe3fffb,
  0xfffd2c, 0xfdfa47, 0xffff6a, 0xfefb84, 0xffffa7, 0xfefdc2, 0xffffe4, 0xffffff
};

auto VDP::color(n32 color) -> n64 {
  n1 M = color.bit(9);
  n64 r, g, b;

  if(colorEmulation && colorEmulation->value()) {
    auto index = color.bit(0, 8);
    n8 B = huc620lut[index].bit( 0,  7);
    n8 G = huc620lut[index].bit( 8, 15);
    n8 R = huc620lut[index].bit(16, 23);
    r = image::normalize(R, 8, 16);
    g = image::normalize(G, 8, 16);
    b = image::normalize(B, 8, 16);
  } else { //Linear RGB
    n3 B = color.bit(0,2);
    n3 R = color.bit(3,5);
    n3 G = color.bit(6,8);
    r = image::normalize(R, 3, 16);
    g = image::normalize(G, 3, 16);
    b = image::normalize(B, 3, 16);
  }
  
  if(M == 0) {
    //color
    return r << 32 | g << 16 | b << 0;
  } else {
    //grayscale
    n64 l = r * 0.2126 + g * 0.7152 + b * 0.0722;
    return l << 32 | l << 16 | l << 0;
  }
}

