// Copyright (c) Contributors to the Apptainer project, established as
//   Apptainer a Series of LF Projects LLC.
//   For website terms of use, trademark policy, privacy policy and other
//   project policies see https://lfprojects.org/policies
// Copyright (c) 2018, Sylabs Inc. All rights reserved.
// This software is licensed under a 3-clause BSD license. Please consult the
// LICENSE.md file distributed with the sources of this project regarding your
// rights to use or distribute this software.

package auth

import (
	"testing"

	"github.com/apptainer/apptainer/internal/pkg/test"
)

const (
	testToken     = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWUsImlhdCI6MTUxNjIzOTAyMn0.TCYt5XsITJX1CxPCT8yAV-TVkIEq_PbChOMqsLfRoPsnsgw5WEuts01mq-pQy7UJiN5mgRxD-WUcX16dUEMGlv50aqzpqh4Qktb3rk-BuQy72IFLOqV0G_zS245-kronKb78cPN25DGlcTwLtjPAYuNzVBAh4vGHSrQyHUdBBPM" // #nosec G101
	testTokenPath = "test_data/test_token"
)

func Test_ReadToken(t *testing.T) {
	test.DropPrivilege(t)
	defer test.ResetPrivilege(t)

	result, _ := ReadToken("/no/such/file")
	if result != "" {
		t.Errorf("readToken from invalid file must give empty string")
	}

	_, err := ReadToken("test_data/test_token_toosmall")
	if err != ErrTokenTooShort {
		t.Errorf("readToken from file with bad (too small) token must give empty string")
	}

	result, _ = ReadToken(testTokenPath)
	if result != testToken {
		t.Errorf("readToken from valid file must match expected result")
	}
}
