/* $Id: keyboard-layouts.h $ */
/** @file
 * VBox/Frontends/Common - X11 keyboard driver translation tables (keyboard layouts).
 *
 * This file was generated by successively loading each of the keyboard
 * layouts listed in the file keyboard-list.h into the X server and
 * reading and dumping the values associated with each key.  The format
 * of the dumped data is chosen to be compatible with the keyboard code
 * in keyboard-new.c, which is based on code from the Wine project.
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

/*
 * Oracle LGPL Disclaimer: For the avoidance of doubt, except that if any license choice
 * other than GPL or LGPL is available it will apply instead, Oracle elects to use only
 * the Lesser General Public License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the language indicating
 * that LGPLv2 or any later version may be used, or where a choice of which version
 * of the LGPL is applied is otherwise unspecified.
 */

#ifndef ___VBox_keyboard_tables_h
# error This file must be included from within keyboard-tables.h
#endif /* !___VBox_keyboard_tables_h */

/* This file contains a more or less complete dump of all keyboard
   layouts known to my version of X.org.  Duplicate layouts have
   been removed to save space and lookup time, and the Japanese
   layout has been manually corrected, due to differences in handling
   between 105 and 106-key keyboards.

   Note that contrary to the original tables in the Wine source code,
   these tables simply contain the X keysym values truncated to the
   least significant byte.  In fact, there is no need to do any
   additional translation of the values (the original code translated
   them to whatever character set was deemed appropriate, rather
   inconsistently) as long as we use the same algorithm for creating
   the tables and doing the lookups.

   The last three entries in the tables are respectively the 102nd
   key on 102/105/106 key keyboards, the extra key on Brazilian and
   Japanese keyboards and the Yen key on Japanese keyboards.
   The layout-switching keys on Japanese and Korean keyboards are
   dealt with elsewhere. */

/* The tables concatenate strings to avoid mis-concatenating hex
   constants; e.g. `` "\x3""1" '' to generate bytes 0x03 0x31. */
#ifdef __clang__
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wstring-concatenation"
#endif

/* U.S. English */
static const char main_key_us[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* U.S. English, International (with dead keys) */
static const char main_key_us_intl[MAIN_LEN][2] =
{
{'P','S'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','R'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'Q','W'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* U.S. English, International, alternative 102nd key */
static const char main_key_us_intl_alt102[MAIN_LEN][2] =
{
{'P','S'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','R'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'Q','W'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'\\','|'},{0,0},{0,0}
};

/* U.S. English, Dvorak */
static const char main_key_us_dvorak[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'[','{'},{']','}'},
{'\'','"'},{',','<'},{'.','>'},{'p','P'},{'y','Y'},{'f','F'},{'g','G'},{'c','C'},{'r','R'},{'l','L'},{'/','?'},{'=','+'},
{'a','A'},{'o','O'},{'e','E'},{'u','U'},{'i','I'},{'d','D'},{'h','H'},{'t','T'},{'n','N'},{'s','S'},{'-','_'},{'\\','|'},
{';',':'},{'q','Q'},{'j','J'},{'k','K'},{'x','X'},{'b','B'},{'m','M'},{'w','W'},{'v','V'},{'z','Z'},{'<','>'},{0,0},{0,0}
};

/* U.S. English, Left handed Dvorak */
static const char main_key_us_dvorak_l[MAIN_LEN][2] =
{
{'`','~'},{'[','{'},{']','}'},{'/','?'},{'p','P'},{'f','F'},{'m','M'},{'l','L'},{'j','J'},{'4','$'},{'3','#'},{'2','@'},{'1','!'},
{';',':'},{'q','Q'},{'b','B'},{'y','Y'},{'u','U'},{'r','R'},{'s','S'},{'o','O'},{'.','>'},{'6','^'},{'5','%'},{'=','+'},
{'-','_'},{'k','K'},{'c','C'},{'d','D'},{'t','T'},{'h','H'},{'e','E'},{'a','A'},{'z','Z'},{'8','*'},{'7','&'},{'\\','|'},
{'\'','"'},{'x','X'},{'g','G'},{'v','V'},{'w','W'},{'n','N'},{'i','I'},{',','<'},{'0',')'},{'9','('},{'<','>'},{0,0},{0,0}
};

/* U.S. English, Right handed Dvorak */
static const char main_key_us_dvorak_r[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'j','J'},{'l','L'},{'m','M'},{'f','F'},{'p','P'},{'/','?'},{'[','{'},{']','}'},
{'5','%'},{'6','^'},{'q','Q'},{'.','>'},{'o','O'},{'r','R'},{'s','S'},{'u','U'},{'y','Y'},{'b','B'},{';',':'},{'=','+'},
{'7','&'},{'8','*'},{'z','Z'},{'a','A'},{'e','E'},{'h','H'},{'t','T'},{'d','D'},{'c','C'},{'k','K'},{'-','_'},{'\\','|'},
{'9','('},{'0',')'},{'x','X'},{',','<'},{'i','I'},{'n','N'},{'w','W'},{'v','V'},{'g','G'},{'\'','"'},{'<','>'},{0,0},{0,0}
};

/* U.S. English, Classic Dvorak */
static const char main_key_us_dvorak_classic[MAIN_LEN][2] =
{
{'`','~'},{'[','{'},{'7','&'},{'5','%'},{'3','#'},{'1','!'},{'9','('},{'0',')'},{'2','@'},{'4','$'},{'6','^'},{'8','*'},{']','}'},
{'/','?'},{',','<'},{'.','>'},{'p','P'},{'y','Y'},{'f','F'},{'g','G'},{'c','C'},{'r','R'},{'l','L'},{'\'','"'},{'=','+'},
{'a','A'},{'o','O'},{'e','E'},{'u','U'},{'i','I'},{'d','D'},{'h','H'},{'t','T'},{'n','N'},{'s','S'},{'-','_'},{'\\','|'},
{';',':'},{'q','Q'},{'j','J'},{'k','K'},{'x','X'},{'b','B'},{'m','M'},{'w','W'},{'v','V'},{'z','Z'},{'<','>'},{0,0},{0,0}
};

/* U.S. English, Russian phonetic */
static const char main_key_us_rus[MAIN_LEN][2] =
{
{'\xa3','\xb3'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'\xdf','\xff'},
{'\xd1','\xf1'},{'\xd7','\xf7'},{'\xc5','\xe5'},{'\xd2','\xf2'},{'\xd4','\xf4'},{'\xd9','\xf9'},{'\xd5','\xf5'},{'\xc9','\xe9'},{'\xcf','\xef'},{'\xd0','\xf0'},{'\xdb','\xfb'},{'\xdd','\xfd'},
{'\xc1','\xe1'},{'\xd3','\xf3'},{'\xc4','\xe4'},{'\xc6','\xe6'},{'\xc7','\xe7'},{'\xc8','\xe8'},{'\xca','\xea'},{'\xcb','\xeb'},{'\xcc','\xec'},{'\xde','\xfe'},{'\xc0','\xe0'},{'\xdc','\xfc'},
{'\xda','\xfa'},{'\xd8','\xf8'},{'\xc3','\xe3'},{'\xd6','\xf6'},{'\xc2','\xe2'},{'\xce','\xee'},{'\xcd','\xed'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* U.S. English, Colemak */
static const char main_key_us_col[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'f','F'},{'p','P'},{'g','G'},{'j','J'},{'l','L'},{'u','U'},{'y','Y'},{';',':'},{'[','{'},{']','}'},
{'a','A'},{'r','R'},{'s','S'},{'t','T'},{'d','D'},{'h','H'},{'n','N'},{'e','E'},{'i','I'},{'o','O'},{'\'','"'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'k','K'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'-','_'},{0,0},{0,0}
};

/* Afghanistan */
static const char main_key_af[MAIN_LEN][2] =
{
{'\x0d','\xf7'},{'\xf1','!'},{'\xf2','l'},{'\xf3','k'},{'\xf4','\x0b'},{'\xf5','j'},{'\xf6','\xd7'},{'\xf7','\xac'},{'\xf8','*'},{'\xf9',')'},{'\xf0','('},{'-','\xe0'},{'+','='},
{'\xd6','\xf2'},{'\xd5','\xec'},{'\xcb','\xed'},{'\xe2','\xeb'},{'\xe1','\xef'},{'\xda','\xf0'},{'\xd9','\xee'},{'\xe7','\xf1'},{'\xce',']'},{'\xcd','['},{'\xcc','}'},{'\x86','{'},
{'\xd4','\xc4'},{'\xd3','\xc6'},{'\xcc','\xea'},{'\xc8','\xc5'},{'\xe4','\xc3'},{'\xc7','\xc2'},{'\xca','\xc9'},{'\xe6','\xbb'},{'\xe5','\xab'},{'\xa9',':'},{'\xaf','\xbb'},{'\\','|'},
{'\xd8','\xe3'},{'\xd7','S'},{'\xd2','\x98'},{'\xd1','p'},{'\xd0','\x0c'},{'\xcf','T'},{'~','\xc1'},{'\xe8','>'},{'.','<'},{'/','\xbf'},{'<','>'},{0,0},{0,0}
};

/* Afghanistan, Pashto */
static const char main_key_af_ps[MAIN_LEN][2] =
{
{'\x0d','\xf7'},{'\xf1','!'},{'\xf2','l'},{'\xf3','k'},{'\xf4','\x0b'},{'\xf5','j'},{'\xf6','\xd7'},{'\xf7','\xbb'},{'\xf8','\xab'},{'\xf9',')'},{'\xf0','('},{'-','\xe0'},{'+','='},
{'\xd6','\xf2'},{'\xd5','\xec'},{'\xcb','\xed'},{'\xe2','\xeb'},{'\xe1','\xef'},{'\xda','\xf0'},{'\xd9','\xee'},{'\xe7','\xf1'},{'\xce','\x81'},{'\xcd','\x85'},{'\xcc',']'},{'\x86','['},
{'\xd4','\x9a'},{'\xd3','\xc6'},{'\xcc','\xea'},{'\xc8','~'},{'\xe4','\xc3'},{'\xc7','\xc2'},{'\xca','|'},{'\xe6','\xbc'},{'\xe5',')'},{'\xa9',':'},{'\xab','\xbb'},{'\\','*'},
{'\xcd','8'},{'\xd0','7'},{'\xd2','\x98'},{'\xd1','!'},{'\xd0','\x0c'},{'\xcf','\x89'},{'\x93','$'},{'\xe8','\x0c'},{'\x96','.'},{'/','\xbf'},{'<','>'},{0,0},{0,0}
};

/* Afghanistan, Southern Uzbek */
static const char main_key_af_uz[MAIN_LEN][2] =
{
{'\x0d','\xf7'},{'\xf1','!'},{'\xf2','l'},{'\xf3','k'},{'\xf4','\x0b'},{'\xf5','j'},{'\xf6','\xd7'},{'\xf7','\xac'},{'\xf8','*'},{'\xf9',')'},{'\xf0','('},{'-','\xe0'},{'+','='},
{'\xd6','\xf2'},{'\xd5','\xec'},{'\xcb','\xed'},{'\xe2','\xeb'},{'\xe1','\xef'},{'\xda','\xf0'},{'\xd9','\xee'},{'\xe7','\xf1'},{'\xce',']'},{'\xcd','['},{'\xcc','}'},{'\x86','{'},
{'\xd4','\xc4'},{'\xd3','\xc6'},{'\xcc','\xea'},{'\xc8','\xd0'},{'\xe4','\xc3'},{'\xc7','\xc2'},{'\xca','\xc9'},{'\xe6','\xbb'},{'\xe5','\xab'},{'\xa9',':'},{'\xaf','\xbb'},{'\\','|'},
{'\xd8','\xc9'},{'\xd7','\xc7'},{'\xd2','\x98'},{'\xd1','%'},{'\xd0','\x0c'},{'\xcf','T'},{'~','\xc1'},{'\xe8','>'},{'.','<'},{'/','\xbf'},{'<','>'},{0,0},{0,0}
};

/* Arabic */
static const char main_key_ara[MAIN_LEN][2] =
{
{'\xd0','\xf1'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xd6','\xee'},{'\xd5','\xeb'},{'\xcb','\xef'},{'\xe2','\xec'},{'\xe1','\xf9'},{'\xda','\xc5'},{'\xd9','`'},{'\xe7','\xf7'},{'\xce','\xd7'},{'\xcd','\xbb'},{'\xcc','{'},{'\xcf','}'},
{'\xd4','\\'},{'\xd3','S'},{'\xea','['},{'\xc8',']'},{'\xe4','\xf7'},{'\xc7','\xc3'},{'\xca','\xe0'},{'\xe6','\xac'},{'\xe5','/'},{'\xe3',':'},{'\xd7','"'},{'<','>'},
{'\xc6','~'},{'\xc1','\xf2'},{'\xc4','\xf0'},{'\xd1','\xed'},{'\xfb','\xf5'},{'\xe9','\xc2'},{'\xc9','\''},{'\xe8',','},{'\xd2','.'},{'\xd8','\xbf'},{'|','\xa6'},{0,0},{0,0}
};

/* Arabic, azerty */
static const char main_key_ara_azerty[MAIN_LEN][2] =
{
{'\xd0','\xf1'},{'&','1'},{'\xe9','2'},{'"','3'},{'\'','4'},{'(','5'},{'-','6'},{'\xe8','7'},{'_','8'},{'\xe7','9'},{'\xe0','0'},{')','\xb0'},{'=','+'},
{'\xd6','\xee'},{'\xd5','\xeb'},{'\xcb','\xef'},{'\xe2','\xec'},{'\xe1','\xf9'},{'\xda','\xc5'},{'\xd9','`'},{'\xe7','\xf7'},{'\xce','\xd7'},{'\xcd','\xbb'},{'\xcc','{'},{'\xcf','}'},
{'\xd4','\\'},{'\xd3','S'},{'\xea','['},{'\xc8',']'},{'\xe4','\xf7'},{'\xc7','\xc3'},{'\xca','\xe0'},{'\xe6','\xac'},{'\xe5','/'},{'\xe3',':'},{'\xd7','"'},{'<','>'},
{'\xc6','~'},{'\xc1','\xf2'},{'\xc4','\xf0'},{'\xd1','\xed'},{'\xfb','\xf5'},{'\xe9','\xc2'},{'\xc9','\''},{'\xe8',','},{'\xd2','.'},{'\xd8','\xbf'},{'|','\xa6'},{0,0},{0,0}
};

/* Arabic, azerty/digits */
static const char main_key_ara_azerty_digits[MAIN_LEN][2] =
{
{'\xd0','\xf1'},{'&','a'},{'\xe9','b'},{'"','c'},{'\'','d'},{'(','e'},{'-','f'},{'\xe8','g'},{'_','h'},{'\xe7','i'},{'\xe0','`'},{')','\xb0'},{'=','+'},
{'\xd6','\xee'},{'\xd5','\xeb'},{'\xcb','\xef'},{'\xe2','\xec'},{'\xe1','\xf9'},{'\xda','\xc5'},{'\xd9','`'},{'\xe7','\xf7'},{'\xce','\xd7'},{'\xcd','\xbb'},{'\xcc','{'},{'\xcf','}'},
{'\xd4','\\'},{'\xd3','S'},{'\xea','['},{'\xc8',']'},{'\xe4','\xf7'},{'\xc7','\xc3'},{'\xca','\xe0'},{'\xe6','\xac'},{'\xe5','/'},{'\xe3',':'},{'\xd7','"'},{'<','>'},
{'\xc6','~'},{'\xc1','\xf2'},{'\xc4','\xf0'},{'\xd1','\xed'},{'\xfb','\xf5'},{'\xe9','\xc2'},{'\xc9','\''},{'\xe8',','},{'\xd2','.'},{'\xd8','\xbf'},{'|','\xa6'},{0,0},{0,0}
};

/* Arabic, digits */
static const char main_key_ara_digits[MAIN_LEN][2] =
{
{'\xd0','\xf1'},{'a','!'},{'b','@'},{'c','#'},{'d','$'},{'e','%'},{'f','^'},{'g','&'},{'h','*'},{'i','('},{'`',')'},{'-','_'},{'=','+'},
{'\xd6','\xee'},{'\xd5','\xeb'},{'\xcb','\xef'},{'\xe2','\xec'},{'\xe1','\xf9'},{'\xda','\xc5'},{'\xd9','`'},{'\xe7','\xf7'},{'\xce','\xd7'},{'\xcd','\xbb'},{'\xcc','{'},{'\xcf','}'},
{'\xd4','\\'},{'\xd3','S'},{'\xea','['},{'\xc8',']'},{'\xe4','\xf7'},{'\xc7','\xc3'},{'\xca','\xe0'},{'\xe6','\xac'},{'\xe5','/'},{'\xe3',':'},{'\xd7','"'},{'<','>'},
{'\xc6','~'},{'\xc1','\xf2'},{'\xc4','\xf0'},{'\xd1','\xed'},{'\xfb','\xf5'},{'\xe9','\xc2'},{'\xc9','\''},{'\xe8',','},{'\xd2','.'},{'\xd8','\xbf'},{'|','\xa6'},{0,0},{0,0}
};

/* Arabic, Buckwalter */
static const char main_key_ara_buckwalter[MAIN_LEN][2] =
{
{'p','\xf1'},{'a','\xff'},{'b','\xff'},{'c','\xff'},{'d','\xd4'},{'e','j'},{'f','\xff'},{'g','\xc4'},{'h','\xd0'},{'i','>'},{'`','?'},{'-','\xe0'},{'=','+'},
{'\xe2','\xff'},{'\xe8','\xc4'},{'\xff','\xd9'},{'\xd1','\xff'},{'\xca','\xd7'},{'\xea','\xe9'},{'\xef','\xff'},{'\xf0','\xc5'},{'\xf2','\xc3'},{'\xc9','\xff'},{'\xff','q'},{'\xff','\xc6'},
{'\xee','\xc7'},{'\xd3','\xd5'},{'\xcf','\xd6'},{'\xe1','\xeb'},{'\xda','\xff'},{'\xe7','\xcd'},{'\xcc','\xff'},{'\xe3','\xed'},{'\xe4','\xff'},{'\xbb','\xff'},{'\xc1','\xff'},{'\xff','\xc2'},
{'\xd2','\xd8'},{'\xce','\xff'},{'\xff','\xff'},{'\xcb','\xff'},{'\xc8','\xff'},{'\xe6','\xec'},{'\xe5','\xff'},{'\xac','\xc5'},{'\xd4','\xc3'},{'\xff','\xbf'},{'<','>'},{0,0},{0,0}
};

/* Albania */
static const char main_key_al[MAIN_LEN][2] =
{
{'\\','|'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe7','\xc7'},{'@','\''},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xeb','\xcb'},{'[','{'},{']','}'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Armenia */
static const char main_key_am[MAIN_LEN][2] =
{
{']','\\'},{'\x86','V'},{'q','A'},{'\x13','\x14'},{',','$'},{'\x89','&'},{'^','%'},{'$','\x87'},{'[','\xbc'},{')','('},{'\x85','U'},{'g','7'},{'r','B'},
{'s','C'},{'\x83','S'},{'b','2'},{'}','M'},{'t','D'},{'x','H'},{'\x82','R'},{'o','?'},{'h','8'},{'i','9'},{'n','>'},{'\x81','Q'},
{'{','K'},{'~','N'},{'c','3'},{'e','5'},{'a','1'},{'v','F'},{'k',';'},{'\x7f','O'},{'p','@'},{'z','J'},{'\x80','P'},{'\xbb','\xab'},
{'j',':'},{'d','4'},{'y','I'},{'u','E'},{'f','6'},{'l','<'},{'\x84','T'},{'m','='},{'w','G'},{'|','L'},{'?','\x8a'},{0,0},{0,0}
};

/* Armenia, Phonetic */
static const char main_key_am_phonetic[MAIN_LEN][2] =
{
{']','\\'},{'g','7'},{'i','9'},{'\x83','S'},{'q','A'},{'{','K'},{'\x82','R'},{'\x87','\x87'},{'\x80','P'},{'y','I'},{'s','C'},{'-','\x15'},{'j',':'},
{'\x84','T'},{'x','H'},{'e','5'},{'|','L'},{'\x7f','O'},{'h','8'},{'\x82','R'},{'k',';'},{'\x85','U'},{'z','J'},{'m','='},{'n','>'},
{'a','1'},{'}','M'},{'d','4'},{'\x86','V'},{'c','3'},{'p','@'},{'u','E'},{'o','?'},{'l','<'},{';','\x89'},{'[','"'},{'w','G'},
{'f','6'},{'r','B'},{'\x81','Q'},{'~','N'},{'b','2'},{'v','F'},{'t','D'},{',','\xab'},{'$','\xbb'},{'/','^'},{'?','\x8a'},{0,0},{0,0}
};

/* Armenia, Eastern */
static const char main_key_am_eastern[MAIN_LEN][2] =
{
{']','\\'},{'\x89','\xb1'},{'q','A'},{'u','E'},{'[','\xb3'},{',','\xb4'},{'-','\xb9'},{'.','\x87'},{'\xab','('},{'\xbb',')'},{'\x85','U'},{'|','L'},{'j',':'},
{'m','='},{'\x82','R'},{'g','7'},{'\x80','P'},{'\x7f','O'},{'e','5'},{'h','8'},{'k',';'},{'x','H'},{'z','J'},{'y','I'},{'{','K'},
{'a','1'},{'}','M'},{'d','4'},{'\x86','V'},{'c','3'},{'p','@'},{'s','C'},{'o','?'},{'l','<'},{'i','9'},{'\x83','S'},{'\'','^'},
{'f','6'},{'\x81','Q'},{'\x84','T'},{'~','N'},{'b','2'},{'v','F'},{'t','D'},{'w','G'},{'r','B'},{'n','>'},{'<','>'},{0,0},{0,0}
};

/* Armenia, Western */
static const char main_key_am_western[MAIN_LEN][2] =
{
{']','\\'},{'\x89','\xb1'},{'q','A'},{'u','E'},{'[','\xb3'},{',','\xb4'},{'-','\xb9'},{'.','\x87'},{'\xab','('},{'\xbb',')'},{'\x85','U'},{'|','L'},{'j',':'},
{'m','='},{'~','N'},{'g','7'},{'\x80','P'},{'d','4'},{'e','5'},{'h','8'},{'k',';'},{'x','H'},{'b','2'},{'y','I'},{'{','K'},
{'a','1'},{'}','M'},{'\x7f','O'},{'\x86','V'},{'o','?'},{'p','@'},{'s','C'},{'\x84','T'},{'l','<'},{'i','9'},{'\x83','S'},{'\'','^'},
{'f','6'},{'\x81','Q'},{'c','3'},{'\x82','R'},{'z','J'},{'v','F'},{'t','D'},{'w','G'},{'r','B'},{'n','>'},{'<','>'},{0,0},{0,0}
};

/* Armenia, Alternative Eastern */
static const char main_key_am_eastern_alt[MAIN_LEN][2] =
{
{']','\\'},{'\x89','\xb1'},{'q','A'},{'u','E'},{'[','\xb3'},{',','\xb4'},{'-','\xb9'},{'.','\x87'},{'\xab','('},{'\xbb',')'},{'\x85','U'},{'|','L'},{'j',':'},
{'m','='},{'\x82','R'},{'g','7'},{'\x80','P'},{'\x7f','O'},{'e','5'},{'h','8'},{'k',';'},{'x','H'},{'z','J'},{'y','I'},{'{','K'},
{'a','1'},{'}','M'},{'d','4'},{'\x86','V'},{'\x84','T'},{'p','@'},{'s','C'},{'o','?'},{'l','<'},{'i','9'},{'\x83','S'},{'\'','^'},
{'f','6'},{'\x81','Q'},{'c','3'},{'~','N'},{'b','2'},{'v','F'},{'t','D'},{'w','G'},{'r','B'},{'n','>'},{'<','>'},{0,0},{0,0}
};

/* Azerbaijan */
static const char main_key_az[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6',':'},{'7','?'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'\xfc','\xdc'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','\xa9'},{'o','O'},{'p','P'},{'\xf6','\xd6'},{'\xbb','\xab'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xb9','I'},{'Y','\x8f'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{'\xe7','\xc7'},{'\xba','\xaa'},{'.',','},{'<','>'},{0,0},{0,0}
};

/* Azerbaijan, Cyrillic */
static const char main_key_az_cyrillic[MAIN_LEN][2] =
{
{0,0},{0,0},{'2','"'},{'3','#'},{'4',';'},{0,0},{'6',':'},{'7','?'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{0,0},
{'\xa8','\xb8'},{'\xaf','\xae'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xbb','\xba'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xb9','\xb8'},
{'\xc6','\xe6'},{'\xd9','\xf9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\x9d','\x9c'},{'\\','|'},
{'\xd9','\xd8'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\x93','\x92'},{'\xc2','\xe2'},{'\xe9','\xe8'},{'.',','},{'<','>'},{0,0},{0,0}
};

/* Belarus */
static const char main_key_by[MAIN_LEN][2] =
{
{'\xa3','\xb3'},{0,0},{'2','"'},{0,0},{'4',';'},{'5','%'},{'6',':'},{'7','?'},{0,0},{0,0},{0,0},{0,0},{0,0},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xae','\xbe'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\'','\''},
{'\xc6','\xe6'},{'\xd9','\xf9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xdc','\xfc'},{'/','|'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xa6','\xb6'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'.',','},{'|','\xa6'},{0,0},{0,0}
};

/* Belarus, Winkeys */
static const char main_key_by_winkeys[MAIN_LEN][2] =
{
{'\xa3','\xb3'},{0,0},{'2','"'},{'3','#'},{'4',';'},{'5','%'},{'6',':'},{'7','?'},{'8','*'},{0,0},{0,0},{0,0},{0,0},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xae','\xbe'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\'','\''},
{'\xc6','\xe6'},{'\xd9','\xf9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xdc','\xfc'},{'/','|'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xa6','\xb6'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'.',','},{'|','\xa6'},{0,0},{0,0}
};

/* Belgium */
static const char main_key_be[MAIN_LEN][2] =
{
{'\xb2','\xb3'},{'&','1'},{'\xe9','2'},{'"','3'},{'\'','4'},{'(','5'},{'\xa7','6'},{'\xe8','7'},{'!','8'},{'\xe7','9'},{'\xe0','0'},{')','\xb0'},{'-','_'},
{'a','A'},{'z','Z'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'R','W'},{'$','*'},
{'q','Q'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'\xf9','%'},{'\xb5','\xa3'},
{'w','W'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','?'},{';','.'},{':','/'},{'=','+'},{'<','>'},{0,0},{0,0}
};

/* Belgium, Eliminate dead keys */
static const char main_key_be_nodeadkeys[MAIN_LEN][2] =
{
{'\xb2','\xb3'},{'&','1'},{'\xe9','2'},{'"','3'},{'\'','4'},{'(','5'},{'\xa7','6'},{'\xe8','7'},{'!','8'},{'\xe7','9'},{'\xe0','0'},{')','\xb0'},{'-','_'},
{'a','A'},{'z','Z'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'^','\xa8'},{'$','*'},
{'q','Q'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'\xf9','%'},{'\xb5','\xa3'},
{'w','W'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','?'},{';','.'},{':','/'},{'=','+'},{'<','>'},{0,0},{0,0}
};

/* Belgium, Sun dead keys */
static const char main_key_be_sundeadkeys[MAIN_LEN][2] =
{
{'\xb2','\xb3'},{'&','1'},{'\xe9','2'},{'"','3'},{'\'','4'},{'(','5'},{'\xa7','6'},{'\xe8','7'},{'!','8'},{'\xe7','9'},{'\xe0','0'},{')','\xb0'},{'-','_'},
{'a','A'},{'z','Z'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\x01','\x04'},{'$','*'},
{'q','Q'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'\xf9','%'},{'\xb5','\xa3'},
{'w','W'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','?'},{';','.'},{':','/'},{'=','+'},{'<','>'},{0,0},{0,0}
};

/* Bangladesh */
static const char main_key_bd[MAIN_LEN][2] =
{
{'`','~'},{'\xe7','!'},{'\xe8','@'},{'\xe9','#'},{'\xea','$'},{'\xeb','%'},{'\xec','^'},{'\xed','&'},{'\xee','*'},{'\xef','('},{'\xe6',')'},{'-','_'},{'=','+'},
{'\x99','\x82'},{'\xaf','\xdf'},{'\xa1','\xa2'},{'\xaa','\xab'},{'\x9f','\xa0'},{'\x9a','\x9b'},{'\x9c','\x9d'},{'\xb9','\x9e'},{'\x97','\x98'},{'\xdc','\xdd'},{'[','{'},{']','}'},
{'\xc3','\xd7'},{'\xc1','\xc2'},{'\xbf','\xc0'},{'\xac','\xad'},{'\xcd','d'},{'\xbe','\x85'},{'\x95','\x96'},{'\xa4','\xa5'},{'\xa6','\xa7'},{';',':'},{'\'','"'},{'\\','|'},
{'\x81','\x83'},{'\xcb','\xcc'},{'\xc7','\xc8'},{'\xb0','\xb2'},{'\xa8','\xa3'},{'\xb8','\xb7'},{'\xae','\xb6'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Bangladesh, Probhat */
static const char main_key_bd_probhat[MAIN_LEN][2] =
{
{'`','~'},{'\xe7','!'},{'\xe8','@'},{'\xe9','#'},{'\xea','\xf3'},{'\xeb','%'},{'\xec','^'},{'\xed','\x9e'},{'\xee','\xce'},{'\xef','('},{'\xe6',')'},{'\x0c','_'},{'=','\x0d'},
{'\xa6','\xa7'},{'\xc2','\x8a'},{'\xc0','\x88'},{'\xb0','\xdc'},{'\x9f','\xa0'},{'\x8f','\x90'},{'\xc1','\x89'},{'\xbf','\x87'},{'\x93','\x94'},{'\xaa','\xab'},{'\xc7','\xc8'},{'\xcb','\xcc'},
{'\xbe','\x85'},{'\xb8','\xb7'},{'\xa1','\xa2'},{'\xa4','\xa5'},{'\x97','\x98'},{'\xb9','\x83'},{'\x9c','\x9d'},{'\x95','\x96'},{'\xb2','\x82'},{';',':'},{'\'','"'},{'\\','e'},
{'\xdf','\xaf'},{'\xb6','\xdd'},{'\x9a','\x9b'},{'\x86','\x8b'},{'\xac','\xad'},{'\xa8','\xa3'},{'\xae','\x99'},{',','\xc3'},{'d','\x81'},{'\xcd','?'},{'<','>'},{0,0},{0,0}
};

/* India */
static const char main_key_in[MAIN_LEN][2] =
{
{'J','\x12'},{'g','\x0d'},{'h','E'},{'i','i'},{'j','j'},{'k','k'},{'l','l'},{'m','m'},{'n','n'},{'o','('},{'f',')'},{'\x03','\x03'},{'C','\x0b'},
{'L','\x14'},{'H','\x10'},{'>','\x06'},{'@','\x08'},{'B','\x0a'},{',','-'},{'9','\x19'},{'\x17','\x18'},{'&','\''},{'\x1c','\x1d'},{'!','"'},{'<','\x1e'},
{'K','\x13'},{'G','\x0f'},{'M','\x05'},{'?','\x07'},{'A','\x09'},{'*','+'},{'0','1'},{'\x15','\x16'},{'$','%'},{'\x1a','\x1b'},{'\x1f','\x20'},{'I','\x11'},
{'F','\x0e'},{'\x02','\x01'},{'.','#'},{'(',')'},{'5','4'},{'2','3'},{'8','6'},{',','7'},{'.','d'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* India, Bengali */
static const char main_key_in_ben[MAIN_LEN][2] =
{
{0,0},{'\xe7','\xe7'},{'\xe8','\xe8'},{'\xe9','\xe9'},{'\xea','\xea'},{'\xeb','\xeb'},{'\xec','\xec'},{'\xed','\xed'},{'\xee','\xee'},{'\xef','('},{'\xe6',')'},{'-','\x83'},{'\x8b','\xc3'},
{'\xcc','\x94'},{'\xc8','\x90'},{'\xbe','\x86'},{'\xc0','\x88'},{'\xc2','\x8a'},{'\xac','\xad'},{'\xb9','\x99'},{'\x97','\x98'},{'\xa6','\xa7'},{'\x9c','\x9d'},{'\xa1','\xa2'},{'\xbc','\x9e'},
{'\xcb','\x93'},{'\xc7','\x8f'},{'\xcd','\x85'},{'\xbf','\x87'},{'\xc1','\x89'},{'\xaa','\xab'},{'\xb0','\xdd'},{'\x95','\x96'},{'\xa4','\xa5'},{'\x9a','\x9b'},{'\x9f','\xa0'},{'\\','|'},
{'z','Z'},{'\x82','\x81'},{'\xae','\xa3'},{'\xa8','\xa8'},{'\xac','\xac'},{'\xb2','\xb2'},{'\xb8','\xb6'},{',','\xb7'},{'.','d'},{'\xdf','\xaf'},{'<','>'},{0,0},{0,0}
};

/* India, Gujarati */
static const char main_key_in_guj[MAIN_LEN][2] =
{
{0,0},{'\xe7','\x8d'},{'\xe8','\xc5'},{'\xe9','\xe9'},{'\xea','\xea'},{'\xeb','\xeb'},{'\xec','\xec'},{'\xed','\xed'},{'\xee','\xee'},{'\xef','('},{'\xe6',')'},{'-','\x83'},{'\x8b','\xc3'},
{'\xcc','\x94'},{'\xc8','\x90'},{'\xbe','\x86'},{'\xc0','\x88'},{'\xc2','\x8a'},{'\xac','\xad'},{'\xb9','\x99'},{'\x97','\x98'},{'\xa6','\xa7'},{'\x9c','\x9d'},{'\xa1','\xa2'},{'\xbc','\x9e'},
{'\xcb','\x93'},{'\xc7','\x8f'},{'\xcd','\x85'},{'\xbf','\x87'},{'\xc1','\x89'},{'\xaa','\xab'},{'\xb0','\xb0'},{'\x95','\x96'},{'\xa4','\xa5'},{'\x9a','\x9b'},{'\x9f','\xa0'},{'\xc9','\x91'},
{'z','Z'},{'\x82','\x81'},{'\xae','\xa3'},{'\xa8','\xa8'},{'\xb5','\xb5'},{'\xb2','\xb3'},{'\xb8','\xb6'},{',','\xb7'},{'.','d'},{'\xaf','?'},{'<','>'},{0,0},{0,0}
};

/* India, Gurmukhi */
static const char main_key_in_guru[MAIN_LEN][2] =
{
{0,0},{'g','g'},{'h','h'},{'i','i'},{'j','j'},{'k','k'},{'l','l'},{'m','m'},{'n','n'},{'o','('},{'f',')'},{0,0},{0,0},
{'L','\x14'},{'H','\x10'},{'>','\x06'},{'@','\x08'},{'B','\x0a'},{',','-'},{'9','\x19'},{'\x17','\x18'},{'&','\''},{'\x1c','\x1d'},{'!','"'},{'<','\x1e'},
{'K','\x13'},{'G','\x0f'},{'M','\x05'},{'?','\x07'},{'A','\x09'},{'*','+'},{'0','0'},{'\x15','\x16'},{'$','%'},{'\x1a','\x1b'},{'\x1f','\x20'},{'\\','|'},
{'z','Z'},{'\x02','p'},{'.','#'},{'(','('},{'5','5'},{'2','3'},{'8','6'},{',','<'},{'.','d'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* India, Kannada */
static const char main_key_in_kan[MAIN_LEN][2] =
{
{'\xca','\x92'},{'\xe7','\xe7'},{'\xe8','\xe8'},{'\xe9','\xe9'},{'\xea','\xea'},{'\xeb','\xeb'},{'\xec','\xec'},{'\xed','\xed'},{'\xee','\xee'},{'\xef','\xef'},{'\xe6','\xe6'},{'\x83','\x83'},{'\xc3','\x8b'},
{'\xcc','\x94'},{'\xc8','\x90'},{'\xbe','\x86'},{'\xc0','\x88'},{'\xc2','\x8a'},{'\xac','\xad'},{'\xb9','\x99'},{'\x97','\x98'},{'\xa6','\xa7'},{'\x9c','\x9d'},{'\xa1','\xa2'},{'\xbc','\x9e'},
{'\xcb','\x93'},{'\xc7','\x8f'},{'\xcd','\x85'},{'\xbf','\x87'},{'\xc1','\x89'},{'\xaa','\xab'},{'\xb0','\xb1'},{'\x95','\x96'},{'\xa4','\xa5'},{'\x9a','\x9b'},{'\x9f','\xa0'},{'\\','|'},
{'\xc6','\x8e'},{'\x82','\x82'},{'\xae','\xa3'},{'\xa8','\xa8'},{'\xb5','\xb4'},{'\xb2','\xb3'},{'\xb8','\xb6'},{',','\xb7'},{'.','.'},{'\xaf','@'},{'<','>'},{0,0},{0,0}
};

/* India, Malayalam */
static const char main_key_in_mal[MAIN_LEN][2] =
{
{'J','\x12'},{'g','!'},{'h','@'},{'i','#'},{'j','$'},{'k','%'},{'l','^'},{'m','&'},{'n','*'},{'o','('},{'f',')'},{'-','\x03'},{'C','\x0b'},
{'L','\x14'},{'H','\x10'},{'>','\x06'},{'@','\x08'},{'B','\x0a'},{',','-'},{'9','\x19'},{'\x17','\x18'},{'&','\''},{'\x1c','\x1d'},{'!','"'},{'\x0d','\x1e'},
{'K','\x13'},{'G','\x0f'},{'M','\x05'},{'?','\x07'},{'A','\x09'},{'*','+'},{'0','1'},{'\x15','\x16'},{'$','%'},{'\x1a','\x1b'},{'\x1f','\x20'},{'\\','|'},
{'F','\x0e'},{'\x02','\x02'},{'.','#'},{'(','('},{'5','4'},{'2','3'},{'8','6'},{',','7'},{'.','.'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* India, Oriya */
static const char main_key_in_ori[MAIN_LEN][2] =
{
{0,0},{'g','g'},{'h','h'},{'i','i'},{'j','j'},{'k','k'},{'l','l'},{'m','m'},{'n','n'},{'o','o'},{'f','f'},{'\x03','\x03'},{'C','\x0b'},
{'L','\x14'},{'H','\x10'},{'>','\x06'},{'@','\x08'},{'B','\x0a'},{',','-'},{'9','\x19'},{'\x17','\x18'},{'&','\''},{'\x1c','\x1d'},{'!','"'},{'<','\x1e'},
{'K','\x13'},{'G','\x0f'},{'M','\x05'},{'?','\x07'},{'A','\x09'},{'*','+'},{'0','0'},{'\x15','\x16'},{'$','%'},{'\x1a','\x1b'},{'\x1f','\x20'},{'\\','|'},
{0,0},{'\x02','\x01'},{'.','#'},{'(','('},{'5','5'},{'2','3'},{'8','6'},{',','7'},{'.','.'},{'/','@'},{'<','>'},{0,0},{0,0}
};

/* India, Tamil Unicode */
static const char main_key_in_tam_unicode[MAIN_LEN][2] =
{
{0,0},{'\x83','\x83'},{0,0},{'\x9c','\x9c'},{'\xb7','\xb7'},{'\xb8','\xb8'},{'\xb9','\xb9'},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},
{'\x9e','\x9e'},{'\xb1','\xb1'},{'\xa8','\xa8'},{'\x9a','\x9a'},{'\xb5','\xb5'},{'\xb2','\xb2'},{'\xb0','\xb0'},{'\xc8','\x90'},{'\xca','\xcb'},{'\xbf','\xc0'},{'\xc1','\xc2'},{0,0},
{'\xaf','\xaf'},{'\xb3','\xb3'},{'\xa9','\xa9'},{'\x95','\x95'},{'\xaa','\xaa'},{'\xbe','\xb4'},{'\xa4','\xa4'},{'\xae','\xae'},{'\x9f','\x9f'},{'\xcd','\xcd'},{'\x99','\x99'},{'\\','|'},
{'\xa3','\xa3'},{'\x92','\x93'},{'\x89','\x8a'},{'\x8e','\x8f'},{'\xc6','\xc7'},{'\x94','\xcc'},{'\x85','\x86'},{'\x87','\x88'},{0,0},{0,0},{'<','>'},{0,0},{0,0}
};

/* India, Tamil TAB Typewriter */
static const char main_key_in_tam_TAB[MAIN_LEN][2] =
{
{0,0},{'\xe7','\xa7'},{'\xfa','\xa8'},{'\xfb','\xfb'},{'\xfc','\xfc'},{'\xfd','\xfd'},{'\xfe','\xfe'},{'\xff','\xff'},{0,0},{0,0},{0,0},{0,0},{0,0},
{'\xeb','\xb3'},{'\xf8','\xc1'},{'\xef','\xb8'},{'\xea','\xb2'},{'\xf5','\xbe'},{'\xf4','\xbd'},{'\xf3','\xbc'},{'\xac','\xe4'},{'\xae','\xaf'},{'\xa4','\xa6'},{'R','\xa6'},{0,0},
{'\xf2','\xbb'},{'\xf7','\xc0'},{'\xf9','\xc2'},{'\xe8','\xb0'},{'\xf0','\xb9'},{'\xa2','\xa3'},{'\xee','\xb6'},{'\xf1','\xba'},{'\xec','\xb4'},{'\xf6','\xbf'},{'\xe9','\xb1'},{'\\','|'},
{'\xed','\xb5'},{'\xe5','\xe6'},{'\xe0','\xe1'},{'\xe2','\xe3'},{'\xaa','\xab'},{'\xac','\xa3'},{'\xdc','\xdd'},{'\xde','\xdf'},{0,0},{0,0},{'<','>'},{0,0},{0,0}
};

/* India, Tamil TSCII Typewriter */
static const char main_key_in_tam_TSCII[MAIN_LEN][2] =
{
{0,0},{'\xb7','\xa4'},{'\x82','\xa5'},{'\x83','\x88'},{'\x84','\x89'},{'\x85','\x8a'},{'\x86','\x8b'},{'\x87','\x8c'},{0,0},{0,0},{0,0},{0,0},{0,0},
{'\xbb','\x9a'},{'\xc8','\xda'},{'\xbf','\xd1'},{'\xba','\xcd'},{'\xc5','\xd7'},{'\xc4','\xd6'},{'\xc3','\xd5'},{'\xa8','\xb3'},{'\xca','\xcb'},{'\xa2','\xa3'},{'Q','\xa3'},{0,0},
{'\xc2','\xd4'},{'\xc7','\xd9'},{'\xc9','\xdb'},{'\xb8','\xcc'},{'\xc0','\xd2'},{'P','\xa1'},{'\xbe','\xd0'},{'\xc1','\xd3'},{'\xbc','\xce'},{'\xc6','\xd8'},{'\xb9','\x99'},{'\\','|'},
{'\xbd','\xcf'},{'\xb4','\xb5'},{'\xaf','\xb0'},{'\xb1','\xb2'},{'\xa6','\xa7'},{'\xb6','\xaa'},{'\xab','\xac'},{'\xfe','\xae'},{0,0},{0,0},{'<','>'},{0,0},{0,0}
};

/* India, Tamil */
static const char main_key_in_tam[MAIN_LEN][2] =
{
{'\xca','\x92'},{'\xe7','\xe7'},{'\xe8','\xe8'},{'\xe9','\xe9'},{'\xea','\xea'},{'\xeb','\xeb'},{'\xec','\xec'},{'\xed','\xed'},{'\xee','\xee'},{'\xef','('},{'\xf0',')'},{'\xf1','\x83'},{'\xf2','+'},
{'\xcc','\x94'},{'\xc8','\x90'},{'\xbe','\x86'},{'\xc0','\x88'},{'\xc2','\x8a'},{0,0},{'\xb9','\x99'},{0,0},{0,0},{0,0},{0,0},{'\x9e','\x9e'},
{'\xcb','\x93'},{'\xc7','\x8f'},{'\xcd','\x85'},{'\xbf','\x87'},{'\xc1','\x89'},{'\xaa','\xaa'},{'\xb0','\xb1'},{'\x95','\x95'},{'\xa4','\xa4'},{'\x9a','\x9a'},{'\x9f','\x9f'},{'\\','|'},
{'\xc6','\x8e'},{'\x82','\x82'},{'\xae','\xa3'},{'\xa8','\xa9'},{'\xb5','\xb4'},{'\xb2','\xb3'},{'\xb8','\xb8'},{',','\xb7'},{'.','d'},{'\xaf','?'},{'<','>'},{0,0},{0,0}
};

/* India, Telugu */
static const char main_key_in_tel[MAIN_LEN][2] =
{
{'J','\x12'},{'g','g'},{'h','h'},{'i','#'},{'j','$'},{'k','%'},{'l','^'},{'m','&'},{'n','*'},{'o','('},{'f',')'},{'\x03','_'},{'C','\x0b'},
{'L','\x14'},{'H','\x10'},{'>','\x06'},{'@','\x08'},{'B','\x0a'},{',','-'},{'9','\x19'},{'\x17','\x18'},{'&','\''},{'\x1c','\x1d'},{'!','"'},{'\x1e','\x1e'},
{'K','\x13'},{'G','\x0f'},{'M','\x05'},{'?','\x07'},{'A','\x09'},{'*','+'},{'0','1'},{'\x15','\x16'},{'$','%'},{'\x1a','\x1b'},{'\x1f','\x20'},{'\\','|'},
{'F','\x0e'},{'\x02','\x01'},{'.','#'},{'(','('},{'5','5'},{'2','3'},{'8','6'},{',','7'},{'.','.'},{'/','@'},{'<','>'},{0,0},{0,0}
};

/* India, Urdu */
static const char main_key_in_urd[MAIN_LEN][2] =
{
{'\xd4','\xd4'},{'a','!'},{'b','@'},{'c','#'},{'\xf4','$'},{'\xf5','%'},{'f','^'},{'g','&'},{'h','*'},{'i','('},{'`',')'},{'-','_'},{'=','+'},
{'\xe2','\xe1'},{'H','\xf9'},{'9','\xf7'},{'1','\x91'},{'\xca','y'},{'\xd2','|'},{'!','L'},{'\xcc','V'},{'G',')'},{'~','O'},{'[','{'},{']','}'},
{'\'','"'},{'\xd3','5'},{'/','\x88'},{'A','p'},{'\xaf',':'},{'\xbe','-'},{',','6'},{'\xa9','.'},{'D','\x12'},{'\x1b',':'},{'\'','\''},{'\\','|'},
{'\xd2','\xd0'},{'4','\x98'},{'\x86','+'},{'7','8'},{'(','('},{'F','\xba'},{'E','E'},{'\x0c','N'},{'\xd4','P'},{'/','\xbf'},{'<','>'},{0,0},{0,0}
};

/* Bosnia and Herzegovina */
static const char main_key_ba[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'+','*'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xb9','\xa9'},{'\xf0','\xd0'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe8','\xc8'},{'\xe6','\xc6'},{'\xbe','\xae'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Bosnia and Herzegovina, Use Bosnian digraphs */
static const char main_key_ba_unicode[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'+','*'},
{'\xc9','\xc8'},{'\xcc','\xcb'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xb9','\xa9'},{'\xf0','\xd0'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe8','\xc8'},{'\xe6','\xc6'},{'\xbe','\xae'},
{'\xbe','\xae'},{'\xc6','\xc5'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Bosnia and Herzegovina, US keyboard with Bosnian digraphs */
static const char main_key_ba_unicodeus[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'+','*'},
{'\xc9','\xc8'},{'\xcc','\xcb'},{'e','E'},{'r','R'},{'t','T'},{'\xbe','\xae'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xb9','\xa9'},{'\xf0','\xd0'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe8','\xc8'},{'\xe6','\xc6'},{'\xbe','\xae'},
{'z','Z'},{'\xc6','\xc5'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Bosnia and Herzegovina, US keyboard with Bosnian letters */
static const char main_key_ba_us[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'+','*'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xb9','\xa9'},{'\xf0','\xd0'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe8','\xc8'},{'\xe6','\xc6'},{'\xbe','\xae'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Brazil */
static const char main_key_br[MAIN_LEN][2] =
{
{'\'','"'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','W'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'Q','P'},{'[','{'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe7','\xc7'},{'S','R'},{']','}'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{';',':'},{'\\','|'},{'/','?'},{0,0}
};

/* Brazil, Eliminate dead keys */
static const char main_key_br_nodeadkeys[MAIN_LEN][2] =
{
{'\'','"'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','\xa8'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\'','`'},{'[','{'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe7','\xc7'},{'~','^'},{']','}'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{';',':'},{'\\','|'},{'/','?'},{0,0}
};

/* Brazil with alternative 102 */
static const char main_key_br_alt_102[MAIN_LEN][2] =
{
{'\'','"'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','W'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'Q','P'},{'[','{'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe7','\xc7'},{'S','R'},{']','}'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{';',':'},{'<','>'},{'/','?'},{0,0}
};

/* Brazil with alternative 102, Eliminate dead keys */
static const char main_key_br_alt_102_nodeadkeys[MAIN_LEN][2] =
{
{'\'','"'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','\xa8'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\'','`'},{'[','{'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe7','\xc7'},{'~','^'},{']','}'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{';',':'},{'<','>'},{'/','?'},{0,0}
};

/* Bulgaria */
static const char main_key_bg[MAIN_LEN][2] =
{
{'(',')'},{'1','!'},{'2','?'},{'3','+'},{'4','"'},{'5','%'},{'6','='},{'7',':'},{'8','/'},{'9','\xa9'},{'0','\xb0'},{'-','I'},{'.','V'},
{',','\xd9'},{'\xd5','\xf5'},{'\xc5','\xe5'},{'\xc9','\xe9'},{'\xdb','\xfb'},{'\xdd','\xfd'},{'\xcb','\xeb'},{'\xd3','\xf3'},{'\xc4','\xe4'},{'\xda','\xfa'},{'\xc3','\xe3'},{';','\xa7'},
{'\xd8','\xf8'},{'\xd1','\xf1'},{'\xc1','\xe1'},{'\xcf','\xef'},{'\xd6','\xf6'},{'\xc7','\xe7'},{'\xd4','\xf4'},{'\xce','\xee'},{'\xd7','\xf7'},{'\xcd','\xed'},{'\xde','\xfe'},{'\'','\xf9'},
{'\xc0','\xe0'},{'\xca','\xea'},{'\xdf','\xff'},{'\xdc','\xfc'},{'\xc6','\xe6'},{'\xc8','\xe8'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcc','\xec'},{'\xc2','\xe2'},{'<','>'},{0,0},{0,0}
};

/* Bulgaria, Phonetic */
static const char main_key_bg_phonetic[MAIN_LEN][2] =
{
{'\xde','\xfe'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xd1','\xf1'},{'\xd7','\xf7'},{'\xc5','\xe5'},{'\xd2','\xf2'},{'\xd4','\xf4'},{'\xdf','\xff'},{'\xd5','\xf5'},{'\xc9','\xe9'},{'\xcf','\xef'},{'\xd0','\xf0'},{'\xdb','\xfb'},{'\xdd','\xfd'},
{'\xc1','\xe1'},{'\xd3','\xf3'},{'\xc4','\xe4'},{'\xc6','\xe6'},{'\xc7','\xe7'},{'\xc8','\xe8'},{'\xca','\xea'},{'\xcb','\xeb'},{'\xcc','\xec'},{';',':'},{'\'','"'},{'\xc0','\xe0'},
{'\xda','\xfa'},{'\xd8','\xf8'},{'\xc3','\xe3'},{'\xd6','\xf6'},{'\xc2','\xe2'},{'\xce','\xee'},{'\xcd','\xed'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Myanmar */
static const char main_key_mm[MAIN_LEN][2] =
{
{0,0},{'A','!'},{'B','B'},{'C','C'},{'D','D'},{'E','E'},{'F','F'},{'G','G'},{'H','H'},{'I','('},{'@',')'},{'-','8'},{'R','V'},
{'*','*'},{'2','2'},{',','!'},{'.','$'},{'0','&'},{'\x17','\x18'},{'\x1f','\x04'},{'\x02','\x03'},{'\x12','\x13'},{'\x07','\x08'},{'\x0d','\x0e'},{'\x0a','\x09'},
{')',')'},{'\'','\''},{'9','!'},{'-','#'},{'/','%'},{'\x15','\x16'},{'\x1b','\x1b'},{'\x00','\x01'},{'\x10','\x11'},{'\x05','\x06'},{'\x0b','\x0c'},{'N','O'},
{'L','M'},{'7','6'},{'\x19','\x0f'},{'\x14','\x14'},{'\x17','\x17'},{'\x1c','\x1c'},{'\x1e','P'},{',','Q'},{'.','J'},{'/','\x1a'},{'<','>'},{0,0},{0,0}
};

/* Canada */
static const char main_key_ca[MAIN_LEN][2] =
{
{'#','|'},{'1','!'},{'2','"'},{'3','/'},{'4','$'},{'5','%'},{'6','?'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'R','R'},{'[','W'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'P','P'},{'<','>'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','\''},{'.','.'},{'\xe9','\xc9'},{'\xab','\xbb'},{0,0},{0,0}
};

/* Canada, French Dvorak */
static const char main_key_ca_fr_dvorak[MAIN_LEN][2] =
{
{'#','|'},{'1','!'},{'2','"'},{'3','/'},{'4','$'},{'5','%'},{'6','?'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'R','R'},{'[','W'},
{'P','P'},{',','\''},{'.','.'},{'p','P'},{'y','Y'},{'f','F'},{'g','G'},{'c','C'},{'r','R'},{'l','L'},{'\xe9','\xc9'},{'=','+'},
{'a','A'},{'o','O'},{'e','E'},{'u','U'},{'i','I'},{'d','D'},{'h','H'},{'t','T'},{'n','N'},{'s','S'},{'-','_'},{'<','>'},
{';',':'},{'q','Q'},{'j','J'},{'k','K'},{'x','X'},{'b','B'},{'m','M'},{'w','W'},{'v','V'},{'z','Z'},{'\xab','\xbb'},{0,0},{0,0}
};

/* Canada, French (legacy) */
static const char main_key_ca_fr_legacy[MAIN_LEN][2] =
{
{'\xb0','\xb0'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','?'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'R','R'},{'\xe7','\xc7'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\xe8','\xc8'},{'\xe0','\xc0'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','\''},{'.','.'},{'\xe9','\xc9'},{'\xf9','\xd9'},{0,0},{0,0}
};

/* Canada, Multilingual */
static const char main_key_ca_multix[MAIN_LEN][2] =
{
{'/','\\'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','?'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'R','W'},{'\xe7','\xc7'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\xe8','\xc8'},{'\xe0','\xc0'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','\''},{'.','"'},{'\xe9','\xc9'},{'\xf9','\xd9'},{0,0},{0,0}
};

/* Canada, Multilingual, second part */
static const char main_key_ca_multi_2gr[MAIN_LEN][2] =
{
{'\x00','\xad'},{'\xb9','\xa1'},{'\xb2','\xb2'},{'\xb3','\xa3'},{'\xbc','\xa4'},{'\xbd','\xc4'},{'\xbe','\xc5'},{'\x00','\xc6'},{'\x00','\xc9'},{'\x00','\xb1'},{0,0},{'\x00','\xbf'},{'[','\\'},
{'\x00','\xd9'},{'\xb3','\xa3'},{'\xbd','\xbc'},{'\xb6','\xae'},{'\xbc','\xac'},{'\xfb','\xa5'},{'\xfe','\xfc'},{'\xfd','\xb9'},{'\xf8','\xd8'},{'\xfe','\xde'},{'\x00','X'},{'S','T'},
{'\xe6','\xc6'},{'\xdf','\xa7'},{'\xf0','\xd0'},{'\x00','\xaa'},{'\xbf','\xbd'},{'\xb1','\xa1'},{'3','2'},{'\xa2','\xa2'},{'@','?'},{'Q','Y'},{'\x00','Z'},{'\\','U'},
{0,0},{0,0},{'\xa2','\xa9'},{'\xd2','\xd0'},{'\xd3','\xd1'},{'I','j'},{'\xb5','\xba'},{'\xaf','\xd7'},{'\xb7','\xf7'},{'\x00','V'},{'<','\xa6'},{0,0},{0,0}
};

/* Canada, Inuktitut */
static const char main_key_ca_ike[MAIN_LEN][2] =
{
{'{','u'},{'\x95','1'},{'I','2'},{'P','3'},{'\x83','4'},{'f','5'},{'\x85','6'},{'\xbb','7'},{'\xd0','8'},{'\xea','9'},{'>','0'},{'-','_'},{']','='},
{'\x8f','\x8b'},{'\x3','1'},{'\x7f','F'},{'m','\x96'},{'N','q'},{'\xef','s'},{'\xa5','u'},{'\xc2','\xa4'},{'\xd5','\xa0'},{'(','\xa6'},{'\xa1','\x05'},{'V','\x1e'},
{'\x91','\x8d'},{'\x5','3'},{'\x81','H'},{'o','U'},{'P','('},{'\xf1',')'},{'\xa7','*'},{'\xc4','W'},{'\xd7','\xa2'},{';',':'},{'\'','"'},{'\\','|'},
{'\x93','\x90'},{'\xa','8'},{'\x83','K'},{'r','?'},{'U','|'},{'\xf4','\xc7'},{'\xaa','\xda'},{',','<'},{'.','>'},{'-','Y'},{'y','w'},{0,0},{0,0}
};

/* Congo, Democratic Republic of the */
static const char main_key_cd[MAIN_LEN][2] =
{
{'`','~'},{'&','1'},{'\x1','2'},{'\x0','3'},{'(','4'},{'{','5'},{'}','6'},{')','7'},{'\x2','8'},{'\xc','9'},{'\x8','0'},{'-','_'},{'=','+'},
{'a','A'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','\x90'},{'*','^'},
{'q','Q'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'T','\x86'},{'"','\\'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','.'},{';',':'},{'!','?'},{'\'','/'},{'\\','|'},{0,0},{0,0}
};

/* Czechia */
static const char main_key_cz[MAIN_LEN][2] =
{
{';','X'},{'+','1'},{'\xec','2'},{'\xb9','3'},{'\xe8','4'},{'\xf8','5'},{'\xbe','6'},{'\xfd','7'},{'\xe1','8'},{'\xed','9'},{'\xe9','0'},{'=','%'},{'Q','Z'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfa','/'},{')','('},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf9','"'},{'\xa7','!'},{'W','\''},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','?'},{'.',':'},{'-','_'},{'\\','|'},{0,0},{0,0}
};

/* Czechia, With <|> key */
static const char main_key_cz_bksl[MAIN_LEN][2] =
{
{';','X'},{'+','1'},{'\xec','2'},{'\xb9','3'},{'\xe8','4'},{'\xf8','5'},{'\xbe','6'},{'\xfd','7'},{'\xe1','8'},{'\xed','9'},{'\xe9','0'},{'=','%'},{'Q','Z'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfa','/'},{')','('},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf9','"'},{'\xa7','!'},{'\\','|'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','?'},{'.',':'},{'-','_'},{'\\','|'},{0,0},{0,0}
};

/* Czechia, qwerty */
static const char main_key_cz_qwerty[MAIN_LEN][2] =
{
{';','X'},{'+','1'},{'\xec','2'},{'\xb9','3'},{'\xe8','4'},{'\xf8','5'},{'\xbe','6'},{'\xfd','7'},{'\xe1','8'},{'\xed','9'},{'\xe9','0'},{'=','%'},{'Q','Z'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfa','/'},{')','('},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf9','"'},{'\xa7','!'},{'W','\''},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','?'},{'.',':'},{'-','_'},{'\\','|'},{0,0},{0,0}
};

/* Czechia, qwerty, extended Backslash */
static const char main_key_cz_qwerty_bksl[MAIN_LEN][2] =
{
{';','X'},{'+','1'},{'\xec','2'},{'\xb9','3'},{'\xe8','4'},{'\xf8','5'},{'\xbe','6'},{'\xfd','7'},{'\xe1','8'},{'\xed','9'},{'\xe9','0'},{'=','%'},{'Q','Z'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfa','/'},{')','('},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf9','"'},{'\xa7','!'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','?'},{'.',':'},{'-','_'},{'\\','|'},{0,0},{0,0}
};

/* Denmark */
static const char main_key_dk[MAIN_LEN][2] =
{
{'\xbd','\xa7'},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'Q','P'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe5','\xc5'},{'W','R'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe6','\xc6'},{'\xf8','\xd8'},{'\'','*'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Denmark, Eliminate dead keys */
static const char main_key_dk_nodeadkeys[MAIN_LEN][2] =
{
{'\xbd','\xa7'},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'\xb4','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe5','\xc5'},{'\xa8','^'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe6','\xc6'},{'\xf8','\xd8'},{'\'','*'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Netherlands */
static const char main_key_nl[MAIN_LEN][2] =
{
{'@','\xa7'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','_'},{'8','('},{'9',')'},{'0','\''},{'/','?'},{'\xb0','S'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'W','R'},{'*','|'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'+','\xb1'},{'\'','`'},{'<','>'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','='},{']','['},{0,0},{0,0}
};

/* Bhutan */
static const char main_key_bt[MAIN_LEN][2] =
{
{'\x09','\x0a'},{'!','\x04'},{'"','\x05'},{'#','\x06'},{'$','H'},{'%','p'},{'&','\x08'},{'\'','8'},{'(','4'},{')','<'},{'\x20','='},{'\x14','\x7f'},{'\x0d','\x11'},
{'@','\x90'},{'A','\x91'},{'B','\x92'},{'D','\x94'},{'r','\x80'},{'t','\x84'},{'z','{'},{'|','}'},{'E','\x95'},{'F','\x96'},{'G','\x97'},{'I','\x99'},
{'O','\x9f'},{'P','\xa0'},{'Q','\xa1'},{'S','\xa3'},{'T','\xa4'},{'U','\xa5'},{'V','\xa6'},{'X','\xa8'},{'Y','\xa9'},{'Z','\xaa'},{'[','\xab'},{']','\xad'},
{'^','\xae'},{'_','\xaf'},{'`','q'},{'a','\xb1'},{'b','\xb2'},{'c','\xb3'},{'d','\xb4'},{'f','\xb6'},{'g','\xb7'},{'h','\xb8'},{'\x0d','\x11'},{0,0},{0,0}
};

/* Estonia */
static const char main_key_ee[MAIN_LEN][2] =
{
{'Z','S'},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'Q','P'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'\xf5','\xd5'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'\'','*'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Estonia, Eliminate dead keys */
static const char main_key_ee_nodeadkeys[MAIN_LEN][2] =
{
{'^','~'},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'\'','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'\xf5','\xd5'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'\'','*'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Iran */
static const char main_key_ir[MAIN_LEN][2] =
{
{'\x0d','\xf7'},{'\xf1','!'},{'\xf2','l'},{'\xf3','k'},{'\xf4','\xfc'},{'\xf5','j'},{'\xf6','\xd7'},{'\xf7','\xac'},{'\xf8','*'},{'\xf9',')'},{'\xf0','('},{'-','\xe0'},{'=','+'},
{'\xd6','\xf2'},{'\xd5','\xec'},{'\xcb','\xed'},{'\xe2','\xeb'},{'\xe1','\xef'},{'\xda','\xf0'},{'\xd9','\xee'},{'\xe7','\xf1'},{'\xce',']'},{'\xcd','['},{'\xcc','}'},{'\x86','{'},
{'\xd4','\xc4'},{'\xd3','\xc6'},{'\xcc','\xea'},{'\xc8','\xc5'},{'\xe4','\xc3'},{'\xc7','\xc2'},{'\xca','\xc9'},{'\xe6','\xbb'},{'\xe5','\xab'},{'\xa9',':'},{'\xaf','\xbb'},{'\\','|'},
{'\xd8','\xe3'},{'\xd7','S'},{'\xd2','\x98'},{'\xd1','p'},{'\xd0','\x0c'},{'\xcf','T'},{'~','\xc1'},{'\xe8','>'},{'.','<'},{'/','\xbf'},{'<','>'},{0,0},{0,0}
};

/* Iran, Kurdish, Latin Q */
static const char main_key_ir_ku[MAIN_LEN][2] =
{
{'"','\\'},{'1','!'},{'2','\''},{'3','^'},{'4','+'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'*','?'},{'-','_'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'x','X'},{'\xfb','\xdb'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xba','\xaa'},{'\xee','\xce'},{',',';'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{'\xea','\xca'},{'\xe7','\xc7'},{'.',':'},{'<','>'},{0,0},{0,0}
};

/* Iran, Kurdish, (F) */
static const char main_key_ir_ku_f[MAIN_LEN][2] =
{
{'+','*'},{'1','!'},{'2','"'},{'3','^'},{'4','$'},{'5','%'},{'6','&'},{'7','\''},{'8','('},{'9',')'},{'0','='},{'/','?'},{'-','_'},
{'f','F'},{'g','G'},{'x','X'},{'i','I'},{'o','O'},{'d','D'},{'r','R'},{'n','N'},{'h','H'},{'p','P'},{'q','Q'},{'w','W'},
{'\xfb','\xdb'},{'\xee','\xce'},{'e','E'},{'a','A'},{'u','U'},{'t','T'},{'k','K'},{'m','M'},{'l','L'},{'y','Y'},{'\xba','\xaa'},{'x','X'},
{'j','J'},{'\xea','\xca'},{'v','V'},{'c','C'},{'\xe7','\xc7'},{'z','Z'},{'s','S'},{'b','B'},{'.',':'},{',',';'},{'<','>'},{0,0},{0,0}
};

/* Iran, Kurdish, Arabic-Latin */
static const char main_key_ir_ku_ara[MAIN_LEN][2] =
{
{'\x0d','\xf7'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9',')'},{'0','('},{'-','\xe0'},{'=','+'},
{'\xe2','X'},{'\xe8','X'},{'\xd5','\xe7'},{'\xd1','\x95'},{'\xca','\xd7'},{'\xcc','\xce'},{'\xc6','\xc1'},{'\xcd','\xd9'},{'\xc6','\xc4'},{'~','\xcb'},{']','}'},{'[','{'},
{'\xc7','\xc2'},{'\xd3','\xd4'},{'\xcf','\xd0'},{'\xe1','\xc5'},{'\xaf','\xda'},{'\xe7','\x0c'},{'\x98','\xc3'},{'\xa9','\xe3'},{'\xe4','\xb5'},{'\xbb',':'},{'\'','"'},{'\\','|'},
{'\xd2','\xd6'},{'\xce','\xd5'},{'\xcc','\x86'},{'\xa4','\xd8'},{'\xc8','I'},{'\xe6','\xc9'},{'\xe5','\xe0'},{'\xac','>'},{'.','<'},{'/','\xbf'},{'<','>'},{0,0},{0,0}
};

/* Faroe Islands */
static const char main_key_fo[MAIN_LEN][2] =
{
{'\xbd','\xa7'},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'Q','P'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe5','\xc5'},{'\xf0','\xd0'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe6','\xc6'},{'\xf8','\xd8'},{'\'','*'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Finland */
static const char main_key_fi[MAIN_LEN][2] =
{
{'\xa7','\xbd'},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'Q','P'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe5','\xc5'},{'W','R'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'\'','*'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Finland, Eliminate dead keys */
static const char main_key_fi_nodeadkeys[MAIN_LEN][2] =
{
{'\xa7','\xbd'},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'\xb4','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe5','\xc5'},{'\xa8','^'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'\'','*'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Finland, Northern Saami */
static const char main_key_fi_smi[MAIN_LEN][2] =
{
{'|','\xa7'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'\\','`'},
{'\xe1','\xc1'},{'\xb9','\xa9'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe5','\xc5'},{'\xbf','\xbd'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'\xf0','\xd0'},
{'z','Z'},{'\xe8','\xc8'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'\xbe','\xae'},{0,0},{0,0}
};

/* Finland, Macintosh */
static const char main_key_fi_mac[MAIN_LEN][2] =
{
{'\xa7','\xb0'},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'\xb4','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe5','\xc5'},{'\xa8','^'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'\'','*'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* France */
static const char main_key_fr[MAIN_LEN][2] =
{
{'\xb2','~'},{'&','1'},{'\xe9','2'},{'"','3'},{'\'','4'},{'(','5'},{'-','6'},{'\xe8','7'},{'_','8'},{'\xe7','9'},{'\xe0','0'},{')','\xb0'},{'=','+'},
{'a','A'},{'z','Z'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'R','W'},{'$','\xa3'},
{'q','Q'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'\xf9','%'},{'*','\xb5'},
{'w','W'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','?'},{';','.'},{':','/'},{'!','\xa7'},{'<','>'},{0,0},{0,0}
};

/* France, Eliminate dead keys */
static const char main_key_fr_nodeadkeys[MAIN_LEN][2] =
{
{'\xb2','~'},{'&','1'},{'\xe9','2'},{'"','3'},{'\'','4'},{'(','5'},{'-','6'},{'\xe8','7'},{'_','8'},{'\xe7','9'},{'\xe0','0'},{')','\xb0'},{'=','+'},
{'a','A'},{'z','Z'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'^','\xa8'},{'$','\xa3'},
{'q','Q'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'\xf9','%'},{'*','\xb5'},
{'w','W'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','?'},{';','.'},{':','/'},{'!','\xa7'},{'<','>'},{0,0},{0,0}
};

/* France, Sun dead keys */
static const char main_key_fr_sundeadkeys[MAIN_LEN][2] =
{
{'\xb2','~'},{'&','1'},{'\xe9','2'},{'"','3'},{'\'','4'},{'(','5'},{'-','6'},{'\xe8','7'},{'_','8'},{'\xe7','9'},{'\xe0','0'},{')','\xb0'},{'=','+'},
{'a','A'},{'z','Z'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\x01','\x04'},{'$','\xa3'},
{'q','Q'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'\xf9','%'},{'*','\xb5'},
{'w','W'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','?'},{';','.'},{':','/'},{'!','\xa7'},{'<','>'},{0,0},{0,0}
};

/* France, Alternative */
static const char main_key_fr_oss[MAIN_LEN][2] =
{
{'\xf8','\xd8'},{'&','1'},{'\xe9','2'},{'"','3'},{'\'','4'},{'(','5'},{'-','6'},{'\xe8','7'},{'_','8'},{'\xe7','9'},{'\xe0','0'},{')','\xb0'},{'=','+'},
{'a','A'},{'z','Z'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'R','W'},{'$','\xa3'},
{'q','Q'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'\xf9','%'},{'*','\xb5'},
{'w','W'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','?'},{';','.'},{':','/'},{'!','\xa7'},{'<','>'},{0,0},{0,0}
};

/* France, Alternative, eliminate dead keys */
static const char main_key_fr_oss_nodeadkeys[MAIN_LEN][2] =
{
{'\xf8','\xd8'},{'&','1'},{'\xe9','2'},{'"','3'},{'\'','4'},{'(','5'},{'-','6'},{'\xe8','7'},{'_','8'},{'\xe7','9'},{'\xe0','0'},{')','\xb0'},{'=','+'},
{'a','A'},{'z','Z'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'^','\xa8'},{'$','\xa3'},
{'q','Q'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'\xf9','%'},{'*','\xb5'},
{'w','W'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','?'},{';','.'},{':','/'},{'!','\xa7'},{'<','>'},{0,0},{0,0}
};

/* France, Alternative, Sun dead keys */
static const char main_key_fr_oss_sundeadkeys[MAIN_LEN][2] =
{
{'\xf8','\xd8'},{'&','1'},{'\xe9','2'},{'"','3'},{'\'','4'},{'(','5'},{'-','6'},{'\xe8','7'},{'_','8'},{'\xe7','9'},{'\xe0','0'},{')','\xb0'},{'=','+'},
{'a','A'},{'z','Z'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\x01','\x04'},{'$','\xa3'},
{'q','Q'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'\xf9','%'},{'*','\xb5'},
{'w','W'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','?'},{';','.'},{':','/'},{'!','\xa7'},{'<','>'},{0,0},{0,0}
};

/* France, (Legacy) Alternative */
static const char main_key_fr_latin9[MAIN_LEN][2] =
{
{'\xbd','\xbc'},{'&','1'},{'\xe9','2'},{'"','3'},{'\'','4'},{'(','5'},{'-','6'},{'\xe8','7'},{'_','8'},{'\xe7','9'},{'\xe0','0'},{')','\xb0'},{'=','+'},
{'a','A'},{'z','Z'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'R','W'},{'$','\xa3'},
{'q','Q'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'\xf9','%'},{'*','\xb5'},
{'w','W'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','?'},{';','.'},{':','/'},{'!','\xa7'},{'<','>'},{0,0},{0,0}
};

/* France, (Legacy) Alternative, eliminate dead keys */
static const char main_key_fr_latin9_nodeadkeys[MAIN_LEN][2] =
{
{'\xbd','\xbc'},{'&','1'},{'\xe9','2'},{'"','3'},{'\'','4'},{'(','5'},{'-','6'},{'\xe8','7'},{'_','8'},{'\xe7','9'},{'\xe0','0'},{')','\xb0'},{'=','+'},
{'a','A'},{'z','Z'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'^','\xa8'},{'$','\xa3'},
{'q','Q'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'\xf9','%'},{'*','\xb5'},
{'w','W'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','?'},{';','.'},{':','/'},{'!','\xa7'},{'<','>'},{0,0},{0,0}
};

/* France, (Legacy) Alternative, Sun dead keys */
static const char main_key_fr_latin9_sundeadkeys[MAIN_LEN][2] =
{
{'\xbd','\xbc'},{'&','1'},{'\xe9','2'},{'"','3'},{'\'','4'},{'(','5'},{'-','6'},{'\xe8','7'},{'_','8'},{'\xe7','9'},{'\xe0','0'},{')','\xb0'},{'=','+'},
{'a','A'},{'z','Z'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\x01','\x04'},{'$','\xa3'},
{'q','Q'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'\xf9','%'},{'*','\xb5'},
{'w','W'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','?'},{';','.'},{':','/'},{'!','\xa7'},{'<','>'},{0,0},{0,0}
};

/* France, Bepo */
static const char main_key_fr_bepo[MAIN_LEN][2] =
{
{'$','#'},{'"','1'},{'\xab','2'},{'\xbb','3'},{'(','4'},{')','5'},{'@','6'},{'+','7'},{'-','8'},{'/','9'},{'*','0'},{'=','\xb0'},{'%','`'},
{'b','B'},{'\xe9','\xc9'},{'p','P'},{'o','O'},{'\xe8','\xc8'},{'^','!'},{'v','V'},{'d','D'},{'l','L'},{'j','J'},{'z','Z'},{'w','W'},
{'a','A'},{'u','U'},{'i','I'},{'e','E'},{',',';'},{'c','C'},{'t','T'},{'s','S'},{'r','R'},{'n','N'},{'m','M'},{'\xe7','\xc7'},
{'\xe0','\xc0'},{'y','Y'},{'x','X'},{'.',':'},{'k','K'},{'\'','?'},{'q','Q'},{'g','G'},{'h','H'},{'f','F'},{'\xea','\xca'},{0,0},{0,0}
};

/* France, Dvorak */
static const char main_key_fr_dvorak[MAIN_LEN][2] =
{
{'\xbd','\xbc'},{'/','1'},{'+','2'},{'-','3'},{'*','4'},{'=','5'},{'\\','6'},{'(','7'},{'`','8'},{')','9'},{'"','0'},{'[','{'},{']','}'},
{':','?'},{'\xe0','\xc0'},{'\xe9','\xc9'},{'g','G'},{'.','!'},{'h','H'},{'v','V'},{'c','C'},{'m','M'},{'k','K'},{'\xe8','\xc8'},{'z','Z'},
{'o','O'},{'a','A'},{'u','U'},{'e','E'},{'b','B'},{'f','F'},{'s','S'},{'t','T'},{'n','N'},{'d','D'},{'w','W'},{'\xf9','\xd9'},
{'\'','_'},{'q','Q'},{',',';'},{'i','I'},{'y','Y'},{'x','X'},{'r','R'},{'l','L'},{'p','P'},{'j','J'},{'\xe7','\xc7'},{0,0},{0,0}
};

/* France, Macintosh */
static const char main_key_fr_mac[MAIN_LEN][2] =
{
{'@','#'},{'&','1'},{'\xe9','2'},{'"','3'},{'\'','4'},{'(','5'},{'\xa7','6'},{'\xe8','7'},{'!','8'},{'\xe7','9'},{'\xe0','0'},{')','\xb0'},{'-','_'},
{'a','A'},{'z','Z'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'R','W'},{'$','*'},
{'q','Q'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'\xf9','%'},{'P','\xa3'},
{'w','W'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','?'},{';','.'},{':','/'},{'=','+'},{'<','>'},{0,0},{0,0}
};

/* Ghana */
static const char main_key_gh[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','\xb5'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Ghana, Akan */
static const char main_key_gh_akan[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','\xb5'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'[','\x90'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'T','\x86'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Ghana, Ewe */
static const char main_key_gh_ewe[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','\xb5'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'[','\x90'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'T','\x86'},{'\x8b','\xb2'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'\x92','\x91'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'x','X'},{'K','J'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Ghana, Fula */
static const char main_key_gh_fula[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','\xb5'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'\xfc','\xdc'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xb4','\xb3'},{'\xe7','\xe6'},
{'a','A'},{'s','S'},{'W','\x8a'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'1','0'},{'\xdd','\x8e'},{'\\','|'},
{'r','\x9d'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'\xf1','\xd1'},{',','<'},{'\xe7','\xc7'},{'\xba','\xaa'},{'<','>'},{0,0},{0,0}
};

/* Ghana, Ga */
static const char main_key_gh_ga[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','\xb5'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'[','\x90'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'T','\x86'},{'K','J'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Georgia */
static const char main_key_ge[MAIN_LEN][2] =
{
{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},
{'\xe5','q'},{'\xec','\xed'},{'\xd4','e'},{'\xe0','\xe6'},{'\xe2','\xd7'},{'\xe7','y'},{'\xe3','u'},{'\xd8','i'},{'\xdd','o'},{'\xde','p'},{'[','{'},{']','}'},
{'\xd0','a'},{'\xe1','\xe8'},{'\xd3','d'},{'\xe4','f'},{'\xd2','g'},{'\xf0','h'},{'\xef','\xdf'},{'\xd9','k'},{'\xda','l'},{';',':'},{'\'','"'},{'\\','|'},
{'\xd6','\xeb'},{'\xee','x'},{'\xea','\xe9'},{'\xd5','v'},{'\xd1','b'},{'\xdc','n'},{'\xdb','m'},{',','<'},{'.','>'},{'/','?'},{'\xab','\xbb'},{0,0},{0,0}
};

/* Georgia, Russian */
static const char main_key_ge_ru[MAIN_LEN][2] =
{
{'^','~'},{'1','!'},{'2','@'},{'3','#'},{'4',';'},{'5',':'},{'6',','},{'7','.'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'#','|'},
{'\xe6','q'},{'\xea','w'},{'\xe3','e'},{'\xd9','r'},{'\xd4','t'},{'\xdc','y'},{'\xd2','u'},{'\xe8','i'},{'\xec','o'},{'\xd6','p'},{'\xee','['},{'\xef',']'},
{'\xe4','a'},{'\xd7','s'},{'\xd5','d'},{'\xd0','f'},{'\xde','g'},{'\xe0','h'},{'\xdd','j'},{'\xda','k'},{'\xd3','l'},{'\xdf',';'},{'\xeb','%'},{'\\','|'},
{'\xed','z'},{'\xe9','x'},{'\xe1','c'},{'\xdb','v'},{'\xd8','b'},{'\xe2','n'},{'\xe5','m'},{'\xd1','<'},{'\xe7','>'},{'\xf0','?'},{'\xab','\xbb'},{0,0},{0,0}
};

/* Germany */
static const char main_key_de[MAIN_LEN][2] =
{
{'R','\xb0'},{'1','!'},{'2','"'},{'3','\xa7'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xdf','?'},{'Q','P'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'#','\''},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Germany, Dead acute */
static const char main_key_de_deadacute[MAIN_LEN][2] =
{
{'^','\xb0'},{'1','!'},{'2','"'},{'3','\xa7'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xdf','?'},{'Q','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'#','\''},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Germany, Dead grave acute */
static const char main_key_de_deadgraveacute[MAIN_LEN][2] =
{
{'^','\xb0'},{'1','!'},{'2','"'},{'3','\xa7'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xdf','?'},{'Q','P'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'#','\''},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Germany, Eliminate dead keys */
static const char main_key_de_nodeadkeys[MAIN_LEN][2] =
{
{'^','\xb0'},{'1','!'},{'2','"'},{'3','\xa7'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xdf','?'},{'\xb4','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'#','\''},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Germany, Eliminate dead keys, acute replaced by apostrophe */
static const char main_key_de_nodeadkeys_noacute[MAIN_LEN][2] =
{
{'^','\xb0'},{'1','!'},{'2','"'},{'3','\xa7'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xdf','?'},{'\x27','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'#','\''},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Germany, Dvorak */
static const char main_key_de_dvorak[MAIN_LEN][2] =
{
{'^','\xb0'},{'1','!'},{'2','"'},{'3','\xa7'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','*'},{'<','>'},
{'\xfc','\xdc'},{',',';'},{'.',':'},{'p','P'},{'y','Y'},{'f','F'},{'g','G'},{'c','C'},{'t','T'},{'z','Z'},{'?','\xdf'},{'/','\\'},
{'a','A'},{'o','O'},{'e','E'},{'i','I'},{'u','U'},{'h','H'},{'d','D'},{'r','R'},{'n','N'},{'s','S'},{'l','L'},{'-','_'},
{'\xf6','\xd6'},{'q','Q'},{'j','J'},{'k','K'},{'x','X'},{'b','B'},{'m','M'},{'w','W'},{'v','V'},{'#','\''},{'\xe4','\xc4'},{0,0},{0,0}
};

/* Germany, Neostyle */
static const char main_key_de_neo[MAIN_LEN][2] =
{
{'R','\xb0'},{'1','!'},{'2','"'},{'3','\xb6'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'-','_'},{'Q','P'},
{'q','Q'},{'v','V'},{'l','L'},{'c','C'},{'w','W'},{'k','K'},{'h','H'},{'g','G'},{'f','F'},{'j','J'},{'\xdf','?'},{'+','*'},
{'u','U'},{'i','I'},{'a','A'},{'e','E'},{'o','O'},{'s','S'},{'n','N'},{'r','R'},{'t','T'},{'d','D'},{'y','Y'},{'#','\''},
{'\xf6','\xd6'},{'\xfc','\xdc'},{'\xe4','\xc4'},{'p','P'},{'z','Z'},{'b','B'},{'m','M'},{',',';'},{'.',':'},{'x','X'},{'<','>'},{0,0},{0,0}
};

/* Germany, paragraph */
static const char main_key_de_para[MAIN_LEN][2] =
{
{'R','\xb0'},{'1','!'},{'2','"'},{'3','\xb6'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xdf','?'},{'Q','P'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'#','\''},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Germany, Dead acute, paragraph */
static const char main_key_de_deadacute_para[MAIN_LEN][2] =
{
{'^','\xb0'},{'1','!'},{'2','"'},{'3','\xb6'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xdf','?'},{'Q','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'#','\''},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Germany, Dead grave acute, paragraph */
static const char main_key_de_deadgraveacute_para[MAIN_LEN][2] =
{
{'^','\xb0'},{'1','!'},{'2','"'},{'3','\xb6'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xdf','?'},{'Q','P'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'#','\''},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Germany, Eliminate dead keys, paragraph */
static const char main_key_de_nodeadkeys_para[MAIN_LEN][2] =
{
{'^','\xb0'},{'1','!'},{'2','"'},{'3','\xb6'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xdf','?'},{'\xb4','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'#','\''},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Germany, Eliminate dead keys, acute replaced by apostrophe, paragraph */
static const char main_key_de_nodeadkeys_noacute_para[MAIN_LEN][2] =
{
{'^','\xb0'},{'1','!'},{'2','"'},{'3','\xb6'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xdf','?'},{'\x27','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'#','\''},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Germany, Dvorak, paragraph */
static const char main_key_de_dvorak_para[MAIN_LEN][2] =
{
{'^','\xb0'},{'1','!'},{'2','"'},{'3','\xb6'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','*'},{'<','>'},
{'\xfc','\xdc'},{',',';'},{'.',':'},{'p','P'},{'y','Y'},{'f','F'},{'g','G'},{'c','C'},{'t','T'},{'z','Z'},{'?','\xdf'},{'/','\\'},
{'a','A'},{'o','O'},{'e','E'},{'i','I'},{'u','U'},{'h','H'},{'d','D'},{'r','R'},{'n','N'},{'s','S'},{'l','L'},{'-','_'},
{'\xf6','\xd6'},{'q','Q'},{'j','J'},{'k','K'},{'x','X'},{'b','B'},{'m','M'},{'w','W'},{'v','V'},{'#','\''},{'\xe4','\xc4'},{0,0},{0,0}
};

/* Germany, Sun dead keys */
static const char main_key_de_sun[MAIN_LEN][2] =
{
{'^','\xb0'},{'1','!'},{'2','"'},{'3','\xa7'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xdf','?'},{'\x03','\x00'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'#','\''},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Greece */
static const char main_key_gr[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{';',':'},{'\xf3','\xd2'},{'\xe5','\xc5'},{'\xf1','\xd1'},{'\xf4','\xd4'},{'\xf5','\xd5'},{'\xe8','\xc8'},{'\xe9','\xc9'},{'\xef','\xcf'},{'\xf0','\xd0'},{'[','{'},{']','}'},
{'\xe1','\xc1'},{'\xf2','\xd2'},{'\xe4','\xc4'},{'\xf6','\xd6'},{'\xe3','\xc3'},{'\xe7','\xc7'},{'\xee','\xce'},{'\xea','\xca'},{'\xeb','\xcb'},{'Q','W'},{'\'','"'},{'\\','|'},
{'\xe6','\xc6'},{'\xf7','\xd7'},{'\xf8','\xd8'},{'\xf9','\xd9'},{'\xe2','\xc2'},{'\xed','\xcd'},{'\xec','\xcc'},{',','<'},{'.','>'},{'/','?'},{'\xab','\xbb'},{0,0},{0,0}
};

/* Greece, Eliminate dead keys */
static const char main_key_gr_nodeadkeys[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{';',':'},{'\xf3','\xd2'},{'\xe5','\xc5'},{'\xf1','\xd1'},{'\xf4','\xd4'},{'\xf5','\xd5'},{'\xe8','\xc8'},{'\xe9','\xc9'},{'\xef','\xcf'},{'\xf0','\xd0'},{'[','{'},{']','}'},
{'\xe1','\xc1'},{'\xf2','\xd2'},{'\xe4','\xc4'},{'\xf6','\xd6'},{'\xe3','\xc3'},{'\xe7','\xc7'},{'\xee','\xce'},{'\xea','\xca'},{'\xeb','\xcb'},{';',':'},{'\'','"'},{'\\','|'},
{'\xe6','\xc6'},{'\xf7','\xd7'},{'\xf8','\xd8'},{'\xf9','\xd9'},{'\xe2','\xc2'},{'\xed','\xcd'},{'\xec','\xcc'},{',','<'},{'.','>'},{'/','?'},{'\xab','\xbb'},{0,0},{0,0}
};

/* Greece, Polytonic */
static const char main_key_gr_polytonic[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{';',':'},{'\xf3','\xd2'},{'\xe5','\xc5'},{'\xf1','\xd1'},{'\xf4','\xd4'},{'\xf5','\xd5'},{'\xe8','\xc8'},{'\xe9','\xc9'},{'\xef','\xcf'},{'\xf0','\xd0'},{'S','W'},{']','\xff'},
{'\xe1','\xc1'},{'\xf2','\xd2'},{'\xe4','\xc4'},{'\xf6','\xd6'},{'\xe3','\xc3'},{'\xe7','\xc7'},{'\xee','\xce'},{'\xea','\xca'},{'\xeb','\xcb'},{'Q','\x13'},{'P','\x14'},{'\\','|'},
{'\xe6','\xc6'},{'\xf7','\xd7'},{'\xf8','\xd8'},{'\xf9','\xd9'},{'\xe2','\xc2'},{'\xed','\xcd'},{'\xec','\xcc'},{',','<'},{'.','>'},{'/','?'},{'\xab','\xbb'},{0,0},{0,0}
};

/* Hungary */
static const char main_key_hu[MAIN_LEN][2] =
{
{'0','\xa7'},{'1','\''},{'2','"'},{'3','+'},{'4','!'},{'5','%'},{'6','/'},{'7','='},{'8','('},{'9',')'},{'\xf6','\xd6'},{'\xfc','\xdc'},{'\xf3','\xd3'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xf5','\xd5'},{'\xfa','\xda'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe9','\xc9'},{'\xe1','\xc1'},{'\xfb','\xdb'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','?'},{'.',':'},{'-','_'},{'\xed','\xcd'},{0,0},{0,0}
};

/* Hungary, qwerty */
static const char main_key_hu_qwerty[MAIN_LEN][2] =
{
{'\xed','\xcd'},{'1','\''},{'2','"'},{'3','+'},{'4','!'},{'5','%'},{'6','/'},{'7','='},{'8','('},{'9',')'},{'\xf6','\xd6'},{'\xfc','\xdc'},{'\xf3','\xd3'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xf5','\xd5'},{'\xfa','\xda'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe9','\xc9'},{'\xe1','\xc1'},{'\xfb','\xdb'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','?'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Hungary, 101/qwertz/comma/Dead keys */
static const char main_key_hu_101_qwertz_comma_dead[MAIN_LEN][2] =
{
{'\xed','\xcd'},{'1','\''},{'2','"'},{'3','+'},{'4','!'},{'5','%'},{'6','/'},{'7','='},{'8','('},{'9',')'},{'\xf6','\xd6'},{'\xfc','\xdc'},{'\xf3','\xd3'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xf5','\xd5'},{'\xfa','\xda'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe9','\xc9'},{'\xe1','\xc1'},{'\xfb','\xdb'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','?'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Hungary, 102/qwerty/comma/Dead keys */
static const char main_key_hu_102_qwerty_comma_dead[MAIN_LEN][2] =
{
{'0','\xa7'},{'1','\''},{'2','"'},{'3','+'},{'4','!'},{'5','%'},{'6','/'},{'7','='},{'8','('},{'9',')'},{'\xf6','\xd6'},{'\xfc','\xdc'},{'\xf3','\xd3'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xf5','\xd5'},{'\xfa','\xda'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe9','\xc9'},{'\xe1','\xc1'},{'\xfb','\xdb'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','?'},{'.',':'},{'-','_'},{'\xed','\xcd'},{0,0},{0,0}
};

/* Iceland */
static const char main_key_is[MAIN_LEN][2] =
{
{'\xb0','\xa8'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xf6','\xd6'},{'-','_'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xf0','\xd0'},{'\'','?'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe6','\xc6'},{'Q','\xc4'},{'+','*'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'\xfe','\xde'},{'<','>'},{0,0},{0,0}
};

/* Iceland, Sun dead keys */
static const char main_key_is_Sundeadkeys[MAIN_LEN][2] =
{
{'\x01','\xb0'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xf6','\xd6'},{'\x03','\x00'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'#','\xb4'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'\xfe','\xde'},{'<','>'},{0,0},{0,0}
};

/* Iceland, Eliminate dead keys */
static const char main_key_is_nodeadkeys[MAIN_LEN][2] =
{
{'^','\xb0'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xf6','\xd6'},{'\'','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xdc'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xd6'},{'\xe4','\xc4'},{'#','\xb4'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'\xfe','\xde'},{'<','>'},{0,0},{0,0}
};

/* Iceland, Macintosh */
static const char main_key_is_mac[MAIN_LEN][2] =
{
{'\xa3','\xa7'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\xf6','\xd6'},{'-','_'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xf0','\xd0'},{'\'','?'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe6','\xc6'},{'Q','W'},{'+','*'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'\xfe','\xde'},{'<','>'},{0,0},{0,0}
};

/* Israel */
static const char main_key_il[MAIN_LEN][2] =
{
{';','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9',')'},{'0','('},{'-','_'},{'=','+'},
{'/','Q'},{'\'','W'},{'\xf7','E'},{'\xf8','R'},{'\xe0','T'},{'\xe8','Y'},{'\xe5','U'},{'\xef','I'},{'\xed','O'},{'\xf4','P'},{']','}'},{'[','{'},
{'\xf9','A'},{'\xe3','S'},{'\xe2','D'},{'\xeb','F'},{'\xf2','G'},{'\xe9','H'},{'\xe7','J'},{'\xec','K'},{'\xea','L'},{'\xf3',':'},{',','"'},{'\\','\\'},
{'\xe6','Z'},{'\xf1','X'},{'\xe1','C'},{'\xe4','V'},{'\xf0','B'},{'\xee','N'},{'\xf6','M'},{'\xfa','>'},{'\xf5','<'},{'.','?'},{'<','>'},{0,0},{0,0}
};

/* Israel, lyx */
static const char main_key_il_lyx[MAIN_LEN][2] =
{
{';','~'},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{'9',')'},{'0','('},{'-','\xbe'},{0,0},
{'/','/'},{'\'','\''},{'\xf7','\xb8'},{'\xf8','\xbc'},{'\xe0','\x0e'},{'\xe8','\x0f'},{'\xe5','\xb9'},{'\xef','\xef'},{'\xed','\xed'},{'\xf4','\xb7'},{']','}'},{'[','{'},
{'\xf9','\xb0'},{'\xe3','\xbc'},{'\xe2','\xe2'},{'\xeb','\xeb'},{'\xf2','\xc2'},{'\xe9','\xc1'},{'\xe7','\xb4'},{'\xec','\xaa'},{'\xea','\xea'},{'\xf3',':'},{',','"'},{'\\','|'},
{'\xe6','\xe6'},{'\xf1','\xb6'},{'\xe1','\xbb'},{'\xe4','\xb1'},{'\xf0','\xb2'},{'\xee','\xb3'},{'\xf6','\xb5'},{'\xfa','>'},{'\xf5','<'},{'.','?'},{'<','>'},{0,0},{0,0}
};

/* Israel, Phonetic */
static const char main_key_il_phonetic[MAIN_LEN][2] =
{
{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{'=','+'},
{'\xf7','\xf7'},{'\xe5','\xe5'},{'\xe0','\xe0'},{'\xf8','\xf8'},{'\xfa','\xe8'},{'\xf2','\xf2'},{'\xe5','\xe5'},{'\xe9','\xe9'},{'\xf1','\xf1'},{'\xf4','\xf3'},{0,0},{0,0},
{'\xe0','\xe0'},{'\xf9','\xf9'},{'\xe3','\xe3'},{'\xf4','\xf3'},{'\xe2','\xe2'},{'\xe4','\xe4'},{'\xe9','\xe9'},{'\xeb','\xea'},{'\xec','\xec'},{0,0},{0,0},{'\\','|'},
{'\xe6','\xe6'},{'\xe7','\xe7'},{'\xf6','\xf5'},{'\xe5','\xe5'},{'\xe1','\xe1'},{'\xf0','\xef'},{'\xee','\xed'},{0,0},{0,0},{0,0},{'<','>'},{0,0},{0,0}
};

/* Italy */
static const char main_key_it[MAIN_LEN][2] =
{
{'\\','|'},{'1','!'},{'2','"'},{'3','\xa3'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'\xec','^'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe8','\xe9'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf2','\xe7'},{'\xe0','\xb0'},{'\xf9','\xa7'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Italy, Macintosh */
static const char main_key_it_mac[MAIN_LEN][2] =
{
{'@','#'},{'&','1'},{'"','2'},{'\'','3'},{'(','4'},{'\xe7','5'},{'\xe8','6'},{')','7'},{'\xa3','8'},{'\xe0','9'},{'\xe9','0'},{'-','_'},{'=','+'},
{'q','Q'},{'z','Z'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xec','^'},{'$','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'m','M'},{'\xf9','%'},{'\xa7','\xb0'},
{'w','W'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{',','?'},{';','.'},{':','/'},{'\xf2','!'},{'<','>'},{0,0},{0,0}
};

/* Japan */
static const char main_key_jp[MAIN_LEN][2] =
{
{0,0},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','\''},{'8','('},{'9',')'},{'0','~'},{'-','='},{'^','~'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'@','`'},{'[','{'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';','+'},{':','*'},{']','}'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{'\\','_'},{'\\','|'}
};

/* Kyrgyzstan */
static const char main_key_kg[MAIN_LEN][2] =
{
{'\xa3','\xb3'},{'1','!'},{'2','"'},{'3','\xb0'},{'4',';'},{'5','%'},{'6',':'},{'7','?'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xdd','\xfd'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xdf','\xff'},
{'\xc6','\xe6'},{'\xd9','\xf9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xdc','\xfc'},{'\\','/'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'.',','},{'/','|'},{0,0},{0,0}
};

/* Cambodia */
static const char main_key_kh[MAIN_LEN][2] =
{
{'\xab','\xbb'},{'\xe1','!'},{'\xe2','\xd7'},{'\xe3','"'},{'\xe4','\xdb'},{'\xe5','%'},{'\xe6','\xcd'},{'\xe7','\xd0'},{'\xe8','\xcf'},{'\xe9','('},{'\xe0',')'},{'\xa5','\xcc'},{'\xb2','='},
{'\x86','\x88'},{'\xb9','\xba'},{'\xc1','\xc2'},{'\x9a','\xac'},{'\x8f','\x91'},{'\x99','\xbd'},{'\xbb','\xbc'},{'\xb7','\xb8'},{'\xc4','\xc5'},{'\x95','\x97'},{'\xc0','\xbf'},{'\xaa','\xa7'},
{'\xb6','\xff'},{'\x9f','\xc3'},{'\x8a','\x8c'},{'\x90','\x92'},{'\x84','\xa2'},{'\xa0','\xc7'},{'\xd2','\x89'},{'\x80','\x82'},{'\x9b','\xa1'},{'\xbe','\xfe'},{'\xcb','\xc9'},{'\xae','\xad'},
{'\x8b','\x8d'},{'\x81','\x83'},{'\x85','\x87'},{'\x9c','\xfd'},{'\x94','\x96'},{'\x93','\x8e'},{'\x98','\xc6'},{'\xfc','\xfb'},{'\xd4','\xd5'},{'\xca','?'},{'<','>'},{0,0},{0,0}
};

/* Kazakhstan */
static const char main_key_kz[MAIN_LEN][2] =
{
{'(',')'},{'\xfe','!'},{'\xd9','\xd8'},{'\xa6','\xb6'},{'\xa3','\xa2'},{'\x93','\x92'},{',',';'},{'.',':'},{'\xaf','\xae'},{'\xb1','\xb0'},{'\x9b','\x9a'},{'\xe9','\xe8'},{'\xbb','\xba'},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xdd','\xfd'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xdf','\xff'},
{'\xc6','\xe6'},{'\xd9','\xf9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xdc','\xfc'},{'\\','/'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'\xb0','?'},{'<','>'},{0,0},{0,0}
};

/* Kazakhstan, Russian with Kazakh */
static const char main_key_kz_ruskaz[MAIN_LEN][2] =
{
{'\xa3','\xb3'},{'1','!'},{'2','"'},{'3','\xb0'},{'4',';'},{'5','%'},{'6',':'},{'7','?'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xdd','\xfd'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xdf','\xff'},
{'\xc6','\xe6'},{'\xd9','\xf9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xdc','\xfc'},{'\\','/'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'.',','},{'<','>'},{0,0},{0,0}
};

/* Kazakhstan, Kazakh with Russian */
static const char main_key_kz_kazrus[MAIN_LEN][2] =
{
{'\xa3','\xb3'},{'1','!'},{'2','"'},{'3','\xb0'},{'4',';'},{'5','%'},{'6',':'},{'7','?'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xca','\xea'},{'\xa3','\xa2'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\x93','\x92'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xb1','\xb0'},
{'\xe9','\xe8'},{'\xd9','\xf9'},{'\x9b','\x9a'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xd9','\xd8'},{'\\','/'},
{'\xd1','\xf1'},{'\xa6','\xb6'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\xaf','\xae'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'.',','},{'<','>'},{0,0},{0,0}
};

/* Laos */
static const char main_key_la[MAIN_LEN][2] =
{
{'\x0d','\x0d'},{'\xa2','\xd1'},{'\x9f','\xd2'},{'\xc2','\xd3'},{'\x96','\xd4'},{'\xb8','\xcc'},{'\xb9','\xbc'},{'\x84','\xd5'},{'\x95','\xd6'},{'\x88','\xd7'},{'\x82','\xd8'},{'\x8a','\xd9'},{'\xcd','\xcd'},
{'\xbb','\xbb'},{'\xc4','\xd0'},{'\xb3','\xb3'},{'\x9e','_'},{'\xb0','+'},{'\xb4','\xb4'},{'\xb5','\xb5'},{'\xa3','\xae'},{'\x99','\x99'},{'\x8d','\xbd'},{'\x9a','-'},{'\xa5','}'},
{'\xb1','\xb1'},{'\xab',';'},{'\x81','.'},{'\x94',','},{'\xc0',':'},{'\xc9','\xca'},{'\xc8','\xcb'},{'\xb2','!'},{'\xaa','?'},{'\xa7','%'},{'\x87','='},{'\xdc','\xdd'},
{'\x9c','\xad'},{'\x9b','('},{'\xc1','\xaf'},{'\xad','\xad'},{'\xb6','\xb6'},{'\xb7','\xb7'},{'\x97','\xc6'},{'\xa1','`'},{'\xc3','$'},{'\x9d',')'},{'<','>'},{0,0},{0,0}
};

/* Latin American */
static const char main_key_latam[MAIN_LEN][2] =
{
{'|','\xb0'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'\xbf','\xa1'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'Q','W'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf1','\xd1'},{'{','['},{'}',']'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Latin American, Eliminate dead keys */
static const char main_key_latam_nodeadkeys[MAIN_LEN][2] =
{
{'|','\xb0'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'\xbf','\xa1'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'`','^'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf1','\xd1'},{'\xb4','\xa8'},{'\xe7','\xc7'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Latin American, Sun dead keys */
static const char main_key_latam_sundeadkeys[MAIN_LEN][2] =
{
{'|','\xb0'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'\xbf','\xa1'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\x00','\x01'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf1','\xd1'},{'\x03','\x04'},{'}',']'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Lithuania */
static const char main_key_lt[MAIN_LEN][2] =
{
{'`','~'},{'\xb1','\xa1'},{'\xe8','\xc8'},{'\xea','\xca'},{'\xec','\xcc'},{'\xe7','\xc7'},{'\xb9','\xa9'},{'\xf9','\xd9'},{'\xfe','\xde'},{'\xfe','('},{'\xd2',')'},{'-','_'},{'\xbe','\xae'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'\xaa','\xac'},{0,0},{0,0}
};

/* Lithuania, Standard */
static const char main_key_lt_std[MAIN_LEN][2] =
{
{'`','~'},{'!','1'},{'-','2'},{'/','3'},{';','4'},{':','5'},{',','6'},{'.','7'},{'=','8'},{'(','9'},{')','0'},{'?','+'},{'x','X'},
{'\xb1','\xa1'},{'\xbe','\xae'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe7','\xc7'},{'w','W'},
{'a','A'},{'s','S'},{'d','D'},{'\xb9','\xa9'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf9','\xd9'},{'\xec','\xcc'},{'q','Q'},
{'z','Z'},{'\xfe','\xde'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{'\xe8','\xc8'},{'f','F'},{'\xea','\xca'},{'<','>'},{0,0},{0,0}
};

/* Lithuania, US keyboard with Lithuanian letters */
static const char main_key_lt_us[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'\xaa','\xac'},{0,0},{0,0}
};

/* Lithuania, IBM (LST 1205-92) */
static const char main_key_lt_ibm[MAIN_LEN][2] =
{
{'`','~'},{'!','1'},{'"','2'},{'/','3'},{';','4'},{':','5'},{',','6'},{'.','7'},{'?','8'},{'(','9'},{')','0'},{'_','-'},{'+','='},
{'\xb1','\xa1'},{'\xbe','\xae'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe7','\xc7'},{'\xfe','\xd2'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf9','\xd9'},{'\xec','\xcc'},{'\\','|'},
{'z','Z'},{'\xfe','\xde'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{'\xe8','\xc8'},{'\xb9','\xa9'},{'\xea','\xca'},{'<','>'},{0,0},{0,0}
};

/* Latvia, Apostrophe (') variant */
static const char main_key_lv_apostrophe[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\x04','"'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Latvia, Tilde (~) variant */
static const char main_key_lv_tilde[MAIN_LEN][2] =
{
{'\x04','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Latvia, F-letter (F) variant */
static const char main_key_lv_fkey[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'\x04','\x04'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Macedonia */
static const char main_key_mk[MAIN_LEN][2] =
{
{'P','~'},{'1','!'},{'2','\xfe'},{'3','\xd2'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xa9','\xb9'},{'\xaa','\xba'},{'\xc5','\xe5'},{'\xd2','\xf2'},{'\xd4','\xf4'},{'\xa5','\xb5'},{'\xd5','\xf5'},{'\xc9','\xe9'},{'\xcf','\xef'},{'\xd0','\xf0'},{'\xdb','\xfb'},{'\xa2','\xb2'},
{'\xc1','\xe1'},{'\xd3','\xf3'},{'\xc4','\xe4'},{'\xc6','\xe6'},{'\xc7','\xe7'},{'\xc8','\xe8'},{'\xa8','\xb8'},{'\xcb','\xeb'},{'\xcc','\xec'},{'\xde','\xfe'},{'\xac','\xbc'},{'\xd6','\xf6'},
{'\xda','\xfa'},{'\xaf','\xbf'},{'\xc3','\xe3'},{'\xd7','\xf7'},{'\xc2','\xe2'},{'\xce','\xee'},{'\xcd','\xed'},{',',';'},{'.',':'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Macedonia, Eliminate dead keys */
static const char main_key_mk_nodeadkeys[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','\xfe'},{'3','\xd2'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xa9','\xb9'},{'\xaa','\xba'},{'\xc5','\xe5'},{'\xd2','\xf2'},{'\xd4','\xf4'},{'\xa5','\xb5'},{'\xd5','\xf5'},{'\xc9','\xe9'},{'\xcf','\xef'},{'\xd0','\xf0'},{'\xdb','\xfb'},{'\xa2','\xb2'},
{'\xc1','\xe1'},{'\xd3','\xf3'},{'\xc4','\xe4'},{'\xc6','\xe6'},{'\xc7','\xe7'},{'\xc8','\xe8'},{'\xa8','\xb8'},{'\xcb','\xeb'},{'\xcc','\xec'},{'\xde','\xfe'},{'\xac','\xbc'},{'\xd6','\xf6'},
{'\xda','\xfa'},{'\xaf','\xbf'},{'\xc3','\xe3'},{'\xd7','\xf7'},{'\xc2','\xe2'},{'\xce','\xee'},{'\xcd','\xed'},{',',';'},{'.',':'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Malta */
static const char main_key_mt[MAIN_LEN][2] =
{
{'\xe5','\xc5'},{'1','!'},{'2','@'},{'3','\xac'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xf5','\xd5'},{'\xb1','\xa1'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'\xbf','\xaf'},{0,0},{0,0}
};

/* Malta, Maltese keyboard with US layout */
static const char main_key_mt_us[MAIN_LEN][2] =
{
{'\xe5','\xc5'},{'1','!'},{'2','@'},{'3','\xac'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xf5','\xd5'},{'\xb1','\xa1'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\xbf','\xaf'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'\xbf','\xaf'},{0,0},{0,0}
};

/* Mongolia */
static const char main_key_mn[MAIN_LEN][2] =
{
{'=','+'},{'1','\xb0'},{'2','-'},{'3','"'},{'4','\xae'},{'5',':'},{'6','.'},{'7','_'},{'8',','},{'9','%'},{'0','?'},{'\xc5','\xe5'},{'\xdd','\xfd'},
{'\xc6','\xe6'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xd6','\xf6'},{'\xdc','\xfc'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xaf','\xae'},{'\xda','\xfa'},{'\xcb','\xeb'},{'\xdf','\xff'},
{'\xca','\xea'},{'\xd9','\xf9'},{'\xc2','\xe2'},{'\xe9','\xe8'},{'\xc1','\xe1'},{'\xc8','\xe8'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd0','\xf0'},{'!','|'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xa3','\xb3'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xd7','\xf7'},{'\xc0','\xe0'},{'(',')'},{0,0},{0,0}
};

/* Norway */
static const char main_key_no[MAIN_LEN][2] =
{
{'|','\xa7'},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'\\','P'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe5','\xc5'},{'W','R'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf8','\xd8'},{'\xe6','\xc6'},{'\'','*'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Norway, Eliminate dead keys */
static const char main_key_no_nodeadkeys[MAIN_LEN][2] =
{
{'|','\xa7'},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'\\','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe5','\xc5'},{'\xa8','^'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf8','\xd8'},{'\xe6','\xc6'},{'\'','*'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Norway, Dvorak */
static const char main_key_no_dvorak[MAIN_LEN][2] =
{
{'|','\xa7'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'\\','`'},
{'\xe5','\xc5'},{',',';'},{'.',':'},{'p','P'},{'y','Y'},{'f','F'},{'g','G'},{'c','C'},{'r','R'},{'l','L'},{'\'','*'},{'~','^'},
{'a','A'},{'o','O'},{'e','E'},{'u','U'},{'i','I'},{'d','D'},{'h','H'},{'t','T'},{'n','N'},{'s','S'},{'-','_'},{'<','>'},
{'\xe6','\xc6'},{'q','Q'},{'j','J'},{'k','K'},{'x','X'},{'b','B'},{'m','M'},{'w','W'},{'v','V'},{'z','Z'},{'\xf8','\xd8'},{0,0},{0,0}
};

/* Norway, Northern Saami */
static const char main_key_no_smi[MAIN_LEN][2] =
{
{'|','\xa7'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'\\','`'},
{'\xe1','\xc1'},{'\xb9','\xa9'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe5','\xc5'},{'\xbf','\xbd'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf8','\xd8'},{'\xe6','\xc6'},{'\xf0','\xd0'},
{'z','Z'},{'\xe8','\xc8'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'\xbe','\xae'},{0,0},{0,0}
};

/* Norway, Macintosh */
static const char main_key_no_mac[MAIN_LEN][2] =
{
{'|','\xa7'},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'P','Q'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe5','\xc5'},{'\xa8','^'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf8','\xd8'},{'\xe6','\xc6'},{'@','*'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Norway, Macintosh, eliminate dead keys */
static const char main_key_no_mac_nodeadkeys[MAIN_LEN][2] =
{
{'|','\xa7'},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'`','\xb4'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe5','\xc5'},{'\xa8','^'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf8','\xd8'},{'\xe6','\xc6'},{'@','*'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Poland, qwertz */
static const char main_key_pl_qwertz[MAIN_LEN][2] =
{
{'\xff','\\'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'\'','*'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xbf','\xf1'},{'\xb6','\xe6'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xb3','\xa3'},{'\xb1','\xea'},{'\xf3','\xbc'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Portugal */
static const char main_key_pt[MAIN_LEN][2] =
{
{'\\','|'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'\xab','\xbb'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'+','*'},{'Q','P'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe7','\xc7'},{'\xba','\xaa'},{'S','R'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Portugal, Eliminate dead keys */
static const char main_key_pt_nodeadkeys[MAIN_LEN][2] =
{
{'\\','|'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'\xab','\xbb'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'+','*'},{'\xb4','`'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe7','\xc7'},{'\xba','\xaa'},{'~','^'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Portugal, Sun dead keys */
static const char main_key_pt_sundeadkeys[MAIN_LEN][2] =
{
{'\\','|'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'\xab','\xbb'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'+','*'},{'\x03','\x00'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe7','\xc7'},{'\xba','\xaa'},{'\x02','\x01'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Portugal, Macintosh */
static const char main_key_pt_mac[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'+','*'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xba','\xaa'},{'Q','P'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe7','\xc7'},{'S','R'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Portugal, Macintosh, eliminate dead keys */
static const char main_key_pt_mac_nodeadkeys[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'+','*'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xba','\xaa'},{'\xb4','`'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe7','\xc7'},{'~','^'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Portugal, Macintosh, Sun dead keys */
static const char main_key_pt_mac_sundeadkeys[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'+','*'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xba','\xaa'},{'\x03','\x00'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe7','\xc7'},{'\x02','\x01'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Romania */
static const char main_key_ro[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'\\','|'},{0,0},{0,0}
};

/* Romania, Standard */
static const char main_key_ro_std[MAIN_LEN][2] =
{
{'\xfe','\xd3'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe3','\xc3'},{'\xee','\xce'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xba','\xaa'},{'\xfe','\xde'},{'\xe2','\xc2'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'/','?'},{'\\','|'},{0,0},{0,0}
};

/* Romania, Standard (Commabelow) */
static const char main_key_ro_academic[MAIN_LEN][2] =
{
{'\xfe','\xd3'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe3','\xc3'},{'\xee','\xce'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\x19','\x18'},{'\x1b','\x1a'},{'\xe2','\xc2'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'/','?'},{'\\','|'},{0,0},{0,0}
};

/* Romania, Winkeys */
static const char main_key_ro_winkeys[MAIN_LEN][2] =
{
{']','['},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'\'','*'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe3','\xc3'},{'\xee','\xce'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xba','\xaa'},{'\xfe','\xde'},{'\xe2','\xc2'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Russia */
static const char main_key_ru[MAIN_LEN][2] =
{
{'\xa3','\xb3'},{'1','!'},{'2','"'},{'3','#'},{'4','*'},{'5',':'},{'6',','},{'7','.'},{'8',';'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xdd','\xfd'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xdf','\xff'},
{'\xc6','\xe6'},{'\xd9','\xf9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xdc','\xfc'},{'\\','|'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'/','?'},{'/','|'},{0,0},{0,0}
};

/* Russia, Phonetic */
static const char main_key_ru_phonetic[MAIN_LEN][2] =
{
{'\xc0','\xe0'},{'1','!'},{'2','@'},{'3','\xa3'},{'4','\xb3'},{'5','\xdf'},{'6','\xff'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{0,0},{'\xde','\xfe'},
{'\xd1','\xf1'},{'\xd7','\xf7'},{'\xc5','\xe5'},{'\xd2','\xf2'},{'\xd4','\xf4'},{'\xd9','\xf9'},{'\xd5','\xf5'},{'\xc9','\xe9'},{'\xcf','\xef'},{'\xd0','\xf0'},{'\xdb','\xfb'},{'\xdd','\xfd'},
{'\xc1','\xe1'},{'\xd3','\xf3'},{'\xc4','\xe4'},{'\xc6','\xe6'},{'\xc7','\xe7'},{'\xc8','\xe8'},{'\xca','\xea'},{'\xcb','\xeb'},{'\xcc','\xec'},{';',':'},{'\'','"'},{'\xdc','\xfc'},
{'\xda','\xfa'},{'\xd8','\xf8'},{'\xc3','\xe3'},{'\xd6','\xf6'},{'\xc2','\xe2'},{'\xce','\xee'},{'\xcd','\xed'},{',','<'},{'.','>'},{'/','?'},{'|','\xa6'},{0,0},{0,0}
};

/* Russia, Typewriter */
static const char main_key_ru_typewriter[MAIN_LEN][2] =
{
{'\'','"'},{'!','1'},{'\xb0','2'},{'/','3'},{';','4'},{':','5'},{',','6'},{'.','7'},{'_','8'},{'?','9'},{'%','0'},{'-','_'},{'=','+'},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xdd','\xfd'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xdf','\xff'},
{'\xc6','\xe6'},{'\xd9','\xf9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xdc','\xfc'},{'(',')'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'\xa3','\xb3'},{'/','|'},{0,0},{0,0}
};

/* Russia, Tatar */
static const char main_key_ru_tt[MAIN_LEN][2] =
{
{'\xbb','\xba'},{'1','!'},{'2','"'},{'3','\xb0'},{'4',';'},{'5','%'},{'6',':'},{'7','?'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xca','\xea'},{'\xe9','\xe8'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xd9','\xd8'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xaf','\xae'},
{'\xc6','\xe6'},{'\xd9','\xf9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xa3','\xa2'},{'\xdc','\xfc'},{'\\','/'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\x97','\x96'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'.',','},{'/','|'},{0,0},{0,0}
};

/* Russia, Ossetian */
static const char main_key_ru_os[MAIN_LEN][2] =
{
{'\xdc','\xfc'},{'1','!'},{'2','"'},{'3','#'},{'4','*'},{'5',':'},{'6',','},{'7','.'},{'8',';'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xdd','\xfd'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xdf','\xff'},
{'\xc6','\xe6'},{'\xd9','\xf9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xd5','\xd4'},{'\\','|'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'/','?'},{'/','|'},{0,0},{0,0}
};

/* Russia, Ossetian, Winkeys */
static const char main_key_ru_os_winkeys[MAIN_LEN][2] =
{
{'\xdc','\xfc'},{'1','!'},{'2','"'},{'3','\xb0'},{'4',';'},{'5','%'},{'6',':'},{'7','?'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xdd','\xfd'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xdf','\xff'},
{'\xc6','\xe6'},{'\xd9','\xf9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xd5','\xd4'},{'\\','/'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'.',','},{'/','|'},{0,0},{0,0}
};

/* Serbia and Montenegro */
static const char main_key_cs[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'+','*'},
{'\xa9','\xb9'},{'\xaa','\xba'},{'\xc5','\xe5'},{'\xd2','\xf2'},{'\xd4','\xf4'},{'\xda','\xfa'},{'\xd5','\xf5'},{'\xc9','\xe9'},{'\xcf','\xef'},{'\xd0','\xf0'},{'\xdb','\xfb'},{'\xa1','\xb1'},
{'\xc1','\xe1'},{'\xd3','\xf3'},{'\xc4','\xe4'},{'\xc6','\xe6'},{'\xc7','\xe7'},{'\xc8','\xe8'},{'\xa8','\xb8'},{'\xcb','\xeb'},{'\xcc','\xec'},{'\xde','\xfe'},{'\xab','\xbb'},{'\xd6','\xf6'},
{'\xd6','\xf6'},{'\xaf','\xbf'},{'\xc3','\xe3'},{'\xd7','\xf7'},{'\xc2','\xe2'},{'\xce','\xee'},{'\xcd','\xed'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Serbia and Montenegro, Z and ZHE swapped */
static const char main_key_cs_yz[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'+','*'},
{'\xa9','\xb9'},{'\xaa','\xba'},{'\xc5','\xe5'},{'\xd2','\xf2'},{'\xd4','\xf4'},{'\xd6','\xf6'},{'\xd5','\xf5'},{'\xc9','\xe9'},{'\xcf','\xef'},{'\xd0','\xf0'},{'\xdb','\xfb'},{'\xa1','\xb1'},
{'\xc1','\xe1'},{'\xd3','\xf3'},{'\xc4','\xe4'},{'\xc6','\xe6'},{'\xc7','\xe7'},{'\xc8','\xe8'},{'\xa8','\xb8'},{'\xcb','\xeb'},{'\xcc','\xec'},{'\xde','\xfe'},{'\xab','\xbb'},{'\xd6','\xf6'},
{'\xda','\xfa'},{'\xaf','\xbf'},{'\xc3','\xe3'},{'\xd7','\xf7'},{'\xc2','\xe2'},{'\xce','\xee'},{'\xcd','\xed'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Slovakia */
static const char main_key_sk[MAIN_LEN][2] =
{
{';','X'},{'+','1'},{'\xb5','2'},{'\xb9','3'},{'\xe8','4'},{'\xbb','5'},{'\xbe','6'},{'\xfd','7'},{'\xe1','8'},{'\xed','9'},{'\xe9','0'},{'=','%'},{'Q','Z'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfa','/'},{'\xe4','('},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf4','"'},{'\xa7','!'},{'\xf2',')'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','?'},{'.',':'},{'-','_'},{'\\','|'},{0,0},{0,0}
};

/* Slovakia, Extended Backslash */
static const char main_key_sk_bksl[MAIN_LEN][2] =
{
{';','X'},{'+','1'},{'\xb5','2'},{'\xb9','3'},{'\xe8','4'},{'\xbb','5'},{'\xbe','6'},{'\xfd','7'},{'\xe1','8'},{'\xed','9'},{'\xe9','0'},{'=','%'},{'Q','Z'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfa','/'},{'\xe4','('},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf4','"'},{'\xa7','!'},{'\\','|'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','?'},{'.',':'},{'-','_'},{'\\','|'},{0,0},{0,0}
};

/* Slovakia, qwerty */
static const char main_key_sk_qwerty[MAIN_LEN][2] =
{
{';','X'},{'+','1'},{'\xb5','2'},{'\xb9','3'},{'\xe8','4'},{'\xbb','5'},{'\xbe','6'},{'\xfd','7'},{'\xe1','8'},{'\xed','9'},{'\xe9','0'},{'=','%'},{'Q','Z'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfa','/'},{'\xe4','('},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf4','"'},{'\xa7','!'},{'\xf2',')'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','?'},{'.',':'},{'-','_'},{'\\','|'},{0,0},{0,0}
};

/* Slovakia, qwerty, extended Backslash */
static const char main_key_sk_qwerty_bksl[MAIN_LEN][2] =
{
{';','X'},{'+','1'},{'\xb5','2'},{'\xb9','3'},{'\xe8','4'},{'\xbb','5'},{'\xbe','6'},{'\xfd','7'},{'\xe1','8'},{'\xed','9'},{'\xe9','0'},{'=','%'},{'Q','Z'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfa','/'},{'\xe4','('},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf4','"'},{'\xa7','!'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','?'},{'.',':'},{'-','_'},{'\\','|'},{0,0},{0,0}
};

/* Spain */
static const char main_key_es[MAIN_LEN][2] =
{
{'\xba','\xaa'},{'1','!'},{'2','"'},{'3','\xb7'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'\xa1','\xbf'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'P','R'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf1','\xd1'},{'Q','W'},{'\xe7','\xc7'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Spain, Eliminate dead keys */
static const char main_key_es_nodeadkeys[MAIN_LEN][2] =
{
{'\xba','\xaa'},{'1','!'},{'2','"'},{'3','\xb7'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'\xa1','\xbf'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'`','^'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf1','\xd1'},{'\xb4','\xa8'},{'\xe7','\xc7'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Spain, Sun dead keys */
static const char main_key_es_sundeadkeys[MAIN_LEN][2] =
{
{'\xba','\xaa'},{'1','!'},{'2','"'},{'3','\xb7'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'\xa1','\xbf'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\x00','\x01'},{'+','*'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf1','\xd1'},{'\x03','\x04'},{'\xe7','\xc7'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Spain, Dvorak */
static const char main_key_es_dvorak[MAIN_LEN][2] =
{
{'\xba','\xaa'},{'1','!'},{'2','"'},{'3','\xb7'},{'4','$'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'\xa1','\xbf'},
{'.',':'},{',',';'},{'\xf1','\xd1'},{'p','P'},{'y','Y'},{'f','F'},{'g','G'},{'c','C'},{'h','H'},{'l','L'},{'P','R'},{'+','*'},
{'a','A'},{'o','O'},{'e','E'},{'u','U'},{'i','I'},{'d','D'},{'r','R'},{'t','T'},{'n','N'},{'s','S'},{'Q','W'},{'\xe7','\xc7'},
{'-','_'},{'q','Q'},{'j','J'},{'k','K'},{'x','X'},{'b','B'},{'m','M'},{'w','W'},{'v','V'},{'z','Z'},{'<','>'},{0,0},{0,0}
};

/* Sweden, Dvorak */
static const char main_key_se_dvorak[MAIN_LEN][2] =
{
{'\xa7','\xbd'},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'Q','P'},
{'\xe5','\xc5'},{'\xe4','\xc4'},{'\xf6','\xd6'},{'p','P'},{'y','Y'},{'f','F'},{'g','G'},{'c','C'},{'r','R'},{'l','L'},{',',';'},{'W','R'},
{'a','A'},{'o','O'},{'e','E'},{'u','U'},{'i','I'},{'d','D'},{'h','H'},{'t','T'},{'n','N'},{'s','S'},{'-','_'},{'\'','*'},
{'.',':'},{'q','Q'},{'j','J'},{'k','K'},{'x','X'},{'b','B'},{'m','M'},{'w','W'},{'v','V'},{'z','Z'},{'<','>'},{0,0},{0,0}
};

/* Sweden, Russian phonetic */
static const char main_key_se_rus[MAIN_LEN][2] =
{
{'\xa3','\xb3'},{'1','!'},{'2','"'},{'3','#'},{'4','\xa4'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'+','?'},{'\xdf','\xff'},
{'\xd1','\xf1'},{'\xd7','\xf7'},{'\xc5','\xe5'},{'\xd2','\xf2'},{'\xd4','\xf4'},{'\xd9','\xf9'},{'\xd5','\xf5'},{'\xc9','\xe9'},{'\xcf','\xef'},{'\xd0','\xf0'},{'\xdc','\xfc'},{'W','R'},
{'\xc1','\xe1'},{'\xd3','\xf3'},{'\xc4','\xe4'},{'\xc6','\xe6'},{'\xc7','\xe7'},{'\xc8','\xe8'},{'\xca','\xea'},{'\xcb','\xeb'},{'\xcc','\xec'},{'\xdb','\xfb'},{'\xdd','\xfd'},{'\xc0','\xe0'},
{'\xda','\xfa'},{'\xd8','\xf8'},{'\xc3','\xe3'},{'\xd6','\xf6'},{'\xc2','\xe2'},{'\xce','\xee'},{'\xcd','\xed'},{',',';'},{'.',':'},{'-','_'},{'\xde','\xfe'},{0,0},{0,0}
};

/* Switzerland */
static const char main_key_ch[MAIN_LEN][2] =
{
{'\xa7','\xb0'},{'1','+'},{'2','"'},{'3','*'},{'4','\xe7'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'R','P'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xe8'},{'W','!'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xe9'},{'\xe4','\xe0'},{'$','\xa3'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Switzerland, German, eliminate dead keys */
static const char main_key_ch_de_nodeadkeys[MAIN_LEN][2] =
{
{'\xa7','\xb0'},{'1','+'},{'2','"'},{'3','*'},{'4','\xe7'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'^','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xe8'},{'\xa8','!'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xe9'},{'\xe4','\xe0'},{'$','\xa3'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Switzerland, German, Sun dead keys */
static const char main_key_ch_de_sundeadkeys[MAIN_LEN][2] =
{
{'\xa7','\xb0'},{'1','+'},{'2','"'},{'3','*'},{'4','\xe7'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'\x01','\x00'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xfc','\xe8'},{'\x04','!'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xf6','\xe9'},{'\xe4','\xe0'},{'$','\xa3'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Switzerland, French */
static const char main_key_ch_fr[MAIN_LEN][2] =
{
{'\xa7','\xb0'},{'1','+'},{'2','"'},{'3','*'},{'4','\xe7'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'R','P'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe8','\xfc'},{'W','!'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe9','\xf6'},{'\xe0','\xe4'},{'$','\xa3'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Switzerland, French, eliminate dead keys */
static const char main_key_ch_fr_nodeadkeys[MAIN_LEN][2] =
{
{'\xa7','\xb0'},{'1','+'},{'2','"'},{'3','*'},{'4','\xe7'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'^','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe8','\xfc'},{'\xa8','!'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe9','\xf6'},{'\xe0','\xe4'},{'$','\xa3'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Switzerland, French, Sun dead keys */
static const char main_key_ch_fr_sundeadkeys[MAIN_LEN][2] =
{
{'\xa7','\xb0'},{'1','+'},{'2','"'},{'3','*'},{'4','\xe7'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'\'','?'},{'\x01','\x00'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'z','Z'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xe8','\xfc'},{'\x04','!'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe9','\xf6'},{'\xe0','\xe4'},{'$','\xa3'},
{'y','Y'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'-','_'},{'<','>'},{0,0},{0,0}
};

/* Syria, Syriac */
static const char main_key_sy_syc[MAIN_LEN][2] =
{
{'\x0f','.'},{'1','!'},{'2','\x0a'},{'3','%'},{'4','I'},{'5','p'},{'6','q'},{'7','\x0a'},{'8','\xbb'},{'9',')'},{'0','('},{'-','\xab'},{'=','+'},
{'\x14','0'},{'(','3'},{'\x16','6'},{')',':'},{'&','='},{'\x1c','@'},{'%','A'},{'\x17','\x08'},{'\x1e','\x04'},{'\x1a','\x07'},{'\x13','\x03'},{'\x15','J'},
{'+','1'},{'#','4'},{'\x1d','7'},{'\x12',';'},{'\x20','>'},{'\x10','\x11'},{',','\xe0'},{'"','$'},{'!','1'},{'\x1f','#'},{'\x1b','0'},{'\x06',':'},
{']','2'},{'[','5'},{'$','8'},{'*','<'},{'\'','?'},{'\x0','9'},{'.','B'},{'\x18','\xac'},{'\x19','\xbb'},{'\x07','\xbf'},{'<','>'},{0,0},{0,0}
};

/* Syria, Syriac phonetic */
static const char main_key_sy_syc_phonetic[MAIN_LEN][2] =
{
{'\x0f','.'},{'1','!'},{'2','\x0a'},{'3','%'},{'4','I'},{'5','p'},{'6','q'},{'7','\x0a'},{'8','\xbb'},{'9',')'},{'0','('},{'-','\xab'},{'=','+'},
{')','0'},{'\x18','3'},{'\x16','6'},{'*',':'},{',','='},{'\x1d','@'},{'\x1c','A'},{'%','\x08'},{'\'','\x4'},{'&','\x07'},{']','\x03'},{'[','J'},
{'\x10','1'},{'#','4'},{'\x15','7'},{'\x14',';'},{'\x13','>'},{'\x17','\x11'},{'\x1b','\xe0'},{'\x1f','$'},{'\x20','1'},{'\x1a','#'},{'\x1e','0'},{'\x06',':'},
{'\x19','2'},{'(','5'},{'$','8'},{'+','<'},{'\x12','?'},{'"','9'},{'!','B'},{'\x00','\xac'},{'.','\xbb'},{'\x07','\xbf'},{'<','>'},{0,0},{0,0}
};

/* Tajikistan */
static const char main_key_tj[MAIN_LEN][2] =
{
{'\xa3','\xb3'},{'1','!'},{'2','"'},{'3','\''},{'4','*'},{'5',':'},{'6',','},{'7','.'},{'8',';'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'[','T'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xdf','\xff'},
{'\xc6','\xe6'},{'\xd9','\xf9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xdc','\xfc'},{'\\','|'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'/','?'},{'|','\xa6'},{0,0},{0,0}
};

/* Sri Lanka */
static const char main_key_lk[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\x8d','\x8e'},{'\x87','\x88'},{'\x91','\x92'},{'\xbb','\xca'},{'\xa7','\xa8'},{'\xba','\xca'},{'\x8b','\x8c'},{'\x89','\x8a'},{'\x94','\x95'},{'\xb4','\xb5'},{'[','{'},{']','}'},
{'\x85','\x86'},{'\xc3','\xc2'},{'\xa9','\xaa'},{'\xc6','F'},{'\x9c','\x9d'},{'\xc4','\x83'},{'\xa2','\xa3'},{'\x9a','\x9b'},{'\xbd','\xc5'},{';',':'},{'\'','"'},{'\\','|'},
{'\xa4','\xa5'},{'\xac','\xb3'},{'\xa0','\xa1'},{'\xc0','V'},{'\xb6','\xb7'},{'\xb1','\xab'},{'\xb8','\xb9'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Thailand */
static const char main_key_th[MAIN_LEN][2] =
{
{'_','%'},{'\xe5','+'},{'/','\xf1'},{'-','\xf2'},{'\xc0','\xf3'},{'\xb6','\xf4'},{'\xd8','\xd9'},{'\xd6','\xdf'},{'\xa4','\xf5'},{'\xb5','\xf6'},{'\xa8','\xf7'},{'\xa2','\xf8'},{'\xaa','\xf9'},
{'\xe6','\xf0'},{'\xe4','"'},{'\xd3','\xae'},{'\xbe','\xb1'},{'\xd0','\xb8'},{'\xd1','\xed'},{'\xd5','\xea'},{'\xc3','\xb3'},{'\xb9','\xcf'},{'\xc2','\xad'},{'\xba','\xb0'},{'\xc5',','},
{'\xbf','\xc4'},{'\xcb','\xa6'},{'\xa1','\xaf'},{'\xb4','\xe2'},{'\xe0','\xac'},{'\xe9','\xe7'},{'\xe8','\xeb'},{'\xd2','\xc9'},{'\xca','\xc8'},{'\xc7','\xab'},{'\xa7','.'},{'\xa3','\xa5'},
{'\xbc','('},{'\xbb',')'},{'\xe1','\xa9'},{'\xcd','\xce'},{'\xd4','\xda'},{'\xd7','\xec'},{'\xb7','?'},{'\xc1','\xb2'},{'\xe3','\xcc'},{'\xbd','\xc6'},{'<','>'},{0,0},{0,0}
};

/* Thailand, TIS-820.2538 */
static const char main_key_th_tis[MAIN_LEN][2] =
{
{'O','['},{'\xdf','\xe5'},{'/','\xf1'},{'-','\xf2'},{'\xc0','\xf3'},{'\xb6','\xf4'},{'\xd8','\xd9'},{'\xd6','N'},{'\xa4','\xf5'},{'\xb5','\xf6'},{'\xa8','\xf7'},{'\xa2','\xf8'},{'\xaa','\xf9'},
{'\xe6','\xf0'},{'\xe4','"'},{'\xd3','\xae'},{'\xbe','\xb1'},{'\xd0','\xb8'},{'\xd1','\xed'},{'\xd5','\xea'},{'\xc3','\xb3'},{'\xb9','\xcf'},{'\xc2','\xad'},{'\xba','\xb0'},{'\xc5',','},
{'\xbf','\xc4'},{'\xcb','\xa6'},{'\xa1','\xaf'},{'\xb4','\xe2'},{'\xe0','\xac'},{'\xe9','\xe7'},{'\xe8','\xeb'},{'\xd2','\xc9'},{'\xca','\xc8'},{'\xc7','\xab'},{'\xa7','.'},{'\xa5','\xa3'},
{'\xbc','('},{'\xbb',')'},{'\xe1','\xa9'},{'\xcd','\xce'},{'\xd4','\xda'},{'\xd7','\xec'},{'\xb7','?'},{'\xc1','\xb2'},{'\xe3','\xcc'},{'\xbd','\xc6'},{'<','>'},{0,0},{0,0}
};

/* Thailand, Pattachote */
static const char main_key_th_pat[MAIN_LEN][2] =
{
{'_','\xdf'},{'=','+'},{'\xf2','"'},{'\xf3','/'},{'\xf4',','},{'\xf5','?'},{'\xd9','\xd8'},{'\xf7','_'},{'\xf8','.'},{'\xf9','('},{'\xf0',')'},{'\xf1','-'},{'\xf6','%'},
{'\xe7','\xea'},{'\xb5','\xc4'},{'\xc2','\xe6'},{'\xcd','\xad'},{'\xc3','\xc9'},{'\xe8','\xd6'},{'\xb4','\xbd'},{'\xc1','\xab'},{'\xc7','\xb6'},{'\xe1','\xb2'},{'\xe3','\xcf'},{'\xac','\xc6'},
{'\xe9','\xeb'},{'\xb7','\xb8'},{'\xa7','\xd3'},{'\xa1','\xb3'},{'\xd1','\xec'},{'\xd5','\xd7'},{'\xd2','\xbc'},{'\xb9','\xaa'},{'\xe0','\xe2'},{'\xe4','\xa6'},{'\xa2','\xb1'},{'\xe5','\xed'},
{'\xba','\xae'},{'\xbb','\xaf'},{'\xc5','\xb0'},{'\xcb','\xc0'},{'\xd4','\xda'},{'\xa4','\xc8'},{'\xca','\xce'},{'\xd0','\xbf'},{'\xa8','\xa9'},{'\xbe','\xcc'},{'<','>'},{0,0},{0,0}
};

/* Turkey */
static const char main_key_tr[MAIN_LEN][2] =
{
{'"','\\'},{'1','!'},{'2','\''},{'3','^'},{'4','+'},{'5','%'},{'6','&'},{'7','/'},{'8','('},{'9',')'},{'0','='},{'*','?'},{'-','_'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'\xb9','I'},{'o','O'},{'p','P'},{'\xbb','\xab'},{'\xfc','\xdc'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xba','\xaa'},{'i','\xa9'},{',',';'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{'\xf6','\xd6'},{'\xe7','\xc7'},{'.',':'},{'<','>'},{0,0},{0,0}
};

/* Turkey, (F) */
static const char main_key_tr_f[MAIN_LEN][2] =
{
{'+','*'},{'1','!'},{'2','"'},{'3','^'},{'4','$'},{'5','%'},{'6','&'},{'7','\''},{'8','('},{'9',')'},{'0','='},{'/','?'},{'-','_'},
{'f','F'},{'g','G'},{'\xbb','\xab'},{'\xb9','I'},{'o','O'},{'d','D'},{'r','R'},{'n','N'},{'h','H'},{'p','P'},{'q','Q'},{'w','W'},
{'u','U'},{'i','\xa9'},{'e','E'},{'a','A'},{'\xfc','\xdc'},{'t','T'},{'k','K'},{'m','M'},{'l','L'},{'y','Y'},{'\xba','\xaa'},{'x','X'},
{'j','J'},{'\xf6','\xd6'},{'v','V'},{'c','C'},{'\xe7','\xc7'},{'z','Z'},{'s','S'},{'b','B'},{'.',':'},{',',';'},{'<','>'},{0,0},{0,0}
};

/* Ukraine */
static const char main_key_ua[MAIN_LEN][2] =
{
{'\'','~'},{'1','!'},{'2','"'},{'3','#'},{'4','*'},{'5',':'},{'6',','},{'7','.'},{'8',';'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xdd','\xfd'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xa7','\xb7'},
{'\xc6','\xe6'},{'\xa6','\xb6'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xa4','\xb4'},{'\xad','\xbd'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'/','?'},{'/','|'},{0,0},{0,0}
};

/* Ukraine, Phonetic */
static const char main_key_ua_phonetic[MAIN_LEN][2] =
{
{'\'','~'},{'1','!'},{'2','"'},{'3','#'},{'4','*'},{'5',':'},{'6',','},{'7','.'},{'8',';'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xd1','\xf1'},{'\xd7','\xf7'},{'\xc5','\xe5'},{'\xd2','\xf2'},{'\xd4','\xf4'},{'\xc9','\xc9'},{'\xd5','\xf5'},{'\xa6','\xb6'},{'\xcf','\xef'},{'\xd0','\xf0'},{'\xdb','\xfb'},{'\xdd','\xfd'},
{'\xc1','\xe1'},{'\xd3','\xf3'},{'\xc4','\xe4'},{'\xc6','\xe6'},{'\xc7','\xe7'},{'\xc8','\xe8'},{'\xca','\xea'},{'\xcb','\xeb'},{'\xcc','\xec'},{'\xad','\xbd'},{'\xde','\xfe'},{'\xc0','\xe0'},
{'\xda','\xfa'},{'\xd8','\xf8'},{'\xc3','\xe3'},{'\xd6','\xf6'},{'\xc2','\xe2'},{'\xce','\xee'},{'\xcd','\xed'},{'\xa7','\xb7'},{'\xa4','\xb4'},{'/','?'},{'/','|'},{0,0},{0,0}
};

/* Ukraine, Typewriter */
static const char main_key_ua_typewriter[MAIN_LEN][2] =
{
{'\'','"'},{'!','1'},{'\xb0','2'},{'/','3'},{';','4'},{':','5'},{',','6'},{'.','7'},{'_','8'},{'?','9'},{'%','0'},{'-','_'},{'=','+'},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xdd','\xfd'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xad','\xbd'},
{'\xc6','\xe6'},{'\xc9','\xe9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xa4','\xb4'},{'(',')'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xa6','\xb6'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'\xa7','\xb7'},{'/','|'},{0,0},{0,0}
};

/* Ukraine, Winkeys */
static const char main_key_ua_winkeys[MAIN_LEN][2] =
{
{'\'','~'},{'1','!'},{'2','"'},{'3','\xb0'},{'4',';'},{'5','%'},{'6',':'},{'7','?'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xdd','\xfd'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xa7','\xb7'},
{'\xc6','\xe6'},{'\xa6','\xb6'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xa4','\xb4'},{'\xad','\xbd'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'.',','},{'/','|'},{0,0},{0,0}
};

/* Ukraine, Standard RSTU */
static const char main_key_ua_rstu[MAIN_LEN][2] =
{
{'\'','?'},{'!','1'},{'"','2'},{'#','3'},{';','4'},{':','5'},{',','6'},{'.','7'},{'*','8'},{'(','9'},{')','0'},{'-','_'},{'=','+'},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xdd','\xfd'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xad','\xbd'},
{'\xc6','\xe6'},{'\xc9','\xe9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xa4','\xb4'},{'/','%'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xa6','\xb6'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'\xa7','\xb7'},{'/','|'},{0,0},{0,0}
};

/* Ukraine, Standard RSTU on Russian layout */
static const char main_key_ua_rstu_ru[MAIN_LEN][2] =
{
{'\'','?'},{'!','1'},{'"','2'},{'#','3'},{';','4'},{':','5'},{',','6'},{'.','7'},{'*','8'},{'(','9'},{')','0'},{'-','_'},{'=','+'},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xdd','\xfd'},{'\xda','\xfa'},{'\xc8','\xe8'},{'\xdf','\xff'},
{'\xc6','\xe6'},{'\xd9','\xf9'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xdc','\xfc'},{'/','%'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'\xa3','\xb3'},{'/','|'},{0,0},{0,0}
};

/* United Kingdom */
static const char main_key_gb[MAIN_LEN][2] =
{
{'`','\xac'},{'1','!'},{'2','"'},{'3','\xa3'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','@'},{'#','~'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'\\','|'},{0,0},{0,0}
};

/* United Kingdom, International (with dead keys) */
static const char main_key_gb_intl[MAIN_LEN][2] =
{
{'P','\xac'},{'1','!'},{'2','W'},{'3','\xa3'},{'4','$'},{'5','%'},{'6','R'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'Q','@'},{'#','S'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'\\','|'},{0,0},{0,0}
};

/* United Kingdom, Dvorak */
static const char main_key_gb_dvorak[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','"'},{'3','\xa3'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'[','{'},{']','}'},
{'\'','@'},{',','<'},{'.','>'},{'p','P'},{'y','Y'},{'f','F'},{'g','G'},{'c','C'},{'r','R'},{'l','L'},{'/','?'},{'=','+'},
{'a','A'},{'o','O'},{'e','E'},{'u','U'},{'i','I'},{'d','D'},{'h','H'},{'t','T'},{'n','N'},{'s','S'},{'-','_'},{'#','~'},
{';',':'},{'q','Q'},{'j','J'},{'k','K'},{'x','X'},{'b','B'},{'m','M'},{'w','W'},{'v','V'},{'z','Z'},{'\\','|'},{0,0},{0,0}
};

/* United Kingdom, Macintosh */
static const char main_key_gb_mac[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','\xa3'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Uzbekistan */
static const char main_key_uz[MAIN_LEN][2] =
{
{'\xa3','\xb3'},{'1','!'},{'2','"'},{'3','#'},{'4',';'},{'5','%'},{'6',':'},{'7','?'},{'8','*'},{'9','('},{'0',')'},{'\xae','\xbe'},{'\x9b','\x9a'},
{'\xca','\xea'},{'\xc3','\xe3'},{'\xd5','\xf5'},{'\xcb','\xeb'},{'\xc5','\xe5'},{'\xce','\xee'},{'\xc7','\xe7'},{'\xdb','\xfb'},{'\xc8','\xe8'},{'\xdf','\xff'},{'\x93','\x92'},{'\xb3','\xb2'},
{'\xc6','\xe6'},{'\xda','\xfa'},{'\xd7','\xf7'},{'\xc1','\xe1'},{'\xd0','\xf0'},{'\xd2','\xf2'},{'\xcf','\xef'},{'\xcc','\xec'},{'\xc4','\xe4'},{'\xd6','\xf6'},{'\xdc','\xfc'},{'\\','|'},
{'\xd1','\xf1'},{'\xde','\xfe'},{'\xd3','\xf3'},{'\xcd','\xed'},{'\xc9','\xe9'},{'\xd4','\xf4'},{'\xd8','\xf8'},{'\xc2','\xe2'},{'\xc0','\xe0'},{'.',','},{'/','|'},{0,0},{0,0}
};

/* Vietnam */
static const char main_key_vn[MAIN_LEN][2] =
{
{'`','~'},{'\xe3','\xc3'},{'\xe2','\xc2'},{'\xea','\xca'},{'\xf4','\xd4'},{'P','%'},{'a','^'},{'S','&'},{'Q','*'},{'`','('},{'\xf0','\xd0'},{'-','_'},{'\xab','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xb0','\xaf'},{'\xa1','\xa0'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Japan (PC-98xx Series) */
static const char main_key_nec_vndr_jp[MAIN_LEN][2] =
{
{0,0},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','&'},{'7','\''},{'8','('},{'9',')'},{'0','0'},{'-','='},{'^','`'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'@','~'},{'[','{'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';','+'},{':','*'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{'\x00','_'},{0,0}
};

/* Ireland, Ogham */
static const char main_key_ie_ogam[MAIN_LEN][2] =
{
{'\x9c','\x9c'},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},
{'\x8a','\x8a'},{'\x95','\x95'},{'\x93','\x93'},{'\x8f','\x8f'},{'\x88','\x88'},{'\x98','\x98'},{'\x92','\x92'},{'\x94','\x94'},{'\x91','\x91'},{'\x9a','\x9a'},{0,0},{0,0},
{'\x90','\x90'},{'\x84','\x84'},{'\x87','\x87'},{'\x83','\x83'},{'\x8c','\x8c'},{'\x86','\x86'},{'\x97','\x97'},{'\x96','\x96'},{'\x82','\x82'},{0,0},{0,0},{'\x80','\x80'},
{'\x8e','\x8e'},{'\x99','\x99'},{'\x89','\x89'},{'\x8d','\x8d'},{'\x81','\x81'},{'\x85','\x85'},{'\x8b','\x8b'},{'\x9c','\x9c'},{'\x9b','\x9b'},{'\x80','\x80'},{'\x9b','\x9c'},{0,0},{0,0}
};

/* Ireland, Ogham IS434 */
static const char main_key_ie_ogam_is434[MAIN_LEN][2] =
{
{'`','\xac'},{'1','!'},{'2','"'},{'3','\xa3'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{0,0},{0,0},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{0,0},{0,0},{'#','~'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'\\','|'},{0,0},{0,0}
};

/* Maldives */
static const char main_key_mv[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','$'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xb0','\xa4'},{'\x87','\xa2'},{'\xac','\xad'},{'\x83','\x9c'},{'\x8c','\x93'},{'\x94','\xa0'},{'\xaa','\xab'},{'\xa8','\xa9'},{'\xae','\xaf'},{'\x95','\xf7'},{'[','{'},{']','}'},
{'\xa6','\xa7'},{'\x90','\x81'},{'\x8b','\x91'},{'\x8a','\xf2'},{'\x8e','\xa3'},{'\x80','\x99'},{'\x96','\x9b'},{'\x86','\x9a'},{'\x8d','\x85'},{';',':'},{'\'','"'},{'\\','|'},
{'\x92','\xa1'},{'\xd7','\x98'},{'\x97','\x9d'},{'\x88','\xa5'},{'\x84','\x9e'},{'\x82','\x8f'},{'\x89','\x9f'},{'\xac','<'},{'.','>'},{'/','\xbf'},{'|','\xa6'},{0,0},{0,0}
};

/* Esperanto */
static const char main_key_epo[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','"'},{'3','#'},{'4','$'},{'5','%'},{'6','\''},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xfe','\xde'},{'\xbc','\xac'},{'e','E'},{'r','R'},{'t','T'},{'\xf8','\xd8'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xfd','\xdd'},{'\xb6','\xa6'},{'\\','|'},
{'z','Z'},{'\xe6','\xc6'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',',';'},{'.',':'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Nepal */
static const char main_key_np[MAIN_LEN][2] =
{
{'=','<'},{'g','g'},{'h','h'},{'i','i'},{'j','j'},{'k','k'},{'l','l'},{'m','m'},{'n','n'},{'o','o'},{'f','p'},{'-','R'},{'=','\x0c'},
{'\x1f','\x20'},{'L','\x14'},{'G','H'},{'0','C'},{'$','%'},{'/','\x1e'},{'A','B'},{'?','@'},{'K','\x13'},{'*','+'},{'\x07','\x08'},{'\x0f','\x10'},
{'>','\x06'},{'8','6'},{'&','\''},{'\x09','\x0a'},{'\x17','\x18'},{'9','\x05'},{'\x1c','\x1d'},{'\x15','\x16'},{'2','3'},{';',':'},{'\'','"'},{'P','\x03'},
{'7','\x0b'},{'!','"'},{'\x1b','\x1a'},{'5','\x01'},{',','-'},{'(','#'},{'.','\x02'},{',','\x19'},{'d','e'},{'M','?'},{'<','>'},{0,0},{0,0}
};

/* Nigeria */
static const char main_key_ng[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','\xa6'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Nigeria, Igbo */
static const char main_key_ng_igbo[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','\xa6'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xcb','\xca'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xcd','\xcc'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'\xe5','\xe4'},{'\'','"'},{'\\','|'},
{'z','Z'},{'E','D'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Nigeria, Yoruba */
static const char main_key_ng_yoruba[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','\xa6'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'\xb9','\xb8'},{'w','W'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'[','{'},{']','}'},
{'a','A'},{'s','S'},{'d','D'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{';',':'},{'\'','"'},{'\\','|'},
{'z','Z'},{'\xcd','\xcc'},{'c','C'},{'c','b'},{'b','B'},{'n','N'},{'m','M'},{',','<'},{'.','>'},{'/','?'},{'<','>'},{0,0},{0,0}
};

/* Nigeria, Hausa */
static const char main_key_ng_hausa[MAIN_LEN][2] =
{
{'`','~'},{'1','!'},{'2','@'},{'3','#'},{'4','\xa6'},{'5','%'},{'6','^'},{'7','&'},{'8','*'},{'9','('},{'0',')'},{'-','_'},{'=','+'},
{'q','Q'},{'\xfc','\xdc'},{'e','E'},{'r','R'},{'t','T'},{'y','Y'},{'u','U'},{'i','I'},{'o','O'},{'p','P'},{'\xb4','\xb3'},{'\xe7','\xe6'},
{'a','A'},{'s','S'},{'W','\x8a'},{'f','F'},{'g','G'},{'h','H'},{'j','J'},{'k','K'},{'l','L'},{'1','0'},{'\xdd','\x8e'},{'\\','|'},
{'r','\x9d'},{'x','X'},{'c','C'},{'v','V'},{'b','B'},{'n','N'},{'\xf1','\xd1'},{',','<'},{'\xe7','\xc7'},{'\xba','\xaa'},{'<','>'},{0,0},{0,0}
};


#ifdef __clang__
# pragma clang diagnostic pop
#endif
