/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.palette;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.manager.palette.EntityPaletteActions;
import com.paterva.maltego.entity.manager.palette.EntityPaletteFilter;
import com.paterva.maltego.entity.manager.palette.FavouriteEntities;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.FeatureDescriptor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.SwingUtilities;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.netbeans.spi.palette.PaletteFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;

public class PaletteSupport {
    public static PaletteController _controller;

    public static synchronized PaletteController getPalette() {
        if (_controller == null) {
            try {
                DataObject dobj = DataObject.find((FileObject)PaletteSupport.getEntitiesRoot());
                NodeProxy rootNode = new NodeProxy(dobj.getNodeDelegate());
                _controller = PaletteFactory.createPalette((Node)rootNode, (PaletteActions)new EntityPaletteActions(), (PaletteFilter)new EntityPaletteFilter(), (DragAndDropHandler)new MyDragDropHandler());
                Lookup myLookup = _controller.getRoot();
                Node nd = (Node)myLookup.lookup(Node.class);
                nd.setDisplayName("Entities");
                Index cookie = (Index)nd.getCookie(Index.class);
                if (cookie != null) {
                    Children children = nd.getChildren();
                    if (children != null) {
                        for (int i = 0; i < children.getNodesCount(); ++i) {
                            Node node = children.getNodeAt(i);
                            if (!"RecentlyUsed".equals(node.getDisplayName())) continue;
                            FavouriteEntities.getInstance().setFavouritesNode(node);
                            cookie.move(i, 0);
                            break;
                        }
                    }
                    PaletteSupport.sortByCategory(cookie);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return _controller;
    }

    private static void sortByCategory(Index cookie) {
        Node[] nodes = cookie.getNodes();
        Arrays.sort(nodes, Comparator.comparing(FeatureDescriptor::getDisplayName));
        int[] perm = new int[nodes.length];
        for (int i = 0; i < perm.length; ++i) {
            perm[cookie.indexOf((Node)nodes[i])] = i;
        }
        cookie.reorder(perm);
    }

    private static FileObject getEntitiesRoot() throws IOException {
        FileObject entities;
        FileObject maltego = FileUtil.getConfigRoot().getFileObject("Maltego");
        if (maltego == null) {
            maltego = FileUtil.getConfigRoot().createFolder("Maltego");
        }
        if ((entities = maltego.getFileObject("Entities")) == null) {
            entities = maltego.createFolder("Entities");
        }
        FavouriteEntities.getInstance().recreate();
        return entities;
    }

    static class ProxyChildren
    extends FilterNode.Children {
        public ProxyChildren(Node owner) {
            super(owner);
        }

        protected Node copyNode(Node original) {
            return new NodeProxy(original);
        }
    }

    static class NodeProxy
    extends FilterNode {
        public NodeProxy(Node original) {
            super(original, (Children)new ProxyChildren(original));
        }

        public PasteType[] getPasteTypes(Transferable t) {
            return super.getPasteTypes(t);
        }

        public boolean canDestroy() {
            if (FavouriteEntities.isFavCategory(this.getDisplayName())) {
                return false;
            }
            return super.canDestroy();
        }

        public boolean canRename() {
            if (FavouriteEntities.isFavCategory(this.getDisplayName())) {
                return false;
            }
            return super.canRename();
        }
    }

    private static class MyDragDropHandler
    extends DragAndDropHandler {
        private MyDragDropHandler() {
        }

        public void customize(ExTransferable t, Lookup item) {
            DataFlavor[] flavours = t.getTransferDataFlavors();
            Node node = (Node)item.lookup(Node.class);
        }

        public boolean canDrop(Lookup targetCategory, DataFlavor[] flavors, int dndAction) {
            Node itemNode;
            Lookup selectedItem;
            PaletteController palette = PaletteSupport.getPalette();
            if (palette != null && (selectedItem = palette.getSelectedItem()) != null && FavouriteEntities.isFavChild(itemNode = (Node)selectedItem.lookup(Node.class))) {
                return false;
            }
            Node node = (Node)targetCategory.lookup(Node.class);
            return node == null ? true : !FavouriteEntities.isFavCategory(node);
        }

        public boolean doDrop(Lookup targetCategory, Transferable item, int dndAction, int dropIndex) {
            Node node = NodeTransfer.node((Transferable)item, (int)3);
            if (node != null) {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)"Hello...", 1);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)d);
            }
            boolean result = super.doDrop(targetCategory, item, dndAction, dropIndex);
            SwingUtilities.invokeLater(() -> EntityRegistry.getDefault().reloadEntities());
            return result;
        }
    }
}

