/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.registry.serializer;

import com.paterva.maltego.entity.api.EntityConverter;
import com.paterva.maltego.entity.registry.converter.AllEntityConverter;
import com.paterva.maltego.entity.registry.converter.PhoneNumberEntityConverter;
import com.paterva.maltego.entity.registry.converter.RegexEntityConverter;
import com.paterva.maltego.entity.registry.serializer.ConverterStub;
import com.paterva.maltego.entity.registry.serializer.RegexGroup;
import com.paterva.maltego.typing.serializer.PropertiesStub;
import com.paterva.maltego.util.StringUtilities;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;

class EntityConverterTranslator {
    private static final Logger LOG = Logger.getLogger(EntityConverterTranslator.class.getName());

    EntityConverterTranslator() {
    }

    public static EntityConverter translate(ConverterStub stub, PropertiesStub propertiesStub) {
        if (stub != null) {
            if (!StringUtilities.isNullOrEmpty((String)stub.type)) {
                if ("maltego.phonenumber".equals(stub.type)) {
                    return new PhoneNumberEntityConverter();
                }
                LOG.log(Level.WARNING, "Unknown Entity Converter type: {0}", stub.type);
            } else if (stub.Regex != null && propertiesStub != null) {
                return EntityConverterTranslator.createRegexConverter(stub, propertiesStub);
            }
        }
        return AllEntityConverter.instance();
    }

    private static EntityConverter createRegexConverter(ConverterStub stub, PropertiesStub propertiesStub) {
        RegexEntityConverter converter = new RegexEntityConverter();
        try {
            converter.init(stub.Regex);
        }
        catch (PatternSyntaxException ex) {
            LOG.log(Level.WARNING, "Invalid regex: {0}", ex.getMessage());
        }
        converter.setMainProperty(propertiesStub.getValueProperty());
        if (stub.Groups != null) {
            ArrayList<String> groupsToProperties = new ArrayList<String>();
            for (RegexGroup regexGroup : stub.Groups) {
                groupsToProperties.add(regexGroup.Property);
            }
            converter.setProperties(groupsToProperties);
        }
        return converter;
    }
}

