/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.wrapper;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.HashMapGuidDataAdapter;
import com.paterva.maltego.graph.wrapper.EdgeCursorIterator;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import java.util.HashSet;
import java.util.Set;
import yguard.A.A.A;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.I;
import yguard.A.A.J;
import yguard.A.A.K;
import yguard.A.A.Y;

public abstract class GraphStructureWrapper {
    private static final String NODE_MAP_PROVIDER_KEY = "maltego.NodeMap";
    private static final String EDGE_MAP_PROVIDER_KEY = "maltego.EdgeMap";
    private static final String ENTITY_MAP_PROVIDER_KEY = "maltego.EntityMap";
    private static final String LINK_MAP_PROVIDER_KEY = "maltego.LinkMap";
    private final D _graph;
    private final I _nodes;
    private final J _edges;
    private final HashMapGuidDataAdapter<EntityID, Y> _entities;
    private final HashMapGuidDataAdapter<LinkID, H> _links;

    protected GraphStructureWrapper(D graph) {
        this._graph = graph;
        this._nodes = GraphStructureWrapper.getNodeMap(graph);
        this._edges = GraphStructureWrapper.getEdgeMap(graph);
        this._entities = GraphStructureWrapper.getEntityMap(graph);
        this._links = GraphStructureWrapper.getLinkMap(graph);
    }

    private static HashMapGuidDataAdapter<EntityID, Y> getEntityMap(D graph) {
        HashMapGuidDataAdapter entities = (HashMapGuidDataAdapter)graph.B((Object)ENTITY_MAP_PROVIDER_KEY);
        if (entities == null) {
            entities = new HashMapGuidDataAdapter();
            graph.A((Object)ENTITY_MAP_PROVIDER_KEY, (K)entities);
        }
        return entities;
    }

    private static HashMapGuidDataAdapter<LinkID, H> getLinkMap(D graph) {
        HashMapGuidDataAdapter links = (HashMapGuidDataAdapter)graph.B((Object)LINK_MAP_PROVIDER_KEY);
        if (links == null) {
            links = new HashMapGuidDataAdapter();
            graph.A((Object)LINK_MAP_PROVIDER_KEY, (K)links);
        }
        return links;
    }

    private static I getNodeMap(D graph) {
        I nodes = (I)graph.B((Object)NODE_MAP_PROVIDER_KEY);
        if (nodes == null) {
            nodes = graph.\u00ba();
            graph.A((Object)NODE_MAP_PROVIDER_KEY, (K)nodes);
        }
        return nodes;
    }

    private static J getEdgeMap(D graph) {
        J edges = (J)graph.B((Object)EDGE_MAP_PROVIDER_KEY);
        if (edges == null) {
            edges = graph.\u00cf();
            graph.A((Object)EDGE_MAP_PROVIDER_KEY, (K)edges);
        }
        return edges;
    }

    protected D graph() {
        return this._graph;
    }

    protected I nodeMap() {
        return this._nodes;
    }

    protected J edgeMap() {
        return this._edges;
    }

    protected HashMapGuidDataAdapter<EntityID, Y> entityMap() {
        return this._entities;
    }

    protected HashMapGuidDataAdapter<LinkID, H> linkMap() {
        return this._links;
    }

    public EntityID entityID(Y node) {
        return (EntityID)this.nodeMap().get((Object)node);
    }

    public MaltegoEntity entity(Y node) {
        EntityID entityID = this.entityID(node);
        return this.getEntity(entityID);
    }

    public LinkID linkID(H edge) {
        return (LinkID)this.edgeMap().get((Object)edge);
    }

    public MaltegoLink link(H edge) {
        return this.getLink(this.linkID(edge));
    }

    public Y node(EntityID entityID) {
        return (Y)this.entityMap().get((Guid)entityID);
    }

    public H edge(LinkID linkID) {
        return (H)this.linkMap().get((Guid)linkID);
    }

    public D getGraph() {
        return this._graph;
    }

    public boolean containsEntity(EntityID entityID) {
        return this._entities.get((Guid)entityID) != null;
    }

    public boolean containsLink(LinkID linkID) {
        return this._links.get((Guid)linkID) != null;
    }

    public Iterable<LinkID> incomingIDs(EntityID entityID) {
        return new EdgeCursorIterator(this, this.node(entityID).M());
    }

    public Iterable<LinkID> outgoingIDs(EntityID entityID) {
        return new EdgeCursorIterator(this, this.node(entityID).G());
    }

    public Iterable<LinkID> linkIDs(EntityID entityID) {
        return new EdgeCursorIterator(this, this.node(entityID).I());
    }

    public Set<LinkID> linkIDs(A edges) {
        EdgeCursorIterator itr = new EdgeCursorIterator(this, edges.\u011e());
        HashSet<LinkID> linkIDs = new HashSet<LinkID>(edges.size());
        while (itr.hasNext()) {
            linkIDs.add(itr.next());
        }
        return linkIDs;
    }

    public EntityID sourceID(LinkID link) {
        Y node;
        H edge = this.edge(link);
        if (edge != null && (node = edge.X()) != null) {
            return this.entityID(node);
        }
        return null;
    }

    public EntityID targetID(LinkID linkID) {
        Y node;
        H edge = this.edge(linkID);
        if (edge != null && (node = edge.V()) != null) {
            return this.entityID(node);
        }
        return null;
    }

    public MaltegoEntity getEntity(EntityID id) {
        return GraphStoreHelper.getEntity(this._graph, id);
    }

    public MaltegoLink getLink(LinkID id) {
        return GraphStoreHelper.getLink(this._graph, id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Graph ");
        sb.append(System.identityHashCode(this)).append("\n Entities->yNodes\n");
        for (EntityID entityID : this._entities.keys()) {
            sb.append("  ").append(entityID);
            sb.append("->").append(this.node(entityID)).append("\n");
        }
        return sb.toString();
    }
}

