/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotContextDispatch;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineDispatch;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotExceptionDispatch;
import com.oracle.truffle.polyglot.PolyglotExceptionImpl;
import com.oracle.truffle.polyglot.PolyglotFastThreadLocals;
import com.oracle.truffle.polyglot.PolyglotHostAccess;
import com.oracle.truffle.polyglot.PolyglotInstrumentDispatch;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageDispatch;
import com.oracle.truffle.polyglot.PolyglotLimits;
import com.oracle.truffle.polyglot.PolyglotLoggers;
import com.oracle.truffle.polyglot.PolyglotManagementDispatch;
import com.oracle.truffle.polyglot.PolyglotSourceDispatch;
import com.oracle.truffle.polyglot.PolyglotSourceSectionDispatch;
import com.oracle.truffle.polyglot.PolyglotValueDispatch;
import com.oracle.truffle.polyglot.PolyglotWrapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Handler;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.ResourceLimitEvent;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.proxy.Proxy;

public final class PolyglotImpl
extends AbstractPolyglotImpl {
    static final Object[] EMPTY_ARGS = new Object[0];
    static final String OPTION_GROUP_ENGINE = "engine";
    static final String PROP_ALLOW_EXPERIMENTAL_OPTIONS = "polyglot.engine.AllowExperimentalOptions";
    private final PolyglotSourceDispatch sourceDispatch = new PolyglotSourceDispatch(this);
    private final PolyglotSourceSectionDispatch sourceSectionDispatch = new PolyglotSourceSectionDispatch(this);
    private final PolyglotManagementDispatch executionListenerDispatch = new PolyglotManagementDispatch(this);
    final PolyglotEngineDispatch engineDispatch = new PolyglotEngineDispatch(this);
    final PolyglotContextDispatch contextDispatch = new PolyglotContextDispatch(this);
    private final PolyglotExceptionDispatch exceptionDispatch = new PolyglotExceptionDispatch(this);
    final PolyglotInstrumentDispatch instrumentDispatch = new PolyglotInstrumentDispatch(this);
    final PolyglotLanguageDispatch languageDispatch = new PolyglotLanguageDispatch(this);
    private final AtomicReference<PolyglotEngineImpl> preInitializedEngineRef = new AtomicReference();
    private final Map<Class<?>, PolyglotValueDispatch> primitiveValues = new HashMap();
    Value hostNull;
    private PolyglotValueDispatch disconnectedHostValue;
    private static volatile PolyglotImpl polyglotImpl;

    public PolyglotImpl() {
        assert (polyglotImpl == null);
        polyglotImpl = this;
    }

    public int getPriority() {
        return 0;
    }

    static PolyglotImpl getInstance() {
        if (polyglotImpl == null) {
            try {
                Method f = Engine.class.getDeclaredMethod("getImpl", new Class[0]);
                f.setAccessible(true);
                f.invoke(null, new Object[0]);
                assert (polyglotImpl != null);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        return polyglotImpl;
    }

    PolyglotEngineImpl getPreinitializedEngine() {
        return this.preInitializedEngineRef.get();
    }

    protected void initialize() {
        this.hostNull = this.getAPIAccess().newValue((AbstractPolyglotImpl.AbstractValueDispatch)PolyglotValueDispatch.createHostNull(this), null, EngineAccessor.HOST.getHostNull());
        this.disconnectedHostValue = new PolyglotValueDispatch.HostValue(this);
        PolyglotValueDispatch.createDefaultValues(this, null, this.primitiveValues);
    }

    public Object buildLimits(long statementLimit, Predicate<org.graalvm.polyglot.Source> statementLimitSourceFilter, Consumer<ResourceLimitEvent> onLimit) {
        try {
            return new PolyglotLimits(statementLimit, statementLimitSourceFilter, onLimit);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    public AbstractPolyglotImpl.AbstractSourceDispatch getSourceDispatch() {
        return this.sourceDispatch;
    }

    public AbstractPolyglotImpl.AbstractSourceSectionDispatch getSourceSectionDispatch() {
        return this.sourceSectionDispatch;
    }

    public AbstractPolyglotImpl.AbstractManagementDispatch getManagementDispatch() {
        return this.executionListenerDispatch;
    }

    public Context getCurrentContext() {
        try {
            PolyglotContextImpl context = PolyglotFastThreadLocals.getContext(null);
            if (context == null) {
                throw PolyglotEngineException.illegalState("No current context is available. Make sure the Java method is invoked by a Graal guest language or a context is entered using Context.enter().");
            }
            Context api = context.api;
            if (api == null) {
                context.api = api = this.getAPIAccess().newContext((AbstractPolyglotImpl.AbstractContextDispatch)this.contextDispatch, (Object)context, context.engine.api);
            }
            return api;
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    public Engine buildEngine(OutputStream out, OutputStream err, InputStream in, Map<String, String> originalOptions, boolean useSystemProperties, boolean allowExperimentalOptions, boolean boundEngine, MessageTransport messageInterceptor, Object logHandlerOrStream, Object hostLanguage, boolean hostLanguageOnly) {
        PolyglotEngineImpl impl = null;
        try {
            PolyglotLoggers.EngineLoggerProvider loggerProvider;
            PolyglotEngineImpl.LogConfig logConfig;
            OptionValuesImpl engineOptions;
            if (TruffleOptions.AOT) {
                EngineAccessor.ACCESSOR.initializeNativeImageTruffleLocator();
            }
            OutputStream resolvedOut = out == null ? System.out : out;
            OutputStream resolvedErr = err == null ? System.err : err;
            InputStream resolvedIn = in == null ? System.in : in;
            DispatchOutputStream dispatchOut = EngineAccessor.INSTRUMENT.createDispatchOutput(resolvedOut);
            DispatchOutputStream dispatchErr = EngineAccessor.INSTRUMENT.createDispatchOutput(resolvedErr);
            Handler logHandler = PolyglotLoggers.asHandler(logHandlerOrStream);
            boolean useAllowExperimentalOptions = allowExperimentalOptions || Boolean.parseBoolean(EngineAccessor.RUNTIME.getSavedProperty(PROP_ALLOW_EXPERIMENTAL_OPTIONS));
            HashMap<String, String> options = new HashMap<String, String>(originalOptions);
            if (useSystemProperties) {
                PolyglotEngineImpl.readOptionsFromSystemProperties(options);
            }
            if ((impl = (PolyglotEngineImpl)EngineAccessor.RUNTIME.tryLoadCachedEngine(engineOptions = PolyglotImpl.createEngineOptions(options, logConfig = new PolyglotEngineImpl.LogConfig(), useAllowExperimentalOptions), loggerProvider = new PolyglotLoggers.EngineLoggerProvider(logHandler = logHandler != null ? logHandler : PolyglotEngineImpl.createLogHandler(logConfig, dispatchErr), logConfig.logLevels))) == null && boundEngine && !hostLanguageOnly && !EngineAccessor.RUNTIME.isStoreEnabled(engineOptions)) {
                impl = this.preInitializedEngineRef.getAndSet(null);
            }
            if (impl != null) {
                if (hostLanguage.getClass() != impl.hostLanguageInstance.spi.getClass()) {
                    throw new AssertionError((Object)"Patching engine with different host language is not supported.");
                }
                impl.patch(dispatchOut, dispatchErr, resolvedIn, engineOptions, logConfig, loggerProvider, options, useAllowExperimentalOptions, boundEngine, logHandler);
            }
            if (impl == null) {
                impl = new PolyglotEngineImpl(this, dispatchOut, dispatchErr, resolvedIn, engineOptions, logConfig.logLevels, loggerProvider, options, useAllowExperimentalOptions, boundEngine, false, messageInterceptor, logHandler, (TruffleLanguage)hostLanguage, hostLanguageOnly);
            }
            return this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineDispatch)this.engineDispatch, (Object)impl);
        }
        catch (Throwable t) {
            if (impl == null) {
                throw PolyglotImpl.guestToHostException(this, t);
            }
            throw PolyglotImpl.guestToHostException(impl, t);
        }
    }

    static OptionValuesImpl createEngineOptions(Map<String, String> options, PolyglotEngineImpl.LogConfig logOptions, boolean allowExperimentalOptions) {
        OptionDescriptors engineOptionDescriptors = PolyglotEngineImpl.createEngineOptionDescriptors();
        HashMap<String, String> engineOptions = new HashMap<String, String>();
        PolyglotEngineImpl.parseEngineOptions(options, engineOptions, logOptions);
        OptionValuesImpl values = new OptionValuesImpl(null, engineOptionDescriptors, true);
        values.putAll(engineOptions, allowExperimentalOptions);
        return values;
    }

    public void preInitializeEngine() {
        PolyglotEngineImpl engine = this.createDefaultEngine();
        try {
            engine.preInitialize();
        }
        finally {
            LanguageCache.resetNativeImageCacheLanguageHomes();
            engine.logLevels.clear();
            engine.logHandler.close();
            engine.logHandler = null;
        }
        this.preInitializedEngineRef.set(engine);
    }

    PolyglotEngineImpl createDefaultEngine() {
        HashMap<String, String> options = new HashMap<String, String>();
        PolyglotEngineImpl.readOptionsFromSystemProperties(options);
        PolyglotEngineImpl.LogConfig logConfig = new PolyglotEngineImpl.LogConfig();
        OptionValuesImpl engineOptions = PolyglotImpl.createEngineOptions(options, logConfig, true);
        DispatchOutputStream out = EngineAccessor.INSTRUMENT.createDispatchOutput(System.out);
        DispatchOutputStream err = EngineAccessor.INSTRUMENT.createDispatchOutput(System.err);
        Handler logHandler = PolyglotEngineImpl.createLogHandler(logConfig, err);
        PolyglotLoggers.EngineLoggerProvider loggerProvider = new PolyglotLoggers.EngineLoggerProvider(logHandler, logConfig.logLevels);
        Object host = this.createHostLanguage(this.createHostAccess());
        PolyglotEngineImpl engine = new PolyglotEngineImpl(this, out, err, System.in, engineOptions, logConfig.logLevels, loggerProvider, options, true, true, true, null, logHandler, (TruffleLanguage<Object>)host, false);
        return engine;
    }

    public TruffleLanguage<Object> createHostLanguage(AbstractPolyglotImpl.AbstractHostAccess access) {
        return EngineAccessor.HOST.createDefaultHostLanguage(this, access);
    }

    public void resetPreInitializedEngine() {
        this.preInitializedEngineRef.set(null);
        PolyglotEngineImpl.resetPreInitializedEngine();
    }

    public Class<?> loadLanguageClass(String className) {
        for (Supplier supplier : EngineAccessor.locatorOrDefaultLoaders()) {
            ClassLoader loader = (ClassLoader)supplier.get();
            if (loader == null) continue;
            try {
                Class<?> c = loader.loadClass(className);
                if (!TruffleOptions.AOT) {
                    EngineAccessor.JDKSERVICES.exportTo(loader, null);
                }
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public Collection<? extends Object> findActiveEngines() {
        return PolyglotEngineImpl.findActiveEngines();
    }

    public <S, T> Object newTargetTypeMapping(Class<S> sourceType, Class<T> targetType, Predicate<S> acceptsValue, Function<S, T> convertValue, HostAccess.TargetMappingPrecedence precedence) {
        return EngineAccessor.HOST.newTargetTypeMapping(sourceType, targetType, acceptsValue, convertValue, precedence);
    }

    Value asValue(PolyglotContextImpl currentContext, Object hostValue) {
        if (currentContext != null) {
            return currentContext.asValue(hostValue);
        }
        assert (!(hostValue instanceof Value));
        Object guestValue = null;
        if (hostValue == null) {
            return this.hostNull;
        }
        if (PolyglotImpl.isGuestPrimitive(hostValue)) {
            return this.getAPIAccess().newValue((AbstractPolyglotImpl.AbstractValueDispatch)this.primitiveValues.get(hostValue.getClass()), null, hostValue);
        }
        if (PolyglotWrapper.isInstance(hostValue)) {
            PolyglotWrapper hostWrapper = PolyglotWrapper.asInstance(hostValue);
            PolyglotLanguageContext languageContext = hostWrapper.getLanguageContext();
            assert (languageContext != null) : "HostWrappers must be guaranteed to have non-null language context.";
            guestValue = hostWrapper.getGuestObject();
            return languageContext.asValue(guestValue);
        }
        guestValue = hostValue instanceof TruffleObject ? hostValue : (hostValue instanceof Proxy ? EngineAccessor.HOST.toDisconnectedHostProxy((Proxy)hostValue) : EngineAccessor.HOST.toDisconnectedHostObject(hostValue));
        return this.getAPIAccess().newValue((AbstractPolyglotImpl.AbstractValueDispatch)this.disconnectedHostValue, null, guestValue);
    }

    @CompilerDirectives.TruffleBoundary
    public Value asValue(Object hostValue) {
        try {
            PolyglotContextImpl currentContext = PolyglotFastThreadLocals.getContext(null);
            return this.asValue(currentContext, hostValue);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    public FileSystem newDefaultFileSystem() {
        return FileSystems.newDefaultFileSystem();
    }

    public AbstractPolyglotImpl.AbstractHostAccess createHostAccess() {
        return new PolyglotHostAccess(this);
    }

    static org.graalvm.polyglot.Source getOrCreatePolyglotSource(AbstractPolyglotImpl polyglot, Source source) {
        return EngineAccessor.SOURCE.getOrCreatePolyglotSource(source, t -> polyglot.getAPIAccess().newSource(t));
    }

    static org.graalvm.polyglot.SourceSection getPolyglotSourceSection(AbstractPolyglotImpl polyglot, SourceSection sourceSection) {
        if (sourceSection == null) {
            return null;
        }
        org.graalvm.polyglot.Source polyglotSource = PolyglotImpl.getOrCreatePolyglotSource(polyglot, sourceSection.getSource());
        return polyglot.getAPIAccess().newSourceSection(polyglotSource, (Object)sourceSection);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException engineToLanguageException(Throwable t) throws T {
        assert (!(t instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the guest language";
        PolyglotEngineException.rethrow(t);
        throw t;
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException engineToInstrumentException(Throwable t) throws T {
        assert (!(t instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the guest instrument";
        PolyglotEngineException.rethrow(t);
        throw t;
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> PolyglotException guestToHostException(PolyglotLanguageContext languageContext, T e, boolean entered) {
        PolyglotExceptionImpl exceptionImpl;
        assert (!(e instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the host: " + e;
        PolyglotEngineException.rethrow(e);
        if (languageContext == null) {
            throw new RuntimeException(e);
        }
        PolyglotContextImpl context = languageContext.context;
        PolyglotContextImpl.State localContextState = context.state;
        if (localContextState.isInvalidOrClosed()) {
            exceptionImpl = new PolyglotExceptionImpl(context.engine, localContextState, context.invalidResourceLimit, e);
        } else {
            try {
                exceptionImpl = new PolyglotExceptionImpl(languageContext.getImpl(), languageContext.context.engine, localContextState, false, languageContext, e, true, entered);
            }
            catch (Throwable t) {
                e.addSuppressed(t);
                exceptionImpl = new PolyglotExceptionImpl(context.engine, localContextState, false, e);
            }
        }
        AbstractPolyglotImpl.APIAccess access = PolyglotImpl.getInstance().getAPIAccess();
        return access.newLanguageException(exceptionImpl.getMessage(), (AbstractPolyglotImpl.AbstractExceptionDispatch)PolyglotImpl.getInstance().exceptionDispatch, (Object)exceptionImpl);
    }

    static <T extends Throwable> PolyglotException guestToHostException(PolyglotEngineImpl engine, T e) {
        assert (!(e instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the host: " + e;
        PolyglotEngineException.rethrow(e);
        AbstractPolyglotImpl.APIAccess access = engine.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = new PolyglotExceptionImpl(engine, null, false, e);
        return access.newLanguageException(exceptionImpl.getMessage(), (AbstractPolyglotImpl.AbstractExceptionDispatch)PolyglotImpl.getInstance().exceptionDispatch, (Object)exceptionImpl);
    }

    @CompilerDirectives.TruffleBoundary
    private static <T extends Throwable> PolyglotException guestToHostException(PolyglotImpl polyglot, T e) {
        assert (!(e instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the host: " + e;
        PolyglotEngineException.rethrow(e);
        AbstractPolyglotImpl.APIAccess access = polyglot.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = new PolyglotExceptionImpl(polyglot, e);
        return access.newLanguageException(exceptionImpl.getMessage(), (AbstractPolyglotImpl.AbstractExceptionDispatch)PolyglotImpl.getInstance().exceptionDispatch, (Object)exceptionImpl);
    }

    static boolean isGuestPrimitive(Object receiver) {
        return receiver instanceof Integer || receiver instanceof Double || receiver instanceof Long || receiver instanceof Float || receiver instanceof Boolean || receiver instanceof Character || receiver instanceof Byte || receiver instanceof Short || receiver instanceof String;
    }

    static interface VMObject {
        public PolyglotEngineImpl getEngine();

        default public PolyglotImpl getImpl() {
            return this.getEngine().impl;
        }

        default public AbstractPolyglotImpl.APIAccess getAPIAccess() {
            return this.getEngine().impl.getAPIAccess();
        }
    }
}

