/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.impl;

import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.imgfactory.impl.ImageFromUrlCallback;
import com.paterva.maltego.util.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ImageFromUrlThread
extends Thread {
    private static final Logger LOG = Logger.getLogger(ImageFromUrlThread.class.getName());
    private final URL _url;
    private final ImageFromUrlCallback _cb;
    private final boolean _capSize;

    public ImageFromUrlThread(URL url, ImageFromUrlCallback cb) {
        this(url, cb, true);
    }

    public ImageFromUrlThread(URL url, ImageFromUrlCallback cb, boolean capSize) {
        this._url = url;
        this._cb = cb;
        this._capSize = capSize;
    }

    @Override
    public void run() {
        try {
            BufferedImage img = null;
            try {
                img = ImageFromUrlThread.getImage(this._url);
            }
            catch (Exception ex) {
                String urlStr = this._url.toString();
                if (urlStr != null && urlStr.contains("https://")) {
                    URL httpUrl = new URL(urlStr.replace("https://", "http://"));
                    img = ImageFromUrlThread.getImage(httpUrl);
                }
                throw ex;
            }
            if (this._capSize && img != null && (img.getWidth(null) > 240 || img.getHeight(null) > 240)) {
                img = ImageUtils.smartSize((BufferedImage)img, (double)240.0);
            }
            if (img == null) {
                throw new NullPointerException("Image load from url = " + (this._url == null ? "null" : this._url.toString()) + " returned null");
            }
            this._cb.imageFromUrlReady(this, img);
        }
        catch (Exception ex) {
            this._cb.imageFromUrlFailed(this, ex);
        }
    }

    public static BufferedImage getImage(URL url) throws IOException {
        HttpAgent agent = new HttpAgent(url);
        agent.setAllowNonHttp(true);
        agent.doGet();
        BufferedImage image = null;
        try {
            URL locationUrl;
            image = ImageIO.read(agent.getInputStream());
            if (image == null && (locationUrl = agent.getLocation()) != null) {
                image = ImageFromUrlThread.getImage(url);
            }
        }
        catch (UnsatisfiedLinkError error) {
            String urlString = url != null && url.toString() != null ? url.toString() : "";
            LOG.warning(() -> "UnsatisfiedLinkError for URL '" + urlString + "': " + error);
            throw new IOException(error.getMessage(), error.getCause());
        }
        return image;
    }
}

