/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.Payload;
import com.paterva.maltego.collab.PayloadCollection;
import com.paterva.maltego.collab.graph.state.HistoryEndMessage;
import com.paterva.maltego.collab.graph.state.SignalMessage;
import com.paterva.maltego.collab.graph.state.StateConnecting;
import com.paterva.maltego.collab.graph.state.StateGraphMerge;

class StateWaitHistory
extends StateConnecting.Timeout {
    @Override
    protected void onRun() {
        this.progress(LogMessageLevel.Info, "Waiting for history", 35);
        this.sendHistoryEndSignal();
        this.debug("waiting for history");
    }

    @Override
    protected long getTimeout() {
        return this.sessionInfo().getMessageTimeout();
    }

    @Override
    protected void onTimeout() {
        String msg = "Timeout getting history";
        this.handleError("", (Exception)((Object)new CollaborationException(msg, false)));
    }

    private void sendHistoryEndSignal() {
        try {
            String id = this.me().getID();
            this.debug("sending history end message");
            this.tx().sendPayload(id, HistoryEndMessage.create().toXml());
        }
        catch (CollaborationException ex) {
            this.handleError("Failed to send history end message", (Exception)((Object)ex));
        }
    }

    @Override
    public void payloadsReceived(PayloadCollection payloads) throws CollaborationException {
        if (this.isHistoryEndSignal(payloads)) {
            this.debug("received end history");
            this.setNextState(new StateGraphMerge());
        } else {
            super.payloadsReceived(payloads);
        }
    }

    private boolean isHistoryEndSignal(PayloadCollection payloads) {
        Payload payload = payloads.first("signal", true);
        if (payload != null) {
            try {
                SignalMessage signal = SignalMessage.parse(payload.getBody());
                return "history-done".equals(signal.getAction());
            }
            catch (CollaborationException ex) {
                this.handleError("Unable to parse signal message", (Exception)((Object)ex));
            }
        }
        return false;
    }
}

