/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;

public class SelectLinks {
    public static final int SELECT_CONNECTED = 0;
    public static final int SELECT_OUT = 1;
    public static final int SELECT_IN = 2;

    public static void selectLinks(GraphID graphID, Collection<EntityID> modelEntities, int mode) {
        if (modelEntities.isEmpty()) {
            StatusDisplayer.getDefault().setStatusText("No entities selected...");
        } else {
            Set<LinkID> links = SelectLinks.getLinks(graphID, modelEntities, mode);
            GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
            selection.setSelectedModelLinks(links);
        }
    }

    private static Set<LinkID> getLinks(GraphID graphID, Collection<EntityID> entities, int mode) {
        Set<LinkID> links = Collections.emptySet();
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureStore structureStore = graphStore.getGraphStructureStore();
            GraphStructureReader structureReader = structureStore.getStructureReader();
            links = SelectLinks.getLinks(structureReader, entities, mode);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return links;
    }

    private static Set<LinkID> getLinks(GraphStructureReader structureReader, Collection<EntityID> entities, int mode) throws GraphStoreException {
        switch (mode) {
            case 0: {
                return structureReader.getLinks(entities);
            }
            case 1: {
                Map links = structureReader.getOutgoing(entities);
                return SelectLinks.linksOnly(links);
            }
            case 2: {
                Map links = structureReader.getIncoming(entities);
                return SelectLinks.linksOnly(links);
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + mode);
    }

    private static Set<LinkID> linksOnly(Map<EntityID, Set<LinkID>> linkMap) {
        HashSet<LinkID> links = new HashSet<LinkID>();
        for (Map.Entry<EntityID, Set<LinkID>> entry : linkMap.entrySet()) {
            links.addAll((Collection<LinkID>)entry.getValue());
        }
        return links;
    }
}

