/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.wizard;

import com.paterva.maltego.util.HtmlUtils;
import com.paterva.maltego.util.ui.components.MultiLineLabel;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.util.ui.dialog.ValidatingPanel;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIDefaults;
import javax.swing.event.HyperlinkEvent;
import org.openide.util.NbBundle;

public class UpdateDisclaimerPanel
extends ValidatingPanel {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private static final int MAX_WIDTH = 1020;
    private JCheckBox _checkBox;
    private JLabel _statusLabel;
    private JTextPane _text;
    private JLabel _titleLabel;
    private JLabel checkBoxText;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane2;

    public UpdateDisclaimerPanel(ValidatingController controller) {
        super(controller);
        this.initComponents();
        this.checkBoxText.setText("By checking the box, I declare that I have read and understood the terms and conditions of the documents indicated above and I undertake to fully comply with them. I agree and understand that the above documents will govern my use of the Maltego Software and will constitute a binding agreement.");
        this.checkBoxText.setVerticalAlignment(1);
        this.checkBoxText.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 3));
        this.checkBoxText.setMaximumSize(new Dimension(2000, 2000));
        this.checkBoxText.setVerticalTextPosition(1);
        this.checkBoxText.setForeground(LAF.getColor("transform-disclaimer-checkbox-fg"));
        this._checkBox.addActionListener((ActionListener)this.getChangeEventPropagator());
    }

    public void setAccept(boolean accept) {
        this._checkBox.setSelected(accept);
    }

    public boolean isAccept() {
        return this._checkBox.isSelected();
    }

    public void setText(TreeSet<String> disclaimerSet) {
        boolean bold = false;
        boolean wrapLink = false;
        this._titleLabel.setText("Disclaimer");
        this._statusLabel.setText("Please accept the following disclaimers:");
        String text = "";
        if (this._text instanceof JTextPane) {
            FontMetrics fm = this._text.getFontMetrics(bold ? this._text.getFont().deriveFont(1) : this._text.getFont());
            for (String disclaimer : disclaimerSet) {
                if (HtmlUtils.containsHtmlLink((String)disclaimer)) continue;
                text = text + HtmlUtils.getClickableText((String)disclaimer, (FontMetrics)fm, (Insets)this._text.getInsets(), (int)1020, (boolean)wrapLink) + "<br>";
            }
            Color linkColor = LAF.getColor("transform-disclaimer-link-fg");
            String linkColorString = String.format("#%02x%02x%02x", linkColor.getRed(), linkColor.getGreen(), linkColor.getBlue());
            String styles = "<style>\na {\n   color: " + linkColorString + ";\n   text-decoration: none;\n}</style>";
            text = bold ? "<html><head>" + styles + "</head><body style='font-weight: bold; color: black'>" + text + "</body></html>" : "<html><head>" + styles + "</head><body style='color: black'>" + text + "</body></html>";
            this._text.setText(text);
            this._text.addHyperlinkListener(event -> HtmlUtils.registerHyperlinkEvents((HyperlinkEvent)event));
        } else {
            this._text.setText(text);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this._titleLabel = new JLabel();
        this._statusLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this._text = new JTextPane();
        this.jPanel2 = new JPanel();
        this._checkBox = new JCheckBox();
        this.checkBoxText = new MultiLineLabel();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 0, 6));
        this.setMaximumSize(new Dimension(10, 10));
        this.setPreferredSize(new Dimension(10, 10));
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this._titleLabel.setFont(this._titleLabel.getFont().deriveFont(this._titleLabel.getFont().getStyle() | 1, this._titleLabel.getFont().getSize() + 1));
        this._titleLabel.setText(NbBundle.getMessage(UpdateDisclaimerPanel.class, (String)"UpdateDisclaimerPanel._titleLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this._titleLabel, gridBagConstraints);
        this._statusLabel.setText(NbBundle.getMessage(UpdateDisclaimerPanel.class, (String)"UpdateDisclaimerPanel._statusLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this._statusLabel, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this._text.setEditable(false);
        this._text.setContentType("text/html");
        this.jScrollPane2.setViewportView(this._text);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.7;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel3.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this._checkBox.setText(NbBundle.getMessage(UpdateDisclaimerPanel.class, (String)"UpdateDisclaimerPanel._checkBox.text"));
        this._checkBox.setToolTipText(NbBundle.getMessage(UpdateDisclaimerPanel.class, (String)"UpdateDisclaimerPanel._checkBox.toolTipText"));
        this._checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateDisclaimerPanel.this._checkBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this._checkBox, gridBagConstraints);
        this.checkBoxText.setLabelFor(this._checkBox);
        this.checkBoxText.setText(NbBundle.getMessage(UpdateDisclaimerPanel.class, (String)"UpdateDisclaimerPanel.checkBoxText.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.checkBoxText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.4;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel3.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.add(this.jPanel1, "Center");
    }

    private void _checkBoxActionPerformed(ActionEvent evt) {
    }
}

