/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.EntryFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;

class MaltegoArchive {
    private final ZipFile _file;
    private Map<String, FileHeader> _paths;

    public MaltegoArchive(ZipFile file) {
        this._file = file;
    }

    public <T> ZipInputStream getInputStream(String fileName) throws ZipException {
        return this._file.getInputStream(this.getPaths().get(fileName));
    }

    public boolean containsEntry(String fileName) throws ZipException {
        return this.getPaths().containsKey(fileName);
    }

    public <TEntry extends Entry> List<TEntry> createEntries(EntryFactory<TEntry> factory, String graphName) throws ZipException {
        ArrayList<TEntry> entries = new ArrayList<TEntry>();
        List<String> paths = this.getPaths(factory, graphName);
        for (String path : paths) {
            entries.add(factory.create(path));
        }
        return entries;
    }

    public <TEntry extends Entry> List<String> getPaths(EntryFactory<TEntry> factory, String graphName) throws ZipException {
        return this.getPaths(factory.getFolderName(), factory.getExtension());
    }

    public List<String> getPaths(String folder, String type) throws ZipException {
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : this.getPaths().keySet()) {
            String[] pathParts = Entry.parse(path);
            String pathFolder = pathParts[0];
            String pathType = pathParts[2];
            if (!pathFolder.startsWith(folder) || type != null && !type.equals(pathType)) continue;
            paths.add(path);
        }
        return paths;
    }

    private Map<String, FileHeader> getPaths() throws ZipException {
        if (this._paths == null) {
            this._paths = new HashMap<String, FileHeader>();
            List fileHeaders = this._file.getFileHeaders();
            for (Object obj : fileHeaders) {
                FileHeader fileHeader;
                if (!(obj instanceof FileHeader) || (fileHeader = (FileHeader)obj).isDirectory()) continue;
                this._paths.put(fileHeader.getFileName(), fileHeader);
            }
        }
        return this._paths;
    }
}

