/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chat.users;

import com.paterva.maltego.chat.ChatRoomTopComponentRegistry;
import com.paterva.maltego.chat.users.Bundle;
import com.paterva.maltego.chat.users.UsersPanel;
import com.paterva.maltego.chatapi.ChatRoom;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.UIManager;
import org.openide.windows.RetainLocation;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="UsersTopComponent", iconBase="", persistenceType=2)
@RetainLocation(value="MaltegoSatellite")
public final class UsersTopComponent
extends TopComponent {
    private final UsersPanel _usersPanel;
    private ChatRoomRegistryListener _registryListener;

    public UsersTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_UsersTopComponent());
        this.setToolTipText(Bundle.HINT_UsersTopComponent());
        this.setLayout(new BorderLayout());
        Color bg = UIManager.getLookAndFeelDefaults().getColor("collaboration-user-window-background");
        this.setBackground(bg);
        this._usersPanel = new UsersPanel();
        this._usersPanel.setBackground(bg);
        this.add(this._usersPanel);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void componentOpened() {
        this._registryListener = new ChatRoomRegistryListener();
        ChatRoomTopComponentRegistry registry = ChatRoomTopComponentRegistry.getDefault();
        registry.addPropertyChangeListener(this._registryListener);
        ChatRoom chatRoom = registry.getActiveChatRoom();
        if (chatRoom != null) {
            this.onChatRoomChanged(chatRoom);
        }
    }

    public void componentClosed() {
        ChatRoomTopComponentRegistry registry = ChatRoomTopComponentRegistry.getDefault();
        registry.removePropertyChangeListener(this._registryListener);
        this._registryListener = null;
        this.onChatRoomChanged(null);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    protected void onChatRoomChanged(ChatRoom chatRoom) {
        this._usersPanel.setChatRoom(chatRoom);
    }

    private class ChatRoomRegistryListener
    implements PropertyChangeListener {
        private ChatRoomRegistryListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("chatRoomActiveChanged".equals(evt.getPropertyName())) {
                UsersTopComponent.this.onChatRoomChanged(ChatRoomTopComponentRegistry.getDefault().getActiveChatRoom());
            }
        }
    }
}

