/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.table;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraphLink;
import com.paterva.maltego.graph.table.ui.graph.ConnectivityController;
import com.paterva.maltego.graph.table.ui.table.ConnectivityTablePanel;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.util.List;
import javax.swing.JTabbedPane;
import org.openide.WizardDescriptor;

public final class ConnectivityTableController
extends ValidatingController<ConnectivityTablePanel> {
    public static final String PROP_HAS_LINKS_BEEN_MODIFIED = "hasLinksBeenModified";
    private final ConnectivityController cc;

    public ConnectivityTableController(ConnectivityController cc) {
        this.setName("Connectivity Table");
        this.cc = cc;
    }

    protected ConnectivityTablePanel createComponent() {
        return new ConnectivityTablePanel();
    }

    protected void readSettings(WizardDescriptor settings) {
        TabularGraph tabularGraph = (TabularGraph)settings.getProperty("graphTable");
        ((ConnectivityTablePanel)this.component()).setTabularGraph(tabularGraph, (JTabbedPane)settings.getProperty("mcTabbedPane"));
    }

    protected void storeSettings(WizardDescriptor settings) {
        ((ConnectivityTablePanel)this.component()).commitFinalEdit();
        List<DefaultTabularGraphLink> removedLinks = ((ConnectivityTablePanel)this.component()).getRemovedLinks();
        List<DefaultTabularGraphLink> addedLinks = ((ConnectivityTablePanel)this.component()).getAddedLinks();
        if (!removedLinks.isEmpty() || !addedLinks.isEmpty()) {
            TabularGraph tg = (TabularGraph)settings.getProperty("graphTable");
            for (int i = 0; i < removedLinks.size(); ++i) {
                DefaultTabularGraphLink remLink = removedLinks.get(i);
                TabularGraphLink findLink = tg.findLink(remLink.getSource(), remLink.getTarget());
                if (findLink == null) continue;
                tg.removeLink(findLink);
            }
            int index = 0;
            for (DefaultTabularGraphLink link : addedLinks) {
                link.setIndex(this.getNextLinkIndex(index, tg));
                tg.putLink((TabularGraphLink)link);
            }
            this.cc.updateCounts(tg);
        }
    }

    private int getNextLinkIndex(int index, TabularGraph tg) {
        ++index;
        for (TabularGraphLink link : tg.getLinks()) {
            if (link.getIndex() != index) continue;
            return this.getNextLinkIndex(index, tg);
        }
        return index;
    }
}

