/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.impl;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.table.PropertyToColumnMap;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class TabularGraphUtils {
    private TabularGraphUtils() {
    }

    public static MaltegoEntitySpec getSpec(TabularGraphEntity entity) {
        return (MaltegoEntitySpec)EntityRegistry.getDefault().get(entity.getEntitySpecName());
    }

    public static List<TabularGraphEntity> getEntities(TabularGraph graph, int[] columns) {
        ArrayList<TabularGraphEntity> entities = new ArrayList<TabularGraphEntity>();
        for (TabularGraphEntity entity : graph.getEntities()) {
            if (!TabularGraphUtils.isAnyMapped((PropertyToColumnMap)entity, columns)) continue;
            entities.add(entity);
        }
        return entities;
    }

    public static TabularGraphEntity getEntity(TabularGraph graph, int column) {
        for (TabularGraphEntity entity : graph.getEntities()) {
            if (!entity.contains(column)) continue;
            return entity;
        }
        return null;
    }

    public static List<TabularGraphLink> getLinks(TabularGraph graph, int[] columns) {
        ArrayList<TabularGraphLink> links = new ArrayList<TabularGraphLink>();
        for (TabularGraphLink link : graph.getLinks()) {
            if (!TabularGraphUtils.isAnyMapped((PropertyToColumnMap)link, columns)) continue;
            links.add(link);
        }
        return links;
    }

    public static TabularGraphLink getLink(TabularGraph graph, int column) {
        for (TabularGraphLink link : graph.getLinks()) {
            if (!link.contains(column)) continue;
            return link;
        }
        return null;
    }

    public static boolean isAnyMapped(PropertyToColumnMap map, int ... columns) {
        for (int column : columns) {
            if (!map.contains(column)) continue;
            return true;
        }
        return false;
    }

    public static Set<PropertyDescriptor> getProperties(PropertyToColumnMap map, int ... columns) {
        int[] columnsToUse = columns;
        if (columnsToUse == null || columnsToUse.length == 0) {
            columnsToUse = map.getColumns();
        }
        HashSet<PropertyDescriptor> pds = new HashSet<PropertyDescriptor>(columnsToUse.length);
        for (int column : columnsToUse) {
            PropertyDescriptor pd = map.getProperty(column);
            if (pd == null) continue;
            pds.add(pd);
        }
        return pds;
    }

    public static PropertyDescriptor getNextUnusedProperty(TabularGraphEntity entity) {
        PropertyDescriptor displayValuePd;
        String typeName;
        EntityRegistry registry = EntityRegistry.getDefault();
        PropertyDescriptor valuePd = InheritanceHelper.getValueProperty((SpecRegistry)registry, (String)(typeName = entity.getEntitySpecName()));
        if (valuePd != null && !TabularGraphUtils.isMapped((PropertyToColumnMap)entity, valuePd)) {
            return valuePd;
        }
        Optional displayValuePdOpt = InheritanceHelper.getDisplayValueProperty((SpecRegistry)registry, (String)typeName);
        if (displayValuePdOpt.isPresent() && !TabularGraphUtils.isMapped((PropertyToColumnMap)entity, displayValuePd = (PropertyDescriptor)displayValuePdOpt.get())) {
            return displayValuePd;
        }
        DisplayDescriptorCollection properties = InheritanceHelper.getAggregatedProperties((SpecRegistry)registry, (String)typeName);
        for (DisplayDescriptor dd : properties) {
            if (TabularGraphUtils.isMapped((PropertyToColumnMap)entity, (PropertyDescriptor)dd)) continue;
            return dd;
        }
        return null;
    }

    public static PropertyDescriptor getNextUnusedProperty(TabularGraphLink link) {
        PropertyDescriptor displayValuePd;
        LinkRegistry registry = LinkRegistry.getDefault();
        MaltegoLinkSpec spec = MaltegoLinkSpec.getManualSpec();
        String typeName = spec.getTypeName();
        DisplayDescriptor valuePd = spec.getValueProperty();
        if (valuePd != null && !TabularGraphUtils.isMapped((PropertyToColumnMap)link, (PropertyDescriptor)valuePd)) {
            return valuePd;
        }
        Optional displayValuePdOpt = InheritanceHelper.getDisplayValueProperty((SpecRegistry)registry, (String)typeName);
        if (displayValuePdOpt.isPresent() && !TabularGraphUtils.isMapped((PropertyToColumnMap)link, displayValuePd = (PropertyDescriptor)displayValuePdOpt.get())) {
            return displayValuePd;
        }
        DisplayDescriptorCollection properties = spec.getProperties();
        for (DisplayDescriptor dd : properties) {
            if (TabularGraphUtils.isMapped((PropertyToColumnMap)link, (PropertyDescriptor)dd)) continue;
            return dd;
        }
        return null;
    }

    private static boolean isMapped(PropertyToColumnMap map, PropertyDescriptor descriptor) {
        for (int column : map.getColumns()) {
            PropertyDescriptor pd = map.getProperty(column);
            if (!descriptor.equals(pd)) continue;
            return true;
        }
        return false;
    }
}

