/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nfa;

import com.oracle.truffle.regex.tregex.nfa.PureNFA;
import com.oracle.truffle.regex.tregex.nfa.PureNFAIndex;
import com.oracle.truffle.regex.tregex.nfa.PureNFAMap;
import com.oracle.truffle.regex.tregex.nfa.PureNFAState;
import com.oracle.truffle.regex.tregex.nfa.PureNFATransition;
import com.oracle.truffle.regex.tregex.nfa.PureNFATransitionGenerator;
import com.oracle.truffle.regex.tregex.nfa.QuantifierGuard;
import com.oracle.truffle.regex.tregex.parser.Counter;
import com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import com.oracle.truffle.regex.tregex.parser.ast.LookAroundAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookAroundIndex;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;

public final class PureNFAGenerator {
    private final RegexAST ast;
    private final Counter.ThresholdCounter stateID = new Counter.ThresholdCounter(Short.MAX_VALUE, "PureNFA explosion");
    private final Counter.ThresholdCounter transitionID = new Counter.ThresholdCounter(Short.MAX_VALUE, "NFA transition explosion");
    private PureNFAState anchoredFinalState;
    private PureNFAState unAnchoredFinalState;
    private final Deque<PureNFAState> expansionQueue = new ArrayDeque<PureNFAState>();
    private final PureNFAState[] nfaStates;
    private final PureNFATransitionGenerator transitionGen;

    private PureNFAGenerator(RegexAST ast) {
        this.ast = ast;
        this.nfaStates = new PureNFAState[ast.getNumberOfStates()];
        this.transitionGen = new PureNFATransitionGenerator(ast, this);
    }

    public static PureNFAMap mapToNFA(RegexAST ast) {
        ast.hidePrefix();
        PureNFAGenerator gen = new PureNFAGenerator(ast);
        PureNFA root = gen.createNFA(ast.getRoot().getSubTreeParent());
        PureNFAIndex lookArounds = PureNFAGenerator.mapLookArounds(gen, ast.getLookArounds());
        ast.unhidePrefix();
        return new PureNFAMap(ast, root, lookArounds);
    }

    private static PureNFAIndex mapLookArounds(PureNFAGenerator gen, LookAroundIndex lookArounds) {
        if (lookArounds.isEmpty()) {
            return PureNFAIndex.getEmptyInstance(gen.ast.getLanguage());
        }
        PureNFAIndex map = new PureNFAIndex(lookArounds.getNumberOfStates());
        for (LookAroundAssertion la : lookArounds) {
            map.add(gen.createNFA(la));
        }
        return map;
    }

    public Counter.ThresholdCounter getTransitionIdCounter() {
        return this.transitionID;
    }

    public PureNFAState getAnchoredFinalState() {
        return this.anchoredFinalState;
    }

    public PureNFAState getUnAnchoredFinalState() {
        return this.unAnchoredFinalState;
    }

    public PureNFAState getOrCreateState(Term t) {
        PureNFAState lookup = this.nfaStates[t.getId()];
        if (lookup != null) {
            return lookup;
        }
        PureNFAState state = new PureNFAState(this.stateID.inc(), t);
        this.expansionQueue.push(state);
        this.nfaStates[t.getId()] = state;
        return state;
    }

    private PureNFA createNFA(RegexASTSubtreeRootNode root) {
        PureNFAState dummyInitialState;
        assert (this.expansionQueue.isEmpty());
        Arrays.fill(this.nfaStates, null);
        this.stateID.reset();
        this.transitionID.reset();
        this.nfaStates[this.ast.getWrappedRoot().getId()] = dummyInitialState = new PureNFAState(this.stateID.inc(), this.ast.getWrappedRoot());
        if (!root.hasDollar()) {
            this.anchoredFinalState = null;
        } else {
            this.anchoredFinalState = this.createFinalState(root.getAnchoredFinalState(), false);
            this.anchoredFinalState.setAnchoredFinalState();
        }
        this.unAnchoredFinalState = this.createFinalState(root.getMatchFound(), false);
        this.unAnchoredFinalState.setUnAnchoredFinalState();
        PureNFATransition initialStateTransition = this.createEmptyTransition(dummyInitialState, this.createUnAnchoredInitialState(root.getUnAnchoredInitialState()));
        if (root.hasCaret()) {
            dummyInitialState.setSuccessors(new PureNFATransition[]{this.createEmptyTransition(dummyInitialState, this.createAnchoredInitialState(root.getAnchoredInitialState())), initialStateTransition});
        } else {
            dummyInitialState.setSuccessors(new PureNFATransition[]{initialStateTransition, initialStateTransition});
        }
        PureNFATransition finalStateTransition = this.createEmptyTransition(this.unAnchoredFinalState, dummyInitialState);
        if (root.hasDollar()) {
            dummyInitialState.setPredecessors(new PureNFATransition[]{this.createEmptyTransition(this.anchoredFinalState, dummyInitialState), finalStateTransition});
        } else {
            dummyInitialState.setPredecessors(new PureNFATransition[]{finalStateTransition, finalStateTransition});
        }
        assert (dummyInitialState.getId() == 0);
        this.expandAllStates();
        return new PureNFA(root, this.nfaStates, this.stateID, this.transitionID);
    }

    private void expandAllStates() {
        while (!this.expansionQueue.isEmpty()) {
            this.expandNFAState(this.expansionQueue.pop());
        }
    }

    private void expandNFAState(PureNFAState curState) {
        this.transitionGen.generateTransitions(curState);
    }

    private PureNFAState createAnchoredInitialState(Term astNode) {
        PureNFAState state = this.createInitialState(astNode);
        state.setAnchoredInitialState();
        return state;
    }

    private PureNFAState createUnAnchoredInitialState(Term astNode) {
        PureNFAState state = this.createInitialState(astNode);
        state.setUnAnchoredInitialState();
        return state;
    }

    private PureNFAState createInitialState(Term astNode) {
        return this.createFinalState(astNode, true);
    }

    private PureNFAState createFinalState(Term astNode, boolean enqueue) {
        PureNFAState state = new PureNFAState(this.stateID.inc(), astNode);
        assert (this.nfaStates[astNode.getId()] == null);
        this.nfaStates[astNode.getId()] = state;
        if (enqueue) {
            this.expansionQueue.add(state);
        }
        return state;
    }

    private PureNFATransition createEmptyTransition(PureNFAState src, PureNFAState tgt) {
        return new PureNFATransition(this.transitionID.inc(), src, tgt, GroupBoundaries.getEmptyInstance(this.ast.getLanguage()), false, false, QuantifierGuard.NO_GUARDS);
    }
}

