/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol;

import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.descriptor.TransformServerAuthentication;
import com.paterva.maltego.transform.discovery.DiscoveryException;
import com.paterva.maltego.transform.discovery.ProgressCallback;
import com.paterva.maltego.transform.discovery.TransformServerDetail;
import com.paterva.maltego.transform.discovery.TransformServerFinder;
import com.paterva.maltego.transform.discovery.TransformServerReference;
import com.paterva.maltego.transform.protocol.api.DiscoveryResult;
import com.paterva.maltego.transform.protocol.api.DiscoveryServer;
import com.paterva.maltego.transform.protocol.api.DiscoveryStrategy;
import com.paterva.maltego.transform.protocol.api.ProgressListener;
import com.paterva.maltego.transform.protocol.api.TransformApplicationDescriptor;
import com.paterva.maltego.transform.protocol.api.TransformSourceFactory;
import com.paterva.maltego.util.FastURL;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class DefaultTransformServerFinder
extends TransformServerFinder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.paterva.maltego.transform.discovery.DiscoveryResult<TransformServerReference> findServers(TransformSeed[] seeds, ProgressCallback cb) throws DiscoveryException {
        DiscoveryStrategy strategy = new DiscoveryStrategy();
        TransformSourceFactory factory = (TransformSourceFactory)Lookup.getDefault().lookup(TransformSourceFactory.class);
        ProgressListener adapter = event -> {
            if (cb != null) {
                cb.progress(event.getMessage());
            }
        };
        strategy.addProgressListener(adapter);
        try {
            DiscoveryResult result = strategy.doDiscovery(factory, DefaultTransformServerFinder.translate(seeds));
            com.paterva.maltego.transform.discovery.DiscoveryResult<TransformServerReference> discoveryResult = DefaultTransformServerFinder.translate(result);
            return discoveryResult;
        }
        finally {
            strategy.removeProgressListener(adapter);
        }
    }

    private static Collection<DiscoveryServer> translate(TransformSeed[] seeds) {
        LinkedList<DiscoveryServer> list = new LinkedList<DiscoveryServer>();
        for (TransformSeed seed : seeds) {
            try {
                list.add(new DiscoveryServer(seed.getUrl().getURL(), seed.getDisplayName()));
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return list;
    }

    public com.paterva.maltego.transform.discovery.DiscoveryResult<TransformServerDetail> getDetails(TransformServerReference[] references, ProgressCallback cb) throws DiscoveryException {
        return new com.paterva.maltego.transform.discovery.DiscoveryResult((Object[])((TransformServerDetail[])references));
    }

    private static com.paterva.maltego.transform.discovery.DiscoveryResult<TransformServerReference> translate(DiscoveryResult result) {
        ArrayList<TransformServerDetail> list = new ArrayList<TransformServerDetail>();
        for (TransformApplicationDescriptor app : result.getApplications()) {
            try {
                FastURL url = new FastURL(app.getUrl());
                FastURL v3url = null;
                if (app.getV3Url() != null) {
                    v3url = new FastURL(app.getV3Url());
                    v3url.getURL();
                }
                url.getURL();
                TransformServerDetail server = new TransformServerDetail(app.getSeedUrl(), url, v3url, app.getName(), app.getProtocolVersion(), app.getDisclaimer());
                if (app.requiresKey()) {
                    server.setAuthentication(TransformServerAuthentication.License);
                } else {
                    server.setAuthentication(TransformServerAuthentication.MAC);
                }
                server.setOverwriteConfig(app.isOverwriteConfig());
                list.add(server);
            }
            catch (MalformedURLException ex) {
                result.getErrors().add(ex);
            }
        }
        return new com.paterva.maltego.transform.discovery.DiscoveryResult((Object[])list.toArray(new TransformServerDetail[list.size()]), result.getErrors().toArray(new Exception[result.getErrors().size()]));
    }
}

