/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.protocol.v2api.messaging.AdditionalInfoButton;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

class NotificationTranslator {
    public TransformMessage translate(TransformResponse.Notification from, int code, Collection<AdditionalInfoButton> buttons) {
        TransformMessage to = new TransformMessage(new Date(), this.translate(from.getType()), from.getValue(), code, this.translateButtons(buttons));
        return to;
    }

    private TransformMessage.Severity translate(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        if (s.equals("Debug")) {
            return TransformMessage.Severity.Debug;
        }
        if (s.equals("Inform")) {
            return TransformMessage.Severity.Info;
        }
        if (s.equals("PartialError")) {
            return TransformMessage.Severity.Warning;
        }
        if (s.equals("FatalError")) {
            return TransformMessage.Severity.Error;
        }
        throw new IllegalArgumentException("Invalid type " + s);
    }

    private List<TransformMessage.MessageButton> translateButtons(Collection<AdditionalInfoButton> buttons) {
        ArrayList<TransformMessage.MessageButton> messageButtons = new ArrayList<TransformMessage.MessageButton>();
        for (AdditionalInfoButton button : buttons) {
            messageButtons.add(new TransformMessage.MessageButton(button.getId(), button.getText(), (String)button.getUrl().orElse(null)));
        }
        return messageButtons;
    }

    public List<TransformMessage> translate(Collection<TransformResponse.Notification> from, int code, Collection<AdditionalInfoButton> buttons) {
        if (from == null || from.size() == 0) {
            return new ArrayList<TransformMessage>(0);
        }
        ArrayList<TransformMessage> results = new ArrayList<TransformMessage>(from.size());
        for (TransformResponse.Notification n : from) {
            results.add(this.translate(n, code, buttons));
        }
        return results;
    }
}

