/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.serialization;

import com.paterva.maltego.imgfactory.serialization.ImageCacheIndex;
import com.paterva.maltego.imgfactory.serialization.ImageCacheIndexStub;
import com.paterva.maltego.imgfactory.serialization.ImageCacheIndexTranslator;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.InputStream;
import java.io.OutputStream;
import org.openide.util.NbPreferences;

public class ImageCacheSerializer {
    private static String ENABLED = "imageCacheSerializerEnabled";

    public static boolean isEnabled() {
        return NbPreferences.forModule(ImageCacheSerializer.class).getBoolean(ENABLED, true);
    }

    public static void setEnabled(boolean enabled) {
        NbPreferences.forModule(ImageCacheSerializer.class).putBoolean(ENABLED, enabled);
    }

    public static void write(ImageCacheIndex index, OutputStream stream) throws XmlSerializationException {
        ImageCacheIndexStub stub = ImageCacheIndexTranslator.translate(index);
        XmlSerializer serializer = new XmlSerializer();
        serializer.write((Object)stub, stream);
    }

    public static ImageCacheIndex read(InputStream stream) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        ImageCacheIndexStub stub = (ImageCacheIndexStub)serializer.read(ImageCacheIndexStub.class, stream);
        if (stub != null) {
            return ImageCacheIndexTranslator.translate(stub);
        }
        return null;
    }
}

