/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.serialization;

import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.graph.serialization.LayoutModeSettings;
import com.paterva.maltego.collab.session.PayloadHelper;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutMode;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutSettings;
import java.util.ArrayList;
import java.util.Collection;

public class LayoutModeSerializer {
    private static final String SHORT_BLOCK = "blk";
    private static final String SHORT_HIERARCHICAL = "hrl";
    private static final String SHORT_CIRCULAR = "cir";
    private static final String SHORT_ORGANIC = "org";
    private static final String SHORT_INTERACTIVE_ORGANIC = "ior";
    private static final String SHORT_LAYOUT_SETTINGS = "ls";

    public String toString(Collection<LayoutModeSettings> lms) {
        StringBuilder sb = new StringBuilder();
        for (LayoutModeSettings lm : lms) {
            sb.append(PayloadHelper.createPayload(SHORT_LAYOUT_SETTINGS, this.toString(lm), true));
        }
        return sb.toString();
    }

    private String toString(LayoutModeSettings lms) {
        StringBuilder sb = new StringBuilder();
        sb.append(lms.getViewName());
        sb.append(",");
        sb.append(this.shorten(lms.getSettings().getMode().getName()));
        sb.append(",");
        sb.append(lms.getSettings().isLayoutAll() ? "1" : "0");
        return sb.toString();
    }

    public Collection<LayoutModeSettings> read(String text) throws CollaborationException {
        ArrayList<LayoutModeSettings> lms = new ArrayList<LayoutModeSettings>();
        Collection<String> tokens = PayloadHelper.splitXml(SHORT_LAYOUT_SETTINGS, text);
        for (String token : tokens) {
            lms.add(this.readOne(PayloadHelper.parsePayload(SHORT_LAYOUT_SETTINGS, token, true)));
        }
        return lms;
    }

    private LayoutModeSettings readOne(String text) throws CollaborationException {
        String[] tokens = text.split(",");
        LayoutModeSettings lms = null;
        if (tokens.length == 3) {
            String viewName = tokens[0];
            LayoutMode mode = LayoutMode.getMode((String)this.lengthen(tokens[1]));
            if (mode != null) {
                boolean layoutAll = !"0".equals(tokens[2]);
                lms = new LayoutModeSettings(viewName, new LayoutSettings(layoutAll, mode));
            }
        }
        if (lms == null) {
            throw new CollaborationException("Invalid layout mode settings: " + text, true);
        }
        return lms;
    }

    public String shorten(String layoutMode) {
        if (LayoutMode.BLOCK.getName().equals(layoutMode)) {
            return SHORT_BLOCK;
        }
        if (LayoutMode.HIERARCHICAL.getName().equals(layoutMode)) {
            return SHORT_HIERARCHICAL;
        }
        if (LayoutMode.CIRCULAR.getName().equals(layoutMode)) {
            return SHORT_CIRCULAR;
        }
        if (LayoutMode.ORGANIC.getName().equals(layoutMode)) {
            return SHORT_ORGANIC;
        }
        if (LayoutMode.INTERACTIVE_ORGANIC.getName().equals(layoutMode)) {
            return SHORT_INTERACTIVE_ORGANIC;
        }
        return layoutMode;
    }

    public String lengthen(String layoutMode) {
        if (SHORT_BLOCK.equals(layoutMode)) {
            return LayoutMode.BLOCK.getName();
        }
        if (SHORT_HIERARCHICAL.equals(layoutMode)) {
            return LayoutMode.HIERARCHICAL.getName();
        }
        if (SHORT_CIRCULAR.equals(layoutMode)) {
            return LayoutMode.CIRCULAR.getName();
        }
        if (SHORT_ORGANIC.equals(layoutMode)) {
            return LayoutMode.ORGANIC.getName();
        }
        if (SHORT_INTERACTIVE_ORGANIC.equals(layoutMode)) {
            return LayoutMode.INTERACTIVE_ORGANIC.getName();
        }
        return layoutMode;
    }
}

