/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.maltego.cloud.data.CloudAttachment;
import com.maltego.cloud.data.CloudAttachments;
import com.maltego.cloud.data.CloudGraphContent;
import com.maltego.cloud.data.Entity;
import com.maltego.cloud.data.Link;
import com.maltego.cloud.data.Property;
import com.maltego.cloud.serializer.NeoJsonAttachments;
import com.maltego.cloud.serializer.NeoSpecialProperty;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.serializers.map.PartMapWriter;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class NeoJsonWriter {
    private final PartMapWriter partMapWriter = new PartMapWriter();
    private final GraphID maltegoGraphId;
    private final String graphName;
    private final Map<Guid, NeoJsonAttachments> attachments;

    public NeoJsonWriter(GraphID graphId, String graphName, Map<Guid, NeoJsonAttachments> attachments) {
        this.maltegoGraphId = graphId;
        this.graphName = graphName;
        this.attachments = attachments;
    }

    public String writeToString() throws JsonProcessingException {
        Map maltegoEntities = GraphStoreHelper.getEntities((GraphID)this.maltegoGraphId);
        ArrayList<Entity> entities = this.toDtoEntities(maltegoEntities);
        ArrayList<Link> links = this.toDtoLinks(maltegoEntities);
        CloudGraphContent graph = new CloudGraphContent(this.graphName, entities, links);
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper.writeValueAsString((Object)graph);
    }

    private ArrayList<Entity> toDtoEntities(Map<EntityID, MaltegoEntity> maltegoEntities) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (MaltegoEntity maltegoEntity : maltegoEntities.values()) {
            Entity entity = this.toDto(maltegoEntity);
            entities.add(entity);
        }
        return entities;
    }

    private ArrayList<Link> toDtoLinks(Map<EntityID, MaltegoEntity> maltegoEntities) {
        Set<EntityID> entityIds = maltegoEntities.keySet();
        Map connectionLinks = GraphStoreHelper.getConnectionLinks((GraphID)this.maltegoGraphId, entityIds);
        ArrayList<Link> links = new ArrayList<Link>();
        for (Map.Entry entry : connectionLinks.entrySet()) {
            MaltegoLink maltegoLink = (MaltegoLink)entry.getKey();
            LinkEntityIDs linkEntities = (LinkEntityIDs)entry.getValue();
            Link link = this.toDto(maltegoLink, linkEntities);
            links.add(link);
        }
        return links;
    }

    private Entity toDto(MaltegoEntity entity) {
        EntityID entityId = (EntityID)entity.getID();
        Entity dto = new Entity();
        dto.setId(entityId.toString());
        dto.setType(entity.getTypeName());
        List<Property> properties = entity.getProperties().stream().filter(property -> !this.isNullOrEmpty(entity.getValue(property))).filter(property -> !NeoSpecialProperty.ATTACHMENTS.getType().equals(property.getType())).map(property -> this.toDto(entity, (PropertyDescriptor)property)).collect(Collectors.toList());
        properties = new ArrayList(properties);
        Integer bookmark = Optional.ofNullable(entity.getBookmarkValue()).map(b -> b >= 0 ? b : null).orElse(null);
        Integer weight = entity.getWeightValue().map(w -> w != 0 ? w : null).orElse(null);
        String notes = entity.getNotes();
        this.addSpecialProperty(properties, NeoSpecialProperty.VALUE, entity.getValuePropertyName());
        this.addSpecialProperty(properties, NeoSpecialProperty.DISPLAY_VALUE, entity.getDisplayValueExpression().orElse(null));
        this.addSpecialProperty(properties, NeoSpecialProperty.BOOKMARK, bookmark);
        this.addSpecialProperty(properties, NeoSpecialProperty.NOTES, notes);
        if (!this.isNullOrEmpty(notes)) {
            this.addSpecialProperty(properties, NeoSpecialProperty.SHOW_NOTES, entity.isShowNotesValue());
        }
        this.addSpecialProperty(properties, NeoSpecialProperty.WEIGHT, weight);
        this.addSpecialProperty(properties, NeoSpecialProperty.IMAGE, this.getImageExpression(entity));
        if (entity.getDisplayInformation() != null && !entity.getDisplayInformation().isEmpty()) {
            ArrayList displayInfo = new ArrayList(entity.getDisplayInformation());
            this.addSpecialProperty(properties, NeoSpecialProperty.DISPLAY_INFO, displayInfo);
        }
        this.addSpecialProperty(properties, NeoSpecialProperty.ATTACHMENTS, this.attachments.get(entityId));
        if (entity.getOverlaySet() != null && !entity.getOverlaySet().isEmpty()) {
            ArrayList overlayDescriptors = new ArrayList(entity.getOverlaySet());
            this.addSpecialProperty(properties, NeoSpecialProperty.OVERLAYS, overlayDescriptors);
        }
        dto.setProperties(properties);
        return dto;
    }

    private Link toDto(MaltegoLink link, LinkEntityIDs linkIDs) {
        LinkID linkId = (LinkID)link.getID();
        Link dto = new Link();
        dto.setId(linkId.toString());
        dto.setFromId(linkIDs.getSourceID().toString());
        dto.setToId(linkIDs.getTargetID().toString());
        List<Property> properties = link.getProperties().stream().filter(property -> !this.isNullOrEmpty(link.getValue(property))).filter(property -> !NeoSpecialProperty.ATTACHMENTS.getType().equals(property.getType())).map(property -> this.toDto(link, (PropertyDescriptor)property)).filter(Objects::nonNull).collect(Collectors.toList());
        properties = new ArrayList(properties);
        this.addSpecialProperty(properties, NeoSpecialProperty.ATTACHMENTS, this.attachments.get(linkId));
        dto.setProperties(properties);
        return dto;
    }

    public String getImageExpression(MaltegoEntity entity) {
        Object value;
        PropertyDescriptor prop;
        String imgExpr = entity.getImageExpression().orElse(null);
        if (imgExpr != null && (prop = entity.getProperties().get(imgExpr)) != null && (value = entity.getValue(prop)) instanceof Attachments) {
            return NeoSpecialProperty.ATTACHMENTS.getId();
        }
        return imgExpr;
    }

    private boolean isNullOrEmpty(Object value) {
        return value instanceof String ? ((String)value).isEmpty() : value == null;
    }

    private Property toDto(MaltegoEntity entity, PropertyDescriptor property) {
        Object value = entity.getValue(property);
        return this.toPropertyDto(property, value);
    }

    private Property toDto(MaltegoLink link, PropertyDescriptor property) {
        Object value = link.getValue(property);
        if (this.partMapWriter.isLinkPropertyDefaultValue((MaltegoPart)link, property)) {
            return null;
        }
        String propId = property.getName();
        if ("maltego.link.color".equals(propId)) {
            return this.toSpecialPropertyDto(NeoSpecialProperty.COLOR, value);
        }
        if ("maltego.link.label".equals(propId) || "maltego.link.manual.type".equals(propId)) {
            return this.toSpecialPropertyDto(NeoSpecialProperty.LABEL, value);
        }
        if ("maltego.link.manual.description".equals(propId)) {
            return this.toSpecialPropertyDto(NeoSpecialProperty.DESCRIPTION, value);
        }
        if ("maltego.link.show-label".equals(propId)) {
            return this.toSpecialPropertyDto(NeoSpecialProperty.SHOW_LABEL, value);
        }
        if ("maltego.link.style".equals(propId)) {
            return this.toSpecialPropertyDto(NeoSpecialProperty.STYLE, value);
        }
        if ("maltego.link.thickness".equals(propId)) {
            return this.toSpecialPropertyDto(NeoSpecialProperty.THICKNESS, value);
        }
        if ("maltego.link.transform.name".equals(propId)) {
            return this.toSpecialPropertyDto(NeoSpecialProperty.TRANSFORM_ID, value);
        }
        if ("maltego.link.transform.display-name".equals(propId)) {
            return this.toSpecialPropertyDto(NeoSpecialProperty.TRANSFORM_NAME, value);
        }
        if ("maltego.link.transform.version".equals(propId)) {
            return this.toSpecialPropertyDto(NeoSpecialProperty.TRANSFORM_VERSION, value);
        }
        if ("maltego.link.transform.run-date".equals(propId)) {
            return this.toSpecialPropertyDto(NeoSpecialProperty.TRANSFORM_DATE, value);
        }
        return this.toPropertyDto(property, value);
    }

    private Property toPropertyDto(PropertyDescriptor property, Object value) {
        Property dto = new Property();
        String propertyId = property.getName();
        String typeId = this.getTypeId(property);
        value = this.toServerSerializationObject(property.getType(), value);
        dto.setId(propertyId);
        dto.setType(typeId);
        dto.setValue(value);
        dto.setHidden(property.isHidden());
        dto.setNullable(property.isNullable());
        dto.setReadonly(property.isReadonly());
        return dto;
    }

    private String getTypeId(PropertyDescriptor property) {
        TypeDescriptor clientType = TypeRegistry.getDefault().getType(property.getType());
        return clientType.getTypeName();
    }

    private void addSpecialProperty(List<Property> properties, NeoSpecialProperty prop, Object value) {
        Property propDto;
        if (!this.isNullOrEmpty(value) && (propDto = this.toSpecialPropertyDto(prop, value)) != null) {
            properties.add(propDto);
        }
    }

    private Property toSpecialPropertyDto(NeoSpecialProperty property, Object value) {
        TypeDescriptor typeDescriptor;
        Property dto = new Property();
        String propertyId = property.getId();
        Class<Integer> type = property.getType();
        Class primitiveType = Converter.getPrimitiveType((Class)type);
        if (primitiveType != null) {
            type = primitiveType;
        }
        if (type.equals(Long.TYPE)) {
            type = Integer.TYPE;
        }
        if ((typeDescriptor = TypeRegistry.getDefault().getType(type)) == null) {
            System.out.println("No type descriptor found for type " + type);
            return null;
        }
        String typeId = typeDescriptor.getTypeName();
        value = value instanceof NeoJsonAttachments ? this.toServerSerializationObject((NeoJsonAttachments)value) : this.toServerSerializationObject(type, value);
        dto.setId(propertyId);
        dto.setType(typeId);
        dto.setValue(value);
        return dto;
    }

    private Object toServerSerializationObject(Class type, Object value) {
        return this.partMapWriter.translateValue(type, value);
    }

    private CloudAttachments toServerSerializationObject(NeoJsonAttachments attachments) {
        int firstIndex;
        Attachments atts = attachments.getAttachments();
        int primaryIndex = firstIndex = attachments.getFirstIndex();
        Attachment primaryAtt = atts.getPrimaryImage();
        if (primaryAtt != null) {
            primaryIndex += atts.indexOf((Object)primaryAtt);
        }
        ArrayList<CloudAttachment> cloudAttachmentList = new ArrayList<CloudAttachment>();
        int attIndex = firstIndex;
        for (Attachment att : atts) {
            String fileName = att.getFileName();
            String source = att.getSource().toString();
            CloudAttachment cloudAttachment = new CloudAttachment(attIndex++, fileName, source);
            cloudAttachmentList.add(cloudAttachment);
        }
        return new CloudAttachments(primaryIndex, cloudAttachmentList);
    }
}

