/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.maltego.cloud.CloudAuth;
import com.maltego.cloud.data.Case;
import com.maltego.cloud.data.CaseKey;
import com.maltego.cloud.data.GraphHistory;
import com.maltego.cloud.data.GraphKey;
import com.maltego.cloud.data.KeyPair;
import com.maltego.cloud.data.NewCase;
import com.maltego.cloud.data.OrganizationSettings;
import com.maltego.cloud.rest.CheckedConsumer;
import com.maltego.cloud.rest.GraphStoreRestError;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.certificates.rest.MultipartWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class GraphStoreRestClient {
    private static final Logger LOG = Logger.getLogger(GraphStoreRestClient.class.getName());
    private static final int TIMEOUT_MILLIS = 15000;
    private static final Map<Integer, String> FALLBACK_ERROR_MESSAGES = new HashMap<Integer, String>();

    public static KeyPair fetchKeyPair() throws IOException {
        LOG.log(Level.INFO, "Sending fetch keypair request");
        KeyPair[] values = GraphStoreRestClient.fetchFromCloud("key-pairs", KeyPair[].class);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public static void createNewCase(NewCase newCase) throws IOException {
        LOG.log(Level.INFO, "Sending create new case request");
        CloudAuth cloudAuth = CloudAuth.getDefault();
        HttpAgent httpAgent = GraphStoreRestClient.createHttpAgent(cloudAuth, cloudAuth.getCloudSyncUrl() + "/cases");
        String requestBody = new ObjectMapper().writeValueAsString((Object)newCase);
        httpAgent.doPost("application/json", requestBody);
        GraphStoreRestClient.getResponseBody(httpAgent);
    }

    public static Case[] fetchCaseList() throws IOException {
        LOG.log(Level.INFO, "Sending fetch case list request");
        return GraphStoreRestClient.fetchFromCloud("cases", Case[].class);
    }

    public static Case fetchCase(String caseId) throws IOException {
        LOG.log(Level.INFO, "Sending fetch case request");
        return GraphStoreRestClient.fetchFromCloud("cases/" + caseId, Case.class);
    }

    public static CaseKey fetchCaseKey(String caseId) throws IOException {
        LOG.log(Level.INFO, "Sending fetch case key for case {0}", caseId);
        return GraphStoreRestClient.fetchFromCloud("cases/" + caseId + "/case-keys", CaseKey.class);
    }

    public static GraphKey fetchGraphKey(String caseId, String graphId) throws IOException {
        LOG.log(Level.INFO, "Sending fetch graph key for graph {0} of case {1}", new Object[]{graphId, caseId});
        return GraphStoreRestClient.fetchFromCloud("cases/" + caseId + "/graphs/" + graphId + "/graph-key", GraphKey.class);
    }

    public static GraphHistory fetchGraphHistory(String graphId) throws IOException {
        LOG.log(Level.INFO, "Sending fetch graph history for graph {0}", graphId);
        GraphHistory[] historyArray = GraphStoreRestClient.fetchFromCloud("graphs/" + graphId + "/history", GraphHistory[].class);
        if (historyArray.length == 0) {
            return null;
        }
        GraphHistory result = historyArray[0];
        for (int i = 1; i < historyArray.length; ++i) {
            boolean isArrayItemUpdatedMoreRecentlyThanCurrent = historyArray[i].getUpdatedAt().after(result.getUpdatedAt());
            if (!isArrayItemUpdatedMoreRecentlyThanCurrent) continue;
            result = historyArray[i];
        }
        return result;
    }

    public static String fetchCloudGraphJson(String graphId, String version) throws IOException {
        LOG.log(Level.INFO, "Sending fetch cloud graph json for graph {0} of version {1}", new Object[]{graphId, version});
        CloudAuth cloudAuth = CloudAuth.getDefault();
        HttpAgent httpAgent = GraphStoreRestClient.createGraphContentReadingHttpAgent(cloudAuth, cloudAuth.getCloudSyncUrl() + "/graphs/" + graphId + "/content/blob" + (version == null ? "" : "?versionId=" + version));
        httpAgent.setAcceptContentType("application/json");
        httpAgent.doGet();
        return GraphStoreRestClient.getResponseBody(httpAgent);
    }

    public static byte[] fetchCloudGraphAttachments(String graphId, int attachmentNo, String version) throws IOException {
        LOG.log(Level.INFO, "Sending fetch cloud graph attachment {0} for graph {1} of version {2}", new Object[]{attachmentNo, graphId, version});
        CloudAuth cloudAuth = CloudAuth.getDefault();
        HttpAgent httpAgent = GraphStoreRestClient.createGraphContentReadingHttpAgent(cloudAuth, cloudAuth.getCloudSyncUrl() + "/graphs/" + graphId + "/content/attachments/" + attachmentNo + (version == null ? "" : "?versionId=" + version));
        httpAgent.setAcceptContentType("text/plain");
        httpAgent.doGet();
        try (InputStream is = httpAgent.getInputStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }

    public static OrganizationSettings fetchOrganizationSettings() throws IOException {
        LOG.log(Level.INFO, "Sending fetch organization settings request");
        return GraphStoreRestClient.fetchFromCloud("encryption/settings", OrganizationSettings.class);
    }

    private static <T> T fetchFromCloud(String urlPath, Class<T> clazz) throws IOException {
        CloudAuth cloudAuth = CloudAuth.getDefault();
        HttpAgent httpAgent = GraphStoreRestClient.createHttpAgent(cloudAuth, cloudAuth.getCloudSyncUrl() + "/" + urlPath);
        httpAgent.doGet();
        String response = GraphStoreRestClient.getResponseBody(httpAgent);
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.readValue(response, clazz);
    }

    public static String createSendGraphWriter(boolean isNewGraph, String graphId, CheckedConsumer<MultipartWriter, IOException> contentWriterHook) throws IOException {
        LOG.log(Level.INFO, "Creating send graph writer for graph {0}", graphId);
        CloudAuth cloudAuth = CloudAuth.getDefault();
        URL url = new URL(cloudAuth.getCloudSyncUrl() + "/graphs/" + graphId + "/content/blob");
        try (MultipartWriter writer = new MultipartWriter(url);){
            String accessToken = cloudAuth.getAccessTokenString();
            writer.getHttpAgent().setAccessToken(accessToken);
            contentWriterHook.accept(writer);
            HttpAgent agent = writer.send(isNewGraph);
            String string = GraphStoreRestClient.getResponseBody(agent);
            return string;
        }
    }

    private static HttpAgent createHttpAgent(CloudAuth cloudAuth, String urlStr) throws MalformedURLException {
        String accessToken = cloudAuth.getAccessTokenString();
        URL url = new URL(urlStr);
        HttpAgent httpAgent = new HttpAgent(url);
        httpAgent.setConnectTimeout(15000);
        httpAgent.setReadTimeout(15000);
        httpAgent.setAccessToken(accessToken);
        return httpAgent;
    }

    private static HttpAgent createGraphContentReadingHttpAgent(CloudAuth cloudAuth, String urlStr) throws MalformedURLException {
        String accessToken = cloudAuth.getAccessTokenString();
        URL url = new URL(urlStr);
        HttpAgent httpAgent = new HttpAgent(url);
        httpAgent.setConnectTimeout(15000);
        httpAgent.setAccessToken(accessToken);
        return httpAgent;
    }

    private static String getResponseBody(HttpAgent httpAgent) throws IOException {
        int responseCode = httpAgent.getResponseCode();
        if (responseCode >= 200 && responseCode < 300) {
            return httpAgent.getContentAsString();
        }
        if (responseCode >= 400 && responseCode < 600) {
            String message;
            String errorAsString = httpAgent.getErrorAsString();
            LOG.log(Level.WARNING, "Http request failed. Error code: {0}\nError body: {1}", new Object[]{responseCode, errorAsString});
            GraphStoreRestError restError = GraphStoreRestClient.parseErrorResponseJson(errorAsString);
            if (restError == null) {
                message = FALLBACK_ERROR_MESSAGES.get(responseCode);
                if (message == null) {
                    message = "Http request failed";
                }
            } else {
                message = restError.getDetail();
            }
            message = message + ". Error code: " + responseCode;
            throw new IOException(message);
        }
        String message = "Http request failed";
        try {
            String contentAsString = httpAgent.getContentAsString();
            message = message + ". Error: " + contentAsString;
        }
        catch (IOException e) {
            message = message + ". Error: " + e.getMessage();
        }
        throw new IOException(message);
    }

    private static GraphStoreRestError parseErrorResponseJson(String errorAsString) {
        if (errorAsString == null) {
            return null;
        }
        try {
            return (GraphStoreRestError)new ObjectMapper().readValue(errorAsString, GraphStoreRestError.class);
        }
        catch (JsonProcessingException ex) {
            return null;
        }
    }

    static {
        FALLBACK_ERROR_MESSAGES.put(401, "Unauthorized");
        FALLBACK_ERROR_MESSAGES.put(403, "Forbidden");
        FALLBACK_ERROR_MESSAGES.put(404, "Not found");
        FALLBACK_ERROR_MESSAGES.put(409, "Conflict");
        FALLBACK_ERROR_MESSAGES.put(413, "Would exceed size limit for graph save request");
        FALLBACK_ERROR_MESSAGES.put(422, "Unprocessable Entity");
        FALLBACK_ERROR_MESSAGES.put(503, "Service Temporarily Unavailable");
    }
}

