/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud;

import com.maltego.cloud.data.Case;
import com.paterva.maltego.core.GraphID;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class CloudGraph {
    public static final String CLOUD_SYMBOL = "\u2601 ";
    private final GraphID maltegoGraphID;
    private final GraphID cloudGraphID;
    private String version;
    private final Boolean editable;
    private String name;
    private final String displayName;
    private final InstanceContent ic;
    private final Lookup lookup;
    private Case cloudCase;

    public CloudGraph(GraphID graphID, String name, Boolean editable) {
        this(graphID, graphID, null, name, editable, null);
    }

    public CloudGraph(GraphID maltegoGraphID, GraphID cloudGraphID, String version, String name, Boolean editable, String displayName) {
        this.maltegoGraphID = maltegoGraphID;
        this.cloudGraphID = cloudGraphID;
        this.version = version;
        this.name = name;
        this.editable = editable;
        this.displayName = displayName;
        this.ic = new InstanceContent();
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.ic);
    }

    public void addToLookup(Object content) {
        this.ic.add(content);
    }

    public <T> T getContentFromLookup(Class<T> contentType) {
        return (T)this.lookup.lookup(contentType);
    }

    public void removeFromLookup(Object content) {
        this.ic.remove(content);
    }

    public GraphID getMaltegoGraphID() {
        return this.maltegoGraphID;
    }

    public GraphID getCloudGraphId() {
        return this.cloudGraphID;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean isEditable() {
        return this.editable;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Case getCase() {
        return this.cloudCase;
    }

    public void setCase(Case cloudCase) {
        this.cloudCase = cloudCase;
    }
}

