/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.laf;

import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.ui.fonts.FontUtils;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import java.awt.Color;
import java.awt.Font;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class MaltegoLAF {
    public static final Color DEFAULT_COLOR = Color.RED;
    private static final Logger LOGGER = Logger.getLogger(MaltegoLAF.class.getName());
    private static MaltegoLAF _default;
    private static UIDefaults _lookAndFeelDefaults;

    public static boolean isColor(String rawStr) {
        return rawStr != null && rawStr.length() > 6 && (rawStr.startsWith("#") || rawStr.startsWith("[") && rawStr.toLowerCase().contains("color"));
    }

    public static synchronized MaltegoLAF getDefault() {
        if (_default == null && (_default = (MaltegoLAF)Lookup.getDefault().lookup(MaltegoLAF.class)) == null) {
            _default = new Cached(new Safe(new GroovyEnabledResource()));
        }
        return _default;
    }

    public static synchronized UIDefaults getLookAndFeelDefaults() {
        if (_lookAndFeelDefaults == null) {
            _lookAndFeelDefaults = UIManager.getLookAndFeelDefaults();
        }
        return _lookAndFeelDefaults;
    }

    public static synchronized void updateLookAndFeelDefaults() {
        for (Map.Entry entrySet : UIManager.getLookAndFeelDefaults().entrySet()) {
            Object key = entrySet.getKey();
            Object value = entrySet.getValue();
            MaltegoLAF.getLookAndFeelDefaults().put(key, value);
        }
    }

    public abstract Set<String> getKeys();

    public abstract String getRawString(String var1);

    public abstract void setRawString(String var1, String var2);

    public abstract String getCompiledString(String var1);

    public abstract void reset();

    public abstract void reset(String var1);

    public abstract String getString(String var1);

    public Color getColor(String key) {
        return this.getColor(key, true);
    }

    public abstract Color getColor(String var1, boolean var2);

    public abstract Font getFont(String var1);

    public abstract Font getFontScaled(String var1);

    public abstract Integer getInt(String var1);

    public abstract Float getFloat(String var1);

    static {
        _lookAndFeelDefaults = null;
    }

    protected static class Cached
    extends MaltegoLAF {
        private final MaltegoLAF _delegate;
        private final Map<String, Object> _cache = new HashMap<String, Object>();
        private final Map<String, String> _compiledCache = new HashMap<String, String>();
        private final Map<String, Font> _scaledFontCache = new HashMap<String, Font>();

        public Cached(MaltegoLAF delegate) {
            this._delegate = delegate;
        }

        @Override
        public Set<String> getKeys() {
            return this._delegate.getKeys();
        }

        @Override
        public String getRawString(String key) {
            return this._delegate.getRawString(key);
        }

        @Override
        public void setRawString(String key, String value) {
            this._delegate.setRawString(key, value);
            if (key.contains("debug-pink")) {
                this._cache.clear();
                this._compiledCache.clear();
                this._scaledFontCache.clear();
            } else {
                this.removeAllDependent(key);
            }
        }

        private void removeAllDependent(String key) {
            HashSet<String> removed;
            HashSet<String> lastRemoved = new HashSet<String>();
            lastRemoved.add(key);
            this._cache.remove(key);
            this._compiledCache.remove(key);
            do {
                removed = new HashSet<String>();
                Iterator<Map.Entry<String, Object>> itr = this._cache.entrySet().iterator();
                block1: while (itr.hasNext()) {
                    Map.Entry<String, Object> entry = itr.next();
                    String entryKey = entry.getKey();
                    String entryScript = this.getRawString(entryKey);
                    for (String script : lastRemoved) {
                        if (!entryScript.contains(script)) continue;
                        itr.remove();
                        this._compiledCache.remove(entryKey);
                        this._scaledFontCache.remove(entryKey);
                        removed.add(entryKey);
                        continue block1;
                    }
                }
                lastRemoved = removed;
            } while (!removed.isEmpty());
        }

        @Override
        public void reset() {
            this._delegate.reset();
            this._cache.clear();
            this._compiledCache.clear();
            this._scaledFontCache.clear();
        }

        @Override
        public void reset(String key) {
            this._delegate.reset(key);
            this._cache.clear();
            this._compiledCache.clear();
            this._scaledFontCache.clear();
        }

        @Override
        public String getString(String key) {
            Object obj = this.get(key);
            if (obj == null) {
                obj = this._delegate.getString(key);
                this.put(obj, key);
            }
            return obj.toString();
        }

        @Override
        public Color getColor(String key, boolean cache) {
            Object obj = this.get(key);
            if (!(obj instanceof Color)) {
                obj = this._delegate.getColor(key, cache);
                if (cache) {
                    this.put(obj, key);
                }
            }
            return (Color)obj;
        }

        @Override
        public Font getFont(String key) {
            Object obj = this.get(key);
            if (obj == null) {
                obj = this._delegate.getFont(key);
                this.put(obj, key);
            }
            return (Font)obj;
        }

        @Override
        public Font getFontScaled(String key) {
            Font font = this._scaledFontCache.get(key);
            if (font == null) {
                font = this._delegate.getFontScaled(key);
                this._scaledFontCache.put(key, font);
            }
            return font;
        }

        @Override
        public Integer getInt(String key) {
            Object obj = this.get(key);
            if (obj == null) {
                obj = this._delegate.getInt(key);
                this.put(obj, key);
            }
            return (Integer)obj;
        }

        @Override
        public Float getFloat(String key) {
            Object obj = this.get(key);
            if (obj == null) {
                obj = this._delegate.getFloat(key);
                this.put(obj, key);
            }
            return (Float)obj;
        }

        private Object get(String key) {
            return this._cache.get(key);
        }

        private void put(Object obj, String key) {
            if (obj != null) {
                this._cache.put(key, obj);
            }
        }

        @Override
        public String getCompiledString(String key) {
            String compiled = this._compiledCache.get(key);
            if (compiled == null) {
                compiled = this._delegate.getCompiledString(key);
                this._compiledCache.put(key, compiled);
            }
            return compiled;
        }
    }

    protected static class GroovyEnabledResource
    extends Resource {
        protected GroovyEnabledResource() {
        }

        @Override
        public String getString(String key) {
            String value = super.getString(key);
            String result = this.getGroovyResult(value, String.class);
            if (result != null) {
                value = result;
            }
            return value;
        }

        @Override
        public Color getColor(String key, boolean cache) {
            String value = ((Resource)this).getRawString(key, cache);
            Color result = this.getGroovyResult(value, Color.class);
            if (result == null) {
                result = this.parseColor(value);
            }
            if ("true".equalsIgnoreCase(this.getString("1-debug-pink"))) {
                int red = 155 * result.getRed() / 255 + 100;
                int blue = 155 * result.getBlue() / 255 + 100;
                result = new Color(red, 0, blue, result.getAlpha());
            }
            return result;
        }

        @Override
        public Font getFont(String key) {
            String value = super.getString(key);
            Font result = this.getGroovyResult(value, Font.class);
            if (result == null) {
                result = this.parseFont(value);
            }
            return result;
        }

        @Override
        public Integer getInt(String key) {
            String value = super.getString(key);
            Integer result = this.getGroovyResult(value, Integer.class);
            if (result == null) {
                result = this.parseInt(value);
            }
            return result;
        }

        @Override
        public Float getFloat(String key) {
            String value = super.getString(key);
            Float result = this.getGroovyResult(value, Float.class);
            if (result == null) {
                result = this.parseFloat(value);
            }
            return result;
        }

        private String getGroovyValue(String propName) {
            String value = super.getString(propName);
            Object result = this.getGroovyResult(value);
            if (result != null) {
                if (result instanceof Font) {
                    Font temp = (Font)result;
                    int fontStyle = temp.getStyle();
                    String style = fontStyle == 1 ? "Bold" : (fontStyle == 2 ? "Italic" : (fontStyle == 0 ? "Plain" : "BoldItalic"));
                    return temp.getFamily() + "-" + style + "-" + temp.getSize();
                }
                if (result instanceof Color) {
                    Color temp = (Color)result;
                    int alpha = temp.getAlpha();
                    String tempValue = ColorUtilities.encode((Color)temp).toUpperCase();
                    if (alpha != 255) {
                        tempValue = tempValue + String.format("%02X", alpha).toUpperCase();
                    }
                    if ("true".equalsIgnoreCase(this.getString("1-debug-pink"))) {
                        tempValue = this.getPinkColor(tempValue);
                    }
                    return tempValue;
                }
                value = result.toString();
            }
            if (MaltegoLAF.isColor(value) && "true".equalsIgnoreCase(this.getString("1-debug-pink"))) {
                value = this.getPinkColor(value);
            }
            return value;
        }

        private String getPinkColor(String value) {
            Color resultsColor = this.parseColor(value);
            int red = 155 * resultsColor.getRed() / 255 + 100;
            int blue = 155 * resultsColor.getBlue() / 255 + 100;
            resultsColor = new Color(red, 0, blue, resultsColor.getAlpha());
            int alpha = resultsColor.getAlpha();
            String tempValue = ColorUtilities.encode((Color)resultsColor).toUpperCase();
            if (alpha != 255) {
                tempValue = tempValue + String.format("%02X", alpha).toUpperCase();
            }
            return tempValue;
        }

        @Override
        public String getCompiledString(String key) {
            return this.getGroovyValue(key);
        }

        private <T> T getGroovyResult(String strValue, Class<T> type) {
            Object value = null;
            Object groovyObj = this.getGroovyResult(strValue);
            if (groovyObj != null) {
                if (type.isAssignableFrom(groovyObj.getClass())) {
                    value = groovyObj;
                } else {
                    String msg = String.format("Groovy result is not of type %s: %s (%s)", type, groovyObj, groovyObj.getClass());
                    LOGGER.warning(msg);
                }
            }
            return (T)value;
        }

        private Object getGroovyResult(String value) {
            Object obj = null;
            if (value != null && value.startsWith("[") && value.endsWith("]")) {
                String script = value.substring(1, value.length() - 1);
                Binding binding = new Binding(Collections.singletonMap("bundle", MaltegoLAF.getDefault()));
                ImportCustomizer importCustomizer = new ImportCustomizer();
                importCustomizer.addStarImports(new String[]{"java.awt", "javax.swing", "com.paterva.maltego.util", "com.paterva.maltego.util.ui.laf"});
                CompilerConfiguration compilerConfig = new CompilerConfiguration();
                compilerConfig.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
                ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                GroovyClassLoader gcl = new GroovyClassLoader(classLoader, compilerConfig);
                GroovyShell shell = new GroovyShell((ClassLoader)gcl, binding, compilerConfig);
                StringBuilder sb = new StringBuilder();
                sb.append("def getString(p) {bundle.getString(p)}\n");
                sb.append("def getColor(p) {bundle.getColor(p)}\n");
                sb.append("def getFont(p) {bundle.getFont(p)}\n");
                sb.append("def getInt(p) {bundle.getInt(p)}\n");
                sb.append("def getFloat(p) {bundle.getFloat(p)}\n");
                sb.append(script);
                obj = shell.evaluate(sb.toString());
            }
            return obj;
        }
    }

    public static class Resource
    extends MaltegoLAF {
        private final Map<String, String> _cache = new HashMap<String, String>();
        private final ResourceBundle _bundle = NbBundle.getBundle(this.getClass());
        private Set<String> _keys;

        @Override
        public synchronized Set<String> getKeys() {
            if (this._keys == null) {
                this._keys = new TreeSet<String>(this._bundle.keySet());
            }
            return this._keys;
        }

        @Override
        public String getRawString(String key) {
            return this.getRawString(key, true);
        }

        private String getRawString(String key, boolean cache) {
            String value = this._cache.get(key);
            if (value == null && (value = this._bundle.getString(key)) != null) {
                value = value.trim();
                if (cache) {
                    this._cache.put(key, value);
                }
            }
            return value;
        }

        @Override
        public void setRawString(String key, String value) {
            this._cache.put(key, value);
        }

        @Override
        public void reset() {
            this._cache.clear();
        }

        @Override
        public void reset(String key) {
            this._cache.remove(key);
        }

        @Override
        public String getString(String key) {
            return this.getRawString(key);
        }

        @Override
        public Color getColor(String key, boolean cache) {
            String value = this.getRawString(key, cache);
            return this.parseColor(value);
        }

        protected Color parseColor(String value) {
            Color color = null;
            if (value != null) {
                try {
                    if (!value.startsWith("#")) {
                        value = "#" + value;
                    }
                    color = this.decodeColor(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return color;
        }

        private Color decodeColor(String value) {
            if (value.length() == 4) {
                return new Color(17 * Integer.valueOf(String.valueOf(value.charAt(1)), 16), 17 * Integer.valueOf(String.valueOf(value.charAt(2)), 16), 17 * Integer.valueOf(String.valueOf(value.charAt(3)), 16));
            }
            if (value.length() == 5) {
                return new Color(17 * Integer.valueOf(String.valueOf(value.charAt(1)), 16), 17 * Integer.valueOf(String.valueOf(value.charAt(2)), 16), 17 * Integer.valueOf(String.valueOf(value.charAt(3)), 16), 17 * Integer.valueOf(String.valueOf(value.charAt(4)), 16));
            }
            if (value.length() == 7) {
                return Color.decode(value);
            }
            if (value.length() == 9) {
                Color opaque = Color.decode(value.substring(0, 7));
                return new Color(opaque.getRed(), opaque.getGreen(), opaque.getBlue(), Integer.parseInt(value.substring(7, 9), 16));
            }
            return null;
        }

        @Override
        public Font getFont(String key) {
            String value = this.getString(key);
            return this.parseFont(value);
        }

        @Override
        public Font getFontScaled(String key) {
            Font font = this.getFont(key);
            if (font != null) {
                font = FontUtils.scale(font);
            }
            return font;
        }

        protected Font parseFont(String value) {
            Font font = null;
            if (value != null) {
                font = Font.decode(value);
            }
            return font;
        }

        @Override
        public Integer getInt(String key) {
            String value = this.getString(key);
            return this.parseInt(value);
        }

        protected Integer parseInt(String value) {
            Integer i = null;
            if (value != null) {
                try {
                    i = Integer.decode(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return i;
        }

        @Override
        public Float getFloat(String key) {
            String value = this.getString(key);
            return this.parseFloat(value);
        }

        protected Float parseFloat(String value) {
            Float f = null;
            if (value != null) {
                try {
                    f = Float.valueOf(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return f;
        }

        @Override
        public String getCompiledString(String key) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    protected static class Safe
    extends MaltegoLAF {
        private MaltegoLAF _delegate;

        public Safe() {
            this(Safe.getDefault());
        }

        public Safe(MaltegoLAF delegate) {
            this._delegate = delegate;
        }

        @Override
        public Set<String> getKeys() {
            return this._delegate.getKeys();
        }

        @Override
        public String getRawString(String key) {
            return this._delegate.getRawString(key);
        }

        @Override
        public void setRawString(String key, String value) {
            this._delegate.setRawString(key, value);
        }

        @Override
        public void reset() {
            this._delegate.reset();
        }

        @Override
        public void reset(String key) {
            this._delegate.reset(key);
        }

        @Override
        public String getString(String key) {
            String value = null;
            try {
                value = this._delegate.getString(key);
            }
            catch (MissingResourceException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return value;
        }

        @Override
        public Color getColor(String key, boolean cache) {
            Color color = null;
            try {
                color = this._delegate.getColor(key, cache);
            }
            catch (MissingResourceException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return color != null ? color : DEFAULT_COLOR;
        }

        @Override
        public Font getFont(String key) {
            Font font = null;
            try {
                font = this._delegate.getFont(key);
            }
            catch (MissingResourceException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return font != null ? font : new JLabel().getFont();
        }

        @Override
        public Font getFontScaled(String key) {
            Font font = null;
            try {
                font = this._delegate.getFontScaled(key);
            }
            catch (MissingResourceException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return font != null ? font : new JLabel().getFont();
        }

        @Override
        public Integer getInt(String key) {
            Integer i = null;
            try {
                i = this._delegate.getInt(key);
            }
            catch (MissingResourceException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return i != null ? i : 0;
        }

        @Override
        public Float getFloat(String key) {
            Float f = null;
            try {
                f = this._delegate.getFloat(key);
            }
            catch (MissingResourceException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return Float.valueOf(f != null ? f.floatValue() : 0.0f);
        }

        @Override
        public String getCompiledString(String key) {
            return this._delegate.getCompiledString(key);
        }
    }
}

