/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.org.jline.style;

import java.util.function.Function;

public final class InterpolationHelper {
    private static final char ESCAPE_CHAR = '\\';
    private static final String DELIM_START = "@{";
    private static final String DELIM_STOP = "}";
    private static final String MARKER = "@__";

    private InterpolationHelper() {
    }

    public static String substVars(String val, Function<String, String> callback, boolean defaultsToEmptyString) throws IllegalArgumentException {
        return InterpolationHelper.unescape(InterpolationHelper.doSubstVars(val, callback, defaultsToEmptyString));
    }

    private static String doSubstVars(String val, Function<String, String> callback, boolean defaultsToEmptyString) throws IllegalArgumentException {
        int startDelim;
        int stopDelim = -1;
        do {
            int idx;
            stopDelim = val.indexOf(DELIM_STOP, stopDelim + 1);
            while (stopDelim > 0 && val.charAt(stopDelim - 1) == '\\') {
                stopDelim = val.indexOf(DELIM_STOP, stopDelim + 1);
            }
            startDelim = val.indexOf(DELIM_START);
            while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
                if (idx >= stopDelim) continue;
                startDelim = idx;
            }
        } while (startDelim >= 0 && stopDelim >= 0 && stopDelim < startDelim + DELIM_START.length());
        if (startDelim < 0 || stopDelim < 0) {
            return val;
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        String substValue = null;
        if (variable.length() > 0 && callback != null) {
            substValue = callback.apply(variable);
        }
        if (substValue == null) {
            substValue = defaultsToEmptyString ? "" : "@__{" + variable + DELIM_STOP;
        }
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = InterpolationHelper.doSubstVars(val, callback, defaultsToEmptyString);
        return val;
    }

    private static String unescape(String val) {
        val = val.replaceAll(MARKER, "@");
        int escape = val.indexOf(92);
        while (escape >= 0 && escape < val.length() - 1) {
            char c = val.charAt(escape + 1);
            if (c == '{' || c == '}' || c == '\\') {
                val = val.substring(0, escape) + val.substring(escape + 1);
            }
            escape = val.indexOf(92, escape + 1);
        }
        return val;
    }
}

