/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.previous;

import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.importexport.previous.PreviousConfigDirs;
import com.paterva.maltego.importexport.previous.PreviousConfigs;
import com.paterva.maltego.importexport.wizard.im.ImportWizard;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeMap;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class PreviousConfigImporter {
    private static final String TITLE = "Previous Configuration Found";

    public void show() throws IOException {
        ConfigImporter[] importers;
        File prevConfDir = PreviousConfigDirs.detectLatest();
        if (prevConfDir != null && (importers = ConfigImporter.getAll(Lookup.getDefault())).length > 0) {
            String msg = "Do you want to import your previous configuration from:\n" + prevConfDir + "?";
            msg = msg + "\n\nYou can also do this later by using the Migration Wizard (Application menu->Import).";
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, TITLE);
            if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                try {
                    prevConfDir = new File(prevConfDir, "config");
                    FileObject configRoot = PreviousConfigs.createConfigRoot(prevConfDir);
                    TreeMap<Config, ConfigImporter> configsMap = PreviousConfigs.loadConfigs(importers, configRoot);
                    this.showWizard(configsMap);
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void showWizard(TreeMap<Config, ConfigImporter> configsMap) {
        if (!configsMap.isEmpty()) {
            HashMap<String, String> descriptionAndIcons = new HashMap<String, String>();
            descriptionAndIcons.put("item_selection_description", "Select the configuration items you which to import from the old Maltego version.");
            descriptionAndIcons.put("item_selection_icon", "com/paterva/maltego/importexport/resources/Migration.png");
            descriptionAndIcons.put("progress_description", "The summary of the progress to import configurations from an old Maltego version is shown below.");
            descriptionAndIcons.put("progress_icon", "com/paterva/maltego/importexport/resources/Migration.png");
            WizardUtilities.runWizard((WizardDescriptor)ImportWizard.create(configsMap, descriptionAndIcons));
        } else {
            String m = "No items found";
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)m);
            descriptor.setTitle(TITLE);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        }
    }
}

