/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3;

import com.paterva.maltego.discovery.DiscoveryMergingRules;
import com.paterva.maltego.json.discovery.JsonDiscoveryContext;
import com.paterva.maltego.json.discovery.JsonDiscoveryProvider;
import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.discovery.TransformServerDetail;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.discovery.TransformServerListingProvider;
import com.paterva.maltego.util.FastURL;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;

public class JsonDiscoveryListingProvider
extends TransformServerListingProvider {
    private static final Logger LOG = Logger.getLogger(JsonDiscoveryListingProvider.class.getName());

    public ProtocolVersion protocolVersion() {
        return ProtocolVersion.V3_1;
    }

    public void update(TransformServerDetail serverDetail, TransformServerListing listing) throws Exception {
        if (serverDetail.getV3Url() == null) {
            return;
        }
        String seedUrl = serverDetail.getSeedUrl();
        String v3Url = serverDetail.getV3Url().toString();
        boolean overwriteConfig = serverDetail.isOverwriteConfig();
        DiscoveryMergingRules rules = DiscoveryMergingRules.getDefault();
        FastURL mtzUrl = serverDetail.getBaseUrl();
        String host = mtzUrl.getURL().getHost().toLowerCase();
        if (overwriteConfig && (host.equals("maltego.com") || host.endsWith(".maltego.com") || host.equals("paterva.com") || host.endsWith(".paterva.com") || host.equals("127.0.0.1") || host.equals("localhost"))) {
            rules = new DiscoveryMergingRules.Replace();
        }
        JsonDiscoveryContext ctx = new JsonDiscoveryContext(v3Url, seedUrl, rules);
        Set items = listing.getMtzDiscoveryItems();
        Collection providers = JsonDiscoveryProvider.getAll();
        for (JsonDiscoveryProvider provider : providers) {
            items.add(provider.fetch(ctx));
        }
    }
}

