/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.ribbon;

import com.paterva.maltego.util.IconSize;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RolloverActionListener;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryFooter;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryPrimary;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.BasicRibbonApplicationMenuPopupPanelUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanelSecondary;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class OfficeRibbonApplicationMenuPopupPanelUI
extends BasicRibbonApplicationMenuPopupPanelUI {
    public static ComponentUI createUI(JComponent c) {
        return new OfficeRibbonApplicationMenuPopupPanelUI();
    }

    protected void installComponents() {
        this.mainPanel = this.createMainPanel();
        this.mainPanel.setBorder(null);
        this.panelLevel1 = new JPanel();
        this.panelLevel1.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int height = 0;
                int width = 0;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Dimension pref = parent.getComponent(i).getPreferredSize();
                    height += pref.height;
                    width = Math.max(width, pref.width);
                }
                Insets ins = parent.getInsets();
                return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public void layoutContainer(Container parent) {
                Insets ins = parent.getInsets();
                int topY = ins.top;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Component comp = parent.getComponent(i);
                    Dimension pref = comp.getPreferredSize();
                    comp.setBounds(ins.left, topY, parent.getWidth() - ins.left - ins.right, pref.height);
                    topY += pref.height;
                }
            }
        });
        final RibbonApplicationMenu ribbonAppMenu = this.applicationMenuPopupPanel.getRibbonAppMenu();
        int secondaryLevelHeight = 0;
        if (ribbonAppMenu != null) {
            List primaryEntries = ribbonAppMenu.getPrimaryEntries();
            int primaryGroupCount = primaryEntries.size();
            for (int i = 0; i < primaryGroupCount; ++i) {
                for (final RibbonApplicationMenuEntryPrimary menuEntry : (List)primaryEntries.get(i)) {
                    final JCommandMenuButton commandButton = new JCommandMenuButton(menuEntry.getText(), menuEntry.getIcon());
                    commandButton.setCommandButtonKind(menuEntry.getEntryKind());
                    commandButton.addActionListener(menuEntry.getMainActionListener());
                    commandButton.setActionKeyTip(menuEntry.getActionKeyTip());
                    commandButton.setPopupKeyTip(menuEntry.getPopupKeyTip());
                    if (menuEntry.getDisabledIcon() != null) {
                        commandButton.setDisabledIcon(menuEntry.getDisabledIcon());
                    }
                    if (menuEntry.getSecondaryGroupCount() == 0) {
                        commandButton.addRolloverActionListener(new RolloverActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback callback = menuEntry.getRolloverCallback();
                                if (callback != null) {
                                    callback.menuEntryActivated(OfficeRibbonApplicationMenuPopupPanelUI.this.panelLevel2);
                                } else {
                                    RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback defaultCallback = ribbonAppMenu.getDefaultCallback();
                                    if (defaultCallback != null) {
                                        defaultCallback.menuEntryActivated(OfficeRibbonApplicationMenuPopupPanelUI.this.panelLevel2);
                                    } else {
                                        OfficeRibbonApplicationMenuPopupPanelUI.this.panelLevel2.removeAll();
                                        OfficeRibbonApplicationMenuPopupPanelUI.this.panelLevel2.revalidate();
                                        OfficeRibbonApplicationMenuPopupPanelUI.this.panelLevel2.repaint();
                                    }
                                }
                                OfficeRibbonApplicationMenuPopupPanelUI.this.panelLevel2.applyComponentOrientation(OfficeRibbonApplicationMenuPopupPanelUI.this.applicationMenuPopupPanel.getComponentOrientation());
                            }
                        });
                    } else {
                        JRibbonApplicationMenuPopupPanelSecondary secondary = new JRibbonApplicationMenuPopupPanelSecondary(menuEntry);
                        if (secondary.getPreferredSize().height > secondaryLevelHeight) {
                            secondaryLevelHeight = secondary.getPreferredSize().height;
                        }
                        final RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback coreCallback = new RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback(){

                            public void menuEntryActivated(JPanel targetPanel) {
                                targetPanel.removeAll();
                                targetPanel.setLayout(new BorderLayout());
                                JRibbonApplicationMenuPopupPanelSecondary secondary = new JRibbonApplicationMenuPopupPanelSecondary(menuEntry){

                                    public void removeNotify() {
                                        super.removeNotify();
                                        commandButton.getPopupModel().setPopupShowing(false);
                                    }
                                };
                                Color color = UIManager.getLookAndFeelDefaults().getColor("ribbon-app-menu-secondary-bg");
                                if (color != null) {
                                    color = new Color(color.getRGB());
                                    secondary.setBackground(color);
                                }
                                secondary.applyComponentOrientation(OfficeRibbonApplicationMenuPopupPanelUI.this.applicationMenuPopupPanel.getComponentOrientation());
                                targetPanel.add((Component)secondary, "Center");
                            }
                        };
                        commandButton.addRolloverActionListener(new RolloverActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                coreCallback.menuEntryActivated(OfficeRibbonApplicationMenuPopupPanelUI.this.panelLevel2);
                                commandButton.getPopupModel().setPopupShowing(true);
                            }
                        });
                    }
                    commandButton.setDisplayState(MENU_TILE_LEVEL_1);
                    commandButton.setHorizontalAlignment(10);
                    commandButton.setPopupOrientationKind(JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
                    commandButton.setEnabled(menuEntry.isEnabled());
                    commandButton.setVisible(menuEntry.isVisible());
                    this.panelLevel1.add((Component)commandButton);
                }
                if (i >= primaryGroupCount - 1) continue;
                JPopupMenu.Separator separator = new JPopupMenu.Separator();
                Color color = UIManager.getLookAndFeelDefaults().getColor("ribbon-app-menu-separator-color");
                separator.setForeground(color);
                separator.setBackground(color);
                this.panelLevel1.add(separator);
            }
        }
        this.mainPanel.add((Component)this.panelLevel1, "Before");
        this.panelLevel2 = new JPanel();
        this.panelLevel2.setBorder(new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                boolean ltr = c.getComponentOrientation().isLeftToRight();
                return new Insets(0, ltr ? 2 : 0, 0, ltr ? 0 : 1);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(UIManager.getLookAndFeelDefaults().getColor("ribbon-app-menu-separator-color"));
                boolean ltr = c.getComponentOrientation().isLeftToRight();
                int xToPaint = ltr ? x : x + width - 1;
                g.drawLine(xToPaint, y, xToPaint, y + height);
                g.drawLine(xToPaint + 1, y, xToPaint + 1, y + height);
            }
        });
        this.panelLevel2.setPreferredSize(new Dimension(30 * FlamingoUtilities.getFont((Component)this.panelLevel1, (String[])new String[]{"Ribbon.font", "Button.font", "Panel.font"}).getSize() - 30, 10));
        this.mainPanel.add((Component)this.panelLevel2, "Center");
        this.mainPanel.setPreferredSize(new Dimension(this.mainPanel.getPreferredSize().width, Math.max(this.panelLevel1.getPreferredSize().height + this.panelLevel1.getInsets().top + this.panelLevel1.getInsets().bottom, secondaryLevelHeight + this.panelLevel2.getInsets().top + this.panelLevel2.getInsets().bottom)));
        if (ribbonAppMenu != null && ribbonAppMenu.getDefaultCallback() != null) {
            ribbonAppMenu.getDefaultCallback().menuEntryActivated(this.panelLevel2);
        }
        this.applicationMenuPopupPanel.add((Component)this.mainPanel, (Object)"Center");
        this.footerPanel = new JPanel(new FlowLayout(4)){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(UIManager.getLookAndFeelDefaults().getColor("ribbon-app-menu-footer-bg"));
                g.fillRect(0, 0, OfficeRibbonApplicationMenuPopupPanelUI.this.footerPanel.getWidth(), OfficeRibbonApplicationMenuPopupPanelUI.this.footerPanel.getHeight());
            }
        };
        if (ribbonAppMenu != null) {
            for (RibbonApplicationMenuEntryFooter footerEntry : ribbonAppMenu.getFooterEntries()) {
                JButton footerButton = new JButton(footerEntry.getText(), (Icon)footerEntry.getIcon());
                if (footerEntry.getDisabledIcon() != null) {
                    footerButton.setDisabledIcon((Icon)footerEntry.getDisabledIcon());
                }
                footerButton.addActionListener(footerEntry.getMainActionListener());
                footerButton.setEnabled(footerEntry.isEnabled());
                this.footerPanel.add(footerButton);
            }
        }
        this.applicationMenuPopupPanel.add((Component)this.footerPanel, (Object)"South");
        this.applicationMenuPopupPanel.setBorder(new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(20, 2, 2, 2);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(UIManager.getLookAndFeelDefaults().getColor("ribbon-app-menu-dark-color"));
                g.fillRect(x + 2, y + 2, width - 4, 8 + IconSize.TINY.getSize());
                JRibbonApplicationMenuButton button = OfficeRibbonApplicationMenuPopupPanelUI.this.applicationMenuPopupPanel.getAppMenuButton();
                JRibbonApplicationMenuButton rendererButton = new JRibbonApplicationMenuButton(OfficeRibbonApplicationMenuPopupPanelUI.this.applicationMenuPopupPanel.getAppMenuButton().getRibbon());
                rendererButton.setPopupKeyTip(button.getPopupKeyTip());
                rendererButton.setIcon(button.getIcon());
                rendererButton.getPopupModel().setRollover(false);
                rendererButton.getPopupModel().setPressed(true);
                rendererButton.getPopupModel().setArmed(true);
                rendererButton.getPopupModel().setPopupShowing(true);
                CellRendererPane buttonRendererPane = new CellRendererPane();
                Point buttonLoc = button.getLocationOnScreen();
                Point panelLoc = c.getLocationOnScreen();
                buttonRendererPane.setBounds(panelLoc.x - buttonLoc.x, panelLoc.y - buttonLoc.y, button.getWidth(), button.getHeight());
                buttonRendererPane.paintComponent(g, (Component)rendererButton, (Container)c, -panelLoc.x + buttonLoc.x, -panelLoc.y + buttonLoc.y, button.getWidth(), button.getHeight(), true);
            }
        });
    }
}

