/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import com.bulenkov.iconloader.util.GraphicsUtil;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

public class OfficeEditorTabCellRenderer2
extends AbstractTabCellRenderer {
    private static final TabPainter noClipPainter = new NoClipPainter();
    private static final TabPainter leftClipPainter = new ClipPainter(2);
    private static final TabPainter rightClipPainter = new ClipPainter(4);
    private static final Color WHITE_0 = new Color(1.0f, 1.0f, 1.0f, 0.0f);

    public OfficeEditorTabCellRenderer2() {
        super(leftClipPainter, noClipPainter, rightClipPainter, new Dimension(32, 42));
    }

    public Dimension getPadding() {
        Dimension d = super.getPadding();
        d.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 32 : 16;
        return d;
    }

    protected int getCaptionYAdjustment() {
        return this.isSelected() ? 0 : 2;
    }

    protected int getIconYAdjustment() {
        return this.isSelected() ? -2 : 0;
    }

    public Color getSelectedActivatedForeground() {
        return OfficeEditorTabCellRenderer2.getTxtColor();
    }

    public Color getSelectedForeground() {
        return OfficeEditorTabCellRenderer2.getTxtColor();
    }

    private static Color getTxtColor() {
        Color result = UIManager.getLookAndFeelDefaults().getColor("editor-tab-selected-fg");
        if (result == null) {
            result = new Color(0, 0, 0);
        }
        return result;
    }

    public void paint(Graphics g) {
        GraphicsUtil.setupTextAntialiasing((Graphics)g, null);
        super.paint(g);
    }

    private static String findIconPath(OfficeEditorTabCellRenderer2 renderer) {
        if (renderer.inCloseButton() && renderer.isPressed()) {
            return "org/openide/awt/resources/xp_bigclose_pressed.png";
        }
        if (renderer.inCloseButton()) {
            return "org/openide/awt/resources/xp_bigclose_rollover.png";
        }
        return "org/openide/awt/resources/xp_bigclose_enabled2.png";
    }

    protected int stateChanged(int oldState, int newState) {
        Color fg;
        int returnValue = super.stateChanged(oldState, newState);
        Color color = this.isSelected() ? (this.isActive() ? this.getSelectedActivatedForeground() : this.getSelectedForeground()) : (fg = UIManager.getLookAndFeelDefaults().getColor("editor-tab-fg"));
        if (this.isArmed() && this.isPressed() && (this.isClipLeft() || this.isClipRight())) {
            fg = this.getSelectedActivatedForeground();
        }
        this.setForeground(fg);
        return returnValue;
    }

    private static void paintInterior(Graphics g, Component c, Polygon interiorPolygon, Rectangle closeButtonRect, String closeButtonIconPath) {
        OfficeEditorTabCellRenderer2 ren = (OfficeEditorTabCellRenderer2)((Object)c);
        Rectangle rect = interiorPolygon.getBounds();
        Graphics2D g2d = (Graphics2D)g;
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        if (ren.isSelected()) {
            g2d.setColor(laf.getColor("editor-tab-selected-bg"));
        } else {
            Color color;
            if (ren.isAttention()) {
                color = UIManager.getLookAndFeelDefaults().getColor("window-title-bg-attention");
            } else {
                Color bg1 = laf.getColor("editor-tab-bg1");
                Color focusedBg1 = laf.getColor("editor-tab-focused-bg1");
                color = ren.isArmed() ? focusedBg1 : bg1;
            }
            g2d.setPaint(color);
        }
        g2d.fillRect(rect.x, rect.y, rect.width - 1, rect.height + 1);
        if (g2d.hitClip(closeButtonRect.x, closeButtonRect.y, closeButtonRect.width, closeButtonRect.height)) {
            Icon icon = TabControlButtonFactory.getIcon((String)closeButtonIconPath);
            if (!ren.isSelected() && !ren.isArmed()) {
                g2d = (Graphics2D)g2d.create();
                g2d.setComposite(AlphaComposite.SrcOver.derive(0.5f));
            }
            icon.paintIcon((Component)((Object)ren), g2d, closeButtonRect.x, closeButtonRect.y);
            if (!ren.isSelected() && !ren.isArmed()) {
                g2d.dispose();
            }
        }
    }

    private static BufferedImage createFadeOutMask(int width, int height, int fadeSize, int direction) {
        float y2;
        float y1;
        float x2;
        float x1;
        BufferedImage gradient = new BufferedImage(width, height, 2);
        Graphics2D g2d = gradient.createGraphics();
        boolean solid = false;
        switch (direction) {
            case 2: {
                x1 = 0.0f;
                x2 = fadeSize;
                y1 = 0.0f;
                y2 = 0.0f;
                break;
            }
            case 4: {
                x1 = width - 1;
                x2 = width - 1 - fadeSize;
                y1 = 0.0f;
                y2 = 0.0f;
                break;
            }
            default: {
                y2 = 0.0f;
                y1 = 0.0f;
                x2 = 0.0f;
                x1 = 0.0f;
                solid = true;
            }
        }
        if (!solid) {
            GradientPaint paint = new GradientPaint(x1, y1, Color.WHITE, x2, y2, WHITE_0);
            g2d.setPaint(paint);
        } else {
            g2d.setColor(Color.WHITE);
        }
        g2d.fillRect(0, 0, width, height);
        g2d.dispose();
        gradient.flush();
        return gradient;
    }

    private static void applyAlphaMask(BufferedImage mask, BufferedImage buffer) {
        Graphics2D g2d = buffer.createGraphics();
        g2d.setComposite(AlphaComposite.DstOut);
        g2d.drawImage(mask, null, 0, 0);
        g2d.dispose();
    }

    private static class ClipPainter
    implements TabPainter {
        private final NoClipPainter delegate = new NoClipPainter();
        private final int direction;

        private ClipPainter(int direction) {
            this.direction = direction;
        }

        public Polygon getInteriorPolygon(Component c) {
            return this.delegate.getInteriorPolygon(c);
        }

        public void paintInterior(Graphics g, Component c) {
            OfficeEditorTabCellRenderer2 ren = (OfficeEditorTabCellRenderer2)((Object)c);
            Rectangle closeButtonRect = new Rectangle();
            this.getCloseButtonRectangle((JComponent)((Object)ren), closeButtonRect, new Rectangle(0, 0, c.getWidth(), c.getHeight()));
            if (ren.isSelected()) {
                OfficeEditorTabCellRenderer2.paintInterior(g, (Component)((Object)ren), this.getInteriorPolygon((Component)((Object)ren)), closeButtonRect, OfficeEditorTabCellRenderer2.findIconPath(ren));
            } else {
                BufferedImage buffer = new BufferedImage(c.getWidth(), c.getHeight(), 2);
                Graphics2D bg = buffer.createGraphics();
                OfficeEditorTabCellRenderer2.paintInterior(bg, (Component)((Object)ren), this.getInteriorPolygon((Component)((Object)ren)), closeButtonRect, OfficeEditorTabCellRenderer2.findIconPath(ren));
                bg.dispose();
                BufferedImage mask = OfficeEditorTabCellRenderer2.createFadeOutMask(c.getWidth(), c.getHeight(), c.getWidth() / 2, this.direction);
                OfficeEditorTabCellRenderer2.applyAlphaMask(mask, buffer);
                Graphics2D g2d = (Graphics2D)g;
                g2d.drawImage(buffer, null, 0, 0);
            }
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            if (this.direction == 4) {
                rect.x = -100;
                rect.y = -100;
                rect.width = 0;
                rect.height = 0;
            } else {
                this.delegate.getCloseButtonRectangle(jc, rect, bounds);
            }
        }

        public boolean supportsCloseButton(JComponent component) {
            return this.direction != 4 && this.delegate.supportsCloseButton(component);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            OfficeEditorTabCellRenderer2 ren = (OfficeEditorTabCellRenderer2)((Object)c);
            if (ren.isSelected()) {
                this.delegate.paintBorder(c, g, x, y, width, height);
            } else {
                BufferedImage buffer = new BufferedImage(width, height, 2);
                Graphics2D bg = buffer.createGraphics();
                this.delegate.paintBorder(c, bg, x, y, width, height);
                bg.dispose();
                BufferedImage mask = OfficeEditorTabCellRenderer2.createFadeOutMask(width, height - 1, width / 2, this.direction);
                OfficeEditorTabCellRenderer2.applyAlphaMask(mask, buffer);
                Graphics2D g2d = (Graphics2D)g;
                g2d.drawImage(buffer, null, 0, 0);
            }
        }

        public Insets getBorderInsets(Component c) {
            return this.delegate.getBorderInsets(c);
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }

    private static class NoClipPainter
    implements TabPainter {
        private static final int closeIconRightInset = 2;

        private NoClipPainter() {
        }

        public Polygon getInteriorPolygon(Component c) {
            OfficeEditorTabCellRenderer2 ren = (OfficeEditorTabCellRenderer2)((Object)c);
            Insets ins = this.getBorderInsets(c);
            Polygon p = new Polygon();
            int x = 0;
            int y = 0;
            int width = c.getWidth();
            int height = c.getHeight() - ins.bottom;
            if (!ren.isSelected()) {
                height -= 2;
                y += 2;
            } else {
                ++height;
            }
            p.addPoint(x, y + ins.top);
            p.addPoint(x + width, y + ins.top);
            p.addPoint(x + width, y + height - 1);
            p.addPoint(x, y + height - 1);
            return p;
        }

        public void paintInterior(Graphics g, Component c) {
            OfficeEditorTabCellRenderer2 ren = (OfficeEditorTabCellRenderer2)((Object)c);
            Rectangle closeButtonRect = new Rectangle();
            this.getCloseButtonRectangle((JComponent)((Object)ren), closeButtonRect, new Rectangle(0, 0, c.getWidth(), c.getHeight()));
            OfficeEditorTabCellRenderer2.paintInterior(g, (Component)((Object)ren), this.getInteriorPolygon((Component)((Object)ren)), closeButtonRect, OfficeEditorTabCellRenderer2.findIconPath(ren));
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            OfficeEditorTabCellRenderer2 ren = (OfficeEditorTabCellRenderer2)((Object)jc);
            if (!ren.isShowCloseButton()) {
                rect.x = -100;
                rect.y = -100;
                rect.width = 0;
                rect.height = 0;
                return;
            }
            String iconPath = OfficeEditorTabCellRenderer2.findIconPath(ren);
            Icon icon = TabControlButtonFactory.getIcon((String)iconPath);
            int iconWidth = icon.getIconWidth();
            int iconHeight = icon.getIconHeight();
            rect.x = bounds.x + bounds.width - iconWidth - 2;
            rect.y = bounds.y + Math.max(0, bounds.height / 2 - iconHeight / 2);
            rect.width = iconWidth;
            rect.height = iconHeight;
            if (!ren.isSelected()) {
                rect.y += 2;
            }
        }

        public boolean supportsCloseButton(JComponent renderer) {
            return !(renderer instanceof TabDisplayer) || ((TabDisplayer)renderer).isShowCloseButton();
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int h;
            OfficeEditorTabCellRenderer2 ren = (OfficeEditorTabCellRenderer2)((Object)c);
            int yy = ren.isSelected() ? y : y + 2;
            int n = h = ren.isSelected() ? height : height - 2;
            if (!ren.isSelected() && !ren.isArmed()) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.translate(x, yy);
                UIDefaults laf = MaltegoLAF.getLookAndFeelDefaults();
                Color borderColor = laf.getColor("editor-tab-border-color");
                g2d.setComposite(AlphaComposite.SrcOver.derive(0.25f));
                g2d.setColor(borderColor);
                if (!ren.isPreviousTabSelected()) {
                    g2d.drawLine(0, 1, 0, h - 1);
                }
                g2d.drawLine(0, 0, width - 2, 0);
                if (!ren.isNextTabSelected()) {
                    g2d.drawLine(width - 2, 1, width - 2, h - 1);
                }
                g2d.dispose();
            }
        }

        public Insets getBorderInsets(Component c) {
            OfficeEditorTabCellRenderer2 ren = (OfficeEditorTabCellRenderer2)((Object)c);
            Rectangle rect = new Rectangle();
            this.getCloseButtonRectangle((JComponent)((Object)ren), rect, new Rectangle(0, 0, ren.getWidth(), ren.getHeight()));
            return new Insets(0, 3, 0, rect.width > 0 ? rect.width + 2 : 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

