/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.imex;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.ui.graph.clipboard.GraphML;
import com.paterva.maltego.ui.graph.clipboard.GraphMLConverter;
import com.paterva.maltego.ui.graph.imex.Bundle;
import com.paterva.maltego.ui.graph.imex.GephiWriter;
import com.paterva.maltego.ui.graph.imex.YEdWriter;
import com.paterva.maltego.ui.graph.util.GraphUtils;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.filechooser.FileChooserUtil;
import com.paterva.maltego.util.ui.filechooser.SaveValidationFileChooser;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ExportAsXmlAction
extends TopGraphAction {
    private static final String GRAPHML_EXT = "graphml";
    private static final String GRAPHML_FILTER_SUFFIX = "GraphML XML (*.graphml)";
    private static final String MALTEGO_FILTER = "Maltego GraphML XML (*.graphml)";
    private static final String YED_FILTER = "yEd GraphML XML (*.graphml)";
    private static final String GEPHI_FILTER = "Gephi GraphML XML (*.graphml)";
    private static final String PREF_SAVED_DIR = "exportAsXmlDir";
    private static final String PREF_SAVED_XML_TYPE = "exportAsXmlType";
    private static final String PREF_SAVED_SELECTION_ONLY = "exportAsXmlSelectionOnly";
    private final FileNameExtensionFilter maltegoXmlFilter = new FileNameExtensionFilter("Maltego GraphML XML (*.graphml)", "graphml");
    private final FileNameExtensionFilter yEdFilter = new FileNameExtensionFilter("yEd GraphML XML (*.graphml)", "graphml");
    private final FileNameExtensionFilter gephiFilter = new FileNameExtensionFilter("Gephi GraphML XML (*.graphml)", "graphml");
    private final JCheckBox selectionOnlycheckBox = new JCheckBox();
    private FileNameExtensionFilter filter;

    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return Bundle.CTL_ExportAsXmlAction();
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/resources/ExportXml.png";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.FALSE);
    }

    @Override
    protected void actionPerformed(TopComponent tc) {
        GraphID graphID = this.getTopGraphID();
        if (graphID == null) {
            return;
        }
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        boolean hasSelectedEntities = selection.hasSelectedEntities();
        this.selectionOnlycheckBox.setEnabled(hasSelectedEntities);
        if (hasSelectedEntities) {
            Preferences prefs = this.getPrefs();
            boolean selectionOnly = prefs.getBoolean(PREF_SAVED_SELECTION_ONLY, false);
            this.selectionOnlycheckBox.setSelected(selectionOnly);
        } else {
            this.selectionOnlycheckBox.setSelected(false);
        }
        File file = this.showFileChooser(tc);
        if (file != null) {
            file = FileChooserUtil.addExtenstionIfMissing((File)file, (String)FileChooserUtil.getFileExtension((FileNameExtensionFilter)this.filter));
            this.export(graphID, file);
        }
    }

    private File showFileChooser(TopComponent tc) {
        SaveValidationFileChooser fileChooser = new SaveValidationFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        Preferences prefs = this.getPrefs();
        FileChooserUtil.setDirectoryAndFile((Preferences)prefs, (String)PREF_SAVED_DIR, (JFileChooser)fileChooser, (String)GraphUtils.getTopGraphName(tc, "GraphXML"));
        LinkedHashMap<String, FileNameExtensionFilter> fileFilters = new LinkedHashMap<String, FileNameExtensionFilter>();
        fileChooser.addChoosableFileFilter((FileFilter)this.maltegoXmlFilter);
        fileFilters.put(this.getId(this.maltegoXmlFilter), this.maltegoXmlFilter);
        fileChooser.addChoosableFileFilter((FileFilter)this.yEdFilter);
        fileFilters.put(this.getId(this.yEdFilter), this.yEdFilter);
        fileChooser.addChoosableFileFilter((FileFilter)this.gephiFilter);
        fileFilters.put(this.getId(this.gephiFilter), this.gephiFilter);
        FileChooserUtil.addAdditionalFieldsToChooser((JFileChooser)fileChooser, (String[])new String[]{"Selection Only:"}, (JComponent[])new JComponent[]{this.selectionOnlycheckBox});
        FileNameExtensionFilter initType = (FileNameExtensionFilter)fileFilters.get(this.getSavedFileType());
        if (initType != null) {
            fileChooser.setFileFilter((FileFilter)initType);
        }
        File file = null;
        int result = fileChooser.showSaveDialog((Component)WindowManager.getDefault().getMainWindow());
        if (result == 0) {
            file = fileChooser.getSelectedFile();
            this.filter = (FileNameExtensionFilter)fileChooser.getFileFilter();
            String currentDirectory = fileChooser.getCurrentDirectory().getAbsolutePath();
            prefs.put(PREF_SAVED_DIR, currentDirectory);
            prefs.put(PREF_SAVED_XML_TYPE, this.getId(this.filter));
            if (this.selectionOnlycheckBox.isEnabled()) {
                prefs.putBoolean(PREF_SAVED_SELECTION_ONLY, this.selectionOnlycheckBox.isSelected());
            }
        }
        return file;
    }

    private String getSavedFileType() {
        String fallbackType = this.getId(this.maltegoXmlFilter);
        String savedType = this.getPrefs().get(PREF_SAVED_XML_TYPE, fallbackType).toLowerCase();
        return savedType;
    }

    private String getId(FileNameExtensionFilter filter) {
        return filter.getDescription().toLowerCase();
    }

    private Preferences getPrefs() {
        Preferences prefs = NbPreferences.forModule(ExportAsXmlAction.class);
        return prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(GraphID graphID, File file) {
        try {
            WindowUtil.showWaitCursor();
            boolean selectionOnly = this.selectionOnlycheckBox.isSelected();
            if (this.filter.equals(this.maltegoXmlFilter)) {
                GraphML graphML = selectionOnly ? GraphMLConverter.convertSelection(graphID, true) : GraphMLConverter.convert(graphID);
                String text = graphML.getText();
                Files.write(file.toPath(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            } else {
                if (this.filter.equals(this.yEdFilter)) {
                    try (FileOutputStream os = new FileOutputStream(file);){
                        YEdWriter writer = new YEdWriter();
                        writer.write(graphID, os, selectionOnly);
                    }
                }
                try (FileOutputStream os = new FileOutputStream(file);){
                    GephiWriter writer = new GephiWriter();
                    writer.write(graphID, os, selectionOnly);
                }
            }
            this.showSuccess(file);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    private void showSuccess(File file) {
        String msg = "Successfully exported to " + file.getPath();
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
        nd.setTitle("Export Successful");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
    }
}

