/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactoryapi;

import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.Map;

public class IconUtils {
    public static String createUniqueIconName(IconRegistry registry, String iconCategory, String iconName) {
        iconName = IconUtils.makeValidIconName(iconName);
        while (registry.existsCaseInsensitive(iconCategory, iconName)) {
            iconName = iconName + "_";
        }
        return iconName;
    }

    public static String makeValidIconName(String name) {
        return StringUtilities.replaceDigitsWithWords((String)name).replaceAll("[^a-zA-Z _]", "_");
    }

    public static Image fixSize(Image icon, IconSize size) {
        BufferedImage bImg = ImageUtils.createBufferedImage((Image)icon);
        if (IconUtils.mustResize(bImg, size)) {
            icon = ImageUtils.smartSize((BufferedImage)bImg, (double)size.getSize(), (double)size.getSize());
        }
        return icon;
    }

    public static boolean mustResize(BufferedImage icon, IconSize size) {
        return icon.getWidth() != size.getSize() || icon.getHeight() != size.getSize();
    }

    public static boolean mustResize(BufferedImage icon, IconSize size, int leeway) {
        return Math.abs(icon.getWidth() - size.getSize()) > leeway || Math.abs(icon.getHeight() - size.getSize()) > leeway;
    }

    public static void resizeAndAddIcon(Map<IconSize, Image> icons, Image icon, IconSize size) {
        icons.put(size, IconUtils.fixSize(icon, size));
    }

    public static void createMissingIcons(Map<IconSize, Image> icons) {
        Image largestIcon = IconUtils.getLargest(icons);
        for (IconSize size : IconSize.values()) {
            Image icon = icons.get(size);
            if (icon != null) continue;
            icons.put(size, IconUtils.fixSize(largestIcon, size));
        }
    }

    public static Image getLargest(Map<IconSize, Image> icons) {
        IconSize[] iconSizes = IconSize.values();
        for (int i = iconSizes.length - 1; i >= 0; --i) {
            Image icon = icons.get(iconSizes[i]);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    public static Map<IconSize, Image> createSizedIcons(Image image) {
        EnumMap<IconSize, Image> icons = new EnumMap<IconSize, Image>(IconSize.class);
        for (IconSize size : IconSize.values()) {
            icons.put(size, IconUtils.fixSize(image, size));
        }
        return icons;
    }
}

