/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository.serializer;

import com.paterva.maltego.transform.descriptor.PersistenceMode;
import com.paterva.maltego.transform.descriptor.Popup;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.descriptor.Visibility;
import com.paterva.maltego.transform.repository.ListMapTransformSettings;
import com.paterva.maltego.transform.repository.serializer.PopupTranslator;
import com.paterva.maltego.transform.repository.serializer.TransformSettingsPropertyStub;
import com.paterva.maltego.transform.repository.serializer.TransformSettingsStub;
import com.paterva.maltego.transform.repository.serializer.VisibilityTranslator;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.InputStream;
import java.io.OutputStream;

public class TransformSettingsSerializer {
    public TransformSettings read(InputStream stream) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        TransformSettingsStub stub = (TransformSettingsStub)serializer.read(TransformSettingsStub.class, stream);
        return TransformSettingsSerializer.translate(stub);
    }

    public void write(TransformDefinition definition, OutputStream stream, boolean isExport) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        TransformSettingsStub stub = TransformSettingsSerializer.translate((TransformSettings)definition, (Iterable<DisplayDescriptor>)definition.getProperties(), isExport);
        serializer.write((Object)stub, stream);
    }

    public static TransformSettings translate(TransformSettingsStub from) {
        ListMapTransformSettings to = new ListMapTransformSettings();
        to.setEnabled(from.isEnabled());
        to.setDisclaimerAccepted(from.isDisclaimerAccepted());
        to.setShowHelp(from.isShowHelp());
        to.setRunWithAll(from.isRunWithAll());
        to.setFavorite(from.isFavorite());
        for (TransformSettingsPropertyStub propStub : from.getProperties()) {
            Object value = Converter.convertFrom((String)propStub.getValue(), (String)propStub.getType());
            to.setValue(propStub.getName(), value);
            to.setPopup(propStub.getName(), PopupTranslator.get(propStub.isPopup()));
            to.setVisibility(propStub.getName(), VisibilityTranslator.get(propStub.getVisibility()));
        }
        to.markClean();
        return to;
    }

    public static TransformSettingsStub translate(TransformSettings from, Iterable<DisplayDescriptor> properties, boolean isExport) {
        TransformSettingsStub to = new TransformSettingsStub();
        to.setEnabled(from.isEnabled());
        to.setDisclaimerAccepted(from.isDisclaimerAccepted());
        to.setShowHelp(from.showHelp());
        to.setRunWithAll(from.isRunWithAll());
        to.setFavorite(from.isFavorite());
        for (DisplayDescriptor dd : properties) {
            Object fromValue;
            boolean persistValue = TransformSettingsSerializer.shouldPersistValue(dd, isExport);
            TransformSettingsPropertyStub propStub = new TransformSettingsPropertyStub(dd.getName(), dd.getTypeDescriptor().getTypeName());
            Object object = fromValue = persistValue ? from.getValue((PropertyDescriptor)dd) : null;
            if (fromValue != null && !fromValue.equals(dd.getDefaultValue())) {
                String toValue = dd.getTypeDescriptor().convert(fromValue);
                propStub.setValue(toValue);
            }
            Popup fromPopup = from.getPopup((PropertyDescriptor)dd);
            boolean toPopup = persistValue ? PopupTranslator.get(fromPopup) : true;
            propStub.setPopup(toPopup);
            Visibility fromVisibility = from.getVisibility((PropertyDescriptor)dd);
            if (fromVisibility != Visibility.Public) {
                String toVisibility = VisibilityTranslator.get(fromVisibility);
                propStub.setVisibility(toVisibility);
            }
            to.getProperties().add(propStub);
        }
        return to;
    }

    static boolean shouldPersistValue(DisplayDescriptor dd, boolean isExport) {
        boolean persistValue = true;
        if (dd instanceof TransformPropertyDescriptor) {
            TransformPropertyDescriptor tpd = (TransformPropertyDescriptor)dd;
            PersistenceMode persistence = tpd.getPersistence();
            switch (persistence) {
                case None: {
                    persistValue = false;
                    break;
                }
                case NoExport: {
                    persistValue = !isExport;
                    break;
                }
                default: {
                    persistValue = !isExport || !tpd.isAuth();
                }
            }
        }
        return persistValue;
    }
}

