/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.runviews;

import com.paterva.maltego.runviews.Bundle;
import com.paterva.maltego.runviews.list.RootRunProviderTreeListItem;
import com.paterva.maltego.util.ui.EmptyPanel;
import com.paterva.maltego.util.ui.treelist.TreeListItem;
import com.paterva.maltego.util.ui.treelist.TreeListItemListener;
import com.paterva.maltego.util.ui.treelist.TreeListPanel;
import com.paterva.maltego.util.ui.treelist.TreeListScrollPane;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.GroupLayout;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="RunTopComponent", iconBase="", persistenceType=0)
public final class RunTopComponent
extends TopComponent {
    private static final String PREFERRED_ID = "RunTopComponent";
    private static final String EMPTY_VIEW = "empty";
    private static final String TREE_LIST_VIEW = "treelist";
    private static RunTopComponent instance;
    private final TreeListPanel _runPanel;
    private String _currentCard;

    public RunTopComponent() {
        instance = this;
        this.initComponents();
        this.setName(Bundle.CTL_RunTopComponent());
        this.setToolTipText(Bundle.HINT_RunTopComponent());
        this.setLayout(new CardLayout());
        this._runPanel = new TreeListPanel((TreeListItem)new RootRunProviderTreeListItem("run-view"), (TreeListItemListener)new TreeListItemClickListener());
        TreeListScrollPane scrollPane = new TreeListScrollPane((Component)this._runPanel, 20, 30);
        this.add((Component)new EmptyPanel("<No Selection>"), EMPTY_VIEW);
        this.add((Component)scrollPane, TREE_LIST_VIEW);
        this._runPanel.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                this.updateCards(e.getContainer().getComponentCount());
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                this.updateCards(e.getContainer().getComponentCount());
            }

            private void updateCards(int componentCount) {
                RunTopComponent.this.showCard(componentCount <= 2 ? RunTopComponent.EMPTY_VIEW : RunTopComponent.TREE_LIST_VIEW);
            }
        });
    }

    private void showCard(String card) {
        if (!card.equals(this._currentCard)) {
            CardLayout layout = (CardLayout)this.getLayout();
            layout.show((Container)((Object)this), card);
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public static synchronized RunTopComponent getDefault() {
        if (instance == null) {
            instance = new RunTopComponent();
        }
        return instance;
    }

    public static synchronized RunTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(RunTopComponent.class.getName()).warning("Cannot find RunTopComponent component. It will not be located properly in the window system.");
            return RunTopComponent.getDefault();
        }
        if (win instanceof RunTopComponent) {
            return (RunTopComponent)win;
        }
        Logger.getLogger(RunTopComponent.class.getName()).warning("There seem to be multiple components with the 'RunTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return RunTopComponent.getDefault();
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        RunTopComponent singleton = RunTopComponent.getDefault();
        singleton.readPropertiesImpl(p);
        return singleton;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    private class TreeListItemClickListener
    implements TreeListItemListener {
        private TreeListItemClickListener() {
        }

        public boolean onClicked(TreeListItem item, MouseEvent e) {
            Action action;
            boolean leftClicked;
            if (e.getID() != 502) {
                return false;
            }
            boolean bl = leftClicked = e.getButton() == 1;
            if (leftClicked && item != null && (action = item.getDefaultAction()) != null) {
                action.actionPerformed(null);
                return true;
            }
            return false;
        }
    }
}

