#!/usr/bin/perl
#
# Copyright (C) 1999 Bibliotech Ltd., 631-633 Fulham Rd., London SW6 5UQ.
#
# $Id: htmlcontents.pl,v 1.1 1999/12/27 15:53:58 rich Exp $
#
# Change log:
#
# $Log: htmlcontents.pl,v $
# Revision 1.1  1999/12/27 15:53:58  rich
# Regular update.
#
# Revision 1.2  1999/03/26 12:32:07  rich
# Added more small programs.
#
# Revision 1.1  1999/03/08 10:33:47  rich
# Added first installment of HTMLCONTENTS.PL program.
#

#----------------------------------------------------------------------
# Please see the accompanying document for information.

#----------------------------------------------------------------------
# Some configuration items.

%toc_colour = ( 0 => "yellow",
		1 => "#ffe0ff",
		2 => "#e0ffff",
		3 => "white",
		4 => "white",
		5 => "white" );

#----------------------------------------------------------------------
# First phase: build structure.

@section_level = ( 0, 0, 0, 0, 0, 0 );
$section_name = "";
%label = ();
@footnote = ();

@saved_argv = @ARGV;

open TOC, ">.toc" or die ".toc: $!";
print TOC ("<a name=\"toc\"></a><table align=center border=0>\n");

sub updatesection
  {
    my $i;

    # Update the section levels.
    $section_level[$_[1]] ++;

    for ($i = $_[1] + 1; $i < 6; ++$i) {
      $section_level[$i] = 0;
    }

    # Generate a name for this section at
    # this level. Basically, ignore all
    # leading 0s and take up to $_[1].
    $section_name = "";
    my $needs_dot = 0;

    for ($i = 0; $i <= $_[1]; ++$i) {
      $section_name .= "." if $section_level[$i] != 0 && $needs_dot;
      $section_name .= $section_level[$i] if $section_level[$i] != 0;
      $needs_dot = 1 if $section_level[$i] != 0;
    }
  }

sub newsection
  {
    updatesection ($_[0],$_[1]);

    # Choose a colour for the table of contents entry.
    my $colour = $toc_colour{$_[1]};

    # Update the table of contents.
    print TOC ("<tr bgcolor=\"", $colour, "\">");

    print TOC ("<td align=\"right\">", $section_name, "</td>");
    print TOC ("<td> ..... </td>");
    print TOC ("<td><a href=\"#", $section_name, "\">", $_[0], "</a></td>");
    print TOC ("</tr>\n");
  }

sub newlabel
  {
    warn "Duplicate label: ", $_[0]
      if exists $label{$_[0]};

    # Add the label to the hash table.
    $label{$_[0]} = $section_name;
  }

sub newfootnote
  {
    # Add the footnote to the hash table.
    push @footnote, $_[0];
  }

while (<>) {
  if (/<!-- CHAPTER ([^>]*) -->/) {
    newsection ($1, 0);
  }
  elsif (/<!-- SECTION ([^>]*) -->/) {
    newsection ($1, 1);
  }
  elsif (/<!-- SUBSECTION ([^>]*) -->/) {
    newsection ($1, 2);
  }
  elsif (/<!-- SUBSUBSECTION ([^>]*) -->/) {
    newsection ($1, 3);
  }
  elsif (/<!-- SUBSUBSUBSECTION ([^>]*) -->/) {
    newsection ($1, 4);
  }
  elsif (/<!-- SUBSUBSUBSUBSECTION ([^>]*) -->/) {
    newsection ($1, 5);
  }
  elsif (/<!-- LABEL ([^>]*) -->/) {
    newlabel ($1);
  }
  elsif (/<!-- FOOTNOTE ([^>]*) -->/) {
    newfootnote ($1);
  }
}

print TOC ("</table>\n");
close TOC;

#----------------------------------------------------------------------
# Second phase: rewrite HTML.

@section_level = ( 0, 0, 0, 0, 0, 0 );
$section_name = "";
$footnote_counter = 1;

@ARGV = @saved_argv;

sub showsection
  {
    updatesection ($_[0], $_[1]);

    return
      "<a name=\"" . $section_name . "\"></a>" .
      "<a href=\"#toc\">" .
      "<h" . ($_[1]+1) . ">" .
      $section_name . " " . $_[0] .
      "</h" . ($_[1]+1) . ">" .
      "</a>"
      ;
  }

sub showlabel
  {
    warn "Missing label: ", $_[0]
      if ! exists $label{$_[0]};

    return "<a href=\"#" . $label{$_[0]} . "\">" . $label{$_[0]} . "</a>";
  }

sub showtoc
  {
    open TOC, ".toc";
    my @lines = <TOC>;
    close TOC;
    return "@lines";
  }

sub showimage
  {
    my $imagename = $_[0];
    my $alttag = $_[1];

    open IMAGE, "file " . $imagename . "|" || warn $_[0], "$!";

    my $xsize = -1;
    my $ysize = -1;

    while (<IMAGE>) {
      if (/GIF image data, version [0-9a-z]+, ([0-9]+) x ([0-9]+)/) {
	$xsize = $1;
	$ysize = $2;
	goto found;
      }
    }

    warn "Unsupported image format: ", $_[0];

  found:
    close IMAGE;

    if ($xsize != -1 && $ysize != -1) {
      return "<img src=\"" . $imagename . "\" alt=\"" . $alttag . "\" " .
	"width=\"" . $xsize . "\" height=\"" . $ysize . "\">";
    } else {
      return "<img src=\"" . $imagename . "\" alt=\"" . $alttag . "\">";
    }
  }

sub showfootnote
  {
    my $out = "<sup><a href=\"#footnote$footnote_counter\">$footnote_counter</a></sup><a name=\"return$footnote_counter\"></a>";
    $footnote_counter++;
    return $out;
  }

sub showfootnotes
  {
    my $out = "";
    my $i = 1;

    $out .= "<table>\n";
    foreach (@footnote)
      {
	$out .= "<tr><td valign=top><sup>";
	$out .= "<a name=\"footnote$i\">$i</a></sup></td>";
	$out .= "<td>" . $_;
	$out .= " [<a href=\"#return$i\">Back</a>]</td></tr>";
	$out .= "\n";

	$i++;
      }
    $out .= "</table>\n";

    return $out;
  }

while (<>) {
  s/<!-- CHAPTER ([^>]*) -->/showsection ($1, 0)/ge;
  s/<!-- SECTION ([^>]*) -->/showsection ($1, 1)/ge;
  s/<!-- SUBSECTION ([^>]*) -->/showsection ($1, 2)/ge;
  s/<!-- SUBSUBSECTION ([^>]*) -->/showsection ($1, 3)/ge;
  s/<!-- SUBSUBSUBSECTION ([^>]*) -->/showsection ($1, 4)/ge;
  s/<!-- SUBSUBSUBSUBSECTION ([^>]*) -->/showsection ($1, 5)/ge;
  s/<!-- WARNING -->/
    <!-- Warning: This file is automatically generated.
         Any changes you make here will be lost.\n
         Generated by HTMLCONTENTS.PL program by
         Richard W.M. Jones (rich\@annexia.org)          -->/g;
  s/<!-- REF ([^>]*) -->/showlabel ($1)/ge;
  s/<!-- TABLE OF CONTENTS -->/showtoc/ge;
  s/<!-- IMAGE ([^ \t]*) ([^>]*) -->/showimage ($1, $2)/ge;
  s/<!-- FOOTNOTE ([^>]*) -->/showfootnote ()/ge;
  s/<!-- FOOTNOTES -->/showfootnotes ()/ge;
  print;
}

unlink ".toc";
