# The -T option checks for missing patches and advises about public exploits

# Using -T Option To Suggest Public Exploits #

[Windows-privesc-check](http://code.google.com/p/windows-privesc-check/wiki/DesignGoals) can use the [Security Bulletin](http://technet.microsoft.com/en-us/security/gg447546) information from the [Microsoft spreadsheet](http://go.microsoft.com/fwlink/?LinkId=245778) to determine which patches are missing.

A list of [Metasploit](http://www.metasploit.com/) exploits is currently hardcoded.

Windows-privesc-check correlates the two and adds an issue to the report if public exploits are available for a system.

This all works as low-privileged user - you don't have to be in the local administrators group.  This can be helpful during pentests: [MBSA](http://technet.microsoft.com/en-us/security/cc184924) and other patch checking tools require administrative rights.

# Example 1: Download patch data from Internet #

Use "-T auto" to have windows-privesc-check connect to the MS site over the Internet and download the patch spreadsheet.  This is the simplest way to use the feature if you have Internet connectivity:

```
C:\>windows-privesc-check2.exe --audit -T auto -o report
windows-privesc-check v2.0svn92 (http://pentestmonkey.net/windows-privesc-check)
...
============ Starting Audit ============

[+] Running: audit_patches
[-] Attempting to download patch info from Microsoft...
[-] Download complete
[-] Gathering installed patches
[-] 1 patches are installed
[-] OS string for Microsoft spreadsheet is: Microsoft Windows Server 2003
[-] Found 21 exploits potentially affecting this system

============ Audit Complete ============

[+] Saving report file report.txt
[+] Saving report file report.html
```

# Example 2: Use a local copy of the patch spreadsheet #

Assuming you've downloaded the [spreadsheet](http://go.microsoft.com/fwlink/?LinkId=245778) and saved it as ms-patch-info.xlsx on the system you're auditing (in the same directory as windows-privesc-check is run from) you can use the -T option without an Internet connection:

```
C:\>windows-privesc-check2.exe --audit -T ms-patch-info.xlsx -o report
windows-privesc-check v2.0svn92 (http://pentestmonkey.net/windows-privesc-check)
...
============ Starting Audit ============

[+] Running: audit_patches
[-] Gathering installed patches
[-] 66 patches are installed
[-] OS string for Microsoft spreadsheet is: Windows XP Service Pack 3
[-] Found 0 exploits potentially affecting this system

============ Audit Complete ============

[+] Saving report file report.txt
[+] Saving report file report.html
```

# Example issue from report #
```
C:\>start report.html
```
http://windows-privesc-check.googlecode.com/svn/wiki/wpc2-report-patches.PNG

# Limitations #

The -T option should be useful for pentests.  However, a few false positives have been spotted during testing, so it's not so great for audits where you want to provide a definitive list of patches/exploits to a client.  False positives mainly relate to exploits for components that aren't installed - windows-privesc-check doesn't currently check what software is installed, it just uses the OS string to get the relevant patches from the spreadsheet.

# Download Source / Exe #

Download from [here](http://code.google.com/p/windows-privesc-check/source/browse/#svn%2Fbranches%2Fwpc-2.0).
