// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UADDW_2D_TRACE_AARCH64_H_
#define VIXL_SIM_UADDW_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_uaddw_2D[] = {
  0x0000000000007e7d, 0x0000000000007f00,
  0x0000000000007f7d, 0x00000000007ffd00,
  0x00000000007ffd7d, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000001,
  0x000000000000007e, 0x0000000000000002,
  0x000000000000007f, 0x0000000000000020,
  0x000000000000009d, 0x000000000000007d,
  0x00000000000000fa, 0x000000000000007e,
  0x00000000000000fb, 0x000000000000007f,
  0x00000000000000fc, 0x0000000000007ffd,
  0x000000000000807a, 0x0000000000007ffe,
  0x000000000000807b, 0x0000000000007fff,
  0x000000000000807c, 0x0000000033333333,
  0x00000000333333b0, 0x0000000055555555,
  0x00000000555555d2, 0x000000007ffffffd,
  0x000000008000007a, 0x000000007ffffffe,
  0x000000008000007b, 0x000000007fffffff,
  0x000000008000007c, 0x0000000080000000,
  0x000000008000007d, 0x0000000080000001,
  0x000000008000007e, 0x00000000aaaaaaaa,
  0x00000000aaaaab27, 0x00000000cccccccc,
  0x00000000cccccd49, 0x00000000ffff8000,
  0x00000000ffff807d, 0x00000000ffff8001,
  0x00000000ffff807e, 0x00000000ffff8002,
  0x00000000ffff807f, 0x00000000ffff8003,
  0x00000000ffff8080, 0x00000000ffffff80,
  0x00000000fffffffd, 0x00000000ffffff81,
  0x00000000fffffffe, 0x00000000ffffff82,
  0x00000000ffffffff, 0x00000000ffffff83,
  0x0000000100000000, 0x00000000ffffffe0,
  0x000000010000005d, 0x00000000fffffffd,
  0x00000000fffffffd, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000021,
  0x0000000000000020, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x0000000033333334,
  0x0000000033333333, 0x0000000055555556,
  0x0000000055555555, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000002,
  0x0000000080000001, 0x00000000aaaaaaab,
  0x00000000aaaaaaaa, 0x00000000cccccccd,
  0x00000000cccccccc, 0x00000000ffff8001,
  0x00000000ffff8000, 0x00000000ffff8002,
  0x00000000ffff8001, 0x00000000ffff8003,
  0x00000000ffff8002, 0x00000000ffff8004,
  0x00000000ffff8003, 0x00000000ffffff81,
  0x00000000ffffff80, 0x00000000ffffff82,
  0x00000000ffffff81, 0x00000000ffffff83,
  0x00000000ffffff82, 0x00000000ffffff84,
  0x00000000ffffff83, 0x00000000ffffffe1,
  0x00000000ffffffe0, 0x00000000fffffffe,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000004,
  0x0000000000000003, 0x0000000000000022,
  0x0000000000000021, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000000081,
  0x0000000000000080, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000008001,
  0x0000000000008000, 0x0000000033333335,
  0x0000000033333334, 0x0000000055555557,
  0x0000000055555556, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000002,
  0x0000000080000001, 0x0000000080000003,
  0x0000000080000002, 0x00000000aaaaaaac,
  0x00000000aaaaaaab, 0x00000000ccccccce,
  0x00000000cccccccd, 0x00000000ffff8002,
  0x00000000ffff8001, 0x00000000ffff8003,
  0x00000000ffff8002, 0x00000000ffff8004,
  0x00000000ffff8003, 0x00000000ffff8005,
  0x00000000ffff8004, 0x00000000ffffff82,
  0x00000000ffffff81, 0x00000000ffffff83,
  0x00000000ffffff82, 0x00000000ffffff84,
  0x00000000ffffff83, 0x00000000ffffff85,
  0x00000000ffffff84, 0x00000000ffffffe2,
  0x00000000ffffffe1, 0x00000000ffffffff,
  0x00000000ffffffff, 0x000000010000003e,
  0x0000000100000000, 0x000000010000003f,
  0x0000000100000001, 0x0000000000000040,
  0x0000000000000002, 0x0000000000000041,
  0x0000000000000003, 0x0000000000000042,
  0x0000000000000004, 0x0000000000000060,
  0x0000000000000022, 0x00000000000000bd,
  0x000000000000007f, 0x00000000000000be,
  0x0000000000000080, 0x00000000000000bf,
  0x0000000000000081, 0x000000000000803d,
  0x0000000000007fff, 0x000000000000803e,
  0x0000000000008000, 0x000000000000803f,
  0x0000000000008001, 0x0000000033333373,
  0x0000000033333335, 0x0000000055555595,
  0x0000000055555557, 0x000000008000003d,
  0x000000007fffffff, 0x000000008000003e,
  0x0000000080000000, 0x000000008000003f,
  0x0000000080000001, 0x0000000080000040,
  0x0000000080000002, 0x0000000080000041,
  0x0000000080000003, 0x00000000aaaaaaea,
  0x00000000aaaaaaac, 0x00000000cccccd0c,
  0x00000000ccccccce, 0x00000000ffff8040,
  0x00000000ffff8002, 0x00000000ffff8041,
  0x00000000ffff8003, 0x00000000ffff8042,
  0x00000000ffff8004, 0x00000000ffff8043,
  0x00000000ffff8005, 0x00000000ffffffc0,
  0x00000000ffffff82, 0x00000000ffffffc1,
  0x00000000ffffff83, 0x00000000ffffffc2,
  0x00000000ffffff84, 0x00000000ffffffc3,
  0x00000000ffffff85, 0x0000000100000020,
  0x00000000ffffffe2, 0x000000010000003d,
  0x000000010000003d, 0x000000010000007b,
  0x000000010000003e, 0x000000010000007c,
  0x000000010000003f, 0x000000000000007d,
  0x0000000000000040, 0x000000000000007e,
  0x0000000000000041, 0x000000000000007f,
  0x0000000000000042, 0x000000000000009d,
  0x0000000000000060, 0x00000000000000fa,
  0x00000000000000bd, 0x00000000000000fb,
  0x00000000000000be, 0x00000000000000fc,
  0x00000000000000bf, 0x000000000000807a,
  0x000000000000803d, 0x000000000000807b,
  0x000000000000803e, 0x000000000000807c,
  0x000000000000803f, 0x00000000333333b0,
  0x0000000033333373, 0x00000000555555d2,
  0x0000000055555595, 0x000000008000007a,
  0x000000008000003d, 0x000000008000007b,
  0x000000008000003e, 0x000000008000007c,
  0x000000008000003f, 0x000000008000007d,
  0x0000000080000040, 0x000000008000007e,
  0x0000000080000041, 0x00000000aaaaab27,
  0x00000000aaaaaaea, 0x00000000cccccd49,
  0x00000000cccccd0c, 0x00000000ffff807d,
  0x00000000ffff8040, 0x00000000ffff807e,
  0x00000000ffff8041, 0x00000000ffff807f,
  0x00000000ffff8042, 0x00000000ffff8080,
  0x00000000ffff8043, 0x00000000fffffffd,
  0x00000000ffffffc0, 0x00000000fffffffe,
  0x00000000ffffffc1, 0x00000000ffffffff,
  0x00000000ffffffc2, 0x0000000100000000,
  0x00000000ffffffc3, 0x000000010000005d,
  0x0000000100000020, 0x000000010000007a,
  0x000000010000007a, 0x000000010000007c,
  0x000000010000007b, 0x000000010000007d,
  0x000000010000007c, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x000000000000009e,
  0x000000000000009d, 0x00000000000000fb,
  0x00000000000000fa, 0x00000000000000fc,
  0x00000000000000fb, 0x00000000000000fd,
  0x00000000000000fc, 0x000000000000807b,
  0x000000000000807a, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x00000000333333b1,
  0x00000000333333b0, 0x00000000555555d3,
  0x00000000555555d2, 0x000000008000007b,
  0x000000008000007a, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007e,
  0x000000008000007d, 0x000000008000007f,
  0x000000008000007e, 0x00000000aaaaab28,
  0x00000000aaaaab27, 0x00000000cccccd4a,
  0x00000000cccccd49, 0x00000000ffff807e,
  0x00000000ffff807d, 0x00000000ffff807f,
  0x00000000ffff807e, 0x00000000ffff8080,
  0x00000000ffff807f, 0x00000000ffff8081,
  0x00000000ffff8080, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x000000010000005e,
  0x000000010000005d, 0x000000010000007b,
  0x000000010000007b, 0x000000010000007d,
  0x000000010000007c, 0x000000010000007e,
  0x000000010000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000000081,
  0x0000000000000080, 0x000000000000009f,
  0x000000000000009e, 0x00000000000000fc,
  0x00000000000000fb, 0x00000000000000fd,
  0x00000000000000fc, 0x00000000000000fe,
  0x00000000000000fd, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807e,
  0x000000000000807d, 0x00000000333333b2,
  0x00000000333333b1, 0x00000000555555d4,
  0x00000000555555d3, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007e,
  0x000000008000007d, 0x000000008000007f,
  0x000000008000007e, 0x0000000080000080,
  0x000000008000007f, 0x00000000aaaaab29,
  0x00000000aaaaab28, 0x00000000cccccd4b,
  0x00000000cccccd4a, 0x00000000ffff807f,
  0x00000000ffff807e, 0x00000000ffff8080,
  0x00000000ffff807f, 0x00000000ffff8081,
  0x00000000ffff8080, 0x00000000ffff8082,
  0x00000000ffff8081, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x0000000100000002,
  0x0000000100000001, 0x000000010000005f,
  0x000000010000005e, 0x000000010000007c,
  0x000000010000007c, 0x0000000100007ffb,
  0x000000010000007d, 0x0000000100007ffc,
  0x000000010000007e, 0x0000000000007ffd,
  0x000000000000007f, 0x0000000000007ffe,
  0x0000000000000080, 0x0000000000007fff,
  0x0000000000000081, 0x000000000000801d,
  0x000000000000009f, 0x000000000000807a,
  0x00000000000000fc, 0x000000000000807b,
  0x00000000000000fd, 0x000000000000807c,
  0x00000000000000fe, 0x000000000000fffa,
  0x000000000000807c, 0x000000000000fffb,
  0x000000000000807d, 0x000000000000fffc,
  0x000000000000807e, 0x000000003333b330,
  0x00000000333333b2, 0x000000005555d552,
  0x00000000555555d4, 0x0000000080007ffa,
  0x000000008000007c, 0x0000000080007ffb,
  0x000000008000007d, 0x0000000080007ffc,
  0x000000008000007e, 0x0000000080007ffd,
  0x000000008000007f, 0x0000000080007ffe,
  0x0000000080000080, 0x00000000aaab2aa7,
  0x00000000aaaaab29, 0x00000000cccd4cc9,
  0x00000000cccccd4b, 0x00000000fffffffd,
  0x00000000ffff807f, 0x00000000fffffffe,
  0x00000000ffff8080, 0x00000000ffffffff,
  0x00000000ffff8081, 0x0000000100000000,
  0x00000000ffff8082, 0x0000000100007f7d,
  0x00000000ffffffff, 0x0000000100007f7e,
  0x0000000100000000, 0x0000000100007f7f,
  0x0000000100000001, 0x0000000100007f80,
  0x0000000100000002, 0x0000000100007fdd,
  0x000000010000005f, 0x0000000100007ffa,
  0x0000000100007ffa, 0x0000000100007ffc,
  0x0000000100007ffb, 0x0000000100007ffd,
  0x0000000100007ffc, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x000000000000801e,
  0x000000000000801d, 0x000000000000807b,
  0x000000000000807a, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000fffb,
  0x000000000000fffa, 0x000000000000fffc,
  0x000000000000fffb, 0x000000000000fffd,
  0x000000000000fffc, 0x000000003333b331,
  0x000000003333b330, 0x000000005555d553,
  0x000000005555d552, 0x0000000080007ffb,
  0x0000000080007ffa, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffe,
  0x0000000080007ffd, 0x0000000080007fff,
  0x0000000080007ffe, 0x00000000aaab2aa8,
  0x00000000aaab2aa7, 0x00000000cccd4cca,
  0x00000000cccd4cc9, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x0000000100007f7e,
  0x0000000100007f7d, 0x0000000100007f7f,
  0x0000000100007f7e, 0x0000000100007f80,
  0x0000000100007f7f, 0x0000000100007f81,
  0x0000000100007f80, 0x0000000100007fde,
  0x0000000100007fdd, 0x0000000100007ffb,
  0x0000000100007ffb, 0x0000000100007ffd,
  0x0000000100007ffc, 0x0000000100007ffe,
  0x0000000100007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000008001,
  0x0000000000008000, 0x000000000000801f,
  0x000000000000801e, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807e,
  0x000000000000807d, 0x000000000000fffc,
  0x000000000000fffb, 0x000000000000fffd,
  0x000000000000fffc, 0x000000000000fffe,
  0x000000000000fffd, 0x000000003333b332,
  0x000000003333b331, 0x000000005555d554,
  0x000000005555d553, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffe,
  0x0000000080007ffd, 0x0000000080007fff,
  0x0000000080007ffe, 0x0000000080008000,
  0x0000000080007fff, 0x00000000aaab2aa9,
  0x00000000aaab2aa8, 0x00000000cccd4ccb,
  0x00000000cccd4cca, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x0000000100000002,
  0x0000000100000001, 0x0000000100007f7f,
  0x0000000100007f7e, 0x0000000100007f80,
  0x0000000100007f7f, 0x0000000100007f81,
  0x0000000100007f80, 0x0000000100007f82,
  0x0000000100007f81, 0x0000000100007fdf,
  0x0000000100007fde, 0x0000000100007ffc,
  0x0000000100007ffc, 0x000000017ffffffb,
  0x0000000100007ffd, 0x000000017ffffffc,
  0x0000000100007ffe, 0x000000007ffffffd,
  0x0000000000007fff, 0x000000007ffffffe,
  0x0000000000008000, 0x000000007fffffff,
  0x0000000000008001, 0x000000008000001d,
  0x000000000000801f, 0x000000008000007a,
  0x000000000000807c, 0x000000008000007b,
  0x000000000000807d, 0x000000008000007c,
  0x000000000000807e, 0x0000000080007ffa,
  0x000000000000fffc, 0x0000000080007ffb,
  0x000000000000fffd, 0x0000000080007ffc,
  0x000000000000fffe, 0x00000000b3333330,
  0x000000003333b332, 0x00000000d5555552,
  0x000000005555d554, 0x00000000fffffffa,
  0x0000000080007ffc, 0x00000000fffffffb,
  0x0000000080007ffd, 0x00000000fffffffc,
  0x0000000080007ffe, 0x00000000fffffffd,
  0x0000000080007fff, 0x00000000fffffffe,
  0x0000000080008000, 0x000000012aaaaaa7,
  0x00000000aaab2aa9, 0x000000014cccccc9,
  0x00000000cccd4ccb, 0x000000017fff7ffd,
  0x00000000ffffffff, 0x000000017fff7ffe,
  0x0000000100000000, 0x000000017fff7fff,
  0x0000000100000001, 0x000000017fff8000,
  0x0000000100000002, 0x000000017fffff7d,
  0x0000000100007f7f, 0x000000017fffff7e,
  0x0000000100007f80, 0x000000017fffff7f,
  0x0000000100007f81, 0x000000017fffff80,
  0x0000000100007f82, 0x000000017fffffdd,
  0x0000000100007fdf, 0x000000017ffffffa,
  0x000000017ffffffa, 0x000000017ffffffc,
  0x000000017ffffffb, 0x000000017ffffffd,
  0x000000017ffffffc, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x000000008000001e,
  0x000000008000001d, 0x000000008000007b,
  0x000000008000007a, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x0000000080007ffb,
  0x0000000080007ffa, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x00000000b3333331,
  0x00000000b3333330, 0x00000000d5555553,
  0x00000000d5555552, 0x00000000fffffffb,
  0x00000000fffffffa, 0x00000000fffffffc,
  0x00000000fffffffb, 0x00000000fffffffd,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000ffffffff,
  0x00000000fffffffe, 0x000000012aaaaaa8,
  0x000000012aaaaaa7, 0x000000014cccccca,
  0x000000014cccccc9, 0x000000017fff7ffe,
  0x000000017fff7ffd, 0x000000017fff7fff,
  0x000000017fff7ffe, 0x000000017fff8000,
  0x000000017fff7fff, 0x000000017fff8001,
  0x000000017fff8000, 0x000000017fffff7e,
  0x000000017fffff7d, 0x000000017fffff7f,
  0x000000017fffff7e, 0x000000017fffff80,
  0x000000017fffff7f, 0x000000017fffff81,
  0x000000017fffff80, 0x000000017fffffde,
  0x000000017fffffdd, 0x000000017ffffffb,
  0x000000017ffffffb, 0x000000017ffffffd,
  0x000000017ffffffc, 0x000000017ffffffe,
  0x000000017ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0x000000008000001f,
  0x000000008000001e, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007e,
  0x000000008000007d, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffe,
  0x0000000080007ffd, 0x00000000b3333332,
  0x00000000b3333331, 0x00000000d5555554,
  0x00000000d5555553, 0x00000000fffffffc,
  0x00000000fffffffb, 0x00000000fffffffd,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x000000012aaaaaa9,
  0x000000012aaaaaa8, 0x000000014ccccccb,
  0x000000014cccccca, 0x000000017fff7fff,
  0x000000017fff7ffe, 0x000000017fff8000,
  0x000000017fff7fff, 0x000000017fff8001,
  0x000000017fff8000, 0x000000017fff8002,
  0x000000017fff8001, 0x000000017fffff7f,
  0x000000017fffff7e, 0x000000017fffff80,
  0x000000017fffff7f, 0x000000017fffff81,
  0x000000017fffff80, 0x000000017fffff82,
  0x000000017fffff81, 0x000000017fffffdf,
  0x000000017fffffde, 0x000000017ffffffc,
  0x000000017ffffffc, 0x3333333433333331,
  0x000000017ffffffd, 0x3333333433333332,
  0x000000017ffffffe, 0x3333333333333333,
  0x000000007fffffff, 0x3333333333333334,
  0x0000000080000000, 0x3333333333333335,
  0x0000000080000001, 0x3333333333333353,
  0x000000008000001f, 0x33333333333333b0,
  0x000000008000007c, 0x33333333333333b1,
  0x000000008000007d, 0x33333333333333b2,
  0x000000008000007e, 0x333333333333b330,
  0x0000000080007ffc, 0x333333333333b331,
  0x0000000080007ffd, 0x333333333333b332,
  0x0000000080007ffe, 0x3333333366666666,
  0x00000000b3333332, 0x3333333388888888,
  0x00000000d5555554, 0x33333333b3333330,
  0x00000000fffffffc, 0x33333333b3333331,
  0x00000000fffffffd, 0x33333333b3333332,
  0x00000000fffffffe, 0x33333333b3333333,
  0x00000000ffffffff, 0x33333333b3333334,
  0x0000000100000000, 0x33333333dddddddd,
  0x000000012aaaaaa9, 0x33333333ffffffff,
  0x000000014ccccccb, 0x333333343332b333,
  0x000000017fff7fff, 0x333333343332b334,
  0x000000017fff8000, 0x333333343332b335,
  0x000000017fff8001, 0x333333343332b336,
  0x000000017fff8002, 0x33333334333332b3,
  0x000000017fffff7f, 0x33333334333332b4,
  0x000000017fffff80, 0x33333334333332b5,
  0x000000017fffff81, 0x33333334333332b6,
  0x000000017fffff82, 0x3333333433333313,
  0x000000017fffffdf, 0x3333333433333330,
  0x3333333433333330, 0x5555555655555553,
  0x3333333433333331, 0x5555555655555554,
  0x3333333433333332, 0x5555555555555555,
  0x3333333333333333, 0x5555555555555556,
  0x3333333333333334, 0x5555555555555557,
  0x3333333333333335, 0x5555555555555575,
  0x3333333333333353, 0x55555555555555d2,
  0x33333333333333b0, 0x55555555555555d3,
  0x33333333333333b1, 0x55555555555555d4,
  0x33333333333333b2, 0x555555555555d552,
  0x333333333333b330, 0x555555555555d553,
  0x333333333333b331, 0x555555555555d554,
  0x333333333333b332, 0x5555555588888888,
  0x3333333366666666, 0x55555555aaaaaaaa,
  0x3333333388888888, 0x55555555d5555552,
  0x33333333b3333330, 0x55555555d5555553,
  0x33333333b3333331, 0x55555555d5555554,
  0x33333333b3333332, 0x55555555d5555555,
  0x33333333b3333333, 0x55555555d5555556,
  0x33333333b3333334, 0x55555555ffffffff,
  0x33333333dddddddd, 0x5555555622222221,
  0x33333333ffffffff, 0x555555565554d555,
  0x333333343332b333, 0x555555565554d556,
  0x333333343332b334, 0x555555565554d557,
  0x333333343332b335, 0x555555565554d558,
  0x333333343332b336, 0x55555556555554d5,
  0x33333334333332b3, 0x55555556555554d6,
  0x33333334333332b4, 0x55555556555554d7,
  0x33333334333332b5, 0x55555556555554d8,
  0x33333334333332b6, 0x5555555655555535,
  0x3333333433333313, 0x5555555655555552,
  0x5555555655555552, 0x80000000fffffffb,
  0x5555555655555553, 0x80000000fffffffc,
  0x5555555655555554, 0x7ffffffffffffffd,
  0x5555555555555555, 0x7ffffffffffffffe,
  0x5555555555555556, 0x7fffffffffffffff,
  0x5555555555555557, 0x800000000000001d,
  0x5555555555555575, 0x800000000000007a,
  0x55555555555555d2, 0x800000000000007b,
  0x55555555555555d3, 0x800000000000007c,
  0x55555555555555d4, 0x8000000000007ffa,
  0x555555555555d552, 0x8000000000007ffb,
  0x555555555555d553, 0x8000000000007ffc,
  0x555555555555d554, 0x8000000033333330,
  0x5555555588888888, 0x8000000055555552,
  0x55555555aaaaaaaa, 0x800000007ffffffa,
  0x55555555d5555552, 0x800000007ffffffb,
  0x55555555d5555553, 0x800000007ffffffc,
  0x55555555d5555554, 0x800000007ffffffd,
  0x55555555d5555555, 0x800000007ffffffe,
  0x55555555d5555556, 0x80000000aaaaaaa7,
  0x55555555ffffffff, 0x80000000ccccccc9,
  0x5555555622222221, 0x80000000ffff7ffd,
  0x555555565554d555, 0x80000000ffff7ffe,
  0x555555565554d556, 0x80000000ffff7fff,
  0x555555565554d557, 0x80000000ffff8000,
  0x555555565554d558, 0x80000000ffffff7d,
  0x55555556555554d5, 0x80000000ffffff7e,
  0x55555556555554d6, 0x80000000ffffff7f,
  0x55555556555554d7, 0x80000000ffffff80,
  0x55555556555554d8, 0x80000000ffffffdd,
  0x5555555655555535, 0x80000000fffffffa,
  0x80000000fffffffa, 0x80000000fffffffc,
  0x80000000fffffffb, 0x80000000fffffffd,
  0x80000000fffffffc, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x8000000000000000,
  0x7fffffffffffffff, 0x800000000000001e,
  0x800000000000001d, 0x800000000000007b,
  0x800000000000007a, 0x800000000000007c,
  0x800000000000007b, 0x800000000000007d,
  0x800000000000007c, 0x8000000000007ffb,
  0x8000000000007ffa, 0x8000000000007ffc,
  0x8000000000007ffb, 0x8000000000007ffd,
  0x8000000000007ffc, 0x8000000033333331,
  0x8000000033333330, 0x8000000055555553,
  0x8000000055555552, 0x800000007ffffffb,
  0x800000007ffffffa, 0x800000007ffffffc,
  0x800000007ffffffb, 0x800000007ffffffd,
  0x800000007ffffffc, 0x800000007ffffffe,
  0x800000007ffffffd, 0x800000007fffffff,
  0x800000007ffffffe, 0x80000000aaaaaaa8,
  0x80000000aaaaaaa7, 0x80000000ccccccca,
  0x80000000ccccccc9, 0x80000000ffff7ffe,
  0x80000000ffff7ffd, 0x80000000ffff7fff,
  0x80000000ffff7ffe, 0x80000000ffff8000,
  0x80000000ffff7fff, 0x80000000ffff8001,
  0x80000000ffff8000, 0x80000000ffffff7e,
  0x80000000ffffff7d, 0x80000000ffffff7f,
  0x80000000ffffff7e, 0x80000000ffffff80,
  0x80000000ffffff7f, 0x80000000ffffff81,
  0x80000000ffffff80, 0x80000000ffffffde,
  0x80000000ffffffdd, 0x80000000fffffffb,
  0x80000000fffffffb, 0x80000000fffffffd,
  0x80000000fffffffc, 0x80000000fffffffe,
  0x80000000fffffffd, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000001,
  0x8000000000000000, 0x800000000000001f,
  0x800000000000001e, 0x800000000000007c,
  0x800000000000007b, 0x800000000000007d,
  0x800000000000007c, 0x800000000000007e,
  0x800000000000007d, 0x8000000000007ffc,
  0x8000000000007ffb, 0x8000000000007ffd,
  0x8000000000007ffc, 0x8000000000007ffe,
  0x8000000000007ffd, 0x8000000033333332,
  0x8000000033333331, 0x8000000055555554,
  0x8000000055555553, 0x800000007ffffffc,
  0x800000007ffffffb, 0x800000007ffffffd,
  0x800000007ffffffc, 0x800000007ffffffe,
  0x800000007ffffffd, 0x800000007fffffff,
  0x800000007ffffffe, 0x8000000080000000,
  0x800000007fffffff, 0x80000000aaaaaaa9,
  0x80000000aaaaaaa8, 0x80000000cccccccb,
  0x80000000ccccccca, 0x80000000ffff7fff,
  0x80000000ffff7ffe, 0x80000000ffff8000,
  0x80000000ffff7fff, 0x80000000ffff8001,
  0x80000000ffff8000, 0x80000000ffff8002,
  0x80000000ffff8001, 0x80000000ffffff7f,
  0x80000000ffffff7e, 0x80000000ffffff80,
  0x80000000ffffff7f, 0x80000000ffffff81,
  0x80000000ffffff80, 0x80000000ffffff82,
  0x80000000ffffff81, 0x80000000ffffffdf,
  0x80000000ffffffde, 0x80000000fffffffc,
  0x80000000fffffffc, 0x80000000fffffffe,
  0x80000000fffffffd, 0x80000000ffffffff,
  0x80000000fffffffe, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000020,
  0x800000000000001f, 0x800000000000007d,
  0x800000000000007c, 0x800000000000007e,
  0x800000000000007d, 0x800000000000007f,
  0x800000000000007e, 0x8000000000007ffd,
  0x8000000000007ffc, 0x8000000000007ffe,
  0x8000000000007ffd, 0x8000000000007fff,
  0x8000000000007ffe, 0x8000000033333333,
  0x8000000033333332, 0x8000000055555555,
  0x8000000055555554, 0x800000007ffffffd,
  0x800000007ffffffc, 0x800000007ffffffe,
  0x800000007ffffffd, 0x800000007fffffff,
  0x800000007ffffffe, 0x8000000080000000,
  0x800000007fffffff, 0x8000000080000001,
  0x8000000080000000, 0x80000000aaaaaaaa,
  0x80000000aaaaaaa9, 0x80000000cccccccc,
  0x80000000cccccccb, 0x80000000ffff8000,
  0x80000000ffff7fff, 0x80000000ffff8001,
  0x80000000ffff8000, 0x80000000ffff8002,
  0x80000000ffff8001, 0x80000000ffff8003,
  0x80000000ffff8002, 0x80000000ffffff80,
  0x80000000ffffff7f, 0x80000000ffffff81,
  0x80000000ffffff80, 0x80000000ffffff82,
  0x80000000ffffff81, 0x80000000ffffff83,
  0x80000000ffffff82, 0x80000000ffffffe0,
  0x80000000ffffffdf, 0x80000000fffffffd,
  0x80000000fffffffd, 0x80000000ffffffff,
  0x80000000fffffffe, 0x8000000100000000,
  0x80000000ffffffff, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000021,
  0x8000000000000020, 0x800000000000007e,
  0x800000000000007d, 0x800000000000007f,
  0x800000000000007e, 0x8000000000000080,
  0x800000000000007f, 0x8000000000007ffe,
  0x8000000000007ffd, 0x8000000000007fff,
  0x8000000000007ffe, 0x8000000000008000,
  0x8000000000007fff, 0x8000000033333334,
  0x8000000033333333, 0x8000000055555556,
  0x8000000055555555, 0x800000007ffffffe,
  0x800000007ffffffd, 0x800000007fffffff,
  0x800000007ffffffe, 0x8000000080000000,
  0x800000007fffffff, 0x8000000080000001,
  0x8000000080000000, 0x8000000080000002,
  0x8000000080000001, 0x80000000aaaaaaab,
  0x80000000aaaaaaaa, 0x80000000cccccccd,
  0x80000000cccccccc, 0x80000000ffff8001,
  0x80000000ffff8000, 0x80000000ffff8002,
  0x80000000ffff8001, 0x80000000ffff8003,
  0x80000000ffff8002, 0x80000000ffff8004,
  0x80000000ffff8003, 0x80000000ffffff81,
  0x80000000ffffff80, 0x80000000ffffff82,
  0x80000000ffffff81, 0x80000000ffffff83,
  0x80000000ffffff82, 0x80000000ffffff84,
  0x80000000ffffff83, 0x80000000ffffffe1,
  0x80000000ffffffe0, 0x80000000fffffffe,
  0x80000000fffffffe, 0x8000000100000000,
  0x80000000ffffffff, 0x8000000100000001,
  0x8000000100000000, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000004,
  0x8000000000000003, 0x8000000000000022,
  0x8000000000000021, 0x800000000000007f,
  0x800000000000007e, 0x8000000000000080,
  0x800000000000007f, 0x8000000000000081,
  0x8000000000000080, 0x8000000000007fff,
  0x8000000000007ffe, 0x8000000000008000,
  0x8000000000007fff, 0x8000000000008001,
  0x8000000000008000, 0x8000000033333335,
  0x8000000033333334, 0x8000000055555557,
  0x8000000055555556, 0x800000007fffffff,
  0x800000007ffffffe, 0x8000000080000000,
  0x800000007fffffff, 0x8000000080000001,
  0x8000000080000000, 0x8000000080000002,
  0x8000000080000001, 0x8000000080000003,
  0x8000000080000002, 0x80000000aaaaaaac,
  0x80000000aaaaaaab, 0x80000000ccccccce,
  0x80000000cccccccd, 0x80000000ffff8002,
  0x80000000ffff8001, 0x80000000ffff8003,
  0x80000000ffff8002, 0x80000000ffff8004,
  0x80000000ffff8003, 0x80000000ffff8005,
  0x80000000ffff8004, 0x80000000ffffff82,
  0x80000000ffffff81, 0x80000000ffffff83,
  0x80000000ffffff82, 0x80000000ffffff84,
  0x80000000ffffff83, 0x80000000ffffff85,
  0x80000000ffffff84, 0x80000000ffffffe2,
  0x80000000ffffffe1, 0x80000000ffffffff,
  0x80000000ffffffff, 0x8000000100000001,
  0x8000000100000000, 0x8000000100000002,
  0x8000000100000001, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000004,
  0x8000000000000003, 0x8000000000000005,
  0x8000000000000004, 0x8000000000000023,
  0x8000000000000022, 0x8000000000000080,
  0x800000000000007f, 0x8000000000000081,
  0x8000000000000080, 0x8000000000000082,
  0x8000000000000081, 0x8000000000008000,
  0x8000000000007fff, 0x8000000000008001,
  0x8000000000008000, 0x8000000000008002,
  0x8000000000008001, 0x8000000033333336,
  0x8000000033333335, 0x8000000055555558,
  0x8000000055555557, 0x8000000080000000,
  0x800000007fffffff, 0x8000000080000001,
  0x8000000080000000, 0x8000000080000002,
  0x8000000080000001, 0x8000000080000003,
  0x8000000080000002, 0x8000000080000004,
  0x8000000080000003, 0x80000000aaaaaaad,
  0x80000000aaaaaaac, 0x80000000cccccccf,
  0x80000000ccccccce, 0x80000000ffff8003,
  0x80000000ffff8002, 0x80000000ffff8004,
  0x80000000ffff8003, 0x80000000ffff8005,
  0x80000000ffff8004, 0x80000000ffff8006,
  0x80000000ffff8005, 0x80000000ffffff83,
  0x80000000ffffff82, 0x80000000ffffff84,
  0x80000000ffffff83, 0x80000000ffffff85,
  0x80000000ffffff84, 0x80000000ffffff86,
  0x80000000ffffff85, 0x80000000ffffffe3,
  0x80000000ffffffe2, 0x8000000100000000,
  0x8000000100000000, 0xaaaaaaabaaaaaaa8,
  0x8000000100000001, 0xaaaaaaabaaaaaaa9,
  0x8000000100000002, 0xaaaaaaaaaaaaaaaa,
  0x8000000000000003, 0xaaaaaaaaaaaaaaab,
  0x8000000000000004, 0xaaaaaaaaaaaaaaac,
  0x8000000000000005, 0xaaaaaaaaaaaaaaca,
  0x8000000000000023, 0xaaaaaaaaaaaaab27,
  0x8000000000000080, 0xaaaaaaaaaaaaab28,
  0x8000000000000081, 0xaaaaaaaaaaaaab29,
  0x8000000000000082, 0xaaaaaaaaaaab2aa7,
  0x8000000000008000, 0xaaaaaaaaaaab2aa8,
  0x8000000000008001, 0xaaaaaaaaaaab2aa9,
  0x8000000000008002, 0xaaaaaaaadddddddd,
  0x8000000033333336, 0xaaaaaaaaffffffff,
  0x8000000055555558, 0xaaaaaaab2aaaaaa7,
  0x8000000080000000, 0xaaaaaaab2aaaaaa8,
  0x8000000080000001, 0xaaaaaaab2aaaaaa9,
  0x8000000080000002, 0xaaaaaaab2aaaaaaa,
  0x8000000080000003, 0xaaaaaaab2aaaaaab,
  0x8000000080000004, 0xaaaaaaab55555554,
  0x80000000aaaaaaad, 0xaaaaaaab77777776,
  0x80000000cccccccf, 0xaaaaaaabaaaa2aaa,
  0x80000000ffff8003, 0xaaaaaaabaaaa2aab,
  0x80000000ffff8004, 0xaaaaaaabaaaa2aac,
  0x80000000ffff8005, 0xaaaaaaabaaaa2aad,
  0x80000000ffff8006, 0xaaaaaaabaaaaaa2a,
  0x80000000ffffff83, 0xaaaaaaabaaaaaa2b,
  0x80000000ffffff84, 0xaaaaaaabaaaaaa2c,
  0x80000000ffffff85, 0xaaaaaaabaaaaaa2d,
  0x80000000ffffff86, 0xaaaaaaabaaaaaa8a,
  0x80000000ffffffe3, 0xaaaaaaabaaaaaaa7,
  0xaaaaaaabaaaaaaa7, 0xcccccccdccccccca,
  0xaaaaaaabaaaaaaa8, 0xcccccccdcccccccb,
  0xaaaaaaabaaaaaaa9, 0xcccccccccccccccc,
  0xaaaaaaaaaaaaaaaa, 0xcccccccccccccccd,
  0xaaaaaaaaaaaaaaab, 0xccccccccccccccce,
  0xaaaaaaaaaaaaaaac, 0xccccccccccccccec,
  0xaaaaaaaaaaaaaaca, 0xcccccccccccccd49,
  0xaaaaaaaaaaaaab27, 0xcccccccccccccd4a,
  0xaaaaaaaaaaaaab28, 0xcccccccccccccd4b,
  0xaaaaaaaaaaaaab29, 0xcccccccccccd4cc9,
  0xaaaaaaaaaaab2aa7, 0xcccccccccccd4cca,
  0xaaaaaaaaaaab2aa8, 0xcccccccccccd4ccb,
  0xaaaaaaaaaaab2aa9, 0xccccccccffffffff,
  0xaaaaaaaadddddddd, 0xcccccccd22222221,
  0xaaaaaaaaffffffff, 0xcccccccd4cccccc9,
  0xaaaaaaab2aaaaaa7, 0xcccccccd4cccccca,
  0xaaaaaaab2aaaaaa8, 0xcccccccd4ccccccb,
  0xaaaaaaab2aaaaaa9, 0xcccccccd4ccccccc,
  0xaaaaaaab2aaaaaaa, 0xcccccccd4ccccccd,
  0xaaaaaaab2aaaaaab, 0xcccccccd77777776,
  0xaaaaaaab55555554, 0xcccccccd99999998,
  0xaaaaaaab77777776, 0xcccccccdcccc4ccc,
  0xaaaaaaabaaaa2aaa, 0xcccccccdcccc4ccd,
  0xaaaaaaabaaaa2aab, 0xcccccccdcccc4cce,
  0xaaaaaaabaaaa2aac, 0xcccccccdcccc4ccf,
  0xaaaaaaabaaaa2aad, 0xcccccccdcccccc4c,
  0xaaaaaaabaaaaaa2a, 0xcccccccdcccccc4d,
  0xaaaaaaabaaaaaa2b, 0xcccccccdcccccc4e,
  0xaaaaaaabaaaaaa2c, 0xcccccccdcccccc4f,
  0xaaaaaaabaaaaaa2d, 0xcccccccdccccccac,
  0xaaaaaaabaaaaaa8a, 0xcccccccdccccccc9,
  0xcccccccdccccccc9, 0x000000007ffffffe,
  0xcccccccdccccccca, 0x000000007fffffff,
  0xcccccccdcccccccb, 0xffffffff80000000,
  0xcccccccccccccccc, 0xffffffff80000001,
  0xcccccccccccccccd, 0xffffffff80000002,
  0xccccccccccccccce, 0xffffffff80000020,
  0xccccccccccccccec, 0xffffffff8000007d,
  0xcccccccccccccd49, 0xffffffff8000007e,
  0xcccccccccccccd4a, 0xffffffff8000007f,
  0xcccccccccccccd4b, 0xffffffff80007ffd,
  0xcccccccccccd4cc9, 0xffffffff80007ffe,
  0xcccccccccccd4cca, 0xffffffff80007fff,
  0xcccccccccccd4ccb, 0xffffffffb3333333,
  0xccccccccffffffff, 0xffffffffd5555555,
  0xcccccccd22222221, 0xfffffffffffffffd,
  0xcccccccd4cccccc9, 0xfffffffffffffffe,
  0xcccccccd4cccccca, 0xffffffffffffffff,
  0xcccccccd4ccccccb, 0x0000000000000000,
  0xcccccccd4ccccccc, 0x0000000000000001,
  0xcccccccd4ccccccd, 0x000000002aaaaaaa,
  0xcccccccd77777776, 0x000000004ccccccc,
  0xcccccccd99999998, 0x000000007fff8000,
  0xcccccccdcccc4ccc, 0x000000007fff8001,
  0xcccccccdcccc4ccd, 0x000000007fff8002,
  0xcccccccdcccc4cce, 0x000000007fff8003,
  0xcccccccdcccc4ccf, 0x000000007fffff80,
  0xcccccccdcccccc4c, 0x000000007fffff81,
  0xcccccccdcccccc4d, 0x000000007fffff82,
  0xcccccccdcccccc4e, 0x000000007fffff83,
  0xcccccccdcccccc4f, 0x000000007fffffe0,
  0xcccccccdccccccac, 0x000000007ffffffd,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000021,
  0xffffffff80000020, 0xffffffff8000007e,
  0xffffffff8000007d, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff80007ffe,
  0xffffffff80007ffd, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffffb3333334,
  0xffffffffb3333333, 0xffffffffd5555556,
  0xffffffffd5555555, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x000000002aaaaaab,
  0x000000002aaaaaaa, 0x000000004ccccccd,
  0x000000004ccccccc, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fff8003,
  0x000000007fff8002, 0x000000007fff8004,
  0x000000007fff8003, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffff83,
  0x000000007fffff82, 0x000000007fffff84,
  0x000000007fffff83, 0x000000007fffffe1,
  0x000000007fffffe0, 0x000000007ffffffe,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000004,
  0xffffffff80000003, 0xffffffff80000022,
  0xffffffff80000021, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffff80008001,
  0xffffffff80008000, 0xffffffffb3333335,
  0xffffffffb3333334, 0xffffffffd5555557,
  0xffffffffd5555556, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000002, 0x000000002aaaaaac,
  0x000000002aaaaaab, 0x000000004cccccce,
  0x000000004ccccccd, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fff8003,
  0x000000007fff8002, 0x000000007fff8004,
  0x000000007fff8003, 0x000000007fff8005,
  0x000000007fff8004, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffff83,
  0x000000007fffff82, 0x000000007fffff84,
  0x000000007fffff83, 0x000000007fffff85,
  0x000000007fffff84, 0x000000007fffffe2,
  0x000000007fffffe1, 0x000000007fffffff,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000002,
  0x0000000080000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000004,
  0xffffffff80000003, 0xffffffff80000005,
  0xffffffff80000004, 0xffffffff80000023,
  0xffffffff80000022, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffff80000082,
  0xffffffff80000081, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffff80008001,
  0xffffffff80008000, 0xffffffff80008002,
  0xffffffff80008001, 0xffffffffb3333336,
  0xffffffffb3333335, 0xffffffffd5555558,
  0xffffffffd5555557, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000004,
  0x0000000000000003, 0x000000002aaaaaad,
  0x000000002aaaaaac, 0x000000004ccccccf,
  0x000000004cccccce, 0x000000007fff8003,
  0x000000007fff8002, 0x000000007fff8004,
  0x000000007fff8003, 0x000000007fff8005,
  0x000000007fff8004, 0x000000007fff8006,
  0x000000007fff8005, 0x000000007fffff83,
  0x000000007fffff82, 0x000000007fffff84,
  0x000000007fffff83, 0x000000007fffff85,
  0x000000007fffff84, 0x000000007fffff86,
  0x000000007fffff85, 0x000000007fffffe3,
  0x000000007fffffe2, 0x0000000080000000,
  0x0000000080000000, 0x00000000ffff7ffe,
  0x0000000080000001, 0x00000000ffff7fff,
  0x0000000080000002, 0xffffffffffff8000,
  0xffffffff80000003, 0xffffffffffff8001,
  0xffffffff80000004, 0xffffffffffff8002,
  0xffffffff80000005, 0xffffffffffff8020,
  0xffffffff80000023, 0xffffffffffff807d,
  0xffffffff80000080, 0xffffffffffff807e,
  0xffffffff80000081, 0xffffffffffff807f,
  0xffffffff80000082, 0xfffffffffffffffd,
  0xffffffff80008000, 0xfffffffffffffffe,
  0xffffffff80008001, 0xffffffffffffffff,
  0xffffffff80008002, 0x000000003332b333,
  0xffffffffb3333336, 0x000000005554d555,
  0xffffffffd5555558, 0x000000007fff7ffd,
  0x0000000000000000, 0x000000007fff7ffe,
  0x0000000000000001, 0x000000007fff7fff,
  0x0000000000000002, 0x000000007fff8000,
  0x0000000000000003, 0x000000007fff8001,
  0x0000000000000004, 0x00000000aaaa2aaa,
  0x000000002aaaaaad, 0x00000000cccc4ccc,
  0x000000004ccccccf, 0x00000000ffff0000,
  0x000000007fff8003, 0x00000000ffff0001,
  0x000000007fff8004, 0x00000000ffff0002,
  0x000000007fff8005, 0x00000000ffff0003,
  0x000000007fff8006, 0x00000000ffff7f80,
  0x000000007fffff83, 0x00000000ffff7f81,
  0x000000007fffff84, 0x00000000ffff7f82,
  0x000000007fffff85, 0x00000000ffff7f83,
  0x000000007fffff86, 0x00000000ffff7fe0,
  0x000000007fffffe3, 0x00000000ffff7ffd,
  0x00000000ffff7ffd, 0x00000000ffff7fff,
  0x00000000ffff7ffe, 0x00000000ffff8000,
  0x00000000ffff7fff, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8021,
  0xffffffffffff8020, 0xffffffffffff807e,
  0xffffffffffff807d, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8080,
  0xffffffffffff807f, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x000000003332b334,
  0x000000003332b333, 0x000000005554d556,
  0x000000005554d555, 0x000000007fff7ffe,
  0x000000007fff7ffd, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8002,
  0x000000007fff8001, 0x00000000aaaa2aab,
  0x00000000aaaa2aaa, 0x00000000cccc4ccd,
  0x00000000cccc4ccc, 0x00000000ffff0001,
  0x00000000ffff0000, 0x00000000ffff0002,
  0x00000000ffff0001, 0x00000000ffff0003,
  0x00000000ffff0002, 0x00000000ffff0004,
  0x00000000ffff0003, 0x00000000ffff7f81,
  0x00000000ffff7f80, 0x00000000ffff7f82,
  0x00000000ffff7f81, 0x00000000ffff7f83,
  0x00000000ffff7f82, 0x00000000ffff7f84,
  0x00000000ffff7f83, 0x00000000ffff7fe1,
  0x00000000ffff7fe0, 0x00000000ffff7ffe,
  0x00000000ffff7ffe, 0x00000000ffff8000,
  0x00000000ffff7fff, 0x00000000ffff8001,
  0x00000000ffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8022,
  0xffffffffffff8021, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x000000003332b335,
  0x000000003332b334, 0x000000005554d557,
  0x000000005554d556, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fff8003,
  0x000000007fff8002, 0x00000000aaaa2aac,
  0x00000000aaaa2aab, 0x00000000cccc4cce,
  0x00000000cccc4ccd, 0x00000000ffff0002,
  0x00000000ffff0001, 0x00000000ffff0003,
  0x00000000ffff0002, 0x00000000ffff0004,
  0x00000000ffff0003, 0x00000000ffff0005,
  0x00000000ffff0004, 0x00000000ffff7f82,
  0x00000000ffff7f81, 0x00000000ffff7f83,
  0x00000000ffff7f82, 0x00000000ffff7f84,
  0x00000000ffff7f83, 0x00000000ffff7f85,
  0x00000000ffff7f84, 0x00000000ffff7fe2,
  0x00000000ffff7fe1, 0x00000000ffff7fff,
  0x00000000ffff7fff, 0x00000000ffff8001,
  0x00000000ffff8000, 0x00000000ffff8002,
  0x00000000ffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8005,
  0xffffffffffff8004, 0xffffffffffff8023,
  0xffffffffffff8022, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffff8082,
  0xffffffffffff8081, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x000000003332b336,
  0x000000003332b335, 0x000000005554d558,
  0x000000005554d557, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fff8003,
  0x000000007fff8002, 0x000000007fff8004,
  0x000000007fff8003, 0x00000000aaaa2aad,
  0x00000000aaaa2aac, 0x00000000cccc4ccf,
  0x00000000cccc4cce, 0x00000000ffff0003,
  0x00000000ffff0002, 0x00000000ffff0004,
  0x00000000ffff0003, 0x00000000ffff0005,
  0x00000000ffff0004, 0x00000000ffff0006,
  0x00000000ffff0005, 0x00000000ffff7f83,
  0x00000000ffff7f82, 0x00000000ffff7f84,
  0x00000000ffff7f83, 0x00000000ffff7f85,
  0x00000000ffff7f84, 0x00000000ffff7f86,
  0x00000000ffff7f85, 0x00000000ffff7fe3,
  0x00000000ffff7fe2, 0x00000000ffff8000,
  0x00000000ffff8000, 0x00000000ffffff7e,
  0x00000000ffff8001, 0x00000000ffffff7f,
  0x00000000ffff8002, 0xffffffffffffff80,
  0xffffffffffff8003, 0xffffffffffffff81,
  0xffffffffffff8004, 0xffffffffffffff82,
  0xffffffffffff8005, 0xffffffffffffffa0,
  0xffffffffffff8023, 0xfffffffffffffffd,
  0xffffffffffff8080, 0xfffffffffffffffe,
  0xffffffffffff8081, 0xffffffffffffffff,
  0xffffffffffff8082, 0x0000000000007f7d,
  0x0000000000000000, 0x0000000000007f7e,
  0x0000000000000001, 0x0000000000007f7f,
  0x0000000000000002, 0x00000000333332b3,
  0x000000003332b336, 0x00000000555554d5,
  0x000000005554d558, 0x000000007fffff7d,
  0x000000007fff8000, 0x000000007fffff7e,
  0x000000007fff8001, 0x000000007fffff7f,
  0x000000007fff8002, 0x000000007fffff80,
  0x000000007fff8003, 0x000000007fffff81,
  0x000000007fff8004, 0x00000000aaaaaa2a,
  0x00000000aaaa2aad, 0x00000000cccccc4c,
  0x00000000cccc4ccf, 0x00000000ffff7f80,
  0x00000000ffff0003, 0x00000000ffff7f81,
  0x00000000ffff0004, 0x00000000ffff7f82,
  0x00000000ffff0005, 0x00000000ffff7f83,
  0x00000000ffff0006, 0x00000000ffffff00,
  0x00000000ffff7f83, 0x00000000ffffff01,
  0x00000000ffff7f84, 0x00000000ffffff02,
  0x00000000ffff7f85, 0x00000000ffffff03,
  0x00000000ffff7f86, 0x00000000ffffff60,
  0x00000000ffff7fe3, 0x00000000ffffff7d,
  0x00000000ffffff7d, 0x00000000ffffff7f,
  0x00000000ffffff7e, 0x00000000ffffff80,
  0x00000000ffffff7f, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffffa1,
  0xffffffffffffffa0, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000007f7e,
  0x0000000000007f7d, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f80,
  0x0000000000007f7f, 0x00000000333332b4,
  0x00000000333332b3, 0x00000000555554d6,
  0x00000000555554d5, 0x000000007fffff7e,
  0x000000007fffff7d, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff82,
  0x000000007fffff81, 0x00000000aaaaaa2b,
  0x00000000aaaaaa2a, 0x00000000cccccc4d,
  0x00000000cccccc4c, 0x00000000ffff7f81,
  0x00000000ffff7f80, 0x00000000ffff7f82,
  0x00000000ffff7f81, 0x00000000ffff7f83,
  0x00000000ffff7f82, 0x00000000ffff7f84,
  0x00000000ffff7f83, 0x00000000ffffff01,
  0x00000000ffffff00, 0x00000000ffffff02,
  0x00000000ffffff01, 0x00000000ffffff03,
  0x00000000ffffff02, 0x00000000ffffff04,
  0x00000000ffffff03, 0x00000000ffffff61,
  0x00000000ffffff60, 0x00000000ffffff7e,
  0x00000000ffffff7e, 0x00000000ffffff80,
  0x00000000ffffff7f, 0x00000000ffffff81,
  0x00000000ffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffffa2,
  0xffffffffffffffa1, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f81,
  0x0000000000007f80, 0x00000000333332b5,
  0x00000000333332b4, 0x00000000555554d7,
  0x00000000555554d6, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffff83,
  0x000000007fffff82, 0x00000000aaaaaa2c,
  0x00000000aaaaaa2b, 0x00000000cccccc4e,
  0x00000000cccccc4d, 0x00000000ffff7f82,
  0x00000000ffff7f81, 0x00000000ffff7f83,
  0x00000000ffff7f82, 0x00000000ffff7f84,
  0x00000000ffff7f83, 0x00000000ffff7f85,
  0x00000000ffff7f84, 0x00000000ffffff02,
  0x00000000ffffff01, 0x00000000ffffff03,
  0x00000000ffffff02, 0x00000000ffffff04,
  0x00000000ffffff03, 0x00000000ffffff05,
  0x00000000ffffff04, 0x00000000ffffff62,
  0x00000000ffffff61, 0x00000000ffffff7f,
  0x00000000ffffff7f, 0x00000000ffffff81,
  0x00000000ffffff80, 0x00000000ffffff82,
  0x00000000ffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffff85,
  0xffffffffffffff84, 0xffffffffffffffa3,
  0xffffffffffffffa2, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f82,
  0x0000000000007f81, 0x00000000333332b6,
  0x00000000333332b5, 0x00000000555554d8,
  0x00000000555554d7, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffff83,
  0x000000007fffff82, 0x000000007fffff84,
  0x000000007fffff83, 0x00000000aaaaaa2d,
  0x00000000aaaaaa2c, 0x00000000cccccc4f,
  0x00000000cccccc4e, 0x00000000ffff7f83,
  0x00000000ffff7f82, 0x00000000ffff7f84,
  0x00000000ffff7f83, 0x00000000ffff7f85,
  0x00000000ffff7f84, 0x00000000ffff7f86,
  0x00000000ffff7f85, 0x00000000ffffff03,
  0x00000000ffffff02, 0x00000000ffffff04,
  0x00000000ffffff03, 0x00000000ffffff05,
  0x00000000ffffff04, 0x00000000ffffff06,
  0x00000000ffffff05, 0x00000000ffffff63,
  0x00000000ffffff62, 0x00000000ffffff80,
  0x00000000ffffff80, 0x00000000ffffffbe,
  0x00000000ffffff81, 0x00000000ffffffbf,
  0x00000000ffffff82, 0xffffffffffffffc0,
  0xffffffffffffff83, 0xffffffffffffffc1,
  0xffffffffffffff84, 0xffffffffffffffc2,
  0xffffffffffffff85, 0xffffffffffffffe0,
  0xffffffffffffffa3, 0x000000000000003d,
  0x0000000000000000, 0x000000000000003e,
  0x0000000000000001, 0x000000000000003f,
  0x0000000000000002, 0x0000000000007fbd,
  0x0000000000007f80, 0x0000000000007fbe,
  0x0000000000007f81, 0x0000000000007fbf,
  0x0000000000007f82, 0x00000000333332f3,
  0x00000000333332b6, 0x0000000055555515,
  0x00000000555554d8, 0x000000007fffffbd,
  0x000000007fffff80, 0x000000007fffffbe,
  0x000000007fffff81, 0x000000007fffffbf,
  0x000000007fffff82, 0x000000007fffffc0,
  0x000000007fffff83, 0x000000007fffffc1,
  0x000000007fffff84, 0x00000000aaaaaa6a,
  0x00000000aaaaaa2d, 0x00000000cccccc8c,
  0x00000000cccccc4f, 0x00000000ffff7fc0,
  0x00000000ffff7f83, 0x00000000ffff7fc1,
  0x00000000ffff7f84, 0x00000000ffff7fc2,
  0x00000000ffff7f85, 0x00000000ffff7fc3,
  0x00000000ffff7f86, 0x00000000ffffff40,
  0x00000000ffffff03, 0x00000000ffffff41,
  0x00000000ffffff04, 0x00000000ffffff42,
  0x00000000ffffff05, 0x00000000ffffff43,
  0x00000000ffffff06, 0x00000000ffffffa0,
  0x00000000ffffff63, 0x00000000ffffffbd,
  0x00000000ffffffbd, 0x00000000fffffffb,
  0x00000000ffffffbe, 0x00000000fffffffc,
  0x00000000ffffffbf, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffe,
  0xffffffffffffffc1, 0xffffffffffffffff,
  0xffffffffffffffc2, 0x000000000000001d,
  0xffffffffffffffe0, 0x000000000000007a,
  0x000000000000003d, 0x000000000000007b,
  0x000000000000003e, 0x000000000000007c,
  0x000000000000003f, 0x0000000000007ffa,
  0x0000000000007fbd, 0x0000000000007ffb,
  0x0000000000007fbe, 0x0000000000007ffc,
  0x0000000000007fbf, 0x0000000033333330,
  0x00000000333332f3, 0x0000000055555552,
  0x0000000055555515, 0x000000007ffffffa,
  0x000000007fffffbd, 0x000000007ffffffb,
  0x000000007fffffbe, 0x000000007ffffffc,
  0x000000007fffffbf, 0x000000007ffffffd,
  0x000000007fffffc0, 0x000000007ffffffe,
  0x000000007fffffc1, 0x00000000aaaaaaa7,
  0x00000000aaaaaa6a, 0x00000000ccccccc9,
  0x00000000cccccc8c, 0x00000000ffff7ffd,
  0x00000000ffff7fc0, 0x00000000ffff7ffe,
  0x00000000ffff7fc1, 0x00000000ffff7fff,
  0x00000000ffff7fc2, 0x00000000ffff8000,
  0x00000000ffff7fc3, 0x00000000ffffff7d,
  0x00000000ffffff40, 0x00000000ffffff7e,
  0x00000000ffffff41, 0x00000000ffffff7f,
  0x00000000ffffff42, 0x00000000ffffff80,
  0x00000000ffffff43, 0x00000000ffffffdd,
  0x00000000ffffffa0, 0x00000000fffffffa,
  0x00000000fffffffa, 0x00000000fffffffc,
  0x00000000fffffffb, 0x00000000fffffffd,
  0x00000000fffffffc, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x000000000000001e,
  0x000000000000001d, 0x000000000000007b,
  0x000000000000007a, 0x000000000000007c,
  0x000000000000007b, 0x000000000000007d,
  0x000000000000007c, 0x0000000000007ffb,
  0x0000000000007ffa, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000033333331,
  0x0000000033333330, 0x0000000055555553,
  0x0000000055555552, 0x000000007ffffffb,
  0x000000007ffffffa, 0x000000007ffffffc,
  0x000000007ffffffb, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x00000000aaaaaaa8,
  0x00000000aaaaaaa7, 0x00000000ccccccca,
  0x00000000ccccccc9, 0x00000000ffff7ffe,
  0x00000000ffff7ffd, 0x00000000ffff7fff,
  0x00000000ffff7ffe, 0x00000000ffff8000,
  0x00000000ffff7fff, 0x00000000ffff8001,
  0x00000000ffff8000, 0x00000000ffffff7e,
  0x00000000ffffff7d, 0x00000000ffffff7f,
  0x00000000ffffff7e, 0x00000000ffffff80,
  0x00000000ffffff7f, 0x00000000ffffff81,
  0x00000000ffffff80, 0x00000000ffffffde,
  0x00000000ffffffdd, 0x00000000fffffffb,
  0x00000000fffffffb, 0x00000000fffffffd,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x00000000fffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x000000000000001f,
  0x000000000000001e, 0x000000000000007c,
  0x000000000000007b, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007e,
  0x000000000000007d, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000033333332,
  0x0000000033333331, 0x0000000055555554,
  0x0000000055555553, 0x000000007ffffffc,
  0x000000007ffffffb, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x00000000aaaaaaa9,
  0x00000000aaaaaaa8, 0x00000000cccccccb,
  0x00000000ccccccca, 0x00000000ffff7fff,
  0x00000000ffff7ffe, 0x00000000ffff8000,
  0x00000000ffff7fff, 0x00000000ffff8001,
  0x00000000ffff8000, 0x00000000ffff8002,
  0x00000000ffff8001, 0x00000000ffffff7f,
  0x00000000ffffff7e, 0x00000000ffffff80,
  0x00000000ffffff7f, 0x00000000ffffff81,
  0x00000000ffffff80, 0x00000000ffffff82,
  0x00000000ffffff81, 0x00000000ffffffdf,
  0x00000000ffffffde, 0x00000000fffffffc,
};
const unsigned kExpectedCount_NEON_uaddw_2D = 1240;

#endif  // VIXL_SIM_UADDW_2D_TRACE_AARCH64_H_
