/*
	file automatically generated by make_test_files.pl
	Tue May 16 16:46:35 2023
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for NORTA
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );

int unur_norta_set_verify( UNUR_PAR *par, int verify);


/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */

#define COMPARE_SAMPLE_SIZE   (10000)
#define VIOLATE_SAMPLE_SIZE   (20)




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,25,(unur_norta_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,25,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,32,(unur_norta_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,32,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* data missing in distribution object */
UNUR_DISTR *distr = NULL;
   double mean[] = {1.,2.};
   double covar[] = {2.,1., 1., 2.};
   distr = unur_distr_cvec_new(2); 


unur_reset_errno();
/* mean */
n_tests_failed += (check_expected_NULL(TESTLOG,42,(unur_norta_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,42,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* covariance matrix */
unur_distr_cvec_set_mean(distr,mean);
unur_distr_cvec_set_covar(distr,covar);
n_tests_failed += (check_expected_NULL(TESTLOG,48,(unur_norta_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,48,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [reinit] */

void test_reinit (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[reinit "); fflush(stdout);
	fprintf(TESTLOG,"\n[reinit]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* does not exist */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double x[3];
   const int dim = 3;
   double rankcorr[] = { 1., 0.5, 0.1,  0.5, 1., 0.3,  0.1, 0.3, 1. };
   distr = unur_distr_copula(dim, rankcorr);
   par = unur_norta_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 76,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,80,(unur_reinit( gen )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,80,UNUR_ERR_NO_REINIT)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_sample_vec( gen, x );
n_tests_failed += (check_expected_INFINITY(TESTLOG,84,(x[0]))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,84,UNUR_ERR_GEN_CONDITION)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_reinit() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   UNUR_GEN *clone;
   distr = unur_distr_copula(dim, NULL);
   par = unur_norta_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 95,    gen );


unur_reset_errno();
/* copula without correlation */;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,99,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,105,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double rankcorr[] = { 1., 0.5, 0.1,  0.5, 1., 0.3,  0.1, 0.3, 1. };
   UNUR_GEN *clone;
   distr = unur_distr_copula(dim, rankcorr);
   par = unur_norta_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 114,    gen );


unur_reset_errno();
/* copula with correlation */;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,118,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,124,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double rankcorr[] = { 1., 0.5, 0.1,  0.5, 1., 0.3,  0.1, 0.3, 1. };
   double gamma_params[] = {5.};
   UNUR_GEN *clone;
   UNUR_DISTR *marginal;
   distr = unur_distr_cvec_new(dim);
   unur_distr_cvec_set_rankcorr(distr,rankcorr);
   marginal = unur_distr_gamma(gamma_params,1);
   unur_distr_cvec_set_marginals(distr,marginal);
   unur_distr_free(marginal);
   par = unur_norta_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 139,    gen );


unur_reset_errno();
/* gamma marginals with correlation */;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,143,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,149,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double rankcorr[] = { 1., 0.5, 0.1,  0.5, 1., 0.3,  0.1, 0.3, 1. };
   double gamma_params[] = {5.};
   double beta_params[] = {3.,5.};
   UNUR_GEN *clone;
   distr = unur_distr_cvec_new(dim);
   unur_distr_cvec_set_rankcorr(distr,rankcorr);
   unur_distr_cvec_set_marginal_list(distr,
        unur_distr_cauchy(NULL,0),
        unur_distr_gamma(gamma_params,1),
        unur_distr_beta(beta_params,2) );
   par = unur_norta_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 165,    gen );


unur_reset_errno();
/* multivariate distribution with given marginals */;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,169,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,175,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double rankcorr[] = { 1., 0.5, 0.1,  0.5, 1., 0.3,  0.1, 0.3, 1. };
   double gamma_params[] = {5.};
   double beta_params[] = {3.,5.};
   UNUR_GEN *clone;
   UNUR_DISTR *marginals[3];
   distr = unur_distr_cvec_new(3);
   unur_distr_cvec_set_rankcorr(distr,rankcorr);
   marginals[0] = unur_distr_gamma(gamma_params,1);
   marginals[1] = unur_distr_cauchy(NULL,0);
   marginals[2] = unur_distr_beta(beta_params,2);
   unur_distr_cvec_set_marginal_array(distr,marginals);
   unur_distr_free(marginals[0]);
   unur_distr_free(marginals[1]);
   unur_distr_free(marginals[2]);
   par = unur_norta_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 194,    gen );


unur_reset_errno();
/* multivariate distribution with given marginals */;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,198,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,204,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare clone 1dim */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 1;
   double beta_params[] = {3.,5.};
   UNUR_GEN *clone;
   distr = unur_distr_cvec_new(dim);
   unur_distr_cvec_set_rankcorr(distr,NULL);
   unur_distr_cvec_set_marginal_list(distr,
	unur_distr_beta(beta_params,2) );
   par = unur_norta_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 216,    gen );


unur_reset_errno();
/* multivariate distribution with given marginals */;
n_tests_failed += (compare_sequence_gen_start(TESTLOG,220,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,226,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */

/*---------------------------------------------------------------------------*/
/* [validate] */

/*---------------------------------------------------------------------------*/

/* [validate] */

void test_validate (void)
{
	/* suppress GCC compiler warning */
GCC_DIAG_OFF(unused-variable)

	UNUR_DISTR *distr[11];
	UNUR_PAR *par;
	UNUR_GEN *gen;
	double *darray;
	double fpm[10];
	int n_tests_failed;
	int rcode;

	/* start test */
	printf("[validate "); fflush(stdout);
	fprintf(TESTLOG,"\n[validate]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);


/* distributions: 11 */
{
distr[0] = unur_distr_copula(3,NULL);
}

{
double rankcorr[] = { 1., 0.5, 0.1,  0.5, 1., 0.3,  0.1, 0.3, 1. };
distr[1] = unur_distr_copula(3, rankcorr);
}

{
#define dim (3)
double rankcorr[] = { 1., 0.5, 0.1,  0.5, 1., 0.3,  0.1, 0.3, 1. };
double gamma_params[] = {5.};
UNUR_DISTR *marginal;
distr[2] = unur_distr_cvec_new(dim);
unur_distr_cvec_set_rankcorr(distr[2],rankcorr);
marginal = unur_distr_gamma(gamma_params,1);
unur_distr_cvec_set_marginals(distr[2],marginal);
unur_distr_free(marginal);
unur_distr_set_name(distr[2],"gamma marginals");
#undef dim
}

{
#define dim (3)
double rankcorr[] = { 1., 0.5, 0.1,  0.5, 1., 0.3,  0.1, 0.3, 1. };
double gamma_params[] = {5.};
double beta_params[] = {3.,5.};
distr[3] = unur_distr_cvec_new(dim);
unur_distr_cvec_set_rankcorr(distr[3],rankcorr);
unur_distr_cvec_set_marginal_list(distr[3],
	unur_distr_gamma(gamma_params,1),
	unur_distr_cauchy(NULL,0),
	unur_distr_beta(beta_params,2) );
unur_distr_set_name(distr[3],"gamma-cauchy-beta marginals");
#undef dim
}

{
#define dim (3)
UNUR_DISTR *corr_distr;
UNUR_GEN *corr_gen;
double corr[dim*dim];
corr_distr = unur_distr_correlation(dim);
corr_gen = unur_init(unur_mcorr_new(corr_distr));
do { 
   unur_sample_matr(corr_gen,corr);
   distr[4] = unur_distr_copula(dim, corr);
} while (distr[4]==NULL);
unur_distr_free(corr_distr);
unur_free(corr_gen);
unur_distr_set_name(distr[4],"copula with random correlations");
#undef dim
}

{
#define dim (10)
UNUR_DISTR *corr_distr;
UNUR_GEN *corr_gen;
double corr[dim*dim];
corr_distr = unur_distr_correlation(dim);
corr_gen = unur_init(unur_mcorr_new(corr_distr));
do { 
   unur_sample_matr(corr_gen,corr);
   distr[5] = unur_distr_copula(dim, corr);
} while (distr[5]==NULL);
unur_distr_free(corr_distr);
unur_free(corr_gen);
unur_distr_set_name(distr[5],"copula with random correlations");
#undef dim
}

{
#define dim (30)
UNUR_DISTR *corr_distr;
UNUR_GEN *corr_gen;
double corr[dim*dim];
corr_distr = unur_distr_correlation(dim);
corr_gen = unur_init(unur_mcorr_new(corr_distr));
do { 
   unur_sample_matr(corr_gen,corr);
   distr[6] = unur_distr_copula(dim, corr);
} while (distr[6]==NULL);
unur_distr_free(corr_distr);
unur_free(corr_gen);
unur_distr_set_name(distr[6],"copula with random correlations");
#undef dim
}

{
#define dim (100)
UNUR_DISTR *corr_distr;
UNUR_GEN *corr_gen;
double corr[dim*dim];
corr_distr = unur_distr_correlation(dim);
corr_gen = unur_init(unur_mcorr_new(corr_distr));
do { 
   unur_sample_matr(corr_gen,corr);
   distr[7] = unur_distr_copula(dim, corr);
} while (distr[7]==NULL);
unur_distr_free(corr_distr);
unur_free(corr_gen);
unur_distr_set_name(distr[7],"copula with random correlations");
#undef dim
}

{
#define dim (3)
double ll[3] = {0.,1.,0.};
double ru[3] = {1.,UNUR_INFINITY,UNUR_INFINITY};
double rankcorr[] = { 1., 0., 0.,  0., 1., 0.,  0., 0., 1. };
double gamma_params[] = {5.};
UNUR_DISTR *marginal;
distr[8] = unur_distr_cvec_new(dim);
unur_distr_cvec_set_rankcorr(distr[8],rankcorr);
marginal = unur_distr_gamma(gamma_params,1);
unur_distr_cvec_set_marginals(distr[8],marginal);
unur_distr_cvec_set_domain_rect(distr[8],ll,ru);
unur_distr_free(marginal);
unur_distr_set_name(distr[8],"gamma marginals with rectangular domain");
#undef dim
}

{
#define dim (3)
double ll[3] = {0.,1.,2.};
double ru[3] = {1.,2., 3.};
double rankcorr[] = { 1., 0.5, 0.1,  0.5, 1., 0.3,  0.1, 0.3, 1. };
double gamma_params[] = {5.};
UNUR_DISTR *marginal;
distr[9] = unur_distr_cvec_new(dim);
unur_distr_cvec_set_rankcorr(distr[9],rankcorr);
marginal = unur_distr_gamma(gamma_params,1);
unur_distr_cvec_set_marginals(distr[9],marginal);
unur_distr_cvec_set_domain_rect(distr[9],ll,ru);
unur_distr_free(marginal);
unur_distr_set_name(distr[9],"gamma marginals with rectangular domain");
#undef dim
}

{
#define dim (3)
double ll[3] = {0.,1.,2.};
double ru[3] = {1.,2., 3.};
double rankcorr[] = { 1., 0.5, 0.1,  0.5, 1., 0.3,  0.1, 0.3, 1. };
double gamma_params[] = {5.};
distr[10] = unur_distr_cvec_new(dim);
unur_distr_cvec_set_rankcorr(distr[10],rankcorr);
unur_distr_cvec_set_marginal_list(distr[10],
	unur_distr_gamma(gamma_params,1),
	unur_distr_gamma(gamma_params,1),
	unur_distr_gamma(gamma_params,1));
unur_distr_cvec_set_domain_rect(distr[10],ll,ru);
unur_distr_set_name(distr[10],"gamma marginals with rectangular domain");
#undef dim
}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>setup time = %.3f ms\n", stopwatch_lap(&watch));

	printf("\n(chi^2) "); fflush(stdout);

/* chi^2 tests: 11 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nChi^2 Test:\n");

/* distribution [0] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_norta_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [1] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_norta_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [2] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_norta_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [3] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_norta_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [4] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_norta_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [5] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_norta_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [6] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_norta_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [7] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_norta_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [8] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_norta_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [9] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_norta_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [10] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_norta_new(distr_localcopy);
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));


/* free distributions */
	unur_distr_free(distr[0]);
	unur_distr_free(distr[1]);
	unur_distr_free(distr[2]);
	unur_distr_free(distr[3]);
	unur_distr_free(distr[4]);
	unur_distr_free(distr[5]);
	unur_distr_free(distr[6]);
	unur_distr_free(distr[7]);
	unur_distr_free(distr[8]);
	unur_distr_free(distr[9]);
	unur_distr_free(distr[10]);

	/* test finished */
	test_ok &= (n_tests_failed>CHI2_FAILURES_TOLERATED) ? 0 : 1;
	/* we accept CHI2_FAILURES_TOLERATED failures */
	(n_tests_failed>CHI2_FAILURES_TOLERATED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_validate */

/* enable GCC compiler warning */
GCC_DIAG_ON(unused-variable)


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_norta_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */

int unur_norta_set_verify(UNUR_PAR *par ATTRIBUTE__UNUSED, int verify ATTRIBUTE__UNUSED) {return 0;}

/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_norta_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_norta_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 367811;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 367811;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("norta: ");

	/* run tests */
test_new();
test_reinit();
test_sample();
test_validate();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());
	unur_urng_free(unur_get_default_urng_aux());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

