//--------------------------------------------------------------------------
// Copyright (C) 2014-2025 Cisco and/or its affiliates. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License Version 2 as published
// by the Free Software Foundation.  You may not use, modify or distribute
// this program under any other version of the GNU General Public License.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//--------------------------------------------------------------------------
// hashes.h author Russ Combs <rucombs@cisco.com>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "hashes.h"

#include <openssl/evp.h>

namespace snort
{
void sha256(const unsigned char* data, size_t size, unsigned char* digest)
{
    EVP_MD_CTX* ctx = EVP_MD_CTX_new();

    if (!ctx)
        return;

    if (EVP_DigestInit_ex(ctx, EVP_sha256(), nullptr) == 1)
    {
        EVP_DigestUpdate(ctx, data, size);
        unsigned int out_len = 0;
        EVP_DigestFinal_ex(ctx, digest, &out_len);
    }
    EVP_MD_CTX_free(ctx);
}

void sha512(const unsigned char* data, size_t size, unsigned char* digest)
{
    EVP_MD_CTX* ctx = EVP_MD_CTX_new();

    if (!ctx)
        return;

    if (EVP_DigestInit_ex(ctx, EVP_sha512(), nullptr) == 1)
    {
        EVP_DigestUpdate(ctx, data, size);
        unsigned int out_len = 0;
        EVP_DigestFinal_ex(ctx, digest, &out_len);
    }
    EVP_MD_CTX_free(ctx);
}

void md5(const unsigned char* data, size_t size, unsigned char* digest)
{
    EVP_MD_CTX* ctx = EVP_MD_CTX_new();
    if (!ctx)
        return;

    if (EVP_DigestInit_ex(ctx, EVP_md5(), nullptr) == 1)
    {
        EVP_DigestUpdate(ctx, data, size);
        unsigned int out_len = 0;
        EVP_DigestFinal_ex(ctx, digest, &out_len);
    }
    EVP_MD_CTX_free(ctx);
}

}
