#version 330
uniform bool lighting;

uniform mat4 pmv;
uniform mat3 normalMatrix;
uniform mat4 ModelViewMatrixInverse;


layout (location=0) in vec4  L0;


out vec3 nor, lightDirection, normal, uv;
out vec3 pos;
out vec3 eye;
out vec4 gcolor;
out float ep, np;
void main(void){
nor= L0.xyz;
gcolor=gl_Color;
uv = L0.xyz;
vec4 p4 = pmv * vec4(uv, 1);
pos = p4.xyz;
if (lighting){
normal = normalMatrix * nor;
vec4 eyePos = ModelViewMatrixInverse * vec4(0., 0., 0., 1.);
eye = eyePos.xyz - uv;
lightDirection = normalize(vec3(-1.0,1.0,1.0));
}
gl_Position = pos;
}
