% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_taxa.R
\name{rl_species_latest}
\alias{rl_species_latest}
\title{Species latest assessment}
\usage{
rl_species_latest(
  genus,
  species,
  infra = NULL,
  subpopulation = NULL,
  key = NULL,
  parse = TRUE,
  ...
)
}
\arguments{
\item{genus}{(character) The genus name of the species to look up.}

\item{species}{(character) The species epithet of the species to look up.}

\item{infra}{(character) An optional name of the subspecies or variety to
look up.}

\item{subpopulation}{(character) An optional name of the geographically
separate subpopulation to look up.}

\item{key}{(character) An IUCN API token. See \code{\link[=rl_use_iucn]{rl_use_iucn()}}.}

\item{parse}{(logical) Whether to parse the output to list (\code{FALSE}) or,
where possible, data.frame (\code{TRUE}). Default: \code{TRUE}.}

\item{...}{Includes the following arguments related to the wait time between
request retries if a "Too Many Requests" error is received from the API
(see \link[crul:HttpClient]{HttpClient()$retry()} for more details):
\itemize{
\item \code{pause_base}, \code{pause_cap}, and \code{pause_min}: basis, maximum, and minimum
for calculating wait time for retry
\item \code{times}: the maximum number of times to retry
\item \code{onwait}: a callback function if the request will be retried and a
wait time is being applied
}
Also supports any \link[curl:curl_options]{curl options} passed to the GET
request via \link[crul:HttpClient]{HttpClient}.}
}
\value{
A list unless using a function with a trailing underscore, in which
case json as character string is returned.
}
\description{
Get the latest assessment for a particular species (i.e., Latin binomial) or
subspecies/variety/subpopulation (i.e., Latin trinomial). Wraps
\code{\link[=rl_species]{rl_species()}} and \code{\link[=rl_assessment]{rl_assessment()}}.
}
\details{
Geographically separate subpopulations of a species are defined as
those populations that are so isolated from others of the same species that
it is considered extremely unlikely that there is any genetic interchange.
In general, listings of such subpopulations are restricted to those that
have been isolated for a long period of time.

Assessments of subspecies, varieties, and geographically separate
subpopulations must adhere to the same standards as for species
assessments. However, these assessments are only included provided there is
a global assessment of the species as a whole.

Infraspecific ranks such as formas, subvarieties, cultivars, etc are not
included in the Red List.
}
\examples{
\dontrun{
# Get latest assessment for species
ex1 <- rl_species_latest(genus = "Fratercula", species = "arctica")
ex1$stresses

# Get latest assessment for subspecies
ex2 <- rl_species_latest(genus = "Gorilla", species = "gorilla",
                         infra = "gorilla")
ex2$stresses
}
}
\references{
API docs at \url{https://api.iucnredlist.org/}.
}
\seealso{
Assessments by taxa:
\code{\link{rl_class}()},
\code{\link{rl_family}()},
\code{\link{rl_kingdom}()},
\code{\link{rl_order}()},
\code{\link{rl_phylum}()},
\code{\link{rl_sis}()},
\code{\link{rl_sis_latest}()},
\code{\link{rl_species}()}
}
\concept{taxa}
