# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class ApplicationClaim(_Model):
    """A claim of a ledger application.

    :ivar digest: An application claim in digested form.
    :vartype digest: ~azure.confidentialledger.models.ClaimDigest
    :ivar kind: Represents the kind of an application claim. Required. Known values are:
     "LedgerEntry" and "ClaimDigest".
    :vartype kind: str or ~azure.confidentialledger.models.ApplicationClaimKind
    :ivar ledger_entry: An application claim derived from ledger entry data.
    :vartype ledger_entry: ~azure.confidentialledger.models.LedgerEntryClaim
    """

    digest: Optional["_models.ClaimDigest"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An application claim in digested form."""
    kind: Union[str, "_models.ApplicationClaimKind"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the kind of an application claim. Required. Known values are: \"LedgerEntry\" and
     \"ClaimDigest\"."""
    ledger_entry: Optional["_models.LedgerEntryClaim"] = rest_field(
        name="ledgerEntry", visibility=["read", "create", "update", "delete", "query"]
    )
    """An application claim derived from ledger entry data."""

    @overload
    def __init__(
        self,
        *,
        kind: Union[str, "_models.ApplicationClaimKind"],
        digest: Optional["_models.ClaimDigest"] = None,
        ledger_entry: Optional["_models.LedgerEntryClaim"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Bundle(_Model):
    """bundle for the user defined endpoints.

    :ivar metadata: Metadata information for the bundle. Required.
    :vartype metadata: ~azure.confidentialledger.models.Metadata
    :ivar modules: Any object. Required.
    :vartype modules: list[~azure.confidentialledger.models.ModuleDef]
    """

    metadata: "_models.Metadata" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata information for the bundle. Required."""
    modules: list["_models.ModuleDef"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Any object. Required."""

    @overload
    def __init__(
        self,
        *,
        metadata: "_models.Metadata",
        modules: list["_models.ModuleDef"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClaimDigest(_Model):
    """An application claim in digested form.

    :ivar value: The digest of the application claim, in hexadecimal form.
    :vartype value: str
    :ivar protocol: Represents the protocol to be used to compute the digest of a claim from the
     given claim data. Required. "LedgerEntryV1"
    :vartype protocol: str or ~azure.confidentialledger.models.ApplicationClaimProtocol
    """

    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The digest of the application claim, in hexadecimal form."""
    protocol: Union[str, "_models.ApplicationClaimProtocol"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the protocol to be used to compute the digest of a claim from the
     given claim data. Required. \"LedgerEntryV1\""""

    @overload
    def __init__(
        self,
        *,
        protocol: Union[str, "_models.ApplicationClaimProtocol"],
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Collection(_Model):
    """Identifier for collections.

    :ivar collection_id: Identifier for the collection. Required.
    :vartype collection_id: str
    """

    collection_id: str = rest_field(name="collectionId", visibility=["read", "create", "update", "delete", "query"])
    """Identifier for the collection. Required."""

    @overload
    def __init__(
        self,
        *,
        collection_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConfidentialLedgerEnclaves(_Model):
    """Information about the enclaves running the Confidential Ledger.

    :ivar current_node_id: Id of the Confidential Ledger node responding to the request. Required.
    :vartype current_node_id: str
    :ivar enclave_quotes: Dictionary of enclave quotes, indexed by node id. Required.
    :vartype enclave_quotes: dict[str, ~azure.confidentialledger.models.EnclaveQuote]
    """

    current_node_id: str = rest_field(name="currentNodeId", visibility=["read", "create", "update", "delete", "query"])
    """Id of the Confidential Ledger node responding to the request. Required."""
    enclave_quotes: dict[str, "_models.EnclaveQuote"] = rest_field(
        name="enclaveQuotes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Dictionary of enclave quotes, indexed by node id. Required."""

    @overload
    def __init__(
        self,
        *,
        current_node_id: str,
        enclave_quotes: dict[str, "_models.EnclaveQuote"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConfidentialLedgerError(_Model):
    """An error response from Confidential Ledger.

    :ivar error: An error response from Confidential Ledger.
    :vartype error: ~azure.confidentialledger.models.ConfidentialLedgerErrorBody
    """

    error: Optional["_models.ConfidentialLedgerErrorBody"] = rest_field(visibility=["read"])
    """An error response from Confidential Ledger."""


class ConfidentialLedgerErrorBody(_Model):
    """An error response from Confidential Ledger.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""


class ConsortiumMember(_Model):
    """Describes a member of the consortium.

    :ivar certificate: PEM-encoded certificate associated with the member. Required.
    :vartype certificate: str
    :ivar id: Identifier assigned to the member. Required.
    :vartype id: str
    """

    certificate: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """PEM-encoded certificate associated with the member. Required."""
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Identifier assigned to the member. Required."""

    @overload
    def __init__(
        self,
        *,
        certificate: str,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Constitution(_Model):
    """The governance script for the application.

    :ivar digest: SHA256 digest of the constitution script. Required.
    :vartype digest: str
    :ivar script: Contents of the constitution. Required.
    :vartype script: str
    """

    digest: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SHA256 digest of the constitution script. Required."""
    script: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Contents of the constitution. Required."""

    @overload
    def __init__(
        self,
        *,
        digest: str,
        script: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveQuote(_Model):
    """Contains the enclave quote.

    :ivar node_id: ID assigned to this node. Required.
    :vartype node_id: str
    :ivar mrenclave: MRENCLAVE value of the code running in the enclave.
    :vartype mrenclave: str
    :ivar quote_version: Version of the quote presented. Required.
    :vartype quote_version: str
    :ivar raw: Raw SGX quote, parsable by tools like Open Enclave's oeverify. Required.
    :vartype raw: str
    """

    node_id: str = rest_field(name="nodeId", visibility=["read", "create", "update", "delete", "query"])
    """ID assigned to this node. Required."""
    mrenclave: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """MRENCLAVE value of the code running in the enclave."""
    quote_version: str = rest_field(name="quoteVersion", visibility=["read", "create", "update", "delete", "query"])
    """Version of the quote presented. Required."""
    raw: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Raw SGX quote, parsable by tools like Open Enclave's oeverify. Required."""

    @overload
    def __init__(
        self,
        *,
        node_id: str,
        quote_version: str,
        raw: str,
        mrenclave: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EndpointProperties(_Model):
    """Endpoint properties.

    :ivar authn_policies: Authentication policies for the endpoint. Required.
    :vartype authn_policies: list[dict[str, any]]
    :ivar forwarding_required: Indicates whether request forwarding is required for this endpoint.
     Required. Known values are: "sometimes", "always", and "never".
    :vartype forwarding_required: str or ~azure.confidentialledger.models.ForwardingRequired
    :ivar interpreter_reuse: Policy for interpreter reuse.
    :vartype interpreter_reuse: ~azure.confidentialledger.models.InterpreterReusePolicy
    :ivar js_function: The JavaScript function.
    :vartype js_function: str
    :ivar js_module: The JavaScript module.
    :vartype js_module: str
    :ivar mode: The operation mode for this endpoint. Known values are: "readwrite", "readonly",
     and "historical".
    :vartype mode: str or ~azure.confidentialledger.models.Mode
    :ivar openapi: Anything.
    :vartype openapi: dict[str, any]
    :ivar openapi_hidden: Openapi hidden.
    :vartype openapi_hidden: bool
    :ivar redirection_strategy: Redirection strategy. Known values are: "none", "to_primary", and
     "to_backup".
    :vartype redirection_strategy: str or ~azure.confidentialledger.models.RedirectionStrategy
    """

    authn_policies: list[dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Authentication policies for the endpoint. Required."""
    forwarding_required: Union[str, "_models.ForwardingRequired"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether request forwarding is required for this endpoint. Required. Known values are:
     \"sometimes\", \"always\", and \"never\"."""
    interpreter_reuse: Optional["_models.InterpreterReusePolicy"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Policy for interpreter reuse."""
    js_function: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The JavaScript function."""
    js_module: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The JavaScript module."""
    mode: Optional[Union[str, "_models.Mode"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The operation mode for this endpoint. Known values are: \"readwrite\", \"readonly\", and
     \"historical\"."""
    openapi: Optional[dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Anything."""
    openapi_hidden: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Openapi hidden."""
    redirection_strategy: Optional[Union[str, "_models.RedirectionStrategy"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Redirection strategy. Known values are: \"none\", \"to_primary\", and \"to_backup\"."""

    @overload
    def __init__(
        self,
        *,
        authn_policies: list[dict[str, Any]],
        forwarding_required: Union[str, "_models.ForwardingRequired"],
        interpreter_reuse: Optional["_models.InterpreterReusePolicy"] = None,
        js_function: Optional[str] = None,
        js_module: Optional[str] = None,
        mode: Optional[Union[str, "_models.Mode"]] = None,
        openapi: Optional[dict[str, Any]] = None,
        openapi_hidden: Optional[bool] = None,
        redirection_strategy: Optional[Union[str, "_models.RedirectionStrategy"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InterpreterReusePolicy(_Model):
    """Policy for interpreter reuse.

    :ivar key: Key for the interpreter reuse policy. Required.
    :vartype key: str
    """

    key: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Key for the interpreter reuse policy. Required."""

    @overload
    def __init__(
        self,
        *,
        key: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JsRuntimeOptions(_Model):
    """JS runtime options for user defined endpoints and functions.

    :ivar log_exception_details: Whether to log exception details in the runtime.
    :vartype log_exception_details: bool
    :ivar max_cached_interpreters: Maximum number of cached interpreters.
    :vartype max_cached_interpreters: int
    :ivar max_execution_time_ms: Maximum execution time in milliseconds.
    :vartype max_execution_time_ms: int
    :ivar max_heap_bytes: Maximum heap size in bytes.
    :vartype max_heap_bytes: int
    :ivar max_stack_bytes: Maximum stack size in bytes.
    :vartype max_stack_bytes: int
    :ivar return_exception_details: Whether to return exception details in the response.
    :vartype return_exception_details: bool
    """

    log_exception_details: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether to log exception details in the runtime."""
    max_cached_interpreters: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum number of cached interpreters."""
    max_execution_time_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum execution time in milliseconds."""
    max_heap_bytes: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum heap size in bytes."""
    max_stack_bytes: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum stack size in bytes."""
    return_exception_details: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether to return exception details in the response."""

    @overload
    def __init__(
        self,
        *,
        log_exception_details: Optional[bool] = None,
        max_cached_interpreters: Optional[int] = None,
        max_execution_time_ms: Optional[int] = None,
        max_heap_bytes: Optional[int] = None,
        max_stack_bytes: Optional[int] = None,
        return_exception_details: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LedgerEntry(_Model):
    """An entry in the ledger.

    :ivar contents: Contents of the ledger entry. Required.
    :vartype contents: str
    :ivar collection_id: The collection identifier for this ledger entry.
    :vartype collection_id: str
    :ivar transaction_id: A unique identifier for the state of the ledger. If returned as part of a
     LedgerEntry, it indicates the state from which the entry was read.
    :vartype transaction_id: str
    :ivar pre_hooks: List of user defined function hooks to be executed before the ledger entry is
     written.
    :vartype pre_hooks: list[~azure.confidentialledger.models.UserDefinedFunctionHook]
    :ivar post_hooks: List of user defined function hooks to be executed after the ledger entry is
     written.
    :vartype post_hooks: list[~azure.confidentialledger.models.UserDefinedFunctionHook]
    """

    contents: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Contents of the ledger entry. Required."""
    collection_id: Optional[str] = rest_field(name="collectionId", visibility=["read"])
    """The collection identifier for this ledger entry."""
    transaction_id: Optional[str] = rest_field(name="transactionId", visibility=["read"])
    """A unique identifier for the state of the ledger. If returned as part of a
     LedgerEntry, it indicates the state from which the entry was read."""
    pre_hooks: Optional[list["_models.UserDefinedFunctionHook"]] = rest_field(
        name="preHooks", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of user defined function hooks to be executed before the ledger entry is
     written."""
    post_hooks: Optional[list["_models.UserDefinedFunctionHook"]] = rest_field(
        name="postHooks", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of user defined function hooks to be executed after the ledger entry is
     written."""

    @overload
    def __init__(
        self,
        *,
        contents: str,
        pre_hooks: Optional[list["_models.UserDefinedFunctionHook"]] = None,
        post_hooks: Optional[list["_models.UserDefinedFunctionHook"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LedgerEntryClaim(_Model):
    """An application claim derived from ledger entry data.

    :ivar collection_id: Identifier of a collection.
    :vartype collection_id: str
    :ivar contents: Contents of a ledger entry.
    :vartype contents: str
    :ivar secret_key: Base64-encoded secret key.
    :vartype secret_key: str
    :ivar protocol: Represents the protocol to be used to compute the digest of a claim from the
     given claim data. Required. "LedgerEntryV1"
    :vartype protocol: str or ~azure.confidentialledger.models.ApplicationClaimProtocol
    """

    collection_id: Optional[str] = rest_field(
        name="collectionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier of a collection."""
    contents: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Contents of a ledger entry."""
    secret_key: Optional[str] = rest_field(name="secretKey", visibility=["read", "create", "update", "delete", "query"])
    """Base64-encoded secret key."""
    protocol: Union[str, "_models.ApplicationClaimProtocol"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the protocol to be used to compute the digest of a claim from the
     given claim data. Required. \"LedgerEntryV1\""""

    @overload
    def __init__(
        self,
        *,
        protocol: Union[str, "_models.ApplicationClaimProtocol"],
        collection_id: Optional[str] = None,
        contents: Optional[str] = None,
        secret_key: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LedgerQueryResult(_Model):
    """The result of querying for a ledger entry from an older transaction id. The
    ledger entry is available in the response only if the returned state is Ready.

    :ivar state: State of a ledger query. Required. Known values are: "Loading" and "Ready".
    :vartype state: str or ~azure.confidentialledger.models.ConfidentialLedgerQueryState
    :ivar entry: The ledger entry found as a result of the query. This is only available if the
     query is in Ready state.
    :vartype entry: ~azure.confidentialledger.models.LedgerEntry
    """

    state: Union[str, "_models.ConfidentialLedgerQueryState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """State of a ledger query. Required. Known values are: \"Loading\" and \"Ready\"."""
    entry: Optional["_models.LedgerEntry"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ledger entry found as a result of the query. This is only available if the
     query is in Ready state."""

    @overload
    def __init__(
        self,
        *,
        state: Union[str, "_models.ConfidentialLedgerQueryState"],
        entry: Optional["_models.LedgerEntry"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LedgerUser(_Model):
    """Details about a Confidential Ledger user.

    :ivar assigned_role: Represents an assignable role. Required. Known values are:
     "Administrator", "Contributor", and "Reader".
    :vartype assigned_role: str or ~azure.confidentialledger.models.ConfidentialLedgerUserRoleName
    :ivar user_id: Identifier for the user. This must either be an AAD object id or a certificate
     fingerprint.
    :vartype user_id: str
    """

    assigned_role: Union[str, "_models.ConfidentialLedgerUserRoleName"] = rest_field(
        name="assignedRole", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents an assignable role. Required. Known values are: \"Administrator\", \"Contributor\",
     and \"Reader\"."""
    user_id: Optional[str] = rest_field(name="userId", visibility=["read"])
    """Identifier for the user. This must either be an AAD object id or a certificate
     fingerprint."""

    @overload
    def __init__(
        self,
        *,
        assigned_role: Union[str, "_models.ConfidentialLedgerUserRoleName"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LedgerUserMultipleRoles(_Model):
    """Details about a Confidential Ledger user.

    :ivar assigned_roles: Represents an assignable role. Required.
    :vartype assigned_roles: list[str or
     ~azure.confidentialledger.models.ConfidentialLedgerUserRoleName]
    :ivar user_id: Identifier for the user. This must either be an AAD object id or a certificate
     fingerprint.
    :vartype user_id: str
    """

    assigned_roles: list[Union[str, "_models.ConfidentialLedgerUserRoleName"]] = rest_field(
        name="assignedRoles", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents an assignable role. Required."""
    user_id: Optional[str] = rest_field(name="userId", visibility=["read"])
    """Identifier for the user. This must either be an AAD object id or a certificate
     fingerprint."""

    @overload
    def __init__(
        self,
        *,
        assigned_roles: list[Union[str, "_models.ConfidentialLedgerUserRoleName"]],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LedgerWriteResult(_Model):
    """Returned as a result of a write to the Confidential Ledger, the transaction id
    in the response indicates when the write will become durable.

    :ivar collection_id: The collection identifier of the ledger entry. Required.
    :vartype collection_id: str
    """

    collection_id: str = rest_field(name="collectionId", visibility=["read", "create", "update", "delete", "query"])
    """The collection identifier of the ledger entry. Required."""

    @overload
    def __init__(
        self,
        *,
        collection_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Metadata(_Model):
    """Metadata for endpoints.

    :ivar endpoints: A map of path to method endpoints for the path. Required.
    :vartype endpoints: dict[str, ~azure.confidentialledger.models.MethodToEndpointProperties]
    """

    endpoints: dict[str, "_models.MethodToEndpointProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A map of path to method endpoints for the path. Required."""

    @overload
    def __init__(
        self,
        *,
        endpoints: dict[str, "_models.MethodToEndpointProperties"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MethodToEndpointProperties(_Model):
    """Maps methods to their corresponding endpoint properties.

    :ivar get_property: Properties for GET method endpoint.
    :vartype get_property: ~azure.confidentialledger.models.EndpointProperties
    :ivar put: Properties for PUT method endpoint.
    :vartype put: ~azure.confidentialledger.models.EndpointProperties
    :ivar patch: Properties for PATCH method endpoint.
    :vartype patch: ~azure.confidentialledger.models.EndpointProperties
    :ivar delete: Properties for DELETE method endpoint.
    :vartype delete: ~azure.confidentialledger.models.EndpointProperties
    """

    get_property: Optional["_models.EndpointProperties"] = rest_field(
        name="get", visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties for GET method endpoint."""
    put: Optional["_models.EndpointProperties"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Properties for PUT method endpoint."""
    patch: Optional["_models.EndpointProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties for PATCH method endpoint."""
    delete: Optional["_models.EndpointProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties for DELETE method endpoint."""

    @overload
    def __init__(
        self,
        *,
        get_property: Optional["_models.EndpointProperties"] = None,
        put: Optional["_models.EndpointProperties"] = None,
        patch: Optional["_models.EndpointProperties"] = None,
        delete: Optional["_models.EndpointProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ModuleDef(_Model):
    """Module definition.

    :ivar module: Module. Required.
    :vartype module: str
    :ivar name: Name. Required.
    :vartype name: str
    """

    module: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Module. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name. Required."""

    @overload
    def __init__(
        self,
        *,
        module: str,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReceiptContents(_Model):
    """The contents of a receipt.

    :ivar cert: Certificate.
    :vartype cert: str
    :ivar leaf: Leaf.
    :vartype leaf: str
    :ivar leaf_components: Leaf components of the receipt.
    :vartype leaf_components: ~azure.confidentialledger.models.ReceiptLeafComponents
    :ivar node_id: Node identifier. Required.
    :vartype node_id: str
    :ivar proof: Proof. Required.
    :vartype proof: list[~azure.confidentialledger.models.ReceiptElement]
    :ivar root: Root.
    :vartype root: str
    :ivar service_endorsements: Service endorsements.
    :vartype service_endorsements: list[str]
    :ivar signature: The signature of the receipt. Required.
    :vartype signature: str
    """

    cert: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Certificate."""
    leaf: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Leaf."""
    leaf_components: Optional["_models.ReceiptLeafComponents"] = rest_field(
        name="leafComponents", visibility=["read", "create", "update", "delete", "query"]
    )
    """Leaf components of the receipt."""
    node_id: str = rest_field(name="nodeId", visibility=["read", "create", "update", "delete", "query"])
    """Node identifier. Required."""
    proof: list["_models.ReceiptElement"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Proof. Required."""
    root: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Root."""
    service_endorsements: Optional[list[str]] = rest_field(
        name="serviceEndorsements", visibility=["read", "create", "update", "delete", "query"]
    )
    """Service endorsements."""
    signature: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The signature of the receipt. Required."""

    @overload
    def __init__(
        self,
        *,
        node_id: str,
        proof: list["_models.ReceiptElement"],
        signature: str,
        cert: Optional[str] = None,
        leaf: Optional[str] = None,
        leaf_components: Optional["_models.ReceiptLeafComponents"] = None,
        root: Optional[str] = None,
        service_endorsements: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReceiptElement(_Model):
    """Receipt element.

    :ivar left: Left.
    :vartype left: str
    :ivar right: Right.
    :vartype right: str
    """

    left: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Left."""
    right: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Right."""

    @overload
    def __init__(
        self,
        *,
        left: Optional[str] = None,
        right: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReceiptLeafComponents(_Model):
    """Components that make up a receipt leaf node.

    :ivar claims_digest: Claims digest.
    :vartype claims_digest: str
    :ivar commit_evidence: Commit evidence.
    :vartype commit_evidence: str
    :ivar write_set_digest: TWrite set digest.
    :vartype write_set_digest: str
    """

    claims_digest: Optional[str] = rest_field(
        name="claimsDigest", visibility=["read", "create", "update", "delete", "query"]
    )
    """Claims digest."""
    commit_evidence: Optional[str] = rest_field(
        name="commitEvidence", visibility=["read", "create", "update", "delete", "query"]
    )
    """Commit evidence."""
    write_set_digest: Optional[str] = rest_field(
        name="writeSetDigest", visibility=["read", "create", "update", "delete", "query"]
    )
    """TWrite set digest."""

    @overload
    def __init__(
        self,
        *,
        claims_digest: Optional[str] = None,
        commit_evidence: Optional[str] = None,
        write_set_digest: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Role(_Model):
    """Definition for roles.

    :ivar role_name: name of the user defined role.
    :vartype role_name: str
    :ivar role_actions: role actions.
    :vartype role_actions: list[str]
    """

    role_name: Optional[str] = rest_field(name="roleName", visibility=["read", "create", "update", "delete", "query"])
    """name of the user defined role."""
    role_actions: Optional[list[str]] = rest_field(
        name="roleActions", visibility=["read", "create", "update", "delete", "query"]
    )
    """role actions."""

    @overload
    def __init__(
        self,
        *,
        role_name: Optional[str] = None,
        role_actions: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Roles(_Model):
    """Roles.

    :ivar roles: Roles. Required.
    :vartype roles: list[~azure.confidentialledger.models.Role]
    """

    roles: list["_models.Role"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Roles. Required."""

    @overload
    def __init__(
        self,
        *,
        roles: list["_models.Role"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TransactionReceipt(_Model):
    """A receipt certifying the transaction at the specified id.

    :ivar application_claims: List of application claims.
    :vartype application_claims: list[~azure.confidentialledger.models.ApplicationClaim]
    :ivar receipt: The receipt contents for the transaction.
    :vartype receipt: ~azure.confidentialledger.models.ReceiptContents
    :ivar state: State of a ledger query. Required. Known values are: "Loading" and "Ready".
    :vartype state: str or ~azure.confidentialledger.models.ConfidentialLedgerQueryState
    :ivar transaction_id: A unique identifier for the state of the ledger. If returned as part of a
     LedgerEntry, it indicates the state from which the entry was read. Required.
    :vartype transaction_id: str
    """

    application_claims: Optional[list["_models.ApplicationClaim"]] = rest_field(
        name="applicationClaims", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of application claims."""
    receipt: Optional["_models.ReceiptContents"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The receipt contents for the transaction."""
    state: Union[str, "_models.ConfidentialLedgerQueryState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """State of a ledger query. Required. Known values are: \"Loading\" and \"Ready\"."""
    transaction_id: str = rest_field(name="transactionId", visibility=["read", "create", "update", "delete", "query"])
    """A unique identifier for the state of the ledger. If returned as part of a
     LedgerEntry, it indicates the state from which the entry was read. Required."""

    @overload
    def __init__(
        self,
        *,
        state: Union[str, "_models.ConfidentialLedgerQueryState"],
        transaction_id: str,
        application_claims: Optional[list["_models.ApplicationClaim"]] = None,
        receipt: Optional["_models.ReceiptContents"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TransactionStatus(_Model):
    """Response returned to a query for the transaction status.

    :ivar state: Represents the state of the transaction. Required. Known values are: "Committed"
     and "Pending".
    :vartype state: str or ~azure.confidentialledger.models.TransactionState
    :ivar transaction_id: A unique identifier for the state of the ledger. If returned as part of a
     LedgerEntry, it indicates the state from which the entry was read. Required.
    :vartype transaction_id: str
    """

    state: Union[str, "_models.TransactionState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the state of the transaction. Required. Known values are: \"Committed\" and
     \"Pending\"."""
    transaction_id: str = rest_field(name="transactionId", visibility=["read", "create", "update", "delete", "query"])
    """A unique identifier for the state of the ledger. If returned as part of a
     LedgerEntry, it indicates the state from which the entry was read. Required."""

    @overload
    def __init__(
        self,
        *,
        state: Union[str, "_models.TransactionState"],
        transaction_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserDefinedFunction(_Model):
    """A user defined function in the ledger.

    :ivar code: Code of the user defined function in JavaScript. Required.
    :vartype code: str
    :ivar id: ID of the user defined function.
    :vartype id: str
    """

    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Code of the user defined function in JavaScript. Required."""
    id: Optional[str] = rest_field(visibility=["read"])
    """ID of the user defined function."""

    @overload
    def __init__(
        self,
        *,
        code: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserDefinedFunctionExecutionError(_Model):
    """The error object of a user defined function execution. This is returned only
    when the user defined function execution throws an exception.

    :ivar message: Message indicating the error thrown when executing the function.
    :vartype message: str
    """

    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Message indicating the error thrown when executing the function."""

    @overload
    def __init__(
        self,
        *,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserDefinedFunctionExecutionProperties(_Model):
    """The properties for executing a user defined function.

    :ivar arguments: Runtime arguments of the user defined function. Defaults to an empty list.
    :vartype arguments: list[str]
    :ivar exported_function_name: Name of the exported function to execute in the code of the user
     defined
     function. Defaults to main.
    :vartype exported_function_name: str
    :ivar runtime_options: JS runtime options for user defined endpoints and functions.
    :vartype runtime_options: ~azure.confidentialledger.models.JsRuntimeOptions
    """

    arguments: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Runtime arguments of the user defined function. Defaults to an empty list."""
    exported_function_name: Optional[str] = rest_field(
        name="exportedFunctionName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the exported function to execute in the code of the user defined
     function. Defaults to main."""
    runtime_options: Optional["_models.JsRuntimeOptions"] = rest_field(
        name="runtimeOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """JS runtime options for user defined endpoints and functions."""

    @overload
    def __init__(
        self,
        *,
        arguments: Optional[list[str]] = None,
        exported_function_name: Optional[str] = None,
        runtime_options: Optional["_models.JsRuntimeOptions"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserDefinedFunctionExecutionResponse(_Model):
    """The result of a user defined function execution.

    :ivar error: The error object of a user defined function execution. This is returned only
     when the user defined function execution throws an exception.
    :vartype error: ~azure.confidentialledger.models.UserDefinedFunctionExecutionError
    :ivar result: The result object of a user defined function execution. This is returned only
     when the user defined function executes successfully.
    :vartype result: ~azure.confidentialledger.models.UserDefinedFunctionExecutionResult
    :ivar status: Represents the status of a user defined function execution. Required. Known
     values are: "Succeeded" and "Failed".
    :vartype status: str or ~azure.confidentialledger.models.UserDefinedFunctionExecutionStatus
    """

    error: Optional["_models.UserDefinedFunctionExecutionError"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The error object of a user defined function execution. This is returned only
     when the user defined function execution throws an exception."""
    result: Optional["_models.UserDefinedFunctionExecutionResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The result object of a user defined function execution. This is returned only
     when the user defined function executes successfully."""
    status: Union[str, "_models.UserDefinedFunctionExecutionStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the status of a user defined function execution. Required. Known values are:
     \"Succeeded\" and \"Failed\"."""

    @overload
    def __init__(
        self,
        *,
        status: Union[str, "_models.UserDefinedFunctionExecutionStatus"],
        error: Optional["_models.UserDefinedFunctionExecutionError"] = None,
        result: Optional["_models.UserDefinedFunctionExecutionResult"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserDefinedFunctionExecutionResult(_Model):
    """The result object of a user defined function execution. This is returned only
    when the user defined function executes successfully.

    :ivar return_value: String-encoded value returned by the user defined function execution. If
     the
     function does not return any value, this is set to an empty string.
    :vartype return_value: str
    """

    return_value: Optional[str] = rest_field(
        name="returnValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """String-encoded value returned by the user defined function execution. If the
     function does not return any value, this is set to an empty string."""

    @overload
    def __init__(
        self,
        *,
        return_value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserDefinedFunctionHook(_Model):
    """Hook for a user defined function execution.

    :ivar function_id: ID of the user defined function to execute. Required.
    :vartype function_id: str
    :ivar properties: The properties for executing a user defined function.
    :vartype properties: ~azure.confidentialledger.models.UserDefinedFunctionExecutionProperties
    """

    function_id: str = rest_field(name="functionId", visibility=["read", "create", "update", "delete", "query"])
    """ID of the user defined function to execute. Required."""
    properties: Optional["_models.UserDefinedFunctionExecutionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties for executing a user defined function."""

    @overload
    def __init__(
        self,
        *,
        function_id: str,
        properties: Optional["_models.UserDefinedFunctionExecutionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
