# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.authorization.aio import AuthorizationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAuthorizationManagementRoleAssignmentsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AuthorizationManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_assignments_list_for_subscription(self, resource_group):
        response = self.client.role_assignments.list_for_subscription(
            api_version="2022-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_assignments_list_for_resource_group(self, resource_group):
        response = self.client.role_assignments.list_for_resource_group(
            resource_group_name=resource_group.name,
            api_version="2022-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_assignments_list_for_resource(self, resource_group):
        response = self.client.role_assignments.list_for_resource(
            resource_group_name=resource_group.name,
            resource_provider_namespace="str",
            resource_type="str",
            resource_name="str",
            api_version="2022-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_assignments_get(self, resource_group):
        response = await self.client.role_assignments.get(
            scope="str",
            role_assignment_name="str",
            api_version="2022-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_assignments_create(self, resource_group):
        response = await self.client.role_assignments.create(
            scope="str",
            role_assignment_name="str",
            parameters={
                "principalId": "str",
                "roleDefinitionId": "str",
                "condition": "str",
                "conditionVersion": "str",
                "createdBy": "str",
                "createdOn": "2020-02-20 00:00:00",
                "delegatedManagedIdentityResourceId": "str",
                "description": "str",
                "principalType": "str",
                "scope": "str",
                "updatedBy": "str",
                "updatedOn": "2020-02-20 00:00:00",
            },
            api_version="2022-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_assignments_delete(self, resource_group):
        response = await self.client.role_assignments.delete(
            scope="str",
            role_assignment_name="str",
            api_version="2022-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_assignments_list_for_scope(self, resource_group):
        response = self.client.role_assignments.list_for_scope(
            scope="str",
            api_version="2022-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_assignments_get_by_id(self, resource_group):
        response = await self.client.role_assignments.get_by_id(
            role_assignment_id="str",
            api_version="2022-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_assignments_create_by_id(self, resource_group):
        response = await self.client.role_assignments.create_by_id(
            role_assignment_id="str",
            parameters={
                "principalId": "str",
                "roleDefinitionId": "str",
                "condition": "str",
                "conditionVersion": "str",
                "createdBy": "str",
                "createdOn": "2020-02-20 00:00:00",
                "delegatedManagedIdentityResourceId": "str",
                "description": "str",
                "principalType": "str",
                "scope": "str",
                "updatedBy": "str",
                "updatedOn": "2020-02-20 00:00:00",
            },
            api_version="2022-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_assignments_delete_by_id(self, resource_group):
        response = await self.client.role_assignments.delete_by_id(
            role_assignment_id="str",
            api_version="2022-04-01",
        )

        # please add some check logic here by yourself
        # ...
