# --------------------------------------------------------------------------
#
# Copyright (c) Microsoft Corporation. All rights reserved.
#
# The MIT License (MIT)
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the ""Software""), to
# deal in the Software without restriction, including without limitation the
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED *AS IS*, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE.
#
# --------------------------------------------------------------------------

import sys
from typing import MutableMapping, Optional

from requests.adapters import HTTPAdapter  # pylint: disable=networking-import-outside-azure-core-transport
from urllib3.connectionpool import ConnectionPool


class BiggerBlockSizeHTTPAdapter(HTTPAdapter):
    def get_connection(self, url: str, proxies: Optional[MutableMapping[str, str]] = None) -> ConnectionPool:
        """Returns a urllib3 connection for the given URL. This should not be
        called from user code, and is only exposed for use when subclassing the
        :class:`HTTPAdapter <requests.adapters.HTTPAdapter>`.

        :param str url: The URL to connect to.
        :param dict proxies: (optional) A Requests-style dictionary of proxies used on this request.
        :rtype: urllib3.connectionpool.ConnectionPool
        :returns: The urllib3 ConnectionPool for the given URL.
        """
        conn = super(BiggerBlockSizeHTTPAdapter, self).get_connection(url, proxies)
        system_version = tuple(sys.version_info)[:3]
        if system_version[:2] >= (3, 7):
            if not conn.conn_kw:
                conn.conn_kw = {}
            conn.conn_kw["blocksize"] = 32768
        return conn
