// Package models contains the types for schema 'public'.
package models

// Code generated by xo. DO NOT EDIT.

import (
	"database/sql"
)

// SlaveHosts96 represents a row from '[custom slave_hosts96]'.
type SlaveHosts96 struct {
	ApplicationName sql.NullString  // application_name
	ClientAddr      sql.NullString  // client_addr
	State           sql.NullString  // state
	ByteLag         sql.NullFloat64 // byte_lag
}

// GetSlaveHosts96s runs a custom query, returning results as SlaveHosts96.
func GetSlaveHosts96s(db XODB) ([]*SlaveHosts96, error) {
	var err error

	// sql query
	var sqlstr = `SELECT application_name, client_addr, state, sent_offset - (replay_offset - (sent_xlog - replay_xlog) * 255 * 16 ^ 6 ) AS byte_lag ` +
		`FROM ( SELECT application_name, client_addr, client_hostname, state, ` +
		`('x' || lpad(split_part(sent_location::TEXT,   '/', 1), 8, '0'))::bit(32)::bigint AS sent_xlog, ` +
		`('x' || lpad(split_part(replay_location::TEXT, '/', 1), 8, '0'))::bit(32)::bigint AS replay_xlog, ` +
		`('x' || lpad(split_part(sent_location::TEXT,   '/', 2), 8, '0'))::bit(32)::bigint AS sent_offset, ` +
		`('x' || lpad(split_part(replay_location::TEXT, '/', 2), 8, '0'))::bit(32)::bigint AS replay_offset ` +
		`FROM pg_stat_replication ) AS s`

	// run query
	XOLog(sqlstr)
	q, err := db.Query(sqlstr)
	if err != nil {
		return nil, err
	}
	defer q.Close()

	// load results
	res := []*SlaveHosts96{}
	for q.Next() {
		sh := SlaveHosts96{}

		// scan
		err = q.Scan(&sh.ApplicationName, &sh.ClientAddr, &sh.State, &sh.ByteLag)
		if err != nil {
			return nil, err
		}

		res = append(res, &sh)
	}

	return res, nil
}
